/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.icon.ArrowIcon;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinComboBoxRenderer;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;

public final class SkinComboBoxUI
extends BasicComboBoxUI {
    private Skin skin = SkinLookAndFeel.getSkin();
    private boolean rollover = false;
    private MouseListener rolloverListener;

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        Dimension dimension2 = this.skin.getPersonality().getComboBoxPreferredSize(this.comboBox);
        dimension.width = Math.max(dimension.width, dimension2.width);
        dimension.height = Math.max(dimension.height, dimension2.height);
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void installListeners() {
        super.installListeners();
        this.rolloverListener = this.createRolloverListener();
        this.comboBox.addMouseListener(this.rolloverListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.rolloverListener);
        this.rolloverListener = null;
    }

    protected MouseListener createRolloverListener() {
        return new RolloverMouseListener();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        Rectangle rectangle = this.rectangleForCurrentValue();
        this.skin.getPersonality().paintComboBox(graphics, this.comboBox, rectangle, this.hasFocus, this.rollover);
        if (!this.comboBox.isEditable() || this.editor == null || !this.editor.isVisible()) {
            this.paintCurrentValue(graphics, rectangle, false);
        }
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Component component;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        if (this.comboBox.getSelectedIndex() == -1) {
            return;
        }
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        component.setFont(this.comboBox.getFont());
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean bl2 = true;
        if (component instanceof JComponent) {
            bl2 = ((JComponent)component).isOpaque();
            ((JComponent)component).setOpaque(false);
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (bl2 && component instanceof JComponent) {
            ((JComponent)component).setOpaque(true);
        }
    }

    protected Insets getInsets() {
        return this.skin.getPersonality().getComboBoxInsets();
    }

    protected JButton createArrowButton() {
        JButton jButton = new JButton(new ArrowIcon(5));
        return jButton;
    }

    protected void installComponents() {
        super.installComponents();
        this.arrowButton.setVisible(false);
    }

    protected void configureEditor() {
        super.configureEditor();
        this.editor.addMouseListener(this.rolloverListener);
        if (this.comboBox.getEditor() != null && this.comboBox.getEditor() instanceof UIResource && this.editor instanceof JComponent) {
            ((JComponent)this.editor).setOpaque(false);
        }
    }

    protected void unconfigureEditor() {
        super.unconfigureEditor();
        this.editor.removeMouseListener(this.rolloverListener);
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right), n2 - (insets.top + insets.bottom));
    }

    protected LayoutManager createLayoutManager() {
        return new SkinComboBoxLayoutManager();
    }

    protected ListCellRenderer createRenderer() {
        return new SkinComboBoxRenderer();
    }

    protected JComboBox comboBox() {
        return this.comboBox;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SkinComboBoxUI.this.comboBox().isEnabled()) {
                    if (SkinComboBoxUI.this.isPopupVisible()) {
                        SkinComboBoxUI.this.selectNextPossibleValue();
                    } else {
                        SkinComboBoxUI.this.setPopupVisible(SkinComboBoxUI.this.comboBox(), true);
                    }
                }
            }
        };
        this.comboBox.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(40, 0), 1);
        this.comboBox.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke("KP_DOWN"), 1);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SkinComboBoxUI.this.comboBox().isEnabled() && SkinComboBoxUI.this.isPopupVisible()) {
                    SkinComboBoxUI.this.togglePopup();
                }
            }
        };
        this.comboBox.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(40, 8), 1);
        this.comboBox.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke("alt KP_DOWN"), 1);
        this.comboBox.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(38, 8), 1);
        this.comboBox.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke("alt KP_UP"), 1);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SkinComboBoxUI.this.comboBox().isEnabled() && SkinComboBoxUI.this.isPopupVisible()) {
                    SkinComboBoxUI.this.selectPreviousPossibleValue();
                }
            }
        };
        this.comboBox.registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke(38, 0), 1);
        this.comboBox.registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke("KP_UP"), 1);
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_DOWN"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 8));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("alt KP_DOWN"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_UP"));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 8));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke("alt KP_UP"));
    }

    protected Component editor() {
        return this.editor;
    }

    boolean isPopupVisible() {
        return super.isPopupVisible(this.comboBox);
    }

    void togglePopup() {
        this.toggleOpenClose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SkinComboBoxUI();
    }

    public class SkinComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return container.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            if (SkinComboBoxUI.this.editor() != null) {
                Rectangle rectangle = SkinComboBoxUI.this.rectangleForCurrentValue();
                SkinComboBoxUI.this.editor().setBounds(rectangle);
            }
        }
    }

    public class RolloverMouseListener
    extends MouseAdapter {
        public void mouseEntered(MouseEvent mouseEvent) {
            SkinComboBoxUI.this.rollover = true;
            SkinComboBoxUI.this.comboBox.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SkinComboBoxUI.this.rollover = false;
            SkinComboBoxUI.this.comboBox.repaint();
        }
    }
}

