/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class SkinSplitArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    protected Skin skin = SkinLookAndFeel.getSkin();

    public SkinSplitArrowButton(int n) {
        this.setRequestFocusEnabled(false);
        this.setDirection(n);
        this.setBackground(UIManager.getColor("control"));
        Dimension dimension = this.getPreferredSize();
        this.setSize(dimension.width, dimension.height);
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setBorder(Border border) {
    }

    public int getDirection() {
        return this.direction;
    }

    public Dimension getPreferredSize() {
        return this.skin.getSplitPane().getArrowPreferredSize(this.direction);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        this.skin.getSplitPane().paintArrow(graphics, this, this.direction);
    }
}

