/*
 * Decompiled with CFR 0.152.
 */
package com.a7soft.examxml;

import com.a7soft.examxml.Element;
import com.a7soft.examxml.ExamXMLErrorHandler;
import com.a7soft.examxml.ExamXMLHandler;
import com.a7soft.examxml.Options;
import com.a7soft.examxml.XMLString;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.xml.sax.InputSource;

public class ExamXML {
    static final int DIFF = 1;
    static final int MERGE = 2;
    static final int IDENTICAL = 0;
    static final int NOT_IDENTICAL = 1;
    static final int ERROR = 2;
    static final String LOG_EXT = ".log";
    private static int operation = 1;
    private static boolean printOutputFile = true;
    private static String firstXMLFile = null;
    private static String secondXMLFile = null;
    private static String deltaFile = null;
    private static String optionsFile = null;
    private static Element firstElement = null;
    private static Element secondElement = null;

    private ExamXML() {
    }

    static boolean isPrinting() {
        return printOutputFile;
    }

    static boolean isDiff() {
        return operation == 1;
    }

    static boolean isMerge() {
        return operation == 2;
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("java -jar examxml.jar <first-xml> <second-xml> [<delta.xml>] [-D|-M] [<option-file>]");
    }

    private static boolean commands(String s) {
        if (s.length() == 2 && (s.charAt(0) == '-' || s.charAt(0) == '/')) {
            switch (Character.toUpperCase(s.charAt(1))) {
                case 'D': {
                    operation = 1;
                    break;
                }
                case 'M': {
                    operation = 2;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean commandLine(String[] argv) {
        if (argv.length < 2) {
            return false;
        }
        firstXMLFile = argv[0];
        secondXMLFile = argv[1];
        printOutputFile = true;
        switch (argv.length) {
            case 2: {
                printOutputFile = false;
                break;
            }
            case 3: {
                if (argv[2].length() > 3) {
                    String oper = argv[2].substring(0, 3);
                    if (oper.equalsIgnoreCase("-O:") || oper.equalsIgnoreCase("/O:")) {
                        printOutputFile = false;
                        optionsFile = argv[2].substring(3);
                        break;
                    }
                    deltaFile = argv[2];
                    break;
                }
                return false;
            }
            case 4: {
                deltaFile = argv[2];
                if (ExamXML.commands(argv[3])) break;
                optionsFile = argv[3];
                break;
            }
            case 5: {
                deltaFile = argv[2];
                ExamXML.commands(argv[3]);
                optionsFile = argv[4];
            }
        }
        return true;
    }

    private static int compare() {
        if (XMLString.isEmpty(firstXMLFile) || XMLString.isEmpty(secondXMLFile) || !ExamXML.loadXML(new InputSource(firstXMLFile), new InputSource(secondXMLFile), firstXMLFile.concat(LOG_EXT))) {
            return 2;
        }
        if (printOutputFile) {
            try {
                Element.compareElements(firstElement, secondElement);
                BufferedWriter file = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(deltaFile), Options.getEncoding()));
                Element.printXMLHeader(file);
                firstElement.printElement(file, false, 0);
                file.close();
            }
            catch (Exception e) {
                ExamXMLErrorHandler.printError(e);
                return 2;
            }
        }
        return firstElement.equals(secondElement) ? 0 : 1;
    }

    private static boolean loadXML(InputSource first, InputSource second, String logFile) {
        ExamXMLHandler handler = ExamXMLHandler.getInstance(logFile);
        firstElement = handler.loadXML(first);
        secondElement = handler.loadXML(second);
        return firstElement != null && secondElement != null;
    }

    private static boolean parseXMLTags(String entity1, String entity2) {
        return !XMLString.isEmpty(entity1) && !XMLString.isEmpty(entity2) && ExamXML.loadXML(new InputSource(new StringReader(entity1)), new InputSource(new StringReader(entity2)), null);
    }

    public static String compareXMLString(String entity1, String entity2) {
        if (ExamXML.parseXMLTags(entity1, entity2)) {
            try {
                Element.compareElements(firstElement, secondElement);
                StringWriter str = new StringWriter();
                firstElement.printElement(str, false, 0);
                return str.toString();
            }
            catch (Exception e) {
                ExamXMLErrorHandler.printError(e);
            }
        }
        return null;
    }

    public static int compareXMLEntities(String entity1, String entity2) {
        if (ExamXML.parseXMLTags(entity1, entity2)) {
            return firstElement.equals(secondElement) ? 0 : 1;
        }
        return 2;
    }

    public static int compareXMLFiles(String file1, String file2) {
        return ExamXML.compareXMLFiles(file1, file2, null, null);
    }

    public static int compareXMLFiles(String file1, String file2, String delta, String options) {
        firstXMLFile = file1;
        secondXMLFile = file2;
        deltaFile = delta;
        operation = 1;
        printOutputFile = delta != null;
        optionsFile = options;
        if (Options.loadOptions(optionsFile)) {
            return ExamXML.compare();
        }
        return 2;
    }

    public static void main(String[] argv) {
        System.out.println("JExamXML 0.1 - Java XML comparison tool");
        if (ExamXML.commandLine(argv) && Options.loadOptions(optionsFile)) {
            System.out.println("Comparing \"".concat(firstXMLFile).concat("\" and \"").concat(secondXMLFile).concat("\""));
            String[] res = new String[]{"Two files are identical", "Two files are not identical", "Error(s)! See log file"};
            int result = ExamXML.compare();
            System.out.println(res[result]);
            System.exit(result);
        } else {
            ExamXML.usage();
            System.exit(2);
        }
    }

    public static void setLogFile(String logFileName) {
        ExamXMLErrorHandler.setLogFile(logFileName, true);
    }
}

