
<!--
'%%%%%%%%%%%%%%%%%%%%%%%%%%% EXTRA SAMPLE FUNCTIONS YOU CAN ADD AND USE (resources) %%%%%%%%%%%%%%%%%%%%%
'USE THE CODE BLOCKS BELOW FOR EXTRA VBSCRIPT FUNCTIONS AND FEATURES.
'==========================================================================================




'FILTER ARRAY EXAMPLE
'Use filtering on arrays returned from the ImageIsle database calls, if you only need to show certain values in the array
'Example: Use this FILTER ARRAY EXAMPLE feature to pull name values which have a "t" in them.
'<%=join(filter(AnArray,"t",True,0),",")%>
'In this lines we have filter the values at MyArray and we have join them. 
'filter(MyArray,"t",True,0) 
'This part of the line have search for "t" in MyArray. 
    'True means we have selected the strings containing the search string (in this case "t"). 
    'False will indicate we are selecting the strings which do not content the search string. 
    '0 means our search is case sensitive (a binary comparation) 
    '1 will mean it is not a case sensitive search (a textual comparation) 
'join(filter(MyArray,"t",True,0),",") 
'The complete line will join the filtered strings with the delimiter indicated (in this case ",")


'DICTIONARY EXAMPLE
'Use dictionary objects if you need to quickly add name-value paired data sets.
'Dim d
'Set d=Server.CreateObject("Scripting.Dictionary")
'd.Add "re","Red"
'd.Add "gr","Green"
'd.Add "bl","Blue"
'd.Add "pi","Pink"
'Response.Write("The value of key gr is: " & d.Item("gr"))


'DATABASE SORT ARRAY EXAMPLE
'When data is returned in an array from the xml database, use this
'function to sort the data and return a new ordered set based on one column
'in a multidimensional array of values. (ie. sort by name, date, id, etc.)
'------------------------------------------------------------------------
Sub SortArray(TheArray,whichSortDirection,whichSortIndex,ByRef OutputArray)

Dim x
Dim y 
Dim columnValue 
Dim columnIndex 
dim minIndex
dim maxIndex
dim tempValue
dim theType
dim theSortDirection
dim z
dim firstAvailableIndex

if ((whichSortIndex < 0) or (whichSortIndex > ubound(TheArray,1))) then
    'return array as is...no sorting
	SortArray = TheArray
else
      
    if lcase(whichSortDirection) = "desc" then
	    theSortDirection = 2
    elseif lcase(whichSortDirection) = "asc" then
	    theSortDirection = 1
    else
	    theSortDirection = 1
    end if

    minIndex = lbound(TheArray,2)
    maxIndex = ubound(TheArray,2)

    firstAvailableIndex = minIndex
    while len(trim(TheArray(whichSortIndex,firstAvailableIndex))) = 0 and firstAvailableIndex < ubound(TheArray,2)
	    firstAvailableIndex = firstAvailableIndex + 1
    wend

    if isDate(trim(TheArray(whichSortIndex,firstAvailableIndex))) then
	    theType = 3
    else
	    if isNumeric(trim(TheArray(whichSortIndex,firstAvailableIndex))) then
		    theType = 2
	    else
		    theType = 1
	    end if
    end if

    For x = minIndex To maxIndex - 1

	    columnValue = TheArray(whichSortIndex,x)
	    columnIndex = x

        'Loop check that gets index of smallest value in array set
	    For y = x + 1 To maxIndex

		    select case theType
			    case 1
                    'The StrComp function compares two strings and returns a value that represents the result of the comparison.
                    'The StrComp function can return one of the following values:
                    '-1 (if string1 < string2) 
                    '0 (if string1 = string2) 
                    '1 (if string1 > string2) 
                    'Null (if string1 or string2 is Null)
				    If strComp(TheArray(whichSortIndex,y),columnValue,vbTextCompare) = theSortDirection Then
					    columnValue = TheArray(whichSortIndex,y)
					    columnIndex = y
				    End If
			    case 2
				    if theSortDirection = 2 then
					    if cdbl(TheArray(whichSortIndex,y)) < cdbl(columnValue) then
						    columnValue = TheArray(whichSortIndex,y)
						    columnIndex = y
					    end if
				    else
					    if cdbl(TheArray(whichSortIndex,y)) > cdbl(columnValue) then
						    columnValue = TheArray(whichSortIndex,y)
						    columnIndex = y
					    end if
				    end if
			    case 3
				    if theSortDirection = 2 then
					    if DateDiff("s",TheArray(whichSortIndex,y),columnValue) > 0 then
						    columnValue = TheArray(whichSortIndex,y)
						    columnIndex = y
					    end if
				    else
					    if DateDiff("s",TheArray(whichSortIndex,y),columnValue) < 0 then
						    columnValue = TheArray(whichSortIndex,y)
						    columnIndex = y
					    end if
				    end if
		    end select

	    Next

        'If there has been ANY change in order, reorder all dimensions of array
	    If (Cint(columnIndex) <> Cint(x)) Then

            'Now sort ALL ROWS of data based on this one column's new order!
		    for z = 0 to ubound(TheArray,1)
			    tempValue = TheArray(z,columnIndex)
			    TheArray(z,columnIndex) = TheArray(z,x)
			    TheArray(z,x) = tempValue
		    next

	    End If

    Next
    ' return the array
    OutputArray = TheArray
end if

End Sub

'EXAMPLE of sorting....
'dim f,myarray(1,2),OutputArray
'myarray(0,0) = 5
'myarray(0,1) = 1
'myarray(0,2) = 2
'myarray(1,0) = "five"
'myarray(1,1) = "one"
'myarray(1,2) = "two"
'Call SortArray(myarray,"asc",0,OutputArray)
'Response.Write("<br />TEST1 ARRAY: " & OutputArray(0,0) & ":" & OutputArray(0,1) & ":" & OutputArray(0,2))
'Response.Write("<br />TEST2 ARRAY: " & OutputArray(1,0) & ":" & OutputArray(1,1) & ":" & OutputArray(1,2))
'------------------------------------------------------------------------






'***************** DIRECTORY MANAGER CLASS EXAMPLE WITH SAMPLE FUNCTIONS ****************
'The large class below has a number of very helpful functions for manipulating, managing and organizing files and folders on the server via a simple class method set. You may add this class and use it for adding, moving and deleting files and folders, as well as getting information from the server on current directories of files and folders in your web site.
'------------------------------------------------------------------------
Class DirectoryManager

'FIELDS........................................
Public test 'add field/property description here

'PROPERTIES....................................
Public Property Let someProperty(x)
  Me.test = x
End Property

'Get XML File path
Public Property Get someProperty()
  someProperty = Me.test
End Property
'*********************************************************

'----------------------CONSTRUCTORS-----------------------
'****************FUNCTION: Class_Initialize****************
'Starts when class is first called...
'When the class is first referenced, go ahead and create, in-memory, a placeholder for the XML DOM object.
'This will hold the xml datafile when stored later
'**********************************************************
Private Sub Class_Initialize()
  Me.test = ""
End Sub
'**********************************************************

'----------------------FUNCTIONS-----------------------
'..............................................
'GET SERVER ROOT PATH
Public Function getServerRootPath()
	getServerRootPath = Request.ServerVariables("APPL_PHYSICAL_PATH")
     if (isEmpty(getServerRootPath) or isNull(getServerRootPath) or getServerRootPath = "") then
     getServerRootPath = server.mappath("/") & "\"
     end if
End Function

'TESTING...
'response.write "*Function getServerRootPath()<br />"
'response.write "getServerRootPath(): <b>" & getServerRootPath() & "</b><br />"
'response.write "server.mappath('/'): <b>" & server.mappath("/") & "\" & "</b>"
'..............................................
'GET SERVER FOLDER PATH
Public Function getServerFolderPath()
	getServerFolderPath = server.mappath(".") & "\"
End Function

'TESTING...
'response.write "<br /><br />*Function getServerFolderPath()<br />"
'response.write "getServerFolderPath(): <b>" & getServerFolderPath() & "</b>"
'..............................................
'GET WEB PARENT FOLDER PATH
Public Function getWebFolderParentPath(folderPath)
	Set yourFolder = Server.CreateObject("Scripting.FileSystemObject")
	    if yourFolder.FolderExists(folderPath) then
        getWebFolderParentPath = yourFolder.GetParentFolderName(folderPath) & "\"
        end if
	Set yourFolder = Nothing
End Function

'TESTING...
'response.write "<br /><br />*Function getWebFolderParentPath()<br />"
'response.write "getWebFolderParentPath(getWebFolderPath()): <b>Parent of - " & getWebFolderPath() & " is - " & getWebFolderParentPath(getWebFolderPath()) & "</b>"
'------------------------------------------------------
'------------------------------------------------------
'GET WEB FILE PATH (of current file)
Public Function getWebFilePath()
	 getWebFilePath = Request.ServerVariables("PATH_TRANSLATED")
     if (isEmpty(getWebFilePath) or isNull(getWebFilePath) or getWebFilePath = "") then
     getWebFilePath = server.mappath(Request.ServerVariables("SCRIPT_NAME"))
        'if (isEmpty(getWebFilePath) or isNull(getWebFilePath) or getWebFilePath = "") then
	    'Set myPath = Server.CreateObject("Scripting.FileSystemObject")
        'getWebFilePath = myPath.GetAbsolutePathName("private\mydoc.txt")
	    'Set myPath = Nothing
        'end if
     end if
End Function

'TESTING...
'response.write "<br /><br />*Function getWebFilePath()<br />"
'response.write "getWebFilePath(): <b>" & getWebFilePath() & "</b>"
'------------------------------------------------------
'------------------------------------------------------
'GET WEB FILE EXTENSION
Public Function getWebFileExtension(filePath)
	Set myFile = Server.CreateObject("Scripting.FileSystemObject")
	    if myFile.FileExists(filePath) then
        getWebFileExtension = myFile.GetExtensionName(filePath)
        end if
	Set myFile = Nothing
End Function

'TESTING...
'response.write "<br /><br />*Function getWebFileExtension()<br />"
'response.write "getWebFileExtension(getWebFilePath()): <b>" & getWebFileExtension(getWebFilePath()) & "</b>"
'------------------------------------------------------
'------------------------------------------------------
'GET WEB FILE BASE NAME (file name without extension of current file)
Public Function getWebFileBaseName(filePath)
	Set myFile = Server.CreateObject( "Scripting.FileSystemObject" )
	    if myFile.FileExists(filePath) then
        getWebFileBaseName = myFile.GetBaseName(filePath)
        end if
	Set myFile = Nothing
End Function

'TESTING...
'response.write "<br /><br />*Function getWebFileBaseName()<br />"
'response.write "getWebFileBaseName(getWebFilePath()): <b>" & getWebFileBaseName(getWebFilePath()) & "</b>"
'------------------------------------------------------
'------------------------------------------------------
'GET URL, or DOMAIN + PATH
Public Function getURL()
	getURL = "http://" & Request.ServerVariables("Server_Name") & Request.ServerVariables("Script_Name")
End Function

'TESTING...
'response.write "<br /><br />*Function getURL()<br />"
'response.write "getURL(): <b>" & getURL() & "</b>"
'------------------------------------------------------
'------------------------------------------------------
'CREATE FOLDER with error catch
Public Function createFolder(folderPathAndName)
'first test that the path passed in is a derivative of the web server drive path
if InStr(folderPathAndName,server.mappath("/")) then
'response.write("web server path integrated into string<br />")
'yourmessage = "Web Path passed in by user is ok..."
	Set yourFolder = Server.CreateObject("Scripting.FileSystemObject")
	    if yourFolder.FolderExists(folderPathAndName) then
            yourmessage = "Folder exists already - not created but present"
        else
		    yourFolder.CreateFolder(folderPathAndName)
            if yourFolder.FolderExists(folderPathAndName) then
            yourmessage = "Folder Created Successfully!"
            else
            yourmessage = "WARNING: Folder not created. Check read/write permissions for the anonymous web user (IUSR) on your server"
            end if
	    end if
	createFolder = yourmessage
	Set yourFolder = Nothing
else
yourmessage = "WARNING: Folder not created. Check that you have entered a valid folder path into the function createFolder(folderPathAndName)"
end if
End Function

'TESTING...
'response.write "<br /><br />*Function createFolder()<br />"

'creates folder in current folder using getWebFolderPath()
'response.write "createFolder(getWebFolderPath() & 'createdfolder').1: <b>" & _
'createFolder(getWebFolderPath() & "createdfolder") & "</b>"

'creates folder in web root directory using modified server.mappath
'response.write "createFolder(server.mappath('/') & '/' & 'createdfolder2').2: <b>" & _
'createFolder(server.mappath("/") & "/" & "createdfolder2") & "</b><br />"

'creates folder in web root using getWebRootPath() function
'response.write "createFolder(getWebRootPath() & 'createdfolder3').3: <b>" & _
'createFolder(getWebRootPath() & "createdfolder3") & "</b><br />"
'------------------------------------------------------
'------------------------------------------------------
'DELETE FOLDER with error catch
Public Function deleteFolder(folderPathAndName)
'first test that the path passed in is a derivative of the web server drive path
if InStr(folderPathAndName,server.mappath("/")) then
'response.write("web server path integrated into string<br />")
'yourmessage = "Web Path passed in by user is ok..."
	Set yourFolder = Server.CreateObject("Scripting.FileSystemObject")
	    If yourFolder.FolderExists(folderPathAndName) Then
		    yourFolder.DeleteFolder(folderPathAndName)
            if yourFolder.FolderExists(folderPathAndName) then
            yourmessage = "WARNING: Folder not deleted. Check read/write permissions for the anonymous web user (IUSR) on your server"
            else
            yourmessage = "Folder Deleted Successfully!"
            end if
	    Else
            yourmessage = "Folder is not present - it may already be deleted"
	    End If
	deleteFolder = yourmessage
	Set yourFolder = Nothing
else
yourmessage = "WARNING: Folder not deleted. Check that you have entered a valid folder path into the function deleteFolder(folderPathAndName)"
end if
End Function

'TESTING...
'response.write "<br /><br />*Function deleteFolder()<br />(<b>This test is disabled to prevent it from deleting folders created in other functions in this page</b>)"

'creates folder in current folder using getWebFolderPath()
'response.write "deleteFolder(getWebFolderPath() & 'createdfolder').1: <b>" & _
'deleteFolder(getWebFolderPath() & "createdfolder") & "</b><br />"

'creates folder in web root directory using modified server.mappath
'response.write "deleteFolder(server.mappath('/') & '/' & 'createdfolder2').2: <b>" & _
'deleteFolder(server.mappath("/") & "/" & "createdfolder2") & "</b><br />"

'creates folder in web root using getWebRootPath() function
'response.write "deleteFolder(getWebRootPath() & 'createdfolder3').3: <b>" & _
'deleteFolder(getWebRootPath() & "createdfolder3") & "</b><br />"
'------------------------------------------------------
'------------------------------------------------------
'COPY FOLDER to new location, check for errors
Public Function copyFolder(folderPathToCopy,folderPathCopyName,folderPathNewLocation)
	Set myFolder = Server.CreateObject("Scripting.FileSystemObject")
	If (not myFolder.FolderExists(folderPathNewLocation & folderPathCopyName)) Then
        if (myFolder.FolderExists(folderPathToCopy) and myFolder.FolderExists(folderPathNewLocation)) then
        'CopyFolder parameters : first folder(s) to move (can use * for all),second is location of folder to move to, third is (optional)whether write-over is allowed...use true if allowed. Default is true, or overwrite
        'file paths both exist, so begin copying folder to new location
		myFolder.CopyFolder folderPathToCopy,folderPathNewLocation,false
            if myFolder.FolderExists(folderPathNewLocation & folderPathCopyName) then
                mymessage = "Success : Directory copied to new location!"
            else
		        mymessage = "WARNING: Failure: Directory not found and not copied to new location. Please check the file folder permission on the web server for the IUSR role."
            end if
        else
        'if the folder to copy and the path to copy to do not exists in the new location...
		mymessage = "WARNING: Failure: Directory not found and not copied to new location. Please check your file paths passed in the function."
        end if
	Else
        'dont do any copying...folder exists
        mymessage = "Folder Already present! : Sorry, folder already exists in this location, so don't do anything."
	End If
	CopyFolder = mymessage
	Set myFolder = Nothing
End Function

'TESTING: copy folder to new location in a folder above or below the current one...first show folder to copy and to copy to...
'response.write "<br /><br />*Function copyFolder: <b><br />" & _
'"Folder to copy:" & getWebFolderPath() & "foldertocopy" & "<br />" & _
'"Folder to copy to:" & getWebFolderPath() & "foldertoholdcopy\" & "<br />" & _
'copyFolder(getWebFolderPath() & "foldertocopy","foldertocopy",getWebFolderPath() & "foldertoholdcopy\") & "</b>"
'------------------------------------------------------
'------------------------------------------------------
'MOVE FOLDER to new location, check for errors
Public Function moveFolder(folderPathToMove,folderPathMoveName,folderPathNewLocation)
	Set myFolder = Server.CreateObject("Scripting.FileSystemObject")
	If (not myFolder.FolderExists(folderPathNewLocation & folderPathMoveName)) Then
        if (myFolder.FolderExists(folderPathToMove) and myFolder.FolderExists(folderPathNewLocation)) then
        'moveFolder parameters : first folder(s) to move (can use * for all),second is location of folder to move to, third is (optional)whether write-over is allowed...use true if allowed. Default is true, or overwrite
        'file paths both exist, so begin moving folder to new location
		myFolder.MoveFolder folderPathToMove,folderPathNewLocation
            if myFolder.FolderExists(folderPathNewLocation & folderPathMoveName) then
                mymessage = "Success : Directory moved to new location!"
            else
		        mymessage = "WARNING: Failure: Directory not found and not moved to new location. Please check the file folder permission on the web server for the IUSR role."
            end if
        else
        'if the folder to move and the path to move to do not exists in the new location...
		mymessage = "WARNING: Failure: Directory not found and not moved to new location. Please check your file paths passed in the function."
        end if
	Else
        'dont do any copying...folder exists
        mymessage = "Folder Already present! : Sorry, folder already exists in this location, so don't do anything."
	End If
	moveFolder = mymessage
	Set myFolder = Nothing
End Function

'TESTING: move folder to new location in a folder above or below the current one...first show folder to move and to move to...
'response.write "<br /><br />*Function moveFolder: <b><br />" & _
'"Folder to move:" & getWebFolderPath() & "foldertomove" & "<br />" & _
'"Folder to move to:" & getWebFolderPath() & "foldertoholdmove\" & "<br />" & _
'moveFolder(getWebFolderPath() & "foldertomove","foldertomove",getWebFolderPath() & "foldertoholdmove\") & "</b>"
'------------------------------------------------------
'------------------------------------------------------
'DOES FOLDER EXIST: returns true/false
Public Function doesFolderExist(folderPathAndName)
	Set myFolder = Server.CreateObject("Scripting.FileSystemObject")
	If myFolder.FolderExists(folderPathAndName) Then
		yourmessage = True
	Else
		yourmessage = False
	End If
	doesFolderExist = yourmessage
	Set myFolder = Nothing
End Function

'TESTING: returns true/false so you can check that a folder exists before performing any action
'response.write "<br /><br />*Function doesFolderExist: <b>" & _
'doesFolderExist(getWebFolderPath() & "createdfolder") & "</b>"
'------------------------------------------------------
'------------------------------------------------------
'DOES FILE EXIST: returns true/false
Public Function doesFileExist(folderPathAndName)
	Set myFile = Server.CreateObject( "Scripting.FileSystemObject" )
	If myFile.FileExists(folderPathAndName) Then
		yourmessage = True
	Else
		yourmessage = False
	End If
	doesFileExist = yourmessage
	Set myFile = Nothing
End Function

'TESTING: returns true/false so you can check that a folder exists before performing any action
'response.write "<br /><br />*Function doesFileExist: <b>" & _
'doesFileExist(getWebFolderPath() & "xmlmanager.asp") & "</b>"
'------------------------------------------------------
'------------------------------------------------------
'response.end()









'...MORE...

'*******************************************************************************************
'The wfile() write a string to a file and returns a string variable with a pass/fail message
Public Function wfile( xVar, yVar, zVar )
	Set Sys = Server.CreateObject( "Scripting.FileSystemObject" )
	If yVar Then
		Set Txt = Sys.OpenTextFile( xVar, 2 )
		Txt.Write( zVar )
		Txt.Close
		msg = "PASS: File created, data saved."
	Else
		If Sys.FileExists( xVar ) Then
			msg = "FAIL: File already exists."
		Else
			Set Txt = Sys.OpenTextFile( xVar, 2 )
			Txt.Write( zVar )
			Txt.Close
			msg = "PASS: File created, data saved."
		End If
	End If
	Set Sys = Nothing
	wfile = msg
End Function

'response.write "The wfile() write a string to a file and returns a string variable with a pass/fail message: " & wfile( server.mappath("/test/test.txt"), false, "hello world!<br>" ) & "<br>"



'*******************************************************************************************
'The afile() function appends a string to a file and returns a string variable with a pass/fail message
Public Function afile( xVar, zVar )
	Set Sys = Server.CreateObject( "Scripting.FileSystemObject" )
	If Sys.FileExists( xVar ) Then
		Set Txt = Sys.OpenTextFile( xVar, 8 )
		Txt.write( zVar )
		Txt.Close
		msg = "PASS: File appended, data saved."
	Else
		msg = "FAIL: File does not exist."
	End If
	Set Sys = Nothing
	afile = msg
End Function

'response.write "The afile() function appends a string to a file and returns a string variable with a pass/fail message: " & afile(server.mappath("/test/test.txt"),"hello again...<br>") & "<br>"


'*******************************************************************************************
'The rfile() function reads a file and returns a string variable with the contents of the file
Public Function rfile( xVar )
	Set Sys = Server.CreateObject( "Scripting.FileSystemObject" )
	If Sys.FileExists( xVar ) Then
		Set Txt = Sys.OpenTextFile( xVar, 1 )
		msg = Txt.ReadAll
		Txt.Close
	Else
		msg = "FAIL: File does not exist."
	End If
	Set Sys = Nothing
	rfile = msg
End Function

'response.write "The rfile() function reads a file and returns a string variable with the contents of the file: " & rfile(server.mappath("/test/test.txt")) & "<br>"


'*******************************************************************************************
'The cpfile() function copies a files and returns a string variable with a pass/fail message
Public Function cpfile( xVar, yVar)
	Set Sys = Server.CreateObject( "Scripting.FileSystemObject" )
	If Sys.FileExists( xVar ) Then
		Sys.CopyFile xVar,yVar
		msg = "PASS: File copied."
	Else
		msg = "FAIL: File not found."
	End If
	Set Sys = Nothing
	cpfile = msg
End Function

'response.write "The cpfile() function copies a files and returns a string variable with a pass/fail message: " & cpfile(server.mappath("/") & "/test/test.txt",server.mappath("/") & "/test/test2/") & "<br>"
'response.write "The cpfile() function copies a files and returns a string variable with a pass/fail message: (off)" & "<br>"

       
'*******************************************************************************************
'NOTE: cannot run this successfully if file copied already in function above...and if moved below, will not work again.
'The mvfile() function moves a file and returns a string variable with a pass/fail message
Public Function mvfile( xVar, yVar,fileName)
	Set Sys = Server.CreateObject( "Scripting.FileSystemObject" )
	If Sys.FileExists( xVar ) and not Sys.FileExists( yVar & fileName ) Then
		Sys.MoveFile xVar,yVar
		msg = "PASS: File moved."
	Else
		msg = "FAIL: File not found, or file cannot be moved as already exists."
	End If
	Set Sys = Nothing
	mvfile = msg
End Function

'response.write "The mvfile() function moves a file and returns a string variable with a pass/fail message: " & mvfile(server.mappath("/") & "/test/test.txt",server.mappath("/") & "/test/test2/","test.txt") & "<br>"
'response.write "The mvfile() function moves a file and returns a string variable with a pass/fail message: (off)" & "<br>"

      
'*******************************************************************************************
'NOTE: Dont run this unless you have a file to delete...!
'The rmfile() function deletes a file and returns a string variable with a pass/fail message
Public Function rmfile( xVar )
	Set Sys = Server.CreateObject( "Scripting.FileSystemObject" )
	If Sys.FileExists( xVar ) Then
		Sys.DeleteFile( xVar )
		msg = "PASS: File deleted."
	Else
		msg = "FAIL: File not found."
	End If
	Set Sys = Nothing
	rmfile = msg
End Function

'response.write "The rmfile() function deletes a file and returns a string variable with a pass/fail message: " & rmfile(server.mappath("/") & "/test/test2/test.txt") & "<br>"
'response.write "The rmfile() function deletes a file and returns a string variable with a pass/fail message: (off)" & "<br>"



'Does file exist inside folder?
Public Function rfile( xVar )
Dim Sys
	Set Sys = Server.CreateObject( "Scripting.FileSystemObject" )
	If Sys.FileExists( xVar ) Then
		'Set Txt = Sys.OpenTextFile( xVar, 1 )
		'msg = Txt.ReadAll
		'Txt.Close
		msg = "SUCCESS. file exists!"
	Else
		msg = "FAIL: File does not exist."
	End If
	Set Sys = Nothing
	rfile = msg
End Function

' get file
dim Msg
Msg = rfile(theFile)
Response.Write("<br />Msg: " & Msg)


'Get folder size
Function FolderSize(folspec)
 FolderSize = CreateObject("Scripting.FileSystemObject").GetFolder(folspec).size
End Function


'Is folder empty
Function folIsEmpty(sFldr)
 folIsEmpty = CStr(CBool(CreateObject("Scripting.FileSystemObject").GetFolder(sFldr).Files.Count))
End Function

End Class
'*************************** END CLASS *******************************
'------------------------------------------------------------------------




'********************** GET SERVER VARIABLES LISTING **********************
'SERVER VARIABLE TESTING : Past code below into a web page and uncomment to run and create a server variables listing in the page.
'Great for viewing all server variables on your web server!
'Dim servVar
'Response.Write("<hr /><strong style='color:#003399;'>Server Variable Test</strong>")
'for each servVar in Request.ServerVariables
'Response.Write("<br />&gt;&gt;&gt;" & servVar & " ::: <strong>")
'Response.Write(Request.ServerVariables(servVar) & "</strong>")
'next
'**********************




'**********************
'HOW TO DYNAMICALLY INCLUDE A SCRIPT....
'Note: This script is valuable if you need to load in pure ASP script that needs to execute but you are not sure which script to run based on the location  of the calling ASP web page relative to the location of the script. This is a classic issue in server-side includes, where you need to dynamically attach included code based on various requirements. You can use Server.Execute calls to dynamically attach many kinds of pages, but remember that those types of included pages do NOT process within the scope of the page, so those pages and their variables are NOT avaialble to the calling page and must be processed to html and text before use.
'So remember, "execute" statements execute inside the called page's "page scope" only so any methods or objects created are NOT available to
'the calling web page as is normally available using plain includes!

sub include(sFile)
dim mfo, mf, sTemp
set mfo = Server.CreateObject("Scripting.FileSystemObject")
set mf = mfo.OpenTextFile(sFile, 1, false, -2)
sTemp = mf.ReadAll
mf.close
set mfo = nothing
if (left(sTemp, 2) = "<" & "%") then
sTemp = right(sTemp, len(sTemp) - 2)
end if
if (right(sTemp, 2) = "%" & ">") then
sTemp = left(sTemp, len(sTemp) - 2)
end if
ExecuteGlobal sTemp
end sub

'Call the subroutine above
call include(server.mappath("yourpath/yourdynamicaspscriptfile.asp"))
'==========================================================================================
-->





