` Scriptol examples
` Generic quick sort function
` Using functions as parameters for processing any kind of object


` Arguments are copy of the original variables, unless they are "alias",

int compare(dyn a, dyn b)
	if a
	< b: return -1        ` if a < b returns -1
	> b: return 1         ` if a > b returns 1
	/if
return 0   ` if a = b returns 0


` Arguments are aliases here
` aliases are just local names for the original variables

void swapdyn(alias dyn a, alias dyn b)
	dyn temp = a; a = b; b = temp
return


` New types are declared for the use of function as arguments

define COMPFUN = "compare"
define SWAPFUN = "swapdyn"


` The name of the array is an alias for the original array, that is sorted
` two functions are used as parameters

void quickSort(COMPFUN comp, SWAPFUN sw, alias array theArray, int first, int last)
	int f = first
	int l = last
	dyn item = theArray[(f + l) / 2]

	do
		while comp(theArray[f] , item) < 0  let f + 1
		while comp(item , theArray[l]) < 0  let l - 1
		if f <= l
			sw(theArray[f], theArray[l])
			f + 1
			l - 1
		/if
	/do while f <= l

	if first < l ? quickSort(comp, sw, theArray, first, l)
	if f < last ? quickSort(comp, sw, theArray, f, last)

return


` Creating a compare function for the new kind of object

int textCompare(dyn a, dyn b)
	text x = a.toText()
	text y = b.toText()
return x.compare(y)


` Main function - Using the same sort algorithm with
` two kind of objects: integer and demo

int main()

	print "Generic Sort - sorting an array of integers using functions as parameters"
	
	array theArray = {10, 5, 8, 1, 126, 33, 12, 5, 7, 1000, 2}
	quickSort("compare", "swapdyn", theArray, 0, theArray.size() - 1)
	theArray.display()

	` Texts to be sorted

	print "Using the same algorithm, but different types and functions"

	array a2 = array("ship", "car", "airplane", "train", "rocket")
	quickSort("textCompare", "swapdyn", a2, 0, a2.size() - 1)
	a2.display()

return 0

main()

