<%@ Import Namespace="System.Runtime.InteropServices" %>

<script language="c#" runat="server">
/// --------------------------------------------------------------------------------
/// Sample web page to generate and update TreeGrid data, using TreeGrid.dll
/// This is a simple version of the SrcPage.aspx without caching, loging and tmp files deleting
/// This page can be used as data source for examples, use Examples/Main/Examples.html?src=../AspNet/AjaxDLLServerPageSimple.aspx
/// TreeGrid.dll must be placed in the ../../server/ directory, or the path must be changed in Init() function
/// Uses data from ../Data/ directory, or the path must be changed in Init() function
/// Shows server paging features
/// --------------------------------------------------------------------------------
void Page_Init(object sender, System.EventArgs e){
Init();
}
// ----------------------------------------------------------------------------------------------------
void Page_Load(object sender, System.EventArgs e) {
try {
   string F = Request.Params["Function"];
   if(F=="LoadBody") Response.Write(FuncLoadBody(Request.Params["File"], Request.Params["Def"], Request.Params["Data"], Request.Params["Bonus"])); 
   else if(F=="LoadPage") Response.Write(FuncLoadPage(Request.Params["File"], Request.Params["Def"], Request.Params["Data"], Request.Params["Bonus"]));
   else if(F=="Save") Response.Write(FuncSave(Request.Params["File"], Request.Params["Def"], Request.Params["Data"], Request.Params["Bonus"]));
   else Response.Write(Error(-3, "Wrong function requested"));
   }
catch(Exception ex){
   Response.Write(Error(-3, ex.Message));
   }
}
// ----------------------------------------------------------------------------------------------------
   
// ----------------------------------------------------------------------------------------------------
// Inicialization and TreeGrid.dll loading
void Init() {
Path = System.IO.Path.GetDirectoryName(Context.Request.PhysicalPath) + "\\";
Loaded = LoadLibrary(Path + "..\\..\\Server\\TreeGrid.dll") != IntPtr.Zero; // Load TreeGrid.dll from the same directory as this file
Path += "..\\ServerDLL\\";
}
// ----------------------------------------------------------------------------------------------------
string Path; // Path to data directory
bool Loaded; // If DLL successfuly loaded
// ----------------------------------------------------------------------------------------------------
// TreeGrid.dll import
[DllImport("kernel32.dll", CharSet = CharSet.Auto)]
static extern IntPtr LoadLibrary(string lpFileName);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)] 
public static extern int CreateGrid(string Data, string Layout, string Defaults, string Text, string Bonus, string Bonus2);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)] 
public static extern int UpdateGrid(int Index, string Bonus);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)]
public static extern int FindGrid(string Cfg);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)] 
public static extern int DeleteGrid(int Index);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)]
public static extern void Clear();
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)] 
public static extern string GetBody(int Index, string Cfg);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)] 
public static extern string GetPage(int Index, string Cfg);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)] 
public static extern int Save(int Index, string Input);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)] 
public static extern int SaveToFile(int Index, string FileName, int Type);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)]
public static extern string GetData(int Index);
[DllImport("TreeGrid.dll", CharSet = CharSet.Unicode, CallingConvention = CallingConvention.StdCall)]
public static extern string LastError();

// ----------------------------------------------------------------------------------------------------
// Returns Xml with given error message
private string Error(int num, string mess){
string Err = LastError();
if (Err != null && Err != "") mess = mess + "&#x0A;&#x0A;" + Err.Replace("&", "&amp;").Replace("<", "&lt;").Replace("\"", "&quot;");
return "<Grid><IO Result='" + num + "' Message=\"" + mess + "\"/></Grid>";
}
// ----------------------------------------------------------------------------------------------------
// Returns Grids index for given file or <0 for error
private int GetIndex(string File, string Def, string Cfg, string Bonus){
if(File=="") return -1;
int Index = FindGrid(Cfg);
if (Index >= 0){
   UpdateGrid(Index, Bonus); // Server / Client paging change
   return Index;
   }
string ID = Context.Request.ServerVariables["REMOTE_HOST"].Replace(":", "_") + File;
if (System.IO.File.Exists(Path + "tmp\\" + ID)) return CreateGrid(Path + "tmp\\" + ID, Path + Def, Path + "..\\..\\Grid\\Defaults.xml", Path + "..\\..\\Grid\\Text.xml", Bonus, null);
else return CreateGrid(Path + File, Path + Def, Path + "..\\..\\Grid\\Defaults.xml", Path + "..\\..\\Grid\\Text.xml", Bonus, null);
}
// ----------------------------------------------------------------------------------------------------
// Returns grid data, for Paging==3 returns only empty pages with information about their content
// Data contains XML with grid settings - sorting and filters
private string FuncLoadBody(string File, string Def, string Data, string Bonus) {
if(!Loaded) return Error(-5, "TreeGrid.dll not found");
int Index = GetIndex(File,Def,Data,Bonus);
if(Index<0) return Error(-1,"Server DLL Error: TreeGrid data not found or server has not permission to read them&#x0A;Data are located at /Examples/ServerDLL/");
string Ret = GetBody(Index,Data);
if(Ret==null) return Error(-4,"Server DLL Error: TreeGrid data cannot be loaded");
string ID = Context.Request.ServerVariables["REMOTE_HOST"].Replace(":", "_") + File;
SaveToFile(Index, Path+"tmp\\"+ID, 0);
return Ret;
}
// ----------------------------------------------------------------------------------------------------
// Returns children of one page or one row
// Data contains XML with page index or row id and grid settings - sorting and filters
private string FuncLoadPage(string File, string Def, string Data, string Bonus) {
if(!Loaded) return Error(-5, "TreeGrid.dll not found");
int Index = GetIndex(File,Def,Data,Bonus);
if (Index < 0) return Error(-1, "Server DLL Error: TreeGrid data not found");
string Ret = GetPage(Index,Data);
if (Ret == null) return Error(-3, "Server DLL Error: Configuration changed, you need to reload grid!");
return Ret;
}
// ----------------------------------------------------------------------------------------------------
// Saves changed data to XML file
// Data contains XML with changed rows
private string FuncSave(string File, string Def, string Data, string Bonus) {
if(!Loaded) return Error(-5, "TreeGrid.dll not found");
int Index = GetIndex(File,Def,Data,Bonus);
if (Index < 0) return Error(-1, "Server DLL Error: TreeGrid data not found");
int Ret = Save(Index,Data);
if (Ret < 0) return Error(Ret, "Server DLL Error: Changes were not saved");
string ID = Context.Request.ServerVariables["REMOTE_HOST"].Replace(":", "_") + File;
SaveToFile(Index, Path + "tmp\\" + ID, 0);
if(Ret > 0) return Error(0, "Warning: Not all data were successfully saved !");
return Error(0,"");
}
// ----------------------------------------------------------------------------------------------------
</script>


