// --------------------------------------------------------------------------------------------------------
// Main settings, change them to modify behaviour of examples
if(!window.Base) Base = "./"; // If HTML file is located somewhere else then in Examples/Main/, set this property before script is loaded to dir Examples/Main/
var Method = "Form";     // Upload method, "Form" - HTML form based (not all ASP.NET servers accept this option), "Soap" - SOAP XML
var Format = "Internal"; // Format of uploaded data - "Internal", "DTD" (don't use DTD format in examples, server side service accepts only Internal format)
var Src = ""; // URL of data source script (page or service), can be relative
var FormService = false; // If true, supports ASP.NET web services with Form method, but does not support some other servers like Apache Tomcat
var Debug = 1; // Level of debug, set it to 3 or 4 to see all communication with server (=1 displays only error messages)
// --------------------------------------------------------------------------------------------------------
// Constants, do not modify
var Images = ["Style='G' Grid = 'Grid.gif' Toolbar='Toolbar.gif' Height = '17' Line = '21' Tree = '26' Panel = '13' Sort = '14' Filter = '17' Row = '17'",
				  "Style='GL' Grid = 'GridLight.gif' Toolbar='ToolbarLight.gif' Height = '17' Line = '21' Tree = '26' Panel = '13' Sort = '14' Filter = '17' Row = '17'",
				  "Style='GB' Grid = 'GridBigger.gif' Toolbar='Toolbar.gif' Height = '21' Line = '21' Tree = '26' Panel = '18' Sort = '14' Filter = '17' Row = '17'",
				  "Style='GG' Grid = 'GridGame.gif' Toolbar='Toolbar.gif' Height = '17' Line = '21' Tree = '26' Panel = '13' Sort = '14' Filter = '17' Row = '17'"];
var Titles = ["<span style='color:blue'>Tree:</span> Region => Country (=> State) => Name => Month",
              "<span style='color:blue'>Tree:</span> Country (=> State) => Name => Month",
              "<span style='color:blue'>Tree:</span> Name => Month",
              "<span style='color:blue'>Table:</span> Name - Month",
              "<span style='color:blue'>Tree:</span> Simple example - a bill"];
var TitlesRows = [" <span style='color:blue'>(one month)</span>",
						" <span style='color:blue'>(one year)</span>",
						" <span style='color:blue'>(one year, more partners)</span>"];
var Paging = ["None","Client","Server"];
var Rows = ["  2000 rows","10000 rows","50000 rows"];
var FileNames = ["S","","E"];
// --------------------------------------------------------------------------------------------------------
// Main function called from body.onload
function Start(){
StartTreeGrid();
// --- Parameters parsing ---
var P = location.search.slice(1).split("&"), pag = -1;
for(var i=0;i<P.length;i++){
	var S = P[i].split("="); if(S.length!=2) continue;
	switch(S[0].toLowerCase()){
		case "example" : GetElem("SelectExample").selectedIndex = parseInt(S[1]); break;
		case "paging" : GetElem("SelectPaging").selectedIndex = parseInt(S[1]); break;
		case "pages" : GetElem("SelectPages").selectedIndex = parseInt(S[1]); break;
		case "rows" : GetElem("SelectRows").selectedIndex = parseInt(S[1]); break;
		case "style" : GetElem("SelectStyle").selectedIndex = parseInt(S[1]); break;
		case "src" : Src = S[1]; break;
		case "method" : Method = S[1]; break;		
		case "format" : Format = S[1]; break;
		case "debug" : Debug = parseInt(S[1]); break;
		case "formservice" : FormService = parseInt(S[1]); break;
		}
	}

if(pag==-1 && Src) GetElem("SelectPaging").selectedIndex = 2; // When used src, default is server paging

// --- Updating parameters ---
if(Src && location.protocol=="file:") Src = null; // Src cannot be used locally
if(!Src) GetElem("SelectRows").options[2] = null; // On local cannot use 50000 rows

// --- Creating grid ---
Resize();
setTimeout(function(){ SelectExample(); },10);
window.onresize = Resize;
}
// --------------------------------------------------------------------------------------------------------
// Called when main window resizes
function Resize(){
var H = GetWindowSize()[1];
if(H>300) GetElem("GRID").style.height = H - 250;
}
// --------------------------------------------------------------------------------------------------------
// Helper function for SelectExample, sets content of given Select to Arr items
function SetOptions(Select,Arr){
var sel = Select.selectedIndex<0 ? null : Select.options[Select.selectedIndex];
if(sel) sel = sel.text;
Select.options.length = 0;
for(var i=0,p=0;i<Arr.length;i++) if(Arr[i]) Select.options[p++] = new Option(Arr[i]);
for(var i=0;i<Select.options.length;i++){
	if(Select.options[i].text==sel){ Select.selectedIndex = i; break; }
	}
if(Select.selectedIndex==-1) Select.selectedIndex = 0;
}
// --------------------------------------------------------------------------------------------------------
// Selects new data from paging examples and renders grid
// It is prepared for many settings of global coomunication parameters from top of this file
function SelectExample(){
var ES = GetElem("SelectExample"), E = ES.selectedIndex;
var RS = GetElem("SelectRows"), R = RS.selectedIndex;
var EP = GetElem("SelectPaging"), P = EP.selectedIndex;
var SP = GetElem("SelectPages"), A = SP.selectedIndex;
var SS = GetElem("SelectStyle"), S = SS.selectedIndex;
R = RS.selectedIndex;
var Arr = new Array(); for(var a in Paging) Arr[a] = Paging[a];
if(E>=2) Arr[0] = null;
if(R==2){ Arr[0] = null; Arr[1] = null; }
if(!Src) Arr[2] = null;
SetOptions(EP,Arr);
P = EP.selectedIndex;
Enable(false);
var G = Grids[0], D = /*G ? G.Data :*/ new TDataIO();
GetElem("TITLE").innerHTML = Titles[E] + TitlesRows[R];
var name,def,paging,chpaging;
var TP = EP.options[P].text;
if(TP==Paging[0]) paging=0;
else if(TP==Paging[1]) paging=2;
else paging=3;
if(paging==3 && !Src) paging=2;
chpaging = paging==3 ? 3 : 2;
name = "Data"+(E+1)+/*"DC"+*/FileNames[R]+".xml";
def = "Data"+(E+1)+(R==2&&E==3 || paging==3&&E==2?"E":"")+"Def.xml";
D.Layout.Url = Base+def;
D.Layout.Bonus = "<Grid><Img "+Images[S]+"/><Cfg Paging='"+paging+"' ChildPaging='"+chpaging+"' AllPages='"+(A?0:1)+"' AllPagesLap='1' SessionId='"+FileNames[R]+"'/></Grid>";
if(!Src){
	D.Data.Url = Base+name;
	}
else {
   if(Src.slice(0,7)=="http://" && window.netscape) netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
   D.Data.Url = Src;
	D.Page.Url = D.Data.Url;	
	D.Upload.Url = D.Data.Url;
   if(Method.toLowerCase()=="form"){
      D.Data.Method = "Form";
      D.Data.Param["Function"] = "LoadBody";
      D.Page.Param["Function"] = "LoadPage";
      D.Upload.Param["Function"] = "Save";
      if(FormService){
         D.Data.Url+="/LoadBody";
         D.Page.Url+="/LoadPage";
         D.Upload.Url+="/Save";
         }
      }
   else {
		D.Data.Method = "Soap";
		D.Data.Function = "LoadBody";
		D.Data.Namespace = "TreeGrid";
		D.Page.Function = "LoadPage";	
	   D.Upload.Function = "Save";
		}
	D.Data.Param["File"] = name;
	D.Data.Param["Def"] = def;
	D.Data.Param["Bonus"] = D.Layout.Bonus.replace(/\&/g,"&amp;").replace(/\</g,"&lt;").replace(/\>/g,"&gt;");
	D.Data.Data = "Data";
	D.Data.Format = Format;
   D.Data.Timeout = R==2&&E==3 ? 20 : 10;
   D.Data.Repeat = 2;
	
	D.Page.Method = D.Data.Method;
   D.Page.Namespace = D.Data.Namespace;
   D.Page.Param["File"] = D.Data.Param["File"];
   D.Page.Param["Def"] = D.Data.Param["Def"];
   D.Page.Param["Bonus"] = D.Data.Param["Bonus"];
	D.Page.Data = "Data";
	D.Page.Format = Format;
   D.Page.Timeout = 5;
   D.Page.Repeat = 1;

	D.Upload.Method = D.Data.Method;
   D.Upload.Namespace = D.Data.Namespace;
   D.Upload.Param["File"] = D.Data.Param["File"];
   D.Upload.Param["Def"] = D.Data.Param["Def"];
   D.Upload.Param["Bonus"] = D.Data.Param["Bonus"];
   D.Upload.Data = "Data";
	D.Upload.Format = Format;
	D.Upload.Timeout = 10;
   D.Upload.Repeat = 2;
   }
D.Upload.Timeout = 60; D.Data.Timeout = 60; D.Page.Timeout = 60;
if(Debug) for(var d in D) D[d].Debug=Debug;
if(G) {
	if(!G.Reload(D)) Enable(true);
	}
else TreeGrid(D,"GRID");
}
// --------------------------------------------------------------------------------------------------------
// Changes TreeGrid's AllPages property and updates it, does not reload
function SelectPages(idx){
var G = Grids[0];
if(!G) return;
G.SetAllPages(!idx,true);
G.SetScrollBars();
var r = G.FRow; G.FRow = null;
G.Focus(r,G.FCol);
}
// --------------------------------------------------------------------------------------------------------
// Changes style of TreeGrid, does not reload, just re-renders
function SelectStyle(idx){
Enable(false);
var G = Grids[0];
G.ChangeStyle("<Grid><Img "+Images[idx]+"/></Grid>");
}
// -------------------------------------------------------------------------------------------
// Called to move focus to grid from <select> control
function TabInside(event,input,move){
if(Grids[0].TabInside(event,move)){ input.blur(); window.focus(); }
}
// -------------------------------------------------------------------------------------------
// Event handler, fired if focus moves by tab key outside the grid to focus <select> control
Grids.OnTabOutside = function(G,move){
var I = GetElem(move<0 ? "SelectStyle" : "SelectExample"); I.focus(); return true;
}
// --------------------------------------------------------------------------------------------------------
// Called after TreeGrid is rendered, to enable selectboxes
Grids.OnRenderFinish = function(){
var G = Grids[0];
if(G && G.Rendering) setTimeout(Enable,200);
else Enable(true);
}
// --------------------------------------------------------------------------------------------------------
// Called if TreeGrid cannot download data
Grids.OnLoadError = function(){
Enable(true);
}
// --------------------------------------------------------------------------------------------------------
// Enables or disables all selectboxes
function Enable(enable){
var SE = GetElem("SelectExample");
SE.disabled = !enable;
GetElem("SelectStyle").disabled = !enable;
if(enable && SE.selectedIndex<0) enable = false;
GetElem("SelectPaging").disabled = !enable;
GetElem("SelectPages").disabled = !enable;
GetElem("SelectRows").disabled = !enable;
}
// --------------------------------------------------------------------------------------------------------
function ShowCfg(ev){
var G = Grids[0];
if(!G) return;
G.ControlPanel.Click(10,ev);
}
// --------------------------------------------------------------------------------------------------------


// --------------------------------------------------------------------------------------------------------
// Tree Grid event handlers for particular examples
// --------------------------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------------------------
// Event handler, for 3. example for not US countries disables State editing
Grids.OnCanEdit = function(G,row,col,e){
if(G.id!="List3") return e;
if(col=="O") return G.GetString(row,"N")=="UNITED STATES" || row.Kind=="Filter" && G.Paging!=3;
return e;
}
// --------------------------------------------------------------------------------------------------------
// Event handler for 3. example - returns correct enum for Country and State for by value in Region and Country
Grids.OnGetEnum = function(G,row,col,f){
if(G.id!="List3") return f;
if(col=="N"){
	switch(G.GetValue(row,"M")){
		case 0 : return ["ARMENIA","AZERBAIJAN","BANGLADESH","INDIA","KAZAKSTAN","PAKISTAN","SRI LANKA"];
		case 1 : return ["AUSTRALIA","BRUNEI","CHINA","HONG KONG","INDONESIA","JAPAN","KOREA, DPR","MALAYSIA","MONGOLIA","MYANMAR","NEW ZEALAND","PAPUA NEW GUINEA","PHILIPPINES","SINGAPORE","SOUTH KOREA","TAIWAN","THAILAND","VIETNAM"];
		case 2 : return ["ALBANIA","BELARUS","BULGARIA","CROATIA","CZECH REPUBLIC","ESTONIA","HUNGARY","LATVIA","LITHUANIA","MOLDOVA","POLAND","ROMANIA","RUSSIA","SERBIA-MONTENEGRO","SLOVAK REPUBLIC","SLOVENIA","UKRAINE"];
		case 3 : return ["ALGERIA","BAHRAIN","EGYPT","IRAN","IRAQ","ISRAEL","JORDAN","KUWAIT","LEBANON","LIBYA","MOROCCO","OMAN","QATAR","SAUDI ARABIA","SYRIA","TUNISIA","UAE","YEMEN"];
		case 4 : return ["BAHAMAS","CANADA","COSTA RICA","CUBA","DOMINICAN REPUBLIC","EL SALVADOR","GUATEMALA","HAITI","HONDURAS","JAMAICA","MEXICO","NICARAGUA","PANAMA","TRINIDAD & TOBAGO","UNITED STATES"];
		case 5 : return ["ARGENTINA","BOLIVIA","BRAZIL","CHILE","COLOMBIA","ECUADOR","GUYANA","PARAGUAY","PERU","SURINAME","URUGUAY","VENEZUELA"];
		case 6 : return ["ANGOLA","BOTSWANA","BURKINA FASO","CAMEROON","CONGO","CONGO DR","COTE D'IVOIRE","ETHIOPIA","GABON","GAMBIA","GHANA","GUINEA","GUINEA-BISSAU","KENYA","LIBERIA","MADAGASCAR","MALAWI","MALI","MOZAMBIQUE","NAMIBIA","NIGER","NIGERIA","SENEGAL","SIERRA LEONE","SOMALIA","SOUTH AFRICA","SUDAN","TANZANIA","TOGO","UGANDA","ZAMBIA","ZIMBABWE"];
		case 7 : return ["AUSTRIA","BELGIUM","CYPRUS","DENMARK","FINLAND","FRANCE","GERMANY","GREECE","ICELAND","IRELAND","ITALY","LUXEMBOURG","MALTA","NETHERLANDS","NORWAY","PORTUGAL","SPAIN","SWEDEN","SWITZERLAND","TURKEY","UNITED KINGDOM"];
		}
	}
if(col=="O"){
	if(G.GetString(row,"N")=="UNITED STATES"){
		return ["Alabama","Alaska","Arizona","Arkansas","California","Colorado","Connecticut","Delaware","Florida","Georgia","Hawaii","Idaho","Illinois","Indiana","Iowa","Kansas","Kentucky","Louisiana","Maine","Maryland","Massachusetts","Michigan","Minnesota","Mississippi","Missouri","Montana","Nebraska","Nevada","New Hampshire","New Jersey","New Mexico","New York","North Carolina","North Dakota","Ohio","Oklahoma","Oregon","Pennsylvania","Rhode Island","South Carolina","South Dakota","Tennessee","Texas","Utah","Vermont","Virginia","Washington","West Virginia","Wisconsin","Wyoming"];	
		}
	}
return f;
}
// --------------------------------------------------------------------------------------------------------
// Refreshes cells for 3. example if changed Region or country and for all examples guards value of Rabat
Grids.OnValueChanged = function(G,row,col,val){
if(col=="C"){
	if(val-0<0 || val-0>50){ alert("Rabat can be in range 0% - 50% only"); val = val-0 < 0 ? 0 : 50; }
	return val;
	}
if(G.id!="List3") return val;
if(col=="M") setTimeout( function(){ 
	if(G.FRow!=row || G.FCol!="N") G.RefreshCell(row,"N"); 
	if(G.FRow!=row || G.FCol!="O"){ row.O=0; G.RefreshCell(row,"O"); }
	},100);
else if(col=="N") setTimeout( function(){ 
	if(G.FRow!=row || G.FCol!="O"){ row.O=0; G.RefreshCell(row,"O"); }
	},100);
return val;
}
// --------------------------------------------------------------------------------------------------------
// Class for row Results
Grids.OnGetClass = function(G,row,col,cls){
if(row.id=="Results"){
	if(cls=="GText" && col=="B") return "GTextM";
	if(cls=="GNumber" && col=="L") return "GNumberM";
	if(cls=="GNumber") return "GNumberB";
	if(cls=="GText") return "GNumberB";
	}
return cls;
}
// --------------------------------------------------------------------------------------------------------
// Shows user dialog on button click
Grids.OnButtonClick = function(G,row,col){
G.ShowDialog(row,col,"<DIV style='background:#ffffaa;border:2px inset #ddaadd; padding:10px;'> User dialog on<br>row '"+row.B+"'<br>column '"+G.GetCaption(col)+"'<br>"
+"<BR><DIV align=center><BUTTON style='width:60;' onclick='Grids[0].CloseDialog();'>OK</BUTTON></DIV></DIV>");
}
// --------------------------------------------------------------------------------------------------------
