/* biosgetc.S: BIOS call: get PnP ISA configuration structure */
/*
 * $Header: /root/pnp/module/RCS/biosgetc.S,v 1.3 1996/06/12 18:56:34 root Exp $
 *
 * $Log: biosgetc.S,v $
 * Revision 1.3  1996/06/12  18:56:34  root
 * standard internal i/f & BIOS read/query
 *
 * Revision 1.2  1996/05/26  19:07:39  root
 * code restructured & modularized
 *
 * Revision 1.1  1996/05/26  15:35:25  root
 * initial revision
 *
 */

/*
 * (c) Copyright 1996  D.W.Howells <dwh@nexor.co.uk>,
 */

#ifdef __ELF__
  #define ENTRY(x) x
#else
  #define ENTRY(x) _##x
#endif

#define GET_NUM_NODES 0
#define GET_ISA_CONFIG_STRUC 0x40

/*
 * int pnp_bios__getconfig(
 *	u_char *revision,	; where to store structure revision
 *	csn_t *ncsn,		; where to store number of CSNs assigned
 *	u_short *port		; where to store the ISA Read Data port
 *	);
 */
#define REVISION	0x08(%ebp)
#define NCSN		0x0c(%ebp)
#define PORT		0x10(%ebp)

.globl ENTRY(pnp_bios__getconfig)
ENTRY(pnp_bios__getconfig):
	pushl %ebp
	movl %esp,%ebp
	pushl %ebx
	pushl %ecx
	pushl %edx

	/* push the arguments as 16-bit values */
#define ARGBLOCK 0x08
	subl $ARGBLOCK,%esp
	movl %esp,%edx
	movl ENTRY(pnpbios_ds),%eax		/* BIOS selector */
	movw %ax,0x06(%edx)
	movl ENTRY(pnpbios_kdata_ds),%eax	/* seg for structure buffer */
	movw %ax,0x04(%edx)
	movw $00,%ax		/* offset for structure buffer */
	movw %ax,0x02(%edx)
	movw $GET_ISA_CONFIG_STRUC,%ax	/* function */
	movw %ax,0x00(%edx)

	/* stack the return address from BIOS (to the 16->32 bit returner) */
	subl $0x04,%esp
	movl %esp,%edx
	movw ENTRY(pnpbios_ret_cs),%ax
	movw %ax,0x02(%edx)		/* %cs */
	movw $0x0000,%ax
	movw %ax,0x00(%edx)		/* %ip */

	/* stack the BIOS address to be called (32-bit lret!!!!) */
	movw ENTRY(pnpbios_cs),%eax
	andl $0xffff,%eax
	pushl %eax			/* %cs */
	movl ENTRY(pnpbios_entry),%eax
	andl $0xffff,%eax
	pushl %eax			/* %eip */

	/* return address to here placed in registers */
	leal ENTRY(return_from_BIOS),%ebx
	movw %cs,%cx
	andl $0xffff,%ecx

	/* call BIOS */
	lret

/*
 * This is where BIOS returns to (%ax holds the return value)
 *
 *
 */
ENTRY(return_from_BIOS):
	/* unstack the parameters */
	addl $ARGBLOCK,%esp

	/* make return an int */
	cwtl

	/* now sort out the arg-returned values */
	mov %es,%bx
	mov ENTRY(pnpbios_kdata_ds),%ecx
	mov %cx,%es
	mov %es:0x0000,%dh
	mov %es:0x0001,%dl
	mov %es:0x0002,%cx
	mov %bx,%es

	/* store port, ncsn and revision */	
	movl PORT,%ebx
	movw %cx,(%ebx)
	movl NCSN,%ebx
	movb %dl,(%ebx)
	movl REVISION,%ebx
	movb %dh,(%ebx)

	/* tidy the stack */
	pop %edx
	pop %ecx
	pop %ebx
	pop %ebp
	ret
