/*
 * Copyright 2002-2017 Drew Noakes
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 *
 * More information about this project is available at:
 *
 *    https://drewnoakes.com/code/exif/
 *    https://github.com/drewnoakes/metadata-extractor
 */

package com.drew.lang;

import org.junit.Test;

import java.util.ArrayList;
import java.util.List;

import static org.junit.Assert.assertEquals;

/**
 * @author Drew Noakes https://drewnoakes.com
 */
public class StringUtilTest
{
    @Test public void testJoinIterable()
    {
        List<String> strings = new ArrayList<String>();
        strings.add("A");
        strings.add("B");
        strings.add("C");

        assertEquals("A;B;C", StringUtil.join(strings, ";"));

        assertEquals("", StringUtil.join(new ArrayList<String>(), ";"));
    }

    @Test public void testJoinArray()
    {
        String[] strings = new String[]{"A", "B", "C"};

        assertEquals("A;B;C", StringUtil.join(strings, ";"));

        assertEquals("", StringUtil.join(new ArrayList<String>(), ";"));
    }
}
