#ifndef swShader_PixelProcessor_hpp
#define swShader_PixelProcessor_hpp

#include "Context.hpp"
#include "FIFOCache.hpp"

namespace swShader
{
	struct XVertex;
	class State;
	class PixelShader;
	class Rasterizer;
	class RenderTarget;
	class FVFFlags;
	class Texture;

	class PixelProcessor : protected Context
	{
		class State
		{
		public:
			State();
			State(const State &state);

			State &operator=(const State &state);

			~State();

			void setShaderFile(const char *shaderFile);
			void setPipelineState(int state);
			void setSamplerState(int stage, int state);

			bool operator==(const State &state) const;
			bool operator!=(const State &state) const;

		private:
			void updateStamp();

			char *shaderFile;
			int pipelineState;
			int samplerState[16];
			int stamp;
		};

	public:
		PixelProcessor();

		~PixelProcessor();

		static void setFloatConstant(int index, const float value[4]);

		static void setFloatConstant(int index, const Vector &V);
		static void setFloatConstant(int index, const Point &P);
		static void setFloatConstant(int index, const Matrix &M);

		void setShader(const char *shaderFile);
		void setRenderTarget(const RenderTarget *renderTarget);
		void setVertexFormat(const FVFFlags &FVF);

		void setTextureMap(int stage, Texture *texture);
		void releaseTextures();

		void setTexCoordIndex(int stage, int texCoordIndex);
		void setStageOperation(int stage, Sampler::StageOperation stageOperation);
		void setFirstArgument(int stage, Sampler::SourceArgument firstArgument);
		void setSecondArgument(int stage, Sampler::SourceArgument secondArgument);
		void setThirdArgument(int stage, Sampler::SourceArgument thirdArgument);
		void setFirstModifier(int stage, Sampler::ArgumentModifier firstModifier);
		void setSecondModifier(int stage, Sampler::ArgumentModifier secondModifier);
		void setThirdModifier(int stage, Sampler::ArgumentModifier thirdModifier);
		void setDestinationArgument(int stage, Sampler::DestinationArgument destinationArgument);
		void setTextureFilter(int sampler, Sampler::FilterType textureFilter);
		void setAddressingMode(int sampler, Sampler::AddressingMode addressingMode);

		void setDepthCompare(DepthCompareMode depthCompareMode);
		void setAlphaCompare(AlphaCompareMode alphaCompareMode);
		void setDepthWriteEnable(bool depthWriteEnable);
		void setAlphaTestEnable(bool alphaTestEnable);
		void setCullMode(CullMode cullMode);

		void setShadingMode(ShadingMode shadingMode);
		void setSpecularEnable(bool specularEnable);

		void setAlphaBlendEnable(bool alphaBlendEnable);
		void setSourceBlendFactor(BlendFactor sourceBlendFactor);
		void setDestBlendFactor(BlendFactor destBlendFactor);

		void setAlphaReference(int alphaReference);

	protected:
		void renderPolygon(XVertex **V, int n, FVFFlags FVF);

	private:
		const State &status() const;
		void update(FVFFlags FVF);
		
		Rasterizer *rasterizer;

		char *shaderFile;
		FIFOCache<State, PixelShader> *shaderCache;
		PixelShader *shader;

		bool updateShader;
	};
}

#endif   // swShader_PixelProcessor_hpp