/*
 *	Load network interfaces (*.xif) from /mint/ and /multitos/.
 *
 *	06/22/94, Kay Roemer.
 */

/* Keep netinfo.h from defining it */
#define NETINFO

#include <ostruct.h>
#include <basepage.h>
#include "kerbind.h"
#include "inet.h"
#include "if.h"
#include "buf.h"
#include "ifeth.h"
#include "netinfo.h"	/* must be after if.h and buf.h */

struct netinfo netinfo = {
	buf_alloc, buf_free, buf_reserve, buf_deref,
	if_enqueue, if_dequeue, if_register, if_input, if_flushq,
	chksum, if_getfreeunit,
	eth_build_hdr, eth_remove_hdr
};

char *paths[] = { "\\mint\\", "\\multitos\\" };

typedef long (*XIFFUNC) (struct kerinfo *, struct netinfo *);

void
if_load (void)
{
	static char oldpath[PATH_MAX];
	static _DTA dta;
	_DTA *olddta;
	BASEPAGE *bp;
	XIFFUNC initf;
	short i;
	long r;

	olddta = (_DTA *)f_getdta ();
	d_getpath (oldpath, 0);
	f_setdta (&dta);

	c_conws ("Loading interfaces:\n\r");

	for (i = 0; i < sizeof (paths)/sizeof (*paths); ++i) {
		r = d_setpath (paths[i]);
		if (r == 0)
			r = f_sfirst ("*.xif", 0);

		while (r == 0) {
			bp = (BASEPAGE *)p_exec (3, dta.dta_name, "", 0);
			if ((long)bp < 0) {
				DEBUG (("if_load: can't load %s",
					dta.dta_name));
				r = f_snext ();
				continue;
			}
			m_shrink (0, bp, 512+bp->p_tlen+bp->p_dlen+bp->p_blen);
			initf = (XIFFUNC)bp->p_tbase;
			TRACE (("if_load: init %s", dta.dta_name));
			if ((*initf) (KERINFO, &netinfo) != 0) {
				DEBUG (("if_load: init %s failed",
					dta.dta_name));
				m_free (bp);
			}
			TRACE (("if_load: init %s ok.", dta.dta_name)); 
			r = f_snext ();
		}
	}
	d_setpath (oldpath);
	f_setdta (olddta);
}
