#ifndef LINT
/* @(#) sysv.c 2.5 88/01/10 14:47:24 */
static char sysvid[]="@(#) sysv.c 2.5 88/01/10 14:47:24";
#endif /* LINT */

/* machine.c for System V */

/*
The contents of this file are hereby released to the public domain.

                                    -- Rahul Dhesi  1986/12/31
*/

#ifdef UNBUF_IO
/*
Function tell() returns the current seek position for a file 
descriptor.  Microport System V/AT has an undocumented tell()
library function (why?) but the UNIX PC doesn't, so we code
one here.  It is needed for unbuffered I/O only.
*/
long lseek PARMS ((int, long, int));
long tell (fd)
int fd;
{ return (lseek (fd, 0L, 1)); }
#endif

/****************
Date and time functions are standard UNIX-style functions.  "nixtime.i"
will be included by machine.c.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

/* Function isadir() returns 1 if the supplied handle is a directory, 
else it returns 0.  
*/

int isadir (file)
ZOOFILE file;
{
   int handle = fileno(file);
   struct stat buf;           /* buffer to hold file information */
   if (fstat (handle, &buf) == -1) {
      return (0);             /* inaccessible -- assume not dir */
   } else {
      if (buf.st_mode & S_IFDIR)
         return (1);
      else
         return (0);
   }
}

/****************
Function fixfname() converts the supplied filename to a syntax
legal for the host system.  It is used during extraction.
*/

char *fixfname(fname)
char *fname;
{
   return (fname); /* default is no-op */
}

extern long timezone;   /* defined by library routine */
long time ();
struct tm *localtime ();

/* Function gettz(), returns the offset from GMT in seconds of the
local time, taking into account daylight savings time */
long gettz()
{
	struct tm *tm;
	long clock;
	clock = time ((long *) 0);
	tm = localtime (&clock);
   return (timezone - tm->tm_isdst*3600);
}

/* Standard UNIX-compatible time functions */
#include "nixtime.i"

/* Standard UNIX-specific file attribute routines */
#include "nixmode.i"

/* 
Make a directory.  System V has no system call accessible to 
ordinary users to make a new directory.  Hence we spawn a shell 
and hope /bin/mkdir is there.  Since /bin/mkdir gives a nasty 
error message if it fails, we call it only if nothing already 
exists by the name of the needed directory.
*/

int mkdir(dirname)
char *dirname;
{
   char cmd[PATHSIZE+11+1]; /* room for "/bin/mkdir " used below  + 1 spare */
   if (!exists(dirname)) {
      strcpy(cmd, "/bin/mkdir ");
      strcat(cmd, dirname);
      return (system(cmd));
   }
	return (0);
}
