/********************************************************************/

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include "plot.h"
#define in_window1(x) (x >= oymin && x<= oymax)
#define in_window2(x,y) (y >= oymin && y<= oymax && x <oxmax && x > oxmin)
#define NOTHING 0
#define ORBIT 1
#define DFIELD 2
extern int    c_token,num_tokens;
extern struct udft_entry *dummy_func;
extern struct dummy_obj  *dummy_obj_list;
extern struct an_object  *look_for_object_name();
extern struct an_object  *look_for_object_by_index();
extern struct a_graph    *look_for_graph_by_index();
extern struct a_material *look_for_mat_by_index();
extern struct an_action  *r_actions;
extern char   temp_line[], input_line[];
extern char c_dummy_var[], c_dummy_var1[];
extern char c_dummy_var2[], c_dummy_var3[];
extern double        real();
extern struct value  *complex();
extern struct a_graph    *current_graph, *last_graph;
char *odetitle;
char   *malloc();
char   *strcat(), *malloc();


typedef struct dfobj{
  struct dfobj *next;
  int type,active,mode,n;
  float *data;
} dfobj;

dfobj *dfobjs;
/*
 *  this is a big waste but surffice at this time.
 *  place to hold the vectors and orbits.
 */
float orbit[5008];
int xgrid, ygrid;
float oxmin= -10.0, oymin= -10.0,oxmax = 10.0, oymax= 10.0;
/********************************************************************/
#define TPE (t_plot->picture).eqn
#define TCE (t_plot->picture).eqn
/********************************************************************/
ode_orbit(x,y)
     float x,y;
{
  struct a_graph *t_plot = current_graph;
  TPE.x0 = (double)x;
  TPE.y0 = (double)y;
  calculate(current_graph);
}
ode_df()
{
  df_mode();
  calculate(current_graph);
  orbit_mode();
}  
/********************************************************************/
dfobj *new_dfobjs()
{
  dfobj **tmp = &dfobjs;
  if( last_graph == (struct a_graph *)0 || last_graph != current_graph)
    destroy_current_picture();

  if(current_graph) odetitle = current_graph->definition;
  else odetitle = (char *)0;

  if(is_orbit_mode() || dfobjs == (dfobj *)0)
    {
      while(*tmp) tmp = &((*tmp)->next);
      if( (*tmp = (dfobj *)malloc( (unsigned)sizeof(dfobj))) == (dfobj *)NULL)
	int_error("Out of memory",-1);
      (*tmp)->next = (dfobj *)0;
      (*tmp)->active = 0;
      (*tmp)->mode = NOTHING;
      (*tmp)->n = 0;
      (*tmp)->data = (float *)NULL;
    }
  return (*tmp);
}
copy_current_plot()
{
  int i,j,k, n;
  dfobj *tmp;
  i = 0; n = (int) orbit[4005];
  if( n > 4000) n = 4000;

  if(is_orbit_mode())
    {
      while( i < n)
	{
	again:
	  while(orbit[i++] != 12345.0 && i < n);
	  if( orbit[i] < 4.0) goto again;
	  if( i < n) {
	    tmp = new_dfobjs();
	    tmp->data=(float *)malloc((unsigned)((int)orbit[i])*sizeof(float));
	    if( tmp->data == (float *)0) int_error("Out of memory",-1);
	    tmp->n = (int)orbit[i];
	    tmp->mode = ORBIT;
	    j = i + 1 + (int) orbit[i] ;
	    for (k = i+1; k< j; k++)
	      tmp->data[k-i-1] = orbit[k];
	  }
	}
    }
  if(is_df_mode())
    {
      int nvects = (xgrid - 1)*(ygrid -1)*2;
      tmp = new_dfobjs();      
      if( tmp->data) (void)free( tmp->data);
      tmp->data=(float *)malloc( (unsigned) (2+nvects)*sizeof(float));
      if( tmp->data == (float *)0) int_error("Out of memory",-1);      
      tmp->mode = DFIELD;
      tmp->n = nvects;
      for(i = 0; i< nvects; i++)
	tmp->data[i] = orbit[i+2];
    }
  last_graph = current_graph;
  orbit_mode();
}
/********************************************************************/
destroy_current_picture()
{
  dfobj **tmp = &dfobjs, **tmp1;
  while(*tmp)
    {
      tmp1 = &((*tmp)->next);
      if( (*tmp)->data)
	(void) free( (*tmp)->data);
      free( *tmp);
      tmp = tmp1;
    }
  dfobjs = (dfobj *)0;
}

/********************************************************************/
make_direction_field(t_plot)
     struct a_graph *t_plot;
{

  double zy1,y2,y3,y4;
  double dy1,dy2,dy3,dy4;
  double xdif, ydif,r, norm = -1000000.0;
  float fnorm;
  register int    i, j, k;

  if(TCE.xgrid>50) TCE.xgrid = 50;
  if(TCE.ygrid>50) TCE.ygrid = 50;
  xgrid = TCE.xgrid; ygrid = TCE.ygrid;

  xdif = (TCE.xmx- TCE.xmn)/TCE.xgrid;
  ydif = (TCE.ymx- TCE.ymn)/TCE.ygrid;
  zy1 = y2 = y3 = y4 = 0.0;
  dy1 = dy2 = dy3=dy4=0.0;
  for(i = 0; i < xgrid - 1; i++)
    for(j = 0; j < ygrid - 1; j++)
      {
	zy1 = TCE.xmn + (double)(i+1) * xdif;
	y2 = TCE.ymn + (double)(j+1) * ydif; 
	compute_deri(t_plot,&zy1,&y2,&y3,&y4,&dy1,&dy2,&dy3,&dy4);
	r = (dy1 * dy1 +  dy2 * dy2); if(r > norm) norm = r;
	k = 2*(i * (ygrid -1)+ j) + 2;
	orbit[k] = (float)dy1; orbit[k+1] = (float)dy2; 
      }
  if(norm == 0.0) norm = 1.0;
  r = xdif; if (r > ydif) r = ydif;
  fnorm = 0.9 * r / ((float) sqrt(norm));

  for(i = 2; i < 2*(xgrid-1)*(ygrid -1)+2; i += 2)
    {
      orbit[i] *= fnorm;  orbit[i+1] *= fnorm; 
      /*     printf(" %f  %f \n", orbit[i], orbit[i+1]); */
    }
  orbit[0] = (float) 2*(xgrid -1)*(ygrid -1)+2;
}
/************************************************************/
make_ode_traj(t_plot)
     struct a_graph *t_plot;
{
  oxmin = TCE.xmn; oxmax = TCE.xmx;
  oymin = TCE.ymn; oymax = TCE.ymx;
  orbit[0] = 0.0;
  if(TCE.dimension == 2) { make_ode_traj2(t_plot); return(2);}
  else if(TCE.dimension == 3){  make_ode_traj3(t_plot); return(3);}
  return(0);
}
      
make_ode_traj2(t_plot)
     struct a_graph *t_plot;
{
  double time,zy1,y2,y3,y4,yy1,yy2,yy3,yy4;
  double dy1,dy2,dy3,dy4;
  double htry,hdid,hnext;
  int    flag,skip_count,fix_count, ind, outside,start_index;
  
  flag = 0; ind = 2; outside = 0; start_index = 2;
  orbit[0]=12345.0; orbit[1] = 0.0;
  skip_count = 0;  
  zy1  = (t_plot->picture).eqn.x0;
  y2  = (t_plot->picture).eqn.y0;
  y3  = (t_plot->picture).eqn.z0;
  y4  = (t_plot->picture).eqn.w0;

  /* forward orbit */
  /* set the step to bee at most 1/200 of the width */
  htry = (TCE.xmx  -TCE.xmn)/200.0;
  if((t_plot->picture).eqn.step > htry) (t_plot->picture).eqn.step = htry;
  htry  = (t_plot->picture).eqn.step;

  TCE.end_time = TCE.xmx - TCE.x0;
  fix_count = (t_plot->picture).eqn.skip;

  time = 0.0;
  while( (time <=  (t_plot->picture).eqn.end_time) && !flag && ind < 2000)
    {
      if(! (skip_count % fix_count))
	{
	  skip_count = 0;
	  if(in_window1(y2))
	    {
	      orbit[ind++] = (float)zy1 - oxmin; 
	      orbit[ind++] = (float)y2 - oymin;
	      outside = 0;
	    }
	  else if( !outside && ind > start_index)
	    {
	      orbit[ind++] = 12345.0;
	      orbit[start_index-1] = (float)(ind - start_index-1);
	      start_index = ++ind;
	      outside = 1;
	    }
	}
      compute_deri(t_plot,&zy1,&y2,&y3,&y4,&dy1,&dy2,&dy3,&dy4);
      if( (t_plot->picture).eqn.method == RK)
	RK4_solver(zy1,y2,y3,y4,
		   dy1,dy2,dy3,dy4,&yy1,&yy2,&yy3,&yy4,t_plot,htry);
      else if( (t_plot->picture).eqn.method == RKQC)
	RKQC_solver(zy1,y2,y3,y4,dy1,dy2,dy3,dy4,
		    &yy1,&yy2,&yy3,&yy4,t_plot,&htry,&hdid,&hnext,&flag);
      if(flag) 
	(void)fprintf(STDERRR,"\tRKQC abort at time %f,step = 0.0\n",
		      (float)time);
      zy1 = yy1;
      y2 = yy2; 
      if((t_plot->picture).eqn.method == RKQC )  
	{
	  htry = hnext;;
	  time += hdid;
	}
      else
	time += (t_plot->picture).eqn.step;
      skip_count++;
    }
  if(!outside)
    {
      orbit[ind++] = 12345.0;
      orbit[start_index-1] = (float)(ind - start_index -1);
      start_index = ++ind;
    }

  zy1  = (t_plot->picture).eqn.x0;
  y2  = (t_plot->picture).eqn.y0;
  y3  = (t_plot->picture).eqn.z0;
  y4  = (t_plot->picture).eqn.w0;

  /* backward orbit */
  TCE.end_time = TCE.xmn - TCE.x0;
  htry  = (-1.0)* (t_plot->picture).eqn.step;

  time = 0.0;
  outside =0; flag=0; skip_count = 0;
  while( (time >= (t_plot->picture).eqn.end_time) && !flag & ind < 4000)
    {
      if(! (skip_count % fix_count))
	{
	  skip_count = 0;
	  if(in_window1(y2))
	    {
	      orbit[ind++] = (float)zy1 - oxmin; 
	      orbit[ind++] = (float)y2 - oymin;
	      outside = 0;
	    }
	  else if( !outside && ind > start_index)
	    {
	      orbit[ind++] = 12345.0;
	      orbit[start_index-1] = (float)(ind - start_index -1);
	      start_index = ++ind;
	      outside = 1;
	    }
	}
      compute_deri(t_plot,&zy1,&y2,&y3,&y4,&dy1,&dy2,&dy3,&dy4);
      if( (t_plot->picture).eqn.method == RK)
	RK4_solver(zy1,y2,y3,y4,
		   dy1,dy2,dy3,dy4,&yy1,&yy2,&yy3,&yy4,t_plot,htry);
      else if( (t_plot->picture).eqn.method == RKQC)
	RKQC_solver(zy1,y2,y3,y4,dy1,dy2,dy3,dy4,
		    &yy1,&yy2,&yy3,&yy4,t_plot,&htry,&hdid,&hnext,&flag);
      if(flag) 
	(void)fprintf(STDERRR,"\tRKQC abort at time %f,step = 0.0\n",
		      (float)time);
      zy1 = yy1;
      y2 = yy2; 
      if((t_plot->picture).eqn.method == RKQC )  
	{
	  htry = hnext;;
	  time += hdid;
	}
      else
	time -= (t_plot->picture).eqn.step;
      skip_count++;
    }
  if(!outside)
    orbit[start_index-1] = (float)(ind - start_index);
  else
    orbit[start_index -2] = 0.0;
  orbit[4005] = ind;
}
/****************************************************************/
make_ode_traj3(t_plot)
     struct a_graph *t_plot;
{
  double time,zy1,y2,y3,y4,yy1,yy2,yy3,yy4;
  double dy1,dy2,dy3,dy4;
  double htry,hdid,hnext;
  int    flag,skip_count,fix_count, ind, outside,start_index;
  
  flag = 0; ind = 2; outside = 0; start_index = 2;
  orbit[0]=12345.0;
  
  skip_count = 0;  
  zy1  = (t_plot->picture).eqn.x0;
  y2  = (t_plot->picture).eqn.y0;
  y3  = (t_plot->picture).eqn.z0;
  y4  = (t_plot->picture).eqn.w0;

  /* forward orbit */
  htry  = (t_plot->picture).eqn.step;
  fix_count = (t_plot->picture).eqn.skip;

  time = TCE.start_time;
  while( (time <=  (t_plot->picture).eqn.end_time) && !flag && ind<2000)
    {
      if(! (skip_count % fix_count))
	{
	  skip_count = 0;
	  if(in_window2(zy1,y2))
	    {
	      orbit[ind++] = (float)zy1 - oxmin; 
	      orbit[ind++] = (float)y2 - oymin;
	      outside = 0;
	    }
	  else if( !outside && ind > start_index)
	    {
	      orbit[ind++] = 12345.0;
	      orbit[start_index-1] = (float)(ind - start_index -1);
	      start_index = ++ind;
	      outside = 1;
	    }
	}
      compute_deri(t_plot,&zy1,&y2,&y3,&y4,&dy1,&dy2,&dy3,&dy4);
      if( (t_plot->picture).eqn.method == RK)
	RK4_solver(zy1,y2,y3,y4,
		   dy1,dy2,dy3,dy4,&yy1,&yy2,&yy3,&yy4,t_plot,htry);
      else if( (t_plot->picture).eqn.method == RKQC)
	RKQC_solver(zy1,y2,y3,y4,dy1,dy2,dy3,dy4,
		    &yy1,&yy2,&yy3,&yy4,t_plot,&htry,&hdid,&hnext,&flag);
      if(flag) 
	(void)fprintf(STDERRR,"\tRKQC abort at time %f,step = 0.0\n",
		      (float)time);
      zy1 = yy1;
      y2 = yy2; 
      if((t_plot->picture).eqn.method == RKQC )  
	{
	  htry = hnext;;
	  time += hdid;
	}
      else
	time += (t_plot->picture).eqn.step;
      skip_count++;
    }
  if(!outside)
    {
      orbit[ind++] = 12345.0;
      orbit[start_index-1] = (float)(ind - start_index-1);
      start_index = ++ind;
    }

  zy1  = (t_plot->picture).eqn.x0;
  y2  = (t_plot->picture).eqn.y0;
  y3  = (t_plot->picture).eqn.z0;
  y4  = (t_plot->picture).eqn.w0;

  /* backward orbit */
  htry  = (-1.0)* (t_plot->picture).eqn.step;

  time = -(TCE.start_time); outside =0;  flag = 0; skip_count = 0;
  while( (time >= -(t_plot->picture).eqn.end_time) && !flag & ind < 4000)
    {
      if(! (skip_count % fix_count))
	{
	  skip_count = 0;
	  if(in_window2(zy1,y2))
	    {
	      orbit[ind++] = (float)zy1 - oxmin; 
	      orbit[ind++] = (float)y2 - oymin;
	      outside = 0;
	    }
	  else if( !outside && ind > start_index)
	    {
	      orbit[ind++] = 12345.0;
	      orbit[start_index-1] = (float)(ind - start_index -1);
	      start_index = ++ind;
	      outside = 1;
	    }
	}
      compute_deri(t_plot,&zy1,&y2,&y3,&y4,&dy1,&dy2,&dy3,&dy4);
      if( (t_plot->picture).eqn.method == RK)
	RK4_solver(zy1,y2,y3,y4,
		   dy1,dy2,dy3,dy4,&yy1,&yy2,&yy3,&yy4,t_plot,htry);
      else if( (t_plot->picture).eqn.method == RKQC)
	RKQC_solver(zy1,y2,y3,y4,dy1,dy2,dy3,dy4,
		    &yy1,&yy2,&yy3,&yy4,t_plot,&htry,&hdid,&hnext,&flag);
      if(flag) 
	(void)fprintf(STDERRR,"\tRKQC abort at time %f,step = 0.0\n",
		      (float)time);
      zy1 = yy1;
      y2 = yy2; 
      if((t_plot->picture).eqn.method == RKQC )  
	{
	  htry = hnext;;
	  time += hdid;
	}
      else
	time -= (t_plot->picture).eqn.step;
      skip_count++;
    }
  if(!outside)
    orbit[start_index-1] = (float)(ind - start_index);
  else
    orbit[start_index-2] = 0.0;
  orbit[4005] = ind;
}
/****************************************************************/
orbit_mode()
{
  (current_graph->picture).eqn.orbit = 1;
}
df_mode()
{
  (current_graph->picture).eqn.orbit = 0;
}
is_orbit_mode()
{
  return((current_graph->picture).eqn.orbit == 1);
}
is_df_mode()
{
  return((current_graph->picture).eqn.orbit == 0);
}

/****************************************************************/
int ode_range_defined = 0;
int ode_range_fixed = 0;

extract_range()
{
  destroy_current_picture();  /* destroy data only a new plot command */
  set_xrange(1);              /* this function is only called by the  */
  set_yrange(1);              /* plot command. Each plot starts from  */
                              /* scratch */
}

set_yrange(i) int i;
{
  struct value a;
  if(!equals(c_token,"["))  return;
  c_token++;
  if(isletter(c_token)) c_token++;
  if( equals(c_token,"=") || equals(c_token,":")) c_token++;
  oymin =  (float) real(const_express(&a));
  if( equals(c_token,",") || equals(c_token,":")) c_token++;
  oymax =  (float) real(const_express(&a));
  if(!equals(c_token,"]")) int_error(" `]` expected", c_token);
  c_token++;
  if(i) ode_range_defined = 2;
  else ode_range_fixed = 2;
}
/****************************************************************/

set_xrange(i) int i;
{
  struct value a;
  if(!equals(c_token,"["))  return;
  c_token++;
  if(isletter(c_token)) c_token++;
  if( equals(c_token,"=") || equals(c_token,":")) c_token++;
  oxmin =  (float) real(const_express(&a));
  if( equals(c_token,",") || equals(c_token,":")) c_token++;
  oxmax =  (float) real(const_express(&a));
  if(!equals(c_token,"]")) int_error(" `]` expected", c_token);
  c_token++;
  if(i) ode_range_defined = 1;
  else ode_range_fixed = 1;
}  
/****************************************************************/
int grid_set = 0;
set_grid()
{
  struct value a;
  if(!equals(c_token,"["))  return;
  c_token++;
  xgrid = (int) real(const_express(&a));
  if( equals(c_token,",") || equals(c_token,":")) c_token++;
  ygrid =  (int) real(const_express(&a));
  if(!equals(c_token,"]")) int_error(" `]` expected", c_token);
  c_token++;
  grid_set = 1;
}  
/****************************************************************/
