


/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */



#ifndef INSTDEF
#define INSTDEF

#include "oogl/geomclass.h"
#include "oogl/bbox.h"

typedef struct {
    Transform 	axis;
    Geom	*geom;
    Geom        *group;
    GeomReference *geomref;
} Inst;

extern GeomClass *InstMethods( void );
extern char *InstName( void );
extern Inst *InstPrint( Inst * );
extern Inst *InstCreate( Geom *geom );
extern Inst *InstDelete( Inst * );
extern Inst *InstLoad( char * );
extern Inst *InstFLoad( FILE * );
extern Inst *InstSave( Inst *, char * );
extern Inst *InstFSave( Inst *, FILE * );
extern BBox *InstBound( Inst *, Transform T );
extern Inst *InstPosition( Inst *, Transform T );
extern Inst *InstTransformTo( Inst *, Transform T );
extern Inst *InstTransform( Inst *, Transform T );
extern Inst *InstRotate( Inst *, double, Point * );
extern Inst *InstTranslate( Inst *, double, double, double );
extern Inst *InstScale( Inst *, double, double, double );
extern Inst *InstEvert( Inst * );
extern Inst *InstDraw( Inst *, ContextObject * );
extern Inst *InstDrawIrisGl( Inst *, ContextObject * );
extern Inst *InstDrawRenderman( Inst *, ContextObject * );
extern Inst *InstDrawXWindows( Inst *, ContextObject * );
extern Geom *InstPick( Inst *, Transform T, double x, double y, float *z );
extern Geom *InstPickPoint( Inst *, Transform T, double x, double y, float *z,Point *pt);
extern Geom *InstPickPlane( Inst *, Transform T, double x, double y, float *z,Plane *pl);
extern Geom *InstPickLine( Inst *, Transform T, double x, double y, float *z, Line *ln);
extern Geom *InstReplace( Inst *, Geom * );

#ifdef GEOM_SM
typedef struct {
    Transform	axis;
    SharedGeom	*sgeom;
} SharedInst;

SharedInst *InstShare( Geom *obj, GeomSMRegion *sm );
Inst *InstPrivate( Geom *sobj, GeomSMRegion *sm );
#endif /*GEOM_SM*/


#endif
