! MMS file for building GPLOT, GTEX and DRAWCGM on VMS

! use this if we will be debugging
CFLAGS = /LIS/show=(include,expan)/DEBUG/NOOPT
! FFLAGS = /DEBUG/NOOP
! LINKFLAGS = /DEBUG
! use this for production
! LINKFLAGS = /NOTRACEBACK

! To use a driver, add the following to the defs of the DRV,
! DEFS and LIBS macros:
!			DRV		DEFS		LIBS
!	tektronix	tek.obj		"inctek"
!	postscript	ps.obj		"incps"
!	peritek		peritek.obj	"incpk"		sys$library:cxp2n/lib
!	gks		gks.obj		"incgks"
!	binary CGM	cgmb.obj	"inccgmb"
!	clear text CGM	cgmc.obj	"inccgmc"
!	XLib		xl.obj		"incxl"
!       xws driver      $(XWS_OBJ)      "incxws"
!       Talaris printer excl.obj        "incexcl"
!       qms driver      qms.obj         "incqms"
!

XWS_OBJ = xws_cla.obj,xws_color.obj,xws_delim.obj,xws_marker.obj, -
	xws_polygon.obj,xws_polyline.obj,xws_setup.obj,xws_text.obj, -
	drvcla.obj,ardent.obj

DRV = ps.obj,tek.obj,cgmb.obj,cgmc.obj

DEFS = "incps","inctek", "inccgmb", "inccgmc"

! To add a controller, add the following to the defs of the CTRL and
! CTRL_DEFS macros below. 
!			CTRL		    CTR_DEFS
!	tty		tty.obj		    "inctty"     (ALWAYS INCLUDE THIS)
!	DiaQuest	dq.obj,fs.obj	    "incdq"      (DIAQUEST TAPE
!                                                         CONTROLLER)
!       LaserVideo      lvr.obj,lvr_io.obj  "inclvr"     (CONTROLLER FOR LASER
!                                                         VIDEO DISK RECORDER)

!

CTRL = tty.obj

CTR_DEFS = "inctty"

LIBS = 
                        
! The following line specifies the use of Hershey fonts and TeX PK fonts.  
FONTS = hload.obj, pkras.obj

! ********************************************************************
!
!   You should not have to modify the rest of the descrip.mms file
!   if you are using the xl driver for gplotdw. To make changes, 
!   follow the directions below.
!
! ********************************************************************

DCGM_PATH = [.drawcgm]

ALL : GPLOT.EXE, GTEX.EXE, GPLOTDW.EXE, DRAWCGM.OLB, TESTS
	write sys$output "done"

! GPlot dependencies
GPLOT.EXE : GPLOT.OBJ, CGM.OBJ, UTILS.OBJ, IO.OBJ, CARRAY.OBJ, -
	CCGM.OBJ, DEVICES.OBJ, EMUL.OBJ, GPT_COMMANDS.OBJ, -
	$(FONTS), $(CTRL), $(DRV) 
	$(LINK)$(LINKFLAGS) GPLOT, CGM, UTILS, IO, CARRAY, DEVICES, -
		CCGM, GPT_COMMANDS, EMUL, $(FONTS), $(CTRL), -
		$(DRV), $(LIBS) CC/OPT

! GTex dependencies
GTEX.EXE : GTEX.OBJ, CGM.OBJ, UTILS.OBJ, IO.OBJ, DEVICES.OBJ,-
	CACHE.OBJ, GPT_COMMANDS.OBJ, EMUL.OBJ, -
	CARRAY.OBJ, $(FONTS), $(CTRL), $(DRV)
	$(LINK)$(LINKFLAGS) GTEX, CGM, UTILS, IO, CARRAY, DEVICES, -
		CCGM, GPT_COMMANDS, EMUL, CACHE, $(FONTS), $(CTRL),- 
		$(DRV), $(LIBS) CC/OPT

! Drawcgm dependencies
$(DCGM_PATH)DRAWCGM.OLB : $(DCGM_PATH)DRAWCGM.OBJ, $(DCGM_PATH)CGMGEN.OBJ, -
	$(DCGM_PATH)CGM_CLIP.OBJ, $(DCGM_PATH)CGM_TEXTEM.OBJ, -
	UTILS.OBJ, CARRAY.OBJ, IO.OBJ, GPT_COMMANDS.OBJ, -
	DEVICES.OBJ, EMUL.OBJ, $(FONTS), $(CTRL), $(DRV)
	lib/create $(DCGM_PATH)drawcgm.olb $(DCGM_PATH)drawcgm.obj,-
		$(DCGM_PATH)cgmgen.obj,$(DCGM_PATH)cgm_clip.obj,-
		$(DCGM_PATH)cgm_textem.obj,[]utils.obj,carray.obj,io.obj,-
		gpt_commands.obj,emul.obj,devices.obj,-
		$(FONTS),$(CTRL),$(DRV)

! Drawcgm and Cgmgen tests
TESTS : $(DCGM_PATH)DRAWCGM_TEST.EXE, $(DCGM_PATH)DRAWCGM_TST2.EXE, -
	$(DCGM_PATH)CGMGEN_TEST.EXE, $(DCGM_PATH)CLIP_TEST.EXE
	write sys$output "tests done"

! GPLOTDW dependencies 
! To use the xws driver for gplotdw, include $(XWS_OBJ) instead of xl.obj
GPLOTDW.EXE : GPLOTDW.OBJ, WINT.OBJ, CGM.OBJ, UTILS.OBJ, IO.OBJ, CARRAY.OBJ, -
	CCGM.OBJ, EMUL.OBJ, GPT_COMMANDS.OBJ, $(FONTS), XL.OBJ, $(LIBS)
	$(LINK)$(LINKFLAGS) GPLOTDW, WINT, CGM, UTILS, IO, CARRAY, XL.OBJ, -
		CCGM, GPT_COMMANDS, EMUL, $(FONTS), CC/OPT

CLEAN :
	purge *.exe,$(DCGM_PATH)drawcgm.olb
	rm *.obj;*
	rm $(DCGM_PATH)*.obj;*

! First and second Drawcgm test routines
$(DCGM_PATH)DRAWCGM_TEST.EXE : $(DCGM_PATH)DRAWCGM_TEST.OBJ -
	$(DCGM_PATH)DRAWCGM.OLB
	$(LINK)$(LINKFLAGS)/exe=$@ $(DCGM_PATH)drawcgm_test.obj, -
		$(DCGM_PATH)drawcgm.olb/lib, []CC/OPT

$(DCGM_PATH)DRAWCGM_TST2.EXE : $(DCGM_PATH)DRAWCGM_TST2.OBJ -
	$(DCGM_PATH)DRAWCGM.OLB
	$(LINK)$(LINKFLAGS)/exe=$@ $(dcgm_path)drawcgm_tst2.obj, -
		$(DCGM_PATH)drawcgm.olb/lib, []CC/OPT

$(DCGM_PATH)DRAWCGM_TEST.OBJ : $(DCGM_PATH)DRAWCGM_TEST.FOR
	$(FORT)$(FFLAGS)/obj=$@ $(DCGM_PATH)drawcgm_test.for

$(DCGM_PATH)DRAWCGM_TST2.OBJ : $(DCGM_PATH)DRAWCGM_TST2.FOR
	$(FORT)$(FFLAGS)/obj=$@ $(DCGM_PATH)drawcgm_tst2.for

$(DCGM_PATH)CGMGEN_TEST.EXE : $(DCGM_PATH)CGMGEN_TEST.OBJ, -
	$(DCGM_PATH)CGMGEN_TEST2.OBJ, $(DCGM_PATH)DRAWCGM.OLB
	$(LINK)$(LINKFLAGS)/exe=$@ $(DCGM_PATH)cgmgen_test, -
		$(DCGM_PATH)cgmgen_test2, $(DCGM_PATH)drawcgm.olb/lib, []CC/OPT

$(DCGM_PATH)CLIP_TEST.EXE : $(DCGM_PATH)CLIP_TEST.OBJ, -
	$(DCGM_PATH)DRAWCGM.OLB
	$(LINK)$(LINKFLAGS)/exe=$@ $(DCGM_PATH)clip_test, -
		$(DCGM_PATH)drawcgm.olb/lib, []CC/OPT

!Cgmgen test routine
$(DCGM_PATH)CGMGEN_TEST.OBJ : $(DCGM_PATH)CGMGEN_TEST.FOR
	$(FORT)$(FFLAGS)/obj=$@ $(DCGM_PATH)cgmgen_test.for

$(DCGM_PATH)CGMGEN_TEST2.OBJ : $(DCGM_PATH)CGMGEN_TEST2.C, DEFS.H
	$(CC)$(CFLAGS)/obj=$@ $(DCGM_PATH)cgmgen_test2

!Cgmgen clipping test routine
$(DCGM_PATH)CLIP_TEST.OBJ : $(DCGM_PATH)clip_test.c
	$(CC)$(CFLAGS)/obj=$@ $(DCGM_PATH)clip_test.c

! drawcgm library
$(DCGM_PATH)DRAWCGM.OBJ : $(DCGM_PATH)DRAWCGM.FOR
	$(FORT)$(FFLAGS)/obj=$@ $(DCGM_PATH)drawcgm.for

! cgmgen library
$(DCGM_PATH)CGMGEN.OBJ : $(DCGM_PATH)CGMGEN.C, DEFS.H, -
		$(DCGM_PATH)CGM_CLIP.H, $(DCGM_PATH)CGM_TEXTEM.H
	$(CC)$(CFLAGS)/obj=$@ $(DCGM_PATH)cgmgen

! clipping routines
$(DCGM_PATH)CGM_CLIP.OBJ : $(DCGM_PATH)CGM_CLIP.C, $(DCGM_PATH)CGM_CLIP.H
	$(CC)$(CFLAGS)/obj=$@ $(DCGM_PATH)cgm_clip.c

! cgmgen text emulation interface
$(DCGM_PATH)CGM_TEXTEM.OBJ : $(DCGM_PATH)CGM_TEXTEM.C, -
	$(DCGM_PATH)CGM_TEXTEM.H, $(DCGM_PATH)defs.h
	$(CC)$(CFLAGS)/obj=$@ $(DCGM_PATH)cgm_textem.c

! controlling GPLOT program
GPLOT.OBJ : GPLOT.C, DEFS.H

! controlling GPLOTDW program
GPLOTDW.OBJ : GPLOTDW.C, DEFS.H
!Uncomment the next line to use xws instead of xl for gplotdw
!	$(CC)$(CFLAGS) GPLOTDW/DEFINE=("incxws")

! all of the cgm specific stuff (binary)
CGM.OBJ : CGM.C, DEFS.H

! all of the cgm specific stuff (clear text)
CCGM.OBJ : CCGM.C, CCDEFS.H, DEFS.H

! utility functions
UTILS.OBJ : UTILS.C, DEFS.H
	$(CC)$(CFLAGS) UTILS/DEFINE=("incpkras", "inchershey")

! I/O routines
IO.OBJ : IO.C, DEFS.H
	$(CC)$(CFLAGS) IO/DEFINE=( $(CTR_DEFS) )

! devices interface
DEVICES.OBJ : DEVICES.C, DEFS.H
	$(CC)$(CFLAGS) DEVICES/DEFINE=( $(CTR_DEFS), $(DEFS) )

! Cell Array library
CARRAY.OBJ : CARRAY.C, DEFS.H

!TTY controller
TTY.OBJ : TTY.C, DEFS.H

!DIAQUEST controller 
DQ.OBJ : DQ.C, DEFS.H

! Postscript device
PS.OBJ : PS.C, DEFS.H

! Tektronix devices
TEK.OBJ : TEK.C, DEFS.H

! UIS workstation
UIS.OBJ : UIS.C, DEFS.H

! GKS stuff
GKS.OBJ : GKS.C, DEFS.H

! CGM binary output
CGMB.OBJ : CGMB.C, DEFS.H

! XLib driver
XL.OBJ : XL.C, DEFS.H

! CGM Clear Text device
CGMC.OBJ : CGMC.C, CCDEFS.H, DEFS.H

! driver cell array service routines
DRVCLA.OBJ : DRVCLA.C, DEFS.H

! PERITEK driver for animations
PERITEK.OBJ : PERITEK.C, DEFS.H

! CLI STUFF
GPT_COMMANDS.OBJ : GPT_COMMANDS.CLD
	SET COMMAND/OBJ GPT_COMMANDS

! GTex
GTEX.OBJ : GTEX.C, DEFS.H
	$(CC)$(CFLAGS) GTEX/DEFINE=( $(DEFS) )

HLOAD.OBJ : HLOAD.C, DEFS.H, HLOAD.H

PKRAS.OBJ : PKRAS.C, DEFS.H

CACHE.OBJ : CACHE.C, DEFS.H

!Emulation Package
EMUL.OBJ : EMUL.C, DEFS.H

!Talaris EXCL Printers   
EXCL.OBJ : EXCL.C, DEFS.H

!QMS driver             
QMS.OBJ : QMS.C, DEFS.H  
         
!Sony Laser Video Disk Recorder   
lvr.obj : lvr.c, lvr_defines.h
	cc/define=(DEFAULT_PORT="""tta1:""",AUDIT_FILE="""lvr.dat""") lvr.c

lvr_io.obj : lvr_io.c, lvr_defines.h  
	cc/define=DEBUG_IO lvr_io.c

!  XWS driver
xws_setup.obj :	xws_setup.c, defs.h, xws_defs.h

xws_delim.obj : xws_delim.c, defs.h, xws_defs.h

xws_color.obj :	xws_color.c, defs.h, xws_defs.h, xws_color.h

xws_polyline.obj : xws_polyline.c, defs.h, xws_defs.h

xws_polygon.obj : xws_polygon.c, defs.h, xws_defs.h, xws_fill.h

xws_marker.obj : xws_marker.c, defs.h, xws_defs.h

xws_text.obj :	xws_text.c, defs.h, xws_defs.h

xws_cla.obj :   xws_cla.c, defs.h, xws_defs.h, xws_color.h


!HELP FILES
SYS$HELP:HELPLIB.HLB(GPLOT=GPLOT.HLP) : GPLOT.HLP
