/*****************************************************************************
* Setting attributes for objects.					     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
*****************************************************************************/

#include <string.h>
#include <stdio.h>
#include <math.h>
#include "irit_sm.h"
#include "imalloc.h"
#include "miscattr.h"

/*****************************************************************************
* DESCRIPTION:                                                               *
*   Routine to release the data slot of an attribute.			     *
* This routine also exists in attribut.c with object handling. it will be    *
* linked in iff no object handling is used.				     *
*                                                                            *
* PARAMETERS:                                                                *
*   Attr:     To free.                                                       *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
void _AttrFreeAttributeData(IPAttributeStruct *Attr)
{
    switch (Attr -> Type) {
	case IP_ATTR_INT:
	    break;
	case IP_ATTR_REAL:
	    break;
	case IP_ATTR_STR:
	    IritFree((VoidPtr) Attr -> U.Str);
	    break;
	case IP_ATTR_PTR:
	    IritFree((VoidPtr) Attr -> U.Ptr);
	    break;
	case IP_ATTR_OBJ:
	    IritFatalError("Should not free object in misc attributes.");
	    break;
	default:
	    IritFatalError("Undefined attribute type");
	    break;
    }
}
