 /*
  * Khoros: $Id: vshape.h,v 1.1 1991/05/10 15:47:34 khoros Exp $
  */

 /*
  * $Log: vshape.h,v $
 * Revision 1.1  1991/05/10  15:47:34  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vshape.h
 >>>>            Author: Pascal ADAM, Shirley Lee
 >>>> Date Last Updated: Wed Mar 27 18:18:00 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vshape_h_
#define _vshape_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vshape Argument Structure
*
****************************************************************/

typedef struct _vshape  {

/*----- these are a Required mutually exclusive group ----*/
/*
 *  input Clust/Label Image (Required infile)
 */
char	*i1_file;	/* input Clust/Label Image FILENAME */
int	 i1_flag;	/* input Clust/Label Image FLAG */

/*
 *  input Grey Level Image (Required infile)
 */
char	*i2_file;	/* input Grey Level Image FILENAME */
int	 i2_flag;	/* input Grey Level Image FLAG */

/*-------------------------------------------*/

/*
 *  output Axis image (Optional outfile)
 */
char	*o1_file;	/* output Axis image FILENAME */
int	 o1_flag;	/* output Axis image FLAG */

/*
 *  output outline image (Optional outfile)
 */
char	*o2_file;	/* output outline image FILENAME */
int	 o2_flag;	/* output outline image FLAG */

/*
 *  output VIFF file (Optional outfile)
 */
char	*o3_file;	/* output VIFF file FILENAME */
int	 o3_flag;	/* output VIFF file FLAG */

/*
 *  output ASCII file (Optional outfile)
 */
char	*f_file;	/* output ASCII file FILENAME */
int	 f_flag;	/* output ASCII file FLAG */

/*
 *  if yes, compute standard moments (Optional logical)
 */
int	 ms_logic;	/* if yes, compute standard moments LOGIC */
int	 ms_flag;  	/* if yes, compute standard moments FLAG */

/*
 *  if yes, compute central moments (Optional logical)
 */
int	 mc_logic;	/* if yes, compute central moments LOGIC */
int	 mc_flag;  	/* if yes, compute central moments FLAG */

/*
 *  if yes, compute invariant moments (Optional logical)
 */
int	 mi_logic;	/* if yes, compute invariant moments LOGIC */
int	 mi_flag;  	/* if yes, compute invariant moments FLAG */

/*
 *  if no computes axis of bounded box (Optional logical)
 */
int	 mr_logic;	/* if no computes axis of bounded box LOGIC */
int	 mr_flag;  	/* if no computes axis of bounded box FLAG */

/*
 *  if no color = white, with black background (Optional logical)
 */
int	 col_logic;	/* if no color = white, with black background LOGIC */
int	 col_flag;  	/* if no color = white, with black background FLAG */

}  vshape_struct;

vshape_struct *vshape;

/* -include_additions */
#define         ALL_OPTS        61
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    if (vshape->i2_flag == TRUE) { \
       image = readimage(vshape->i2_file); \
       if (image == NULL){ \
          (void) fprintf(stderr,"vshape: Image could not be read\\n"); \
          exit(1); \
          } \
       } \
    else { \
       if (vshape->i1_flag == TRUE) { \
          image = readimage(vshape->i1_file); \
          if (image == NULL){ \
             (void) fprintf(stderr,"vshape: Image could not be read\\n"); \
             exit(1); \
             } \
          } \
       else { \
          (void) fprintf(stderr, "vshape: input image required !! \n\n"); \
          (void) gw_usage(); \
          exit(1); \
          } \
       }
#define CHECKINPUT(program, image) \
        if ((image->data_storage_type != VFF_TYP_1_BYTE) && \
            (image->data_storage_type != VFF_TYP_2_BYTE) && \
            (image->data_storage_type != VFF_TYP_4_BYTE) && \
            (image->data_storage_type != VFF_TYP_FLOAT) ) { \
            (void) fprintf(stderr,  \
                   "vshape:  Can't accept this Data Storage Type!\n\n"); \
            exit(1); \
            } \
        (void) proper_num_images(program,image,1,TRUE); \
        (void) proper_num_bands(program,image,1,TRUE); \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
