 /*
  * Khoros: $Id: vgcirc.c,v 1.2 1991/12/18 09:41:17 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgcirc.c,v 1.2 1991/12/18 09:41:17 dkhoros Exp $";
#endif

 /*
  * $Log: vgcirc.c,v $
 * Revision 1.2  1991/12/18  09:41:17  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgcirc.c
 >>>>
 >>>>      Program Name: vgcirc
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates an image of a filled circle
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Dec  9 23:22:51 1991
 >>>>
 >>>>          Routines: main- the main program for vgcirc
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgcirc.h"


/****************************************************************
 *
 * Routine Name:  main program for vgcirc
 *
 *       Input:  
 *        -o  output image 
 *        -t  Selects data type of output image
 *		'byte' (choose Byte data storage type),
 *		 or 'float' (choose Float data storage type)
 *		 
 *
 *
 *        [-trigger] trigger input
 *        [-r] Desired number of rows in output image  (value > 0)
 *        [-c] Desired number of columns in output image  (value > 0)
 *        [-d] Diameter of circle (in pixels)  (value >= 0.0)
 *        [-x] X coordinate of center of circle 
 *        [-y] Y coordinate of center of circle 
 *        [-b] Background level 
 *        [-f] Foreground level 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image;
int type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if(check_args())exit(1);

if(!vget_type(&type, vgcirc->t_toggle)){
   fprintf(stderr,"vgcirc:  Invalid data type specified\n");
   exit(1);
}

if(type!=VFF_TYP_1_BYTE && type!=VFF_TYP_FLOAT){
   fprintf(stderr,"%s:  Illegal image data type specified.\n",program);
   exit(1);
}

if (vgcirc->r_int <= 0 || vgcirc->c_int <= 0){
  fprintf(stderr,"%s: Rows and columns must be positive and non-zero\n",program);
  exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvgcirc( &image,vgcirc->r_int,vgcirc->c_int, type, vgcirc->b_float, vgcirc->f_float,vgcirc->x_float,vgcirc->y_float, vgcirc->d_float))
  {
      (void) fprintf(stderr, "lvgcirc Failed\n");
      exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vgcirc->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgcirc 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgcirc :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates an image of a filled circle\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\t-t  ");
	fprintf(stderr, "Selects data type of output image\n  ");
	fprintf(stderr, "\t\t'byte'  (choose Byte data storage type),\n");
	fprintf(stderr, "\t\t or 'float'  (choose Float data storage type)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-r]  Desired number of rows in output image (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-c]  Desired number of columns in output image (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-d]  Diameter of circle (in pixels) (float, >= 0.0) [256]\n");
	fprintf(stderr,"\t[-x]  X coordinate of center of circle (float) [256]\n");
	fprintf(stderr,"\t[-y]  Y coordinate of center of circle (float) [256]\n");
	fprintf(stderr,"\t[-b]  Background level (float) [0]\n");
	fprintf(stderr,"\t[-f]  Foreground level (float) [255]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgcirc\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgcirc\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgcirc.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgcirc.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgcirc
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*t_pstr = "\nEnter: (t) Selects data type of output image -- \n      \t\t'byte' (choose Byte data storage type)\n\t\tor 'float' (choose Float data storage type)\n     : "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) Desired number of rows in output image \n        {integer, > 0 [512] }: "; 
char	*c_pstr = 
	"\nEnter: (c) Desired number of columns in output image \n        {integer, > 0 [512] }: "; 
char	*d_pstr = 
	"\nEnter: (d) Diameter of circle (in pixels) \n        {float, >= 0.0 [256.000000] }: "; 
char	*x_pstr = 
	"\nEnter: (x) X coordinate of center of circle \n        {float [256.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) Y coordinate of center of circle \n        {float [256.000000] }: "; 
char	*b_pstr = 
	"\nEnter: (b) Background level \n        {float [0.000000] }: "; 
char	*f_pstr = 
	"\nEnter: (f) Foreground level \n        {float [255.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgcirc", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgcirc.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgcirc: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgcirc.ans");
		}

	     }

	}

	/*
	 * allocate the vgcirc structure
	 */
	vgcirc = (vgcirc_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgcirc_struct));

	/*
	 * get required arguments for vgcirc
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgcirc->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgcirc->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgcirc->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgcirc->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgcirc->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


	/*
	 * get required toggles for vgcirc
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vgcirc->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vgcirc->t_toggle),
		"byte");

		if ((((strcmp(vgcirc->t_toggle, "byte") == 0)) || 
		     ((strcmp(vgcirc->t_toggle, "float") == 0))) &&
		     (vgcirc->t_flag))
		      ok = TRUE;
		else
		{
		    fprintf(stderr, "\nt is a required argument.\n");
		}
	    }
	}
	else
	{
		vgcirc->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vgcirc->t_toggle),
		"byte");

		if ((((strcmp(vgcirc->t_toggle, "byte") != 0)) && 
		     ((strcmp(vgcirc->t_toggle, "float") != 0))) ||
		     (!(vgcirc->t_flag)))
		{
		    fprintf(stderr, "t is a required argument.\n");
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}

	/*
	 * get optional arguments for vgcirc
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgcirc->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vgcirc->trigger_file))
;

	vgcirc->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vgcirc->r_int),
	512, 2, 2);

	vgcirc->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vgcirc->c_int),
	512, 2, 2);

	vgcirc->d_flag = vget_float(fid, prompt_flag,
	"-d", d_pstr, &(vgcirc->d_float),
	256.000000, 1.000000, 1.000000);

	vgcirc->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vgcirc->x_float),
	256.000000, 0.000000, 0.000000);

	vgcirc->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vgcirc->y_float),
	256.000000, 0.000000, 0.000000);

	vgcirc->b_flag = vget_float(fid, prompt_flag,
	"-b", b_pstr, &(vgcirc->b_float),
	0.000000, 0.000000, 0.000000);

	vgcirc->f_flag = vget_float(fid, prompt_flag,
	"-f", f_pstr, &(vgcirc->f_float),
	255.000000, 0.000000, 0.000000);


}



