 /*
  * Khoros: $Id: vfft.c,v 1.4 1992/01/17 00:43:47 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vfft.c,v 1.4 1992/01/17 00:43:47 dkhoros Exp $";
#endif

 /*
  * $Log: vfft.c,v $
 * Revision 1.4  1992/01/17  00:43:47  dkhoros
 * HellPatch4
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vfft.c
 >>>>
 >>>>      Program Name: vfft
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Computes the two dimensional Fast Fourier Transform (FFT)
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Jan 15 10:00:33 1992
 >>>>
 >>>>          Routines: main- the main program for vfft
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vfft.h"


/****************************************************************
 *
 * Routine Name:  main program for vfft
 *
 *       Input:  
 *      -i1  complex or real image 
 *
 *
 *      [-i2] imaginary image
 *      [-o1] complex output image
 *      [-o2] real output image
 *      [-o3] imaginary output image
 *      [-d] FFT direction (0 is forward, 1 is inverse)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image1, *image2, *o_image1, *o_image2, *o_image3;
struct xvimage *images[2], *readimage(), *createimage();
int num_images, upcast_flg;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

upcast_flg = 0;
image1 = NULL;
image2 = NULL;
READINPUT(image1);
CHECKINPUT(program, image1);

if ( (image1->data_storage_type == VFF_TYP_1_BYTE) || (image1->data_storage_type ==VFF_TYP_2_BYTE) || (image1->data_storage_type == VFF_TYP_4_BYTE) )
{
   upcast_flg = 1;
}
images[0] = image1;
num_images = 1;

if ( (image1->data_storage_type == VFF_TYP_COMPLEX) && (vfft->i2_flag) )
{
  (void) fprintf(stderr, "vfft: Input image 1 is complex. \n");
  (void) fprintf(stderr, "Unable to accept imaginary input for second image.\n");
  exit(1);
}

if (vfft->i2_flag)
{
  image2 = readimage(vfft->i2_file);
  if (image2 == NULL)
  {
    (void) fprintf(stderr, "vfft: Imaginary input image could not be read.\n");
    exit(1);
  }
  MATCHINPUT(program, image1, image2);
  if ( (image2->data_storage_type == VFF_TYP_1_BYTE) || (image2->data_storage_type ==VFF_TYP_2_BYTE) || (image2->data_storage_type == VFF_TYP_4_BYTE) )
  {
     upcast_flg = 1;
  }
  images[1] = image2;
  num_images++;
}

/* Ensure that at least one output has been selected */
if ( (vfft->o1_flag == FALSE) && (vfft->o2_flag == FALSE) && (vfft->o3_flag == FALSE) )
{
  (void) fprintf(stderr,"vfft: Need at least one output selected!\n");
  exit(1);
}

            /* Call lvcast to upcast input image1 to float data type */
if (upcast_flg == 1)
{
   if (! lvcast(images, num_images, VFF_TYP_FLOAT) )
   {
     (void) fprintf(stderr, "lvcast failed: could not upcast images.\n");
     exit(1);
   }
}

/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvfft(image1, image2, vfft->o1_flag, &o_image1, vfft->o2_flag, &o_image2, vfft->o3_flag, &o_image3, vfft->d_logic) )
    {
        (void) fprintf(stderr, "lvfft Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
if (vfft->o1_flag) writeimage(vfft->o1_file, o_image1);
if (vfft->o2_flag) writeimage(vfft->o2_file, o_image2);
if (vfft->o3_flag) writeimage(vfft->o3_file, o_image3);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vfft 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vfft :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tComputes the two dimensional Fast Fourier Transform (FFT)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  complex or real image  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i2]  imaginary image (infile) [null]\n");
	fprintf(stderr,"\t[-o1]  complex output image (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  real output image (outfile) [null]\n");
	fprintf(stderr,"\t[-o3]  imaginary output image (outfile) [null]\n");
	fprintf(stderr,"\t[-d]  FFT direction (0 is forward, 1 is inverse) (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vfft\n");
	fprintf(stderr, "\t[-U] Gives the usage for vfft\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vfft.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vfft.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vfft
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) complex or real image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) imaginary image \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) complex output image \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) real output image \n        {outfile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) imaginary output image \n        {outfile}: "; 
char	*d_pstr = 
	"\nEnter: (d) FFT direction (0 is forward, 1 is inverse) \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vfft", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vfft.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vfft: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vfft.ans");
		}

	     }

	}

	/*
	 * allocate the vfft structure
	 */
	vfft = (vfft_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vfft_struct));

	/*
	 * get required arguments for vfft
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vfft->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vfft->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vfft->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vfft->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vfft->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vfft
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vfft->i2_flag = vget_infile(fid, prompt_flag,
	"-i2", i2_pstr, &(vfft->i2_file))
;

	vfft->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(vfft->o1_file))
;

	vfft->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(vfft->o2_file))
;

	vfft->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(vfft->o3_file))
;

	vfft->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(vfft->d_logic), 0);


}



