 /*
  * Khoros: $Id: getimage.c,v 1.2 1991/10/02 00:04:44 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: getimage.c,v 1.2 1991/10/02 00:04:44 khoros Exp $";
#endif

 /*
  * $Log: getimage.c,v $
 * Revision 1.2  1991/10/02  00:04:44  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: getimage.c
 >>>>
 >>>>      Program Name: getimage
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This is a  window image dumping utility.
 >>>>	
 >>>>	

 >>>>            Author: Mark Young
 >>>>
 >>>> Date Last Updated: Mon Sep 23 16:25:24 1991
 >>>>
 >>>>          Routines: main- the main program for getimage
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "getimage.h"


/****************************************************************
 *
 * Routine Name:  main program for getimage
 *
 *       Input:  
 *          -o  output image filename 
 *
 *
 *          [-e] extract image from screen?
 *          [-all] get the entire screen?
 *          [-name] name or id of window to dump
 *          [-b] output image in bitmap format?
 *          [-decor] grab the screen (WM) decoration?
 *          [-d] host:display.screen
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image;
int  dummy;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */

        if (dummy != dummy) XtToolkitInitialize();

        if (check_args())
            exit(1);

        if (! getimage->d_flag)
            getimage->d = NULL;

/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lgetimage(&image, getimage->b, getimage->e, getimage->name, getimage->all, getimage->decor, getimage->d))
        {
            (void) fprintf(stderr, "lgetimage Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(getimage->o, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for getimage 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "getimage :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis is a  window image dumping utility.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-e]  extract image from screen? (boolean) [false]\n");
	fprintf(stderr,"\t[-all]  get the entire screen? (boolean) [false]\n");
	fprintf(stderr,"\t[-name]  name or id of window to dump (string) [null]\n");
	fprintf(stderr,"\t[-b]  output image in bitmap format? (boolean) [false]\n");
	fprintf(stderr,"\t[-decor]  grab the screen (WM) decoration? (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  host:display.screen (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for getimage\n");
	fprintf(stderr, "\t[-V] Gives the version for getimage\n");
	fprintf(stderr, "\t[-U] Gives the usage for getimage\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called getimage.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses getimage.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for getimage
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*e_pstr = 
	"\nEnter: (e) extract image from screen? \n        {boolean, (y/n)  [no] }: "; 
char	*all_pstr = 
	"\nEnter: (all) get the entire screen? \n        {boolean, (y/n)  [no] }: "; 
char	*name_pstr = 
	"\nEnter: (name) name or id of window to dump \n        {string}: "; 
char	*name_def = NULL;
char	*b_pstr = 
	"\nEnter: (b) output image in bitmap format? \n        {boolean, (y/n)  [no] }: "; 
char	*decor_pstr = 
	"\nEnter: (decor) grab the screen (WM) decoration? \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) host:display.screen \n        {string}: "; 
char	*d_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "getimage", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "getimage.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "getimage: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "getimage.ans");
		}

	     }

	}

	/*
	 * allocate the getimage structure
	 */
	getimage = (getimage_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (getimage_struct));

	/*
	 * get required arguments for getimage
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(getimage->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(getimage->o))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(getimage->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    getimage->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(getimage->o))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for getimage
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	getimage->e_flag = vget_logic(fid, prompt_flag,
	"-e", e_pstr, &(getimage->e), 0);

	getimage->all_flag = vget_logic(fid, prompt_flag,
	"-all", all_pstr, &(getimage->all), 0);

	getimage->name_flag = vget_string(fid, prompt_flag,
	"-name", name_pstr, &(getimage->name),
	name_def);

	if (prompt_flag == FALSE)
	{
	    if ((getimage->name_flag == 1)&&(getimage->name == NULL))
    	{
		fprintf(stderr, "getimage:\n");
		fprintf(stderr, "you must specify a name following '-name'\n");
		gw_usage();
		exit(1);
		}
	}
	getimage->b_flag = vget_logic(fid, prompt_flag,
	"-b", b_pstr, &(getimage->b), 0);

	getimage->decor_flag = vget_logic(fid, prompt_flag,
	"-decor", decor_pstr, &(getimage->decor), 1);

	getimage->d_flag = vget_string(fid, prompt_flag,
	"-d", d_pstr, &(getimage->d),
	d_def);

	if (prompt_flag == FALSE)
	{
	    if ((getimage->d_flag == 1)&&(getimage->d == NULL))
    	{
		fprintf(stderr, "getimage:\n");
		fprintf(stderr, "you must specify a name following '-d'\n");
		gw_usage();
		exit(1);
		}
	}

}



