
PlaneRightBisector::usage = "PlaneRightBisector[l] is the plane perpendicular 
to the line segment l at its midpoint." 

( PlaneRightBisector[Line @ {p_, q_}] := 
	Translate[(p + q) / 2] @ Plane[{$o, $i, $j}]
	/; Cross[$k, q - p] == $o )

( PlaneRightBisector[Line @ {p_, q_}] := 
	Translate[(p + q) / 2] [
		Rotate[	
			Angle[$k, q - p], 
			Line[{$o, Cross[$k, q - p]}]
		] @ 
			Plane[{$o, $i, $j}]
	]
)
