/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class SplitCmd
implements Command {
    private static char[] defSplitChars = new char[]{' ', '\n', '\t', '\r'};

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        char[] splitChars = null;
        if (argv.length == 2) {
            splitChars = defSplitChars;
        } else if (argv.length == 3) {
            splitChars = argv[2].toString().toCharArray();
        } else {
            throw new TclNumArgsException(interp, 1, argv, "string ?splitChars?");
        }
        String string = argv[1].toString();
        int len = string.length();
        int num = splitChars.length;
        if (num == 0) {
            TclObject list = TclList.newInstance();
            list.preserve();
            try {
                int i = 0;
                while (i < len) {
                    TclList.append(interp, list, TclString.newInstance((char)string.charAt(i)));
                    ++i;
                }
                interp.setResult(list);
            }
            finally {
                Object var9_12 = null;
                list.release();
            }
            return;
        }
        TclObject list = TclList.newInstance();
        int elemStart = 0;
        list.preserve();
        try {
            int i = 0;
            while (i < len) {
                char c = string.charAt(i);
                int j = 0;
                while (j < num) {
                    if (c == splitChars[j]) {
                        TclList.append(interp, list, TclString.newInstance((String)string.substring(elemStart, i)));
                        elemStart = i + 1;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (i != 0) {
                TclList.append(interp, list, TclString.newInstance((String)string.substring(elemStart)));
            }
            interp.setResult(list);
        }
        finally {
            Object var10_10 = null;
            list.release();
        }
    }

    SplitCmd() {
    }
}

