/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

class ExecCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n = tclObjectArray.length;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 1;
        while (n2 < n) {
            String string = tclObjectArray[n2].toString();
            if (string.length() <= 0 || string.charAt(0) != '-') break;
            if (!string.equals("-keepnewline")) {
                if (string.equals("--")) {
                    ++n2;
                    break;
                }
                throw new TclException(interp, "bad switch \"" + string + "\": must be -keepnewline or --");
            }
            bl2 = true;
            ++n2;
        }
        if (n <= n2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? arg ?arg ...?");
        }
        if (tclObjectArray[n - 1].toString().equals("&")) {
            --n;
            bl = true;
        }
        try {
            Process process = !Util.isMac() && (!Util.isWindows() || false) ? this.execUnix(interp, tclObjectArray, n2, n) : (Util.isWindows() ? this.execWin(interp, tclObjectArray, n2, n) : this.execDefault(interp, tclObjectArray, n2, n));
            int n3 = process.waitFor();
            StringBuffer stringBuffer = new StringBuffer();
            ExecCmd.readStreamIntoBuffer(process.getInputStream(), stringBuffer);
            int n4 = ExecCmd.readStreamIntoBuffer(process.getErrorStream(), stringBuffer);
            if (n4 == 0 && n3 != 0) {
                stringBuffer.append("child process exited abnormally");
            }
            int n5 = stringBuffer.length();
            if (!bl2 && n5 > 0 && stringBuffer.charAt(n5 - 1) == '\n') {
                stringBuffer.setLength(n5 - 1);
            }
            if (n3 != 0 || n4 != 0) {
                throw new TclException(interp, stringBuffer.toString());
            }
            String string = stringBuffer.toString();
            if (string == null) {
                interp.resetResult();
                return;
            }
            interp.setResult(TclString.newInstance((String)string));
            return;
        }
        catch (IOException iOException) {
            throw new TclException(interp, "couldn't execute \"" + tclObjectArray[n2].toString() + "\": no such file or directory");
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    static int readStreamIntoBuffer(InputStream inputStream, StringBuffer stringBuffer) {
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuffer.append(string);
                    n += string.length();
                    stringBuffer.append('\n');
                    ++n;
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return n;
    }

    static String escapeWinString(String string) {
        if (string.indexOf(37) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(50);
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '%') {
                stringBuffer.append('%');
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private Process execUnix(Interp interp, TclObject[] tclObjectArray, int n, int n2) throws IOException, InterruptedException {
        String[] stringArray = new String[3];
        stringArray[0] = "sh";
        stringArray[1] = "-c";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cd '");
        stringBuffer.append(interp.getWorkingDir().toString());
        stringBuffer.append("'; ");
        int n3 = n;
        while (n3 < n2) {
            stringBuffer.append('\'');
            stringBuffer.append(tclObjectArray[n3].toString());
            stringBuffer.append('\'');
            stringBuffer.append(' ');
            ++n3;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringArray[2] = stringBuffer.toString();
        return Runtime.getRuntime().exec(stringArray);
    }

    private Process execWin(Interp interp, TclObject[] tclObjectArray, int n, int n2) throws IOException, InterruptedException {
        File file;
        PrintWriter printWriter;
        File file2 = new File("C:\\TEMP");
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("could not create C:\\TEMP");
        }
        boolean bl = System.getProperty("os.name").toLowerCase().equals("windows nt");
        File file3 = new File("C:\\TEMP\\jacl1.bat");
        File file4 = new File("C:\\TEMP\\jacl2.bat");
        if (bl) {
            if (file3.exists()) {
                file3.delete();
            }
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file3)));
            printWriter.println("@echo off");
            printWriter.println("cmd.exe /C C:\\TEMP\\jacl2.bat");
            printWriter.close();
            file = file4;
        } else {
            file = file3;
        }
        if (file.exists()) {
            file.delete();
        }
        printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        printWriter.println("@echo off");
        String string = interp.getWorkingDir().toString();
        printWriter.println(string.substring(0, 2));
        printWriter.println("cd " + ExecCmd.escapeWinString(string.substring(2)));
        printWriter.print(ExecCmd.escapeWinString(tclObjectArray[n].toString()));
        printWriter.print(' ');
        int n3 = n + 1;
        while (n3 < n2) {
            printWriter.print('\"');
            printWriter.print(ExecCmd.escapeWinString(tclObjectArray[n3].toString()));
            printWriter.print('\"');
            printWriter.print(' ');
            ++n3;
        }
        printWriter.println();
        printWriter.close();
        String[] stringArray = new String[]{"command.com", "/C", "C:\\TEMP\\jacl1.bat"};
        return Runtime.getRuntime().exec(stringArray);
    }

    private Process execDefault(Interp interp, TclObject[] tclObjectArray, int n, int n2) throws IOException, InterruptedException {
        String[] stringArray = new String[n2 - n];
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            stringArray[n4] = tclObjectArray[n3].toString();
            ++n4;
            ++n3;
        }
        return Runtime.getRuntime().exec(stringArray);
    }

    ExecCmd() {
    }
}

