/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.StrtoulResult;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class FormatCmd
implements Command {
    private static final int LEFT_JUSTIFY = 1;
    private static final int SHOW_SIGN = 2;
    private static final int SPACE_OR_SIGN = 4;
    private static final int PAD_W_ZERO = 8;
    private static final int ALT_OUTPUT = 16;
    private static final int SIGNED_VALUE = 32;
    private static final int RADIX = 1;
    private static final int FLOAT = 2;
    private static final int EXP = 3;
    private static final int GENERIC = 4;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "formatString ?arg arg ...?");
        }
        int n = 2;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = tclObjectArray[1].toString().toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < cArray.length) {
            int n3;
            StrtoulResult strtoulResult;
            int n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n8 = -1;
            if (cArray[n2] != '%') {
                n4 = n2;
                while (n4 < cArray.length) {
                    if (cArray[n4] == '%') {
                        bl3 = false;
                        break;
                    }
                    ++n4;
                }
                stringBuffer.append(new String(cArray, n2, n4 - n2));
                n2 = n4;
                if (bl3) break;
            }
            if (n2 + 1 >= cArray.length) {
                throw new TclException(interp, "format string ended in middle of field specifier");
            }
            n4 = n2 + 1;
            if (n4 >= cArray.length || n4 < 0) {
                throw new TclException(interp, "\"%n$\" argument index out of range");
            }
            if (cArray[n2 + 1] == '%') {
                stringBuffer.append("%");
                n2 += 2;
                continue;
            }
            if (++n2 >= cArray.length || n2 < 0) {
                throw new TclException(interp, "\"%n$\" argument index out of range");
            }
            if (Character.isDigit(cArray[n2])) {
                strtoulResult = this.strtoul(cArray, n2);
                n3 = (int)strtoulResult.value;
                int n9 = strtoulResult.index;
                if (cArray[n9] == '$') {
                    if (n3 == 0) {
                        throw new TclException(interp, "\"%n$\" argument index out of range");
                    }
                    if (bl) {
                        throw new TclException(interp, "cannot mix \"%\" and \"%n$\" conversion specifiers");
                    }
                    bl2 = true;
                    bl6 = true;
                    n6 = 2;
                    n2 = n9 + 1;
                    n = n3 + 1;
                    if (n < 2 || n >= tclObjectArray.length) {
                        if (bl2) {
                            throw new TclException(interp, "\"%n$\" argument index out of range");
                        }
                        throw new TclException(interp, "not enough arguments for all format specifiers");
                    }
                } else {
                    if (bl2) {
                        throw new TclException(interp, "cannot mix \"%\" and \"%n$\" conversion specifiers");
                    }
                    bl = true;
                    if (cArray[n2] != '0') {
                        n2 = n9;
                        n5 = n3;
                        n6 = 4;
                    }
                }
            } else {
                if (bl2) {
                    throw new TclException(interp, "cannot mix \"%\" and \"%n$\" conversion specifiers");
                }
                bl = true;
            }
            if (n6 < 3) {
                if (n2 >= cArray.length || n2 < 0) {
                    throw new TclException(interp, "\"%n$\" argument index out of range");
                }
                n4 = cArray[n2];
                boolean bl7 = true;
                while (bl7) {
                    switch (n4) {
                        case 45: {
                            n7 |= 1;
                            break;
                        }
                        case 35: {
                            n7 |= 0x10;
                            break;
                        }
                        case 48: {
                            n7 |= 8;
                            break;
                        }
                        case 32: {
                            n7 |= 4;
                            break;
                        }
                        case 43: {
                            n7 |= 2;
                            break;
                        }
                        default: {
                            bl7 = false;
                        }
                    }
                    if (!bl7) continue;
                    if (++n2 >= cArray.length || n2 < 0) {
                        throw new TclException(interp, "\"%n$\" argument index out of range");
                    }
                    n4 = cArray[n2];
                }
                n6 = 3;
            }
            if (n2 >= cArray.length || n2 < 0) {
                throw new TclException(interp, "\"%n$\" argument index out of range");
            }
            if (Character.isDigit(cArray[n2])) {
                strtoulResult = this.strtoul(cArray, n2);
                n5 = (int)strtoulResult.value;
                n2 = strtoulResult.index;
            } else if (cArray[n2] == '*' && tclObjectArray.length > n) {
                n5 = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[n]);
                ++n;
                ++n2;
            }
            if (n2 >= cArray.length || n2 < 0) {
                throw new TclException(interp, "\"%n$\" argument index out of range");
            }
            if (cArray[n2] == '.') {
                if (++n2 >= cArray.length || n2 < 0) {
                    throw new TclException(interp, "\"%n$\" argument index out of range");
                }
                if (Character.isDigit(cArray[n2])) {
                    bl5 = true;
                    strtoulResult = this.strtoul(cArray, n2);
                    n8 = (int)strtoulResult.value;
                    n2 = strtoulResult.index;
                } else if (cArray[n2] == '*') {
                    if (tclObjectArray.length > n) {
                        bl5 = true;
                        n8 = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[n]);
                        ++n;
                        if (++n2 >= cArray.length || n2 < 0) {
                            throw new TclException(interp, "\"%n$\" argument index out of range");
                        }
                    }
                } else {
                    FormatCmd.errorBadField(interp, cArray[n2]);
                }
            }
            if (cArray[n2] == 'h') {
                if (++n2 >= cArray.length || n2 < 0) {
                    throw new TclException(interp, "\"%n$\" argument index out of range");
                }
                bl4 = true;
            } else if (cArray[n2] == 'l' && (++n2 >= cArray.length || n2 < 0)) {
                throw new TclException(interp, "\"%n$\" argument index out of range");
            }
            if (n < 2 || n >= tclObjectArray.length) {
                if (bl2) {
                    throw new TclException(interp, "\"%n$\" argument index out of range");
                }
                throw new TclException(interp, "not enough arguments for all format specifiers");
            }
            String string2 = "";
            char c = cArray[n2];
            switch (c) {
                case 'X': 
                case 'd': 
                case 'i': 
                case 'o': 
                case 'u': 
                case 'x': {
                    long l;
                    if (c == 'u') {
                        l = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[n]);
                        if (l < 0L) {
                            l <<= 32;
                            l >>>= 32;
                        }
                    } else {
                        n7 |= 0x20;
                        l = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[n]);
                    }
                    if (bl4) {
                        l <<= 48;
                        l >>= 48;
                    }
                    if (c == 'o') {
                        stringBuffer.append(this.cvtLngToStr(l, n5, n8, n7, 8, "01234567".toCharArray(), "0"));
                        break;
                    }
                    if (c == 'x') {
                        stringBuffer.append(this.cvtLngToStr(l, n5, n8, n7, 16, "0123456789abcdef".toCharArray(), "0x"));
                        break;
                    }
                    if (c == 'X') {
                        stringBuffer.append(this.cvtLngToStr(l, n5, n8, n7, 16, "0123456789ABCDEF".toCharArray(), "0X"));
                        break;
                    }
                    stringBuffer.append(this.cvtLngToStr(l, n5, n8, n7, 10, "0123456789".toCharArray(), ""));
                    break;
                }
                case 'c': {
                    n3 = 0;
                    char[] cArray2 = new char[]{(char)TclInteger.get((Interp)interp, (TclObject)tclObjectArray[n])};
                    string2 = new String(cArray2);
                    stringBuffer.append(FormatCmd.cvtStrToStr(string2, n5, n8, n7));
                    break;
                }
                case 's': {
                    string2 = tclObjectArray[n].toString();
                    stringBuffer.append(FormatCmd.cvtStrToStr(string2, n5, n8, n7));
                    break;
                }
                case 'f': {
                    double d = TclDouble.get((Interp)interp, (TclObject)tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "0123456789".toCharArray(), "", 2));
                    break;
                }
                case 'e': {
                    double d = TclDouble.get((Interp)interp, (TclObject)tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "e".toCharArray(), "", 3));
                    break;
                }
                case 'E': {
                    double d = TclDouble.get((Interp)interp, (TclObject)tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "E".toCharArray(), "", 3));
                    break;
                }
                case 'g': {
                    double d = TclDouble.get((Interp)interp, (TclObject)tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "e".toCharArray(), "", 4));
                    break;
                }
                case 'G': {
                    double d = TclDouble.get((Interp)interp, (TclObject)tclObjectArray[n]);
                    stringBuffer.append(FormatCmd.cvtDblToStr(d, n5, n8, n7, 10, "E".toCharArray(), "", 4));
                    break;
                }
                default: {
                    FormatCmd.errorBadField(interp, cArray[n2]);
                }
            }
            ++n2;
            ++n;
        }
        if ((string = stringBuffer.toString()) == null) {
            interp.resetResult();
            return;
        }
        interp.setResult(TclString.newInstance((String)string));
    }

    private String cvtLngToStr(long l, int n, int n2, int n3, int n4, char[] cArray, String string) {
        int n5;
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(0).append("");
        int n6 = 0;
        char c = '\u0000';
        if (l == 0L) {
            n3 |= 0x10;
        }
        if ((n3 & 0x20) != 0) {
            if (l < 0L) {
                if (string.length() > 0) {
                    l <<= 32;
                    l >>>= 32;
                } else {
                    l = -l;
                    c = '-';
                    n6 = 1;
                }
            } else if ((n3 & 2) != 0) {
                c = '+';
                n6 = 1;
            } else if ((n3 & 4) != 0) {
                c = ' ';
                n6 = 1;
            }
        }
        if ((8 & n3) != 0 && n2 < n - n6) {
            n2 = n - n6;
        }
        do {
            stringBuffer.insert(0, cArray[(int)(l % (long)n4)]);
        } while ((l /= (long)n4) > 0L);
        int n7 = stringBuffer.length();
        int n8 = n2 - n7;
        while (n8 > 0) {
            stringBuffer.insert(0, '0');
            --n8;
        }
        if (c != '\u0000') {
            stringBuffer.insert(0, c);
        }
        if ((n3 & 0x10) != 0 && string.length() > 0 && stringBuffer.charAt(0) != string.charAt(0)) {
            stringBuffer.insert(0, string);
        }
        if ((n5 = n - stringBuffer.length()) > 0) {
            stringBuffer2 = new StringBuffer(n5);
            n8 = 0;
            while (n8 < n5) {
                stringBuffer2.append(" ");
                ++n8;
            }
        }
        if ((1 & n3) != 0) {
            return String.valueOf(stringBuffer.toString()) + stringBuffer2.toString();
        }
        return String.valueOf(stringBuffer2.toString()) + stringBuffer.toString();
    }

    static String toString(double d, int n, int n2) {
        return FormatCmd.cvtDblToStr(d, 0, n, 0, n2, "e".toCharArray(), null, 4);
    }

    private static String cvtDblToStr(double d, int n, int n2, int n3, int n4, char[] cArray, String string, int n5) {
        int n6;
        int n7;
        int n8;
        StringBuffer stringBuffer = new StringBuffer(100);
        int n9 = 0;
        char c = '\u0000';
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (n2 < 0) {
            n2 = 6;
        }
        if (d < 0.0) {
            d = -d;
            c = '-';
            n9 = 1;
        } else if (d == 0.0 && new Double(d).equals(new Double(-0.0))) {
            d = -d;
            c = '-';
            n9 = 1;
        } else if ((n3 & 2) != 0) {
            c = '+';
            n9 = 1;
        } else if ((n3 & 4) != 0) {
            c = ' ';
            n9 = 1;
        }
        if (n5 == 4 && n2 > 0) {
            --n2;
        }
        int n10 = n2;
        double d2 = 0.4999;
        while (n10 > 0) {
            --n10;
            d2 *= 0.1;
        }
        if (n5 == 2) {
            d += d2;
        }
        int n11 = 0;
        if (d > 0.0) {
            n8 = 0;
            while (d >= 1.0E8 && n8++ < 100) {
                d *= 1.0E-8;
                n11 += 8;
            }
            while (d >= 10.0 && n8++ < 100) {
                d *= 0.1;
                ++n11;
            }
            while (d < 1.0E-8 && n8++ < 100) {
                d *= 1.0E8;
                n11 -= 8;
            }
            while (d < 1.0 && n8++ < 100) {
                d *= 10.0;
                --n11;
            }
            if (n8 >= 100) {
                return "NaN";
            }
        }
        boolean bl4 = bl = n5 == 3;
        if (n5 != 2 && (d += d2) >= 10.0) {
            d *= 0.1;
            ++n11;
        }
        if (n5 == 4) {
            boolean bl5 = bl2 = (n3 & 0x10) == 0;
            if (n11 < -4 || n11 > n2) {
                n5 = 3;
            } else {
                n2 -= n11;
                n5 = 2;
            }
        } else {
            bl2 = false;
        }
        int n12 = 0;
        if (n5 == 2) {
            boolean bl6 = bl3 = n2 > 0 || (n3 & 0x10) != 0;
            if (n9 > 0) {
                stringBuffer.append(c);
            }
            if (n11 < 0) {
                stringBuffer.append('0');
            }
            while (n11 >= 0) {
                if (n12++ >= 16) {
                    stringBuffer.append('0');
                } else {
                    n7 = (int)d;
                    d = (d - (double)n7) * 10.0;
                    stringBuffer.append(n7);
                }
                --n11;
            }
            if (bl3) {
                stringBuffer.append('.');
            }
            ++n11;
            while (n11 < 0 && n2 > 0) {
                stringBuffer.append('0');
                --n2;
                ++n11;
            }
            while (n2-- > 0) {
                if (n12++ >= 16) {
                    stringBuffer.append('0');
                    continue;
                }
                n7 = (int)d;
                d = (d - (double)n7) * 10.0;
                stringBuffer.append(n7);
            }
            if (bl2 && bl3) {
                int n13 = 0;
                n8 = 0;
                n8 = stringBuffer.length() - 1;
                n13 = 0;
                while (n8 >= 0 && stringBuffer.charAt(n8) == '0') {
                    --n8;
                    ++n13;
                }
                if (n8 >= 0 && stringBuffer.charAt(n8) == '.') {
                    ++n13;
                }
                if (n13 > 0) {
                    stringBuffer = new StringBuffer(stringBuffer.toString().substring(0, stringBuffer.length() - n13));
                }
            }
        } else {
            boolean bl7 = bl3 = n2 > 0 || (n3 & 0x10) != 0;
            if (n9 > 0) {
                stringBuffer.append(c);
            }
            n7 = (int)d;
            d = (d - (double)n7) * 10.0;
            stringBuffer.append(n7);
            if (bl3) {
                stringBuffer.append('.');
            }
            while (n2-- > 0) {
                if (n12++ >= 16) {
                    stringBuffer.append('0');
                    continue;
                }
                n7 = (int)d;
                d = (d - (double)n7) * 10.0;
                stringBuffer.append(n7);
            }
            if (bl2 && bl3) {
                n10 = 0;
                n6 = stringBuffer.length() - 1;
                while (n6 >= 0 && stringBuffer.charAt(n6) == '0') {
                    --n6;
                    ++n10;
                }
                if (n6 >= 0 && stringBuffer.charAt(n6) == '.') {
                    ++n10;
                }
                if (n10 > 0) {
                    stringBuffer = new StringBuffer(stringBuffer.toString().substring(0, stringBuffer.length() - n10));
                }
            }
            if (n11 != 0 || bl) {
                stringBuffer.append(cArray[0]);
                if (n11 < 0) {
                    stringBuffer.append('-');
                    n11 = -n11;
                } else {
                    stringBuffer.append('+');
                }
                if (n11 >= 100) {
                    stringBuffer.append(n11 / 100);
                    n11 %= 100;
                }
                stringBuffer.append(n11 / 10);
                stringBuffer.append(n11 % 10);
            }
        }
        n6 = stringBuffer.length();
        if ((8 & n3) != 0 && (1 & n3) == 0) {
            n8 = n - n6;
            n10 = n9;
            while (n8-- > 0) {
                stringBuffer.insert(n9, '0');
            }
            n6 = n;
        }
        n8 = n - n6;
        StringBuffer stringBuffer2 = new StringBuffer(0).append("");
        if (n8 > 0) {
            stringBuffer2 = new StringBuffer(n8);
            n10 = 0;
            while (n10 < n8) {
                stringBuffer2.append(" ");
                ++n10;
            }
        }
        if ((1 & n3) != 0) {
            return String.valueOf(stringBuffer.toString()) + stringBuffer2.toString();
        }
        return String.valueOf(stringBuffer2.toString()) + stringBuffer.toString();
    }

    private static String cvtStrToStr(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 != 0 && n2 < string.length()) {
            string = string.substring(0, n2);
        }
        if (n > string.length()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = n - string.length();
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.append(' ');
                ++n5;
            }
            if ((1 & n3) != 0) {
                string3 = stringBuffer.toString();
            } else {
                string2 = stringBuffer.toString();
            }
        }
        return String.valueOf(string2) + string + string3;
    }

    private StrtoulResult strtoul(char[] cArray, int n) {
        int n2 = n;
        while (n < cArray.length) {
            if (!Character.isDigit(cArray[n])) break;
            ++n;
        }
        return new StrtoulResult(Long.parseLong(new String(cArray, n2, n - n2)), n, 0);
    }

    private static void checkOverFlow(Interp interp, char[] cArray, int n) throws TclException {
        if (n >= cArray.length || n < 0) {
            throw new TclException(interp, "\"%n$\" argument index out of range");
        }
    }

    private static void errorMixedXPG(Interp interp) throws TclException {
        throw new TclException(interp, "cannot mix \"%\" and \"%n$\" conversion specifiers");
    }

    private static void errorBadIndex(Interp interp, boolean bl) throws TclException {
        if (bl) {
            throw new TclException(interp, "\"%n$\" argument index out of range");
        }
        throw new TclException(interp, "not enough arguments for all format specifiers");
    }

    private static void errorBadField(Interp interp, char c) throws TclException {
        throw new TclException(interp, "bad field specifier \"" + c + "\"");
    }

    private static void errorEndMiddle(Interp interp) throws TclException {
        throw new TclException(interp, "format string ended in middle of field specifier");
    }

    FormatCmd() {
    }
}

