/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import tcl.lang.AssocData;
import tcl.lang.AutoloadStub;
import tcl.lang.BackSlashResult;
import tcl.lang.BgErrorMgr;
import tcl.lang.BlendExtension;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.DebugInfo;
import tcl.lang.Env;
import tcl.lang.Expression;
import tcl.lang.FileUtil;
import tcl.lang.Notifier;
import tcl.lang.PackageCmd;
import tcl.lang.Parser;
import tcl.lang.Procedure;
import tcl.lang.ReflectObject;
import tcl.lang.RegexpCmd;
import tcl.lang.RegsubCmd;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.VarTrace;

public class Interp {
    Hashtable reflectIDTable;
    Hashtable reflectObjTable;
    long reflectObjCount;
    private Thread primaryThread;
    private static final int MAX_ERR_LENGTH = 200;
    static final String TCL_VERSION = "8.0";
    static final String TCL_PATCH_LEVEL = "8.0";
    protected int cmdCount;
    Hashtable cmdTable = new Hashtable();
    Hashtable interpChanTable;
    private Notifier notifier;
    Hashtable assocDataTab;
    private File workingDir;
    CallFrame frame;
    CallFrame varFrame = this.frame = this.newCallFrame();
    CallFrame globalFrame = this.frame;
    String scriptFile = "";
    int nestLevel = 0;
    int maxNestingDepth = 1000;
    int evalFlags;
    int flags;
    int termOffset;
    Expression expr = new Expression();
    int noEval = 0;
    boolean randSeedInit;
    long randSeed;
    String errorInfo;
    String errorCode;
    protected int returnCode;
    protected boolean deleted;
    protected boolean errInProgress;
    protected boolean errAlreadyLogged;
    protected boolean errCodeSet;
    int errorLine;
    private TclObject m_result;
    private TclObject m_nullResult;
    Hashtable packageTable;
    String packageUnknown;
    protected DebugInfo dbg;

    public Interp() {
        this.workingDir = new File(Util.tryGetSystemProperty("user.dir", "."));
        this.primaryThread = Thread.currentThread();
        this.notifier = Notifier.getNotifierForThread(this.primaryThread);
        this.notifier.preserve();
        this.assocDataTab = null;
        this.randSeedInit = false;
        ReflectObject.init(this);
        this.errorLine = 0;
        this.deleted = false;
        this.errInProgress = false;
        this.errAlreadyLogged = false;
        this.errCodeSet = false;
        this.returnCode = 0;
        this.dbg = this.initDebugInfo();
        this.packageTable = new Hashtable();
        this.packageUnknown = null;
        this.m_nullResult = TclString.newInstance("");
        Object object = this.m_nullResult;
        if (((TclObject)object).internalRep == null) {
            throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
        }
        ++((TclObject)object).refCount;
        this.m_result = this.m_nullResult;
        this.interpChanTable = TclIO.getInterpChanTable(this);
        Util.setupPrecisionTrace(this);
        this.createCommands();
        try {
            this.varFrame.setVar("tcl_platform", "platform", TclString.newInstance("java"), 1);
            object = Util.tryGetSystemProperty("java.version", "?");
            this.varFrame.setVar("tcl_platform", "javaVersion", TclString.newInstance((String)object), 1);
            this.varFrame.setVar("tcl_platform", "byteOrder", TclString.newInstance("bigEndian"), 1);
            object = Util.tryGetSystemProperty("os.name", "?");
            this.varFrame.setVar("tcl_platform", "os", TclString.newInstance((String)object), 1);
            object = Util.tryGetSystemProperty("os.version", "?");
            this.varFrame.setVar("tcl_platform", "osVersion", TclString.newInstance((String)object), 1);
            object = Util.tryGetSystemProperty("os.arch", "?");
            this.varFrame.setVar("tcl_platform", "machine", TclString.newInstance((String)object), 1);
            this.varFrame.setVar("tcl_version", TclString.newInstance("8.0"), 1);
            this.varFrame.setVar("tcl_patchLevel", TclString.newInstance("8.0"), 1);
            this.varFrame.setVar("tcl_library", TclString.newInstance("resource:/tcl/lang/library"), 1);
            if (Util.isWindows()) {
                this.varFrame.setVar("tcl_platform", "host_platform", TclString.newInstance("windows"), 1);
            } else if (Util.isMac()) {
                this.varFrame.setVar("tcl_platform", "host_platform", TclString.newInstance("macintosh"), 1);
            } else {
                this.varFrame.setVar("tcl_platform", "host_platform", TclString.newInstance("unix"), 1);
            }
            Env.initialize(this);
            PackageCmd.pkgProvide(this, "Tcl", "8.0");
            this.evalResource("/tcl/lang/library/init.tcl");
            return;
        }
        catch (TclException tclException) {
            System.out.println(this.m_result);
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    public void dispose() {
        Object object;
        Object object2;
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        if (this.nestLevel > 0) {
            throw new TclRuntimeError("dispose() called with active evals");
        }
        if (this.notifier != null) {
            this.notifier.release();
            this.notifier = null;
        }
        TclObject tclObject = null;
        TclObject tclObject2 = null;
        try {
            tclObject = this.varFrame.getVar("errorInfo", null, 2049);
            if (tclObject != null) {
                if (tclObject.internalRep == null) {
                    throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
                }
                ++tclObject.refCount;
            }
            if ((tclObject2 = this.varFrame.getVar("errorCode", null, 2049)) != null) {
                if (tclObject2.internalRep == null) {
                    throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
                }
                ++tclObject2.refCount;
            }
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        this.globalFrame.dispose();
        this.varFrame = this.frame = this.newCallFrame();
        this.globalFrame = this.frame;
        try {
            if (tclObject != null) {
                this.varFrame.setVar("errorInfo", null, tclObject, 1);
                tclObject.release();
            }
            if (tclObject2 != null) {
                this.varFrame.setVar("errorCode", null, tclObject2, 1);
                tclObject2.release();
            }
        }
        catch (TclException tclException) {}
        if (this.cmdTable != null) {
            object2 = this.cmdTable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                this.deleteCommand((String)object);
            }
            this.cmdTable = null;
        }
        this.expr = null;
        while (this.assocDataTab != null) {
            object2 = this.assocDataTab;
            this.assocDataTab = null;
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                AssocData assocData = (AssocData)((Hashtable)object2).get(e);
                assocData.disposeAssocData(this);
                ((Hashtable)object2).remove(e);
            }
        }
        this.globalFrame.dispose();
        this.frame = null;
        this.varFrame = null;
        this.globalFrame = null;
        this.resetResult();
    }

    protected void finalize() {
        this.dispose();
    }

    protected void createCommands() {
        this.createCommand("after", new AutoloadStub("tcl.lang.AfterCmd"));
        this.createCommand("append", new AutoloadStub("tcl.lang.AppendCmd"));
        this.createCommand("array", new AutoloadStub("tcl.lang.ArrayCmd"));
        this.createCommand("break", new AutoloadStub("tcl.lang.BreakCmd"));
        this.createCommand("case", new AutoloadStub("tcl.lang.CaseCmd"));
        this.createCommand("catch", new AutoloadStub("tcl.lang.CatchCmd"));
        this.createCommand("cd", new AutoloadStub("tcl.lang.CdCmd"));
        this.createCommand("close", new AutoloadStub("tcl.lang.CloseCmd"));
        this.createCommand("continue", new AutoloadStub("tcl.lang.ContinueCmd"));
        this.createCommand("concat", new AutoloadStub("tcl.lang.ConcatCmd"));
        this.createCommand("eof", new AutoloadStub("tcl.lang.EofCmd"));
        this.createCommand("eval", new AutoloadStub("tcl.lang.EvalCmd"));
        this.createCommand("error", new AutoloadStub("tcl.lang.ErrorCmd"));
        this.createCommand("exec", new AutoloadStub("tcl.lang.ExecCmd"));
        this.createCommand("exit", new AutoloadStub("tcl.lang.ExitCmd"));
        this.createCommand("expr", new AutoloadStub("tcl.lang.ExprCmd"));
        this.createCommand("fblocked", new AutoloadStub("tcl.lang.FblockedCmd"));
        this.createCommand("fconfigure", new AutoloadStub("tcl.lang.FconfigureCmd"));
        this.createCommand("file", new AutoloadStub("tcl.lang.FileCmd"));
        this.createCommand("flush", new AutoloadStub("tcl.lang.FlushCmd"));
        this.createCommand("for", new AutoloadStub("tcl.lang.ForCmd"));
        this.createCommand("foreach", new AutoloadStub("tcl.lang.ForeachCmd"));
        this.createCommand("format", new AutoloadStub("tcl.lang.FormatCmd"));
        this.createCommand("gets", new AutoloadStub("tcl.lang.GetsCmd"));
        this.createCommand("global", new AutoloadStub("tcl.lang.GlobalCmd"));
        this.createCommand("glob", new AutoloadStub("tcl.lang.GlobCmd"));
        this.createCommand("if", new AutoloadStub("tcl.lang.IfCmd"));
        this.createCommand("incr", new AutoloadStub("tcl.lang.IncrCmd"));
        this.createCommand("info", new AutoloadStub("tcl.lang.InfoCmd"));
        this.createCommand("list", new AutoloadStub("tcl.lang.ListCmd"));
        this.createCommand("join", new AutoloadStub("tcl.lang.JoinCmd"));
        this.createCommand("lappend", new AutoloadStub("tcl.lang.LappendCmd"));
        this.createCommand("lindex", new AutoloadStub("tcl.lang.LindexCmd"));
        this.createCommand("linsert", new AutoloadStub("tcl.lang.LinsertCmd"));
        this.createCommand("llength", new AutoloadStub("tcl.lang.LlengthCmd"));
        this.createCommand("lrange", new AutoloadStub("tcl.lang.LrangeCmd"));
        this.createCommand("lreplace", new AutoloadStub("tcl.lang.LreplaceCmd"));
        this.createCommand("lsearch", new AutoloadStub("tcl.lang.LsearchCmd"));
        this.createCommand("lsort", new AutoloadStub("tcl.lang.LsortCmd"));
        this.createCommand("namespace", new AutoloadStub("tcl.lang.NamespaceCmd"));
        this.createCommand("open", new AutoloadStub("tcl.lang.OpenCmd"));
        this.createCommand("package", new AutoloadStub("tcl.lang.PackageCmd"));
        this.createCommand("proc", new AutoloadStub("tcl.lang.ProcCmd"));
        this.createCommand("puts", new AutoloadStub("tcl.lang.PutsCmd"));
        this.createCommand("pwd", new AutoloadStub("tcl.lang.PwdCmd"));
        this.createCommand("read", new AutoloadStub("tcl.lang.ReadCmd"));
        this.createCommand("regsub", new AutoloadStub("tcl.lang.RegsubCmd"));
        this.createCommand("rename", new AutoloadStub("tcl.lang.RenameCmd"));
        this.createCommand("return", new AutoloadStub("tcl.lang.ReturnCmd"));
        this.createCommand("scan", new AutoloadStub("tcl.lang.ScanCmd"));
        this.createCommand("seek", new AutoloadStub("tcl.lang.SeekCmd"));
        this.createCommand("set", new AutoloadStub("tcl.lang.SetCmd"));
        this.createCommand("socket", new AutoloadStub("tcl.lang.SocketCmd"));
        this.createCommand("source", new AutoloadStub("tcl.lang.SourceCmd"));
        this.createCommand("split", new AutoloadStub("tcl.lang.SplitCmd"));
        this.createCommand("string", new AutoloadStub("tcl.lang.StringCmd"));
        this.createCommand("subst", new AutoloadStub("tcl.lang.SubstCmd"));
        this.createCommand("switch", new AutoloadStub("tcl.lang.SwitchCmd"));
        this.createCommand("tell", new AutoloadStub("tcl.lang.TellCmd"));
        this.createCommand("testcmdinfo", new AutoloadStub("tcl.lang.TestcmdinfoCmd"));
        this.createCommand("testdcall", new AutoloadStub("tcl.lang.TestdcallCmd"));
        this.createCommand("testfhandle", new AutoloadStub("tcl.lang.TestfhandleCmd"));
        this.createCommand("testgetplatform", new AutoloadStub("tcl.lang.TestgetplatformCmd"));
        this.createCommand("testsetplatform", new AutoloadStub("tcl.lang.TestsetplatformCmd"));
        this.createCommand("testtranslatefilename", new AutoloadStub("tcl.lang.TesttranslatefilenameCmd"));
        this.createCommand("time", new AutoloadStub("tcl.lang.TimeCmd"));
        this.createCommand("trace", new AutoloadStub("tcl.lang.TraceCmd"));
        this.createCommand("unset", new AutoloadStub("tcl.lang.UnsetCmd"));
        this.createCommand("update", new AutoloadStub("tcl.lang.UpdateCmd"));
        this.createCommand("uplevel", new AutoloadStub("tcl.lang.UplevelCmd"));
        this.createCommand("upvar", new AutoloadStub("tcl.lang.UpvarCmd"));
        this.createCommand("vwait", new AutoloadStub("tcl.lang.VwaitCmd"));
        this.createCommand("while", new AutoloadStub("tcl.lang.WhileCmd"));
        try {
            new BlendExtension().init(this);
            this.createCommand("regexp", new RegexpCmd());
            this.createCommand("regsub", new RegsubCmd());
            return;
        }
        catch (TclException tclException) {
            System.out.println(this.m_result);
            tclException.printStackTrace();
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    public void setAssocData(String string, AssocData assocData) {
        if (this.assocDataTab == null) {
            this.assocDataTab = new Hashtable();
        }
        this.assocDataTab.put(string, assocData);
    }

    public void deleteAssocData(String string) {
        if (this.assocDataTab == null) {
            return;
        }
        this.assocDataTab.remove(string);
    }

    public AssocData getAssocData(String string) {
        if (this.assocDataTab == null) {
            return null;
        }
        return (AssocData)this.assocDataTab.get(string);
    }

    public void backgroundError() {
        BgErrorMgr bgErrorMgr = (BgErrorMgr)this.getAssocData("tclBgError");
        if (bgErrorMgr == null) {
            bgErrorMgr = new BgErrorMgr(this);
            this.setAssocData("tclBgError", bgErrorMgr);
        }
        bgErrorMgr.addBgError();
    }

    final TclObject setVar(TclObject tclObject, TclObject tclObject2, int n) throws TclException {
        return this.varFrame.setVar(tclObject, tclObject2, n);
    }

    public final TclObject setVar(String string, TclObject tclObject, int n) throws TclException {
        return this.varFrame.setVar(string, tclObject, n);
    }

    public final TclObject setVar(String string, String string2, TclObject tclObject, int n) throws TclException {
        return this.varFrame.setVar(string, string2, tclObject, n);
    }

    final void setVar(String string, String string2, int n) throws TclException {
        this.varFrame.setVar(string, TclString.newInstance(string2), n);
    }

    final void setVar(String string, String string2, String string3, int n) throws TclException {
        this.varFrame.setVar(string, string2, TclString.newInstance(string3), n);
    }

    final TclObject getVar(TclObject tclObject, int n) throws TclException {
        return this.varFrame.getVar(tclObject, n);
    }

    public final TclObject getVar(String string, int n) throws TclException {
        return this.varFrame.getVar(string, n);
    }

    public final TclObject getVar(String string, String string2, int n) throws TclException {
        return this.varFrame.getVar(string, string2, n);
    }

    final void unsetVar(TclObject tclObject, int n) throws TclException {
        this.varFrame.unsetVar(tclObject, n);
    }

    public final void unsetVar(String string, int n) throws TclException {
        this.varFrame.unsetVar(string, n);
    }

    public final void unsetVar(String string, String string2, int n) throws TclException {
        this.varFrame.unsetVar(string, string2, n);
    }

    void traceVar(TclObject tclObject, VarTrace varTrace, int n) throws TclException {
        this.varFrame.traceVar(tclObject, varTrace, n);
    }

    public void traceVar(String string, VarTrace varTrace, int n) throws TclException {
        this.varFrame.traceVar(string, varTrace, n);
    }

    public void traceVar(String string, String string2, VarTrace varTrace, int n) throws TclException {
        this.varFrame.traceVar(string, string2, varTrace, n);
    }

    void untraceVar(TclObject tclObject, VarTrace varTrace, int n) {
        this.varFrame.untraceVar(tclObject, varTrace, n);
    }

    public void untraceVar(String string, VarTrace varTrace, int n) {
        this.varFrame.untraceVar(string, varTrace, n);
    }

    public void untraceVar(String string, String string2, VarTrace varTrace, int n) {
        this.varFrame.untraceVar(string, string2, varTrace, n);
    }

    public void createCommand(String string, Command command) {
        Command command2 = (Command)this.cmdTable.get(string);
        if (command2 != null && command2 instanceof CommandWithDispose) {
            ((CommandWithDispose)command2).disposeCmd();
        }
        this.cmdTable.put(string, command);
    }

    public int deleteCommand(String string) {
        Command command = (Command)this.cmdTable.get(string);
        if (command == null) {
            return -1;
        }
        this.cmdTable.remove(string);
        if (command instanceof CommandWithDispose) {
            ((CommandWithDispose)command).disposeCmd();
        }
        return 0;
    }

    public Command getCommand(String string) {
        return (Command)this.cmdTable.get(string);
    }

    public static boolean commandComplete(String string) {
        return Parser.commandComplete(string, string.length());
    }

    public final TclObject getResult() {
        return this.m_result;
    }

    public final void setResult(TclObject tclObject) {
        if (tclObject == null) {
            throw new NullPointerException("Interp.setResult() called with null TclObject argument.");
        }
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
        }
        TclObject tclObject2 = this.m_result = tclObject;
        if (tclObject2.internalRep == null) {
            throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
        }
        ++tclObject2.refCount;
    }

    public final void setResult(String string) {
        if (string == null) {
            this.resetResult();
            return;
        }
        this.setResult(TclString.newInstance(string));
    }

    public final void setResult(int n) {
        this.setResult(TclInteger.newInstance(n));
    }

    public final void setResult(double d) {
        this.setResult(TclDouble.newInstance(d));
    }

    public final void setResult(boolean bl) {
        this.setResult(TclBoolean.newInstance(bl));
    }

    public final void resetResult() {
        if (this.m_result != this.m_nullResult) {
            this.m_result.release();
            this.m_result = this.m_nullResult;
        }
        this.errAlreadyLogged = false;
        this.errInProgress = false;
        this.errCodeSet = false;
    }

    void appendElement(String string) throws TclException {
        String string2;
        TclObject tclObject = this.m_result;
        if (tclObject.internalRep == null) {
            throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
        }
        ++tclObject.refCount;
        tclObject = tclObject.takeExclusive();
        TclList.append(this, tclObject, TclString.newInstance(string));
        if (tclObject.stringRep == null) {
            tclObject.stringRep = tclObject.internalRep.toString();
        }
        if ((string2 = tclObject.stringRep) == null) {
            this.resetResult();
        } else {
            this.setResult(TclString.newInstance(string2));
        }
        tclObject.release();
    }

    public void eval(String string, int n) throws TclException {
        CharPointer charPointer = new CharPointer(string);
        Parser.eval2(this, charPointer, charPointer.length(), n);
    }

    public void eval(String string) throws TclException {
        this.eval(string, 0);
    }

    public void eval(TclObject tclObject, int n) throws TclException {
        if (tclObject.stringRep == null) {
            tclObject.stringRep = tclObject.internalRep.toString();
        }
        this.eval(tclObject.stringRep, n);
    }

    public void evalFile(String string) throws TclException {
        String string2 = this.readScriptFromFile(string);
        if (string2 == null) {
            throw new TclException(this, "couldn't read file \"" + string + "\"");
        }
        String string3 = this.scriptFile;
        this.scriptFile = string;
        try {
            this.pushDebugStack(string, 1);
            this.eval(string2, 0);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.scriptFile = string3;
            this.popDebugStack();
            throw throwable;
        }
        Object var5_4 = null;
        this.scriptFile = string3;
        this.popDebugStack();
    }

    void evalURL(URL uRL, String string) throws TclException {
        String string2 = this.readScriptFromURL(uRL, string);
        if (string2 == null) {
            throw new TclException(this, "cannot read URL \"" + string + "\"");
        }
        String string3 = this.scriptFile;
        this.scriptFile = string;
        try {
            this.eval(string2, 0);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.scriptFile = string3;
            throw throwable;
        }
        Object var6_5 = null;
        this.scriptFile = string3;
    }

    private String readScriptFromFile(String string) {
        FileInputStream fileInputStream;
        try {
            File file = FileUtil.getNewFileObj(this, string);
            fileInputStream = new FileInputStream(file);
        }
        catch (TclException tclException) {
            this.resetResult();
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        try {
            try {
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                String string2 = new String(byArray);
                Object var6_7 = null;
                this.closeInputStream(fileInputStream);
                return string2;
            }
            catch (IOException iOException) {
                String string3 = null;
                Object var6_8 = null;
                this.closeInputStream(fileInputStream);
                return string3;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.closeInputStream(fileInputStream);
            throw throwable;
        }
    }

    private String readScriptFromURL(URL uRL, String string) {
        URL uRL2;
        Object object = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        try {
            object = uRL2.getContent();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            try {
                try {
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    String string2 = new String(byArray);
                    Object var8_9 = null;
                    this.closeInputStream(inputStream);
                    return string2;
                }
                catch (IOException iOException) {
                    String string3 = null;
                    Object var8_10 = null;
                    this.closeInputStream(inputStream);
                    return string3;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.closeInputStream(inputStream);
                throw throwable;
            }
        }
        return null;
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    void evalResource(String string) throws TclException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new TclException(this, "cannot read resource \"" + string + "\"");
        }
        try {
            try {
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                this.eval(new String(byArray), 0);
            }
            catch (IOException iOException) {
                Object var4_4 = null;
                this.closeInputStream(inputStream);
                return;
            }
            Object var4_5 = null;
            this.closeInputStream(inputStream);
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeInputStream(inputStream);
            throw throwable;
        }
    }

    static BackSlashResult backslash(String string, int n, int n2) {
        CharPointer charPointer = new CharPointer(string.substring(0, n2));
        charPointer.index = n;
        return Parser.backslash(charPointer);
    }

    public void setErrorCode(TclObject tclObject) {
        try {
            this.varFrame.setVar("errorCode", null, tclObject, 1);
            this.errCodeSet = true;
            return;
        }
        catch (TclException tclException) {
            return;
        }
    }

    public void addErrorInfo(String string) {
        if (!this.errInProgress) {
            this.errInProgress = true;
            try {
                Object object = this.m_result;
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                object = ((TclObject)object).stringRep;
                this.varFrame.setVar("errorInfo", null, TclString.newInstance((String)object), 1);
            }
            catch (TclException tclException) {}
            if (!this.errCodeSet) {
                try {
                    this.varFrame.setVar("errorCode", null, TclString.newInstance("NONE"), 1);
                }
                catch (TclException tclException) {}
            }
        }
        try {
            this.varFrame.setVar("errorInfo", null, TclString.newInstance(string), 5);
            return;
        }
        catch (TclException tclException) {
            return;
        }
    }

    protected int updateReturnInfo() {
        int n = this.returnCode;
        this.returnCode = 0;
        if (n == 1) {
            String string;
            try {
                string = this.errorCode != null ? this.errorCode : "NONE";
                this.varFrame.setVar("errorCode", null, TclString.newInstance(string), 1);
            }
            catch (TclException tclException) {}
            this.errCodeSet = true;
            if (this.errorInfo != null) {
                try {
                    string = this.errorInfo;
                    this.varFrame.setVar("errorInfo", null, TclString.newInstance(string), 1);
                }
                catch (TclException tclException) {}
                this.errInProgress = true;
            }
        }
        return n;
    }

    protected CallFrame newCallFrame(Procedure procedure, TclObject[] tclObjectArray) throws TclException {
        return new CallFrame(this, procedure, tclObjectArray);
    }

    protected CallFrame newCallFrame() {
        return new CallFrame(this);
    }

    File getWorkingDir() {
        if (this.workingDir == null) {
            try {
                Object object = this.varFrame.getVar("env", "HOME", 0);
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                object = ((TclObject)object).stringRep;
                this.workingDir = FileUtil.getNewFileObj(this, (String)object);
            }
            catch (TclException tclException) {
                this.resetResult();
            }
            this.workingDir = new File(Util.tryGetSystemProperty("user.home", "."));
        }
        return this.workingDir;
    }

    void setWorkingDir(String string) throws TclException {
        File file = FileUtil.getNewFileObj(this, string);
        try {
            file = new File(file.getCanonicalPath());
        }
        catch (IOException iOException) {}
        if (file.isDirectory()) {
            this.workingDir = file;
            return;
        }
        throw new TclException(this, "couldn't change working directory to \"" + file.getName() + "\": no such file or directory");
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public final void pkgProvide(String string, String string2) throws TclException {
        PackageCmd.pkgProvide(this, string, string2);
    }

    public final String pkgRequire(String string, String string2, boolean bl) throws TclException {
        return PackageCmd.pkgRequire(this, string, string2, bl);
    }

    protected DebugInfo initDebugInfo() {
        return new DebugInfo(null, 1);
    }

    void pushDebugStack(String string, int n) {
    }

    void popDebugStack() throws TclRuntimeError {
    }

    String getScriptFile() {
        return this.dbg.fileName;
    }

    int getArgLineNumber(int n) {
        return 0;
    }
}

