/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Interp;
import tcl.lang.MathFunction;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class RoundFunction
extends MathFunction {
    RoundFunction() {
        this.argTypes = new int[1];
        this.argTypes[0] = 2;
    }

    ExprValue apply(Interp interp, TclObject[] tclObjectArray) throws TclException {
        TclObject tclObject = tclObjectArray[0];
        if (tclObject.internalRep instanceof TclDouble) {
            double d = TclDouble.get(interp, tclObjectArray[0]);
            if (d < 0.0) {
                double d2 = d - 0.5;
                if (d2 < 0.0) {
                    if (d2 < -2.147483648E9) {
                        interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
                        throw new TclException(interp, "integer value too large to represent");
                    }
                } else if (d2 > 2.147483647E9) {
                    interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
                    throw new TclException(interp, "integer value too large to represent");
                }
                return new ExprValue((int)(d - 0.5));
            }
            double d3 = d + 0.5;
            if (d3 < 0.0) {
                if (d3 < -2.147483648E9) {
                    interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
                    throw new TclException(interp, "integer value too large to represent");
                }
            } else if (d3 > 2.147483647E9) {
                interp.setErrorCode(TclString.newInstance("ARITH IOVERFLOW {integer value too large to represent}"));
                throw new TclException(interp, "integer value too large to represent");
            }
            return new ExprValue((int)(d + 0.5));
        }
        return new ExprValue(TclInteger.get(interp, tclObjectArray[0]));
    }
}

