/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.RegsubCmd;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class RegexpCmd
implements Command {
    private static final String[] validCmds = new String[]{"-indices", "-nocase", "--"};
    private static final int OPT_INDICES = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_LAST = 2;

    static void init(Interp interp) {
        interp.createCommand("regexp", new RegexpCmd());
        interp.createCommand("regsub", new RegsubCmd());
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Class<?> clazz = null;
        Command command = null;
        try {
            clazz = Class.forName("tcl.regex.OroRegexpCmd");
        }
        catch (ClassNotFoundException classNotFoundException) {
            RegexpCmd.stubCmdProc(interp, tclObjectArray);
            return;
        }
        try {
            command = (Command)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TclException(interp, "IllegalAccessException for class \"" + clazz.getName() + "\"");
        }
        catch (InstantiationException instantiationException) {
            throw new TclException(interp, "InstantiationException for class \"" + clazz.getName() + "\"");
        }
        catch (ClassCastException classCastException) {
            throw new TclException(interp, "ClassCastException for class \"" + clazz.getName() + "\"");
        }
        interp.createCommand("regexp", command);
        command.cmdProc(interp, tclObjectArray);
    }

    private static void stubCmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        String string;
        String string2;
        int n = tclObjectArray.length - 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
        int n2 = 1;
        while (n > 0 && !bl3) {
            if (!tclObjectArray[n2].toString().startsWith("-")) break;
            int n3 = TclIndex.get(interp, tclObjectArray[n2], validCmds, "switch", 1);
            switch (n3) {
                case 0: {
                    bl2 = true;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl3 = true;
                    break;
                }
                default: {
                    throw new TclException(interp, "RegexpCmd.cmdProc: bad option " + n3 + " index to validCmds");
                }
            }
            --n;
            ++n2;
        }
        if (n < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? exp string ?matchVar? ?subMatchVar subMatchVar ...?");
        }
        int n4 = n2 + 1;
        int n5 = n4 + 1;
        if (bl) {
            string2 = tclObjectArray[n2].toString().toLowerCase();
            string = tclObjectArray[n4].toString().toLowerCase();
        } else {
            string2 = tclObjectArray[n2].toString();
            string = tclObjectArray[n4].toString();
        }
        throw new TclException(interp, "Can't execute regexp \"" + string2 + " " + string + "\": not yet implemented");
    }

    RegexpCmd() {
    }
}

