/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class SeekCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Channel channel;
        if (tclObjectArray.length != 3 && tclObjectArray.length != 4) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "channelId offset ?origin?");
        }
        int n = 1;
        if (tclObjectArray.length == 4) {
            if ("start".equals(tclObjectArray[3].toString())) {
                n = 1;
            } else if ("current".equals(tclObjectArray[3].toString())) {
                n = 2;
            } else if ("end".equals(tclObjectArray[3].toString())) {
                n = 3;
            } else {
                throw new TclException(interp, "bad origin \"" + tclObjectArray[3].toString() + "\": should be start, current, or end");
            }
        }
        if ((channel = TclIO.getChannel(interp, tclObjectArray[1].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + tclObjectArray[1].toString() + "\"");
        }
        long l = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[2]);
        try {
            channel.seek(l, n);
            return;
        }
        catch (IOException iOException) {
            throw new TclException(interp, "error during seek on \"" + channel.getChanName() + "\": invalid argument");
        }
    }

    SeekCmd() {
    }
}

