/*
 * Decompiled with CFR 0.152.
 */
import jurt.Action;
import jurt.Concept;
import jurt.IO;
import jurt.Nomen;
import jurt.Rebuff;
import jurt.Refusal;
import jurt.Vicinity;

public class Scale
extends Concept {
    Concept plug;
    Concept light;

    public Scale(Concept concept) {
        super("electrionic scale", concept);
        this.put("ID", new String[]{"electronic", "scale"});
        this.give("supporter");
        this.plug = new Concept("plug", this){

            public void before(Action action) throws Refusal {
                if (action.isType("insert") && action.second.isSpecies("sockets")) {
                    action.second.checkReachable(action);
                    if (this.isIn(action.second)) {
                        throw new Rebuff("But it's already in " + action.second.def() + ".");
                    }
                    Concept concept = action.second.getParent().getParent();
                    if (!Scale.this.isIn(concept)) {
                        throw new Rebuff("You'll have to put " + Scale.this.def() + " " + concept.prepIn() + " before you can do that.");
                    }
                    action.second.give("open");
                    action.second.give("container");
                    this.remove("attachment");
                    this.remove("static");
                    concept.put("plug-source", Scale.this);
                    this.setParent(action.second);
                    action.vic.io.println("Hey! That did something!");
                    if (Scale.this.getNumMarbles() < 0) {
                        throw new Rebuff("The red light on the scale flickers momentarily, then remains out.");
                    }
                    throw new Rebuff();
                }
            }

            public void after(Action action) throws Refusal {
                if (action.isType("take") || action.isType("extract")) {
                    Concept concept = action.second.getParent().getParent();
                    action.second.remove("open");
                    action.second.remove("container");
                    action.second.remove("data");
                    this.give("attachment");
                    this.give("static");
                    this.setParent(Scale.this);
                    concept.remove("plug-source");
                    throw new Rebuff("You take the plug from " + action.second.def() + ".");
                }
            }

            public void printItemDesc(IO iO) {
                iO.print("The small electrical plug is part of the scale.");
                if (this.isIn(Scale.this)) {
                    iO.print(" You put it into electrical sockets.");
                }
                iO.println();
            }
        };
        this.plug.put("ID", new String[]{"electrical", "plug"});
        this.plug.give("attachment");
        this.plug.give("static");
        this.plug.put("species", "plugs");
        this.light = new Concept("red light", this);
        this.light.put("ID", new String[]{"red", "light"});
        this.light.give("attachment");
        this.light.give("static");
    }

    public void before(Action action) throws Refusal {
        if ((action.isType("take") || action.isType("extract")) && !this.plug.isIn(this)) {
            throw new Rebuff("You'll have to take the plug " + this.plug.getParent().prepOutOf() + " first.");
        }
    }

    public void printItemDesc(IO iO) {
        Nomen nomen = this.getChildList();
        if (nomen != null) {
            iO.print("On it " + nomen.pis() + ".");
        } else {
            iO.print("There's nothing on it.");
        }
        if (!this.plug.isIn(this)) {
            if (this.light.has("on")) {
                iO.print(" Its red light is on.");
            }
        } else {
            iO.print(" A red light (off) and a small plug are attached to it.");
        }
        iO.println();
    }

    public void eachTurn(Vicinity vicinity) {
        if (this.light.has("on") && (this.plug.isIn(this) || this.getNumMarbles() >= 0)) {
            this.light.remove("on");
            vicinity.io.println();
            vicinity.io.println("The red light on the scale goes out.");
        } else if (!this.light.has("on") && !this.plug.isIn(this) && this.getNumMarbles() < 0) {
            this.light.give("on");
            vicinity.io.println();
            vicinity.io.println("The red light on the scale comes on.");
        }
    }

    public int getNumMarbles() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.getNumChildren()) {
            Concept concept = this.getChild(n3);
            if (!concept.has("attachment")) {
                if (this.getChild(n3).isSpecies("marbles")) {
                    ++n;
                } else {
                    ++n2;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            return -1;
        }
        return n;
    }
}

