DECLARE SUB AddPronoun (b$)
DEFINT A-Z

DECLARE SUB AddLine (WhichArray, Text$, ResetColors)
DECLARE FUNCTION IsItem (a$, x)
DECLARE FUNCTION GetSupport (Lo, b$)
DECLARE FUNCTION IsVerb (a$, b$)
DECLARE FUNCTION IsNoun% (a$, b$)
DECLARE FUNCTION IsNoun2% (a$, b$)
DECLARE FUNCTION IsPrep (a$, b$)
DECLARE SUB Decode (b$)
DECLARE FUNCTION RemoveColor$ (a$)
DECLARE FUNCTION GetMaxItems ()
DECLARE FUNCTION GetOc$ (x)
DECLARE FUNCTION GetNoDir$ (Lo%, x%)
DECLARE FUNCTION GetPicNum (a$)
DECLARE FUNCTION GetSpecial! (x)
DECLARE FUNCTION GetObject (x)
DECLARE SUB FormatString (a$)
DECLARE SUB Oprint (a$)
DECLARE SUB ClearLine ()
DECLARE FUNCTION KbIn$ (l%, a$, cc$, SB%)
DECLARE SUB esleep (waitval!)
DECLARE SUB ShowArray (Style%, WhichArray%)
DECLARE FUNCTION GetResource$ (Lo%, Tag$)
DECLARE SUB CreateArray (Text$, ml%, WhichArray%, StartOver%)
DECLARE FUNCTION GetRoomTitle$ (Lo%)
DECLARE SUB PicLoad (a$, WhichType)
DECLARE FUNCTION CheckDirection (DirNum%)
DECLARE FUNCTION GetRoomDesc$ (Lo%)
'***** Module to contain the game data!

CONST MAXARRAYSIZE = 60

COMMON SHARED TextMode
COMMON SHARED BwMode   'configurable
COMMON SHARED MusicOn
COMMON SHARED SoundOn
COMMON SHARED AllUpper 'configurable
COMMON SHARED Box1Size 'This is set by code, not configurable
COMMON SHARED Box2Size 'This is set by code, not configurable
COMMON SHARED a$
COMMON SHARED Lo AS INTEGER
COMMON SHARED Fbuff AS STRING * 8960 'For Fonts
COMMON SHARED ScrollArray() AS STRING * 96
COMMON SHARED bs1$, bs2$, bs3$, bs4$, bs5$, bs6$, bs0$, bsb$

DIM SHARED ScrollArray(MAXARRAYSIZE, 1 TO 2) AS STRING * 96
DIM SHARED Direction(10) AS INTEGER

FUNCTION CheckDirection (DirNum)
    CheckDirection = Direction(DirNum)
END FUNCTION

SUB Decode (b$)

keyval = 193: RotVal = 3
FOR x = 1 TO LEN(b$)
    l = ASC(MID$(b$, x, 1))
    IF x > 1 THEN
        l = l - 33
        IF (l - keyval) < 0 THEN l = l + 223
        l = l - keyval
        l = l + 32
    END IF
    MID$(b$, x, 1) = CHR$(l)
    keyval = keyval + RotVal: IF keyval > 242 THEN keyval = RotVal + 14
NEXT x

END SUB

SUB FormatString (b$)

WHILE INSTR(b$, "~")
    MID$(b$, INSTR(b$, "~"), 1) = " "
WEND
WHILE INSTR(b$, "\")
    MID$(b$, INSTR(b$, "\"), 1) = CHR$(13)
WEND

'FormatString$ = b$
END SUB

FUNCTION GetNoDir$ (Lo, x)

IF Lo = 16 THEN GetNoDir$ = GetResource$(Lo, "NODIR"): EXIT FUNCTION

IF Lo = 18 THEN
    IF (x = 1 OR x = 3 OR x = 4) AND GetSpecial(8) = 0 THEN
        GetNoDir$ = GetResource$(Lo, "BLOCKED"): EXIT FUNCTION
    END IF
    IF x = 4 AND GetSpecial(19) < 2 THEN
        GetNoDir$ = GetResource$(Lo, "NOGOW"): EXIT FUNCTION
    END IF
END IF

IF Lo = 20 THEN
    GetNoDir$ = GetResource$(Lo, "NODIR"): EXIT FUNCTION
END IF

IF Lo = 21 THEN
    IF x = 2 THEN
        GetNoDir$ = GetResource$(Lo, "NOGOSOUTH"): EXIT FUNCTION
    END IF
END IF
IF Lo = 22 THEN
    IF x = 3 THEN
        GetNoDir$ = GetResource$(Lo, "NOGOE"): EXIT FUNCTION
    END IF
END IF

IF Lo = 26 THEN
    IF GetSpecial(37) = 0 THEN
        GetNoDir$ = GetResource$(Lo, "NODIR1"): EXIT FUNCTION
    ELSE
        IF x = 2 OR x = 3 OR x = 4 THEN
            GetNoDir$ = GetResource$(Lo, "NODIR2"): EXIT FUNCTION
        END IF
    END IF
END IF

IF Lo = 27 THEN
    GetNoDir$ = GetResource$(Lo, "NODIR"): EXIT FUNCTION
END IF

IF Lo = 28 THEN
    IF x = 9 THEN
        GetNoDir$ = GetResource$(Lo, "NOGOSW"): EXIT FUNCTION
    END IF
    IF x = 2 THEN
        GetNoDir$ = GetResource$(Lo, "NOGOS"): EXIT FUNCTION
    END IF
    IF x = 8 THEN
        GetNoDir$ = GetResource$(Lo, "NOGOSE"): EXIT FUNCTION
    END IF
    IF x = 3 THEN
        GetNoDir$ = GetResource$(Lo, "NOGOE"): EXIT FUNCTION
    END IF
END IF

IF Lo = 36 THEN
    GetNoDir$ = GetResource$(Lo, "NODIR"): EXIT FUNCTION
END IF


IF x = 5 THEN
    GetNoDir$ = GetResource$(0, "NODIR1"): EXIT FUNCTION
END IF
IF x = 6 THEN
    GetNoDir$ = GetResource$(0, "NODIR2"): EXIT FUNCTION
END IF
GetNoDir$ = GetResource$(0, "NODIR3")
END FUNCTION

FUNCTION GetPicNum (a$)
x = 1
a$ = UCASE$(a$)

IF a$ = "EXITDOOR" THEN x = 1
IF a$ = "BATHROOM" THEN x = 2
IF a$ = "AUTHOR" THEN x = 3
IF a$ = "ODDWARD1" THEN x = 4
IF a$ = "CONSTR" THEN x = 5
IF a$ = "HOTTUB" THEN x = 6
IF a$ = "HALL5" THEN x = 7
IF a$ = "HALL2" THEN x = 8
IF a$ = "HALL3" THEN x = 9
IF a$ = "LAB2" THEN x = 10
IF a$ = "PIPES" THEN x = 11
IF a$ = "FANS" THEN x = 12
IF a$ = "HALL1" THEN x = 13
IF a$ = "MEETROOM" THEN x = 14
IF a$ = "OFFICE1" THEN x = 15
IF a$ = "CAFLADY" THEN x = 16
IF a$ = "CAFE" THEN x = 17
IF a$ = "CHAIR1" THEN x = 18
IF a$ = "GUARD" THEN x = 19
IF a$ = "HALLWAY4" THEN x = 20
IF a$ = "CLOSET" THEN x = 21
IF a$ = "ESC_DOOR" THEN x = 22
IF a$ = "ELEVATOR" THEN x = 23
IF a$ = "KANDI" THEN x = 24
IF a$ = "TODD" THEN x = 25
IF a$ = "NAPOL-1" THEN x = 26
IF a$ = "SOCRAT-1" THEN x = 27
IF a$ = "GROUNDS" THEN x = 28
IF a$ = "ROOM1-10" THEN x = 29
IF a$ = "ROOM1-4" THEN x = 30
IF a$ = "ROOM1-5" THEN x = 31
IF a$ = "ROOM1-6" THEN x = 32
IF a$ = "ROOM1-7" THEN x = 33
IF a$ = "ROOM1-8" THEN x = 34
IF a$ = "ROOM1-9" THEN x = 35
IF a$ = "CLOSET2" THEN x = 36
IF a$ = "CLOSET3" THEN x = 37
IF a$ = "HALL6" THEN x = 38
IF a$ = "HALL7" THEN x = 39
IF a$ = "ESCDOOR2" THEN x = 40
IF a$ = "ODDWARD2" THEN x = 41
IF a$ = "GOATS2" THEN x = 42
IF a$ = "EXITDOR2" THEN x = 43

GetPicNum = x

END FUNCTION

FUNCTION GetResource$ (Lo, Tag$)

STATIC IsOpened AS INTEGER

bsb$ = "": Found = 0: exloop = 0
Resource = 1

IF Resource = 0 THEN
    OPEN "DATA\room" + LTRIM$(RTRIM$(STR$(Lo))) + ".dat" FOR INPUT SHARED AS #1
ELSE
    IF IsOpened = 0 THEN
        OPEN "LUNATIX1.DAT" FOR INPUT SHARED AS #1
        IsOpened = 1
    END IF
    SEEK #1, 1
    LINE INPUT #1, bs0$ 'Get the index record
    SEEK #1, VAL(MID$(bs0$, (Lo * 8) + 1, 8))
END IF

WHILE exloop = 0 AND NOT EOF(1)
    LINE INPUT #1, bs0$
    IF Resource = 0 THEN bs0$ = RTRIM$(LTRIM$(bs0$))
    IF LEN(bs0$) > 0 THEN
        IF Found = 0 THEN
            IF LEFT$(bs0$, 1) = ":" OR LEFT$(bs0$, 1) = "/" THEN
                IF Resource = 1 THEN Decode bs0$: bs0$ = RTRIM$(LTRIM$(bs0$))
                IF UCASE$(bs0$) = ":" + UCASE$(Tag$) OR UCASE$(bs0$) = "/" + UCASE$(Tag$) THEN
                    Found = 1
                END IF
            END IF
        ELSE
            IF LEFT$(bs0$, 1) = ":" THEN
                exloop = 1
            ELSE
                IF Resource = 1 THEN Decode bs0$: bs0$ = RTRIM$(LTRIM$(bs0$))
                IF LEFT$(bs0$, 1) <> "/" THEN
                    IF LEN(bsb$) > 0 THEN bsb$ = bsb$ + " "
                    FormatString bs0$
                    bsb$ = bsb$ + bs0$
                ELSE
                    GOSUB ParseLine
                END IF
            END IF
        END IF
    END IF
WEND

IF Resource = 0 THEN CLOSE #1

GetResource$ = bsb$
bsb$ = "": bs0$ = ""

EXIT FUNCTION

ParseLine:

'***************************************************** Specials
IF MID$(bs0$, 2, 3) = "IFS" THEN
    x = VAL(MID$(bs0$, 5, 3))
    '*****
    y = INSTR(bs0$, ">=")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 2, 6))
         IF GetSpecial(x) >= z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDS" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, "<=")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 2, 6))
         IF GetSpecial(x) <= z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDS" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, "<>")
    IF y = 0 THEN y = INSTR(bs0$, "!=")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 2, 6))
         IF GetSpecial(x) <> z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDS" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, ">")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 1, 6))
         IF GetSpecial(x) > z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDS" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, "<")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 1, 6))
         IF GetSpecial(x) < z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDS" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, "=")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 1, 6))
         IF GetSpecial(x) = z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDS" + LTRIM$(STR$(x))
         END IF
    END IF
END IF

'***************************************************** Object Detection
IF MID$(bs0$, 2, 3) = "IFO" THEN
    x = VAL(MID$(bs0$, 5, 3))
    '*****
    y = INSTR(bs0$, ">=")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 2, 6))
         IF GetObject(x) >= z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDO" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, "<=")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 2, 6))
         IF GetObject(x) <= z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDO" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, "<>")
    IF y = 0 THEN y = INSTR(bs0$, "!=")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 2, 6))
         IF GetObject(x) <> z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDO" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, ">")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 1, 6))
         IF GetObject(x) > z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDO" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, "<")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 1, 6))
         IF GetObject(x) < z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDO" + LTRIM$(STR$(x))
         END IF
    END IF
    '*****
    y = INSTR(bs0$, "=")
    IF y > 0 THEN
         z = VAL(MID$(bs0$, y + 1, 6))
         IF GetObject(x) = z THEN
             RETURN
         ELSE
             Found = 0: Tag$ = "ENDO" + LTRIM$(STR$(x))
         END IF
    END IF
END IF

RETURN

END FUNCTION

FUNCTION GetRoomDesc$ (Lo)

a$ = GetResource$(Lo, "DESCRIPTION")

bs0$ = ""
'** Now check to see what items are here.
g = 0 'How MANY items were here!!!
FOR x = 1 TO GetMaxItems
    IF GetObject(x) = Lo THEN 'The item *IS* at this location!
        IF g > 0 THEN
            bs0$ = bs0$ + ", "
        ELSE
            bs0$ = bs0$ + " On the floor, you see "
        END IF
        g = g + 1
        b$ = UCASE$(LEFT$(GetOc$(x), 1))
        IF b$ = "A" OR b$ = "E" OR b$ = "I" OR b$ = "O" OR b$ = "U" THEN
            bs0$ = bs0$ + "an " + GetOc$(x)
        ELSE
            bs0$ = bs0$ + "a " + GetOc$(x)
        END IF
    END IF
NEXT x
IF g > 0 THEN
    bs0$ = bs0$ + "."
END IF

GetRoomDesc$ = a$ + bs0$: a$ = "": bs0$ = ""

END FUNCTION

FUNCTION GetRoomTitle$ (Lo)

Title$ = "Unknown"

IF Lo = 1 THEN Title$ = "Central Heating Room"
IF Lo = 2 THEN Title$ = "Patient Cell #156"
IF Lo = 3 THEN Title$ = "Patient Cell #157"
IF Lo = 4 THEN Title$ = "Patient Cell #158"
IF Lo = 5 THEN Title$ = "Cell #158's Closet"

IF Lo = 6 THEN Title$ = "Central Cooling Room"
IF Lo = 7 THEN Title$ = "Cell #156's Closet"
IF Lo = 8 THEN Title$ = "The Odd Ward"
IF Lo = 9 THEN Title$ = "Socrates: Weapons Dealer"
IF Lo = 10 THEN Title$ = "Napoleon: Defense Dealer"

IF Lo = 11 THEN Title$ = "Unfinished Staff Lounge"
IF Lo = 12 THEN Title$ = "Staff Conference Room"
IF Lo = 13 THEN Title$ = "Employee's Hallway #3"
IF Lo = 14 THEN Title$ = "The Asylum Cafeteria"
IF Lo = 15 THEN Title$ = "The Kitchen"

IF Lo = 16 THEN Title$ = "Outside The Institution"
IF Lo = 17 THEN Title$ = "Research Laboratory"
IF Lo = 18 THEN Title$ = "Employee's Hallway #2"
IF Lo = 19 THEN Title$ = "Patient Access Hallway"
IF Lo = 20 THEN Title$ = "Inside The Elevator"

IF Lo = 21 THEN Title$ = "The Asylum Entrance"
IF Lo = 22 THEN Title$ = "Your Office"
IF Lo = 23 THEN Title$ = "Employee's Hallway #1"
IF Lo = 24 THEN Title$ = "Shock Therapy Room Door"
IF Lo = 25 THEN Title$ = "Shock Therapy Room"

IF Lo = 26 THEN
    IF GetSpecial(37) = 0 THEN
        Title$ = "The Insanity Circle"
    ELSE
        Title$ = "The Main Asylum Hallway"
    END IF
END IF
IF Lo = 27 THEN Title$ = "Your Private Bathroom"
IF Lo = 28 THEN Title$ = "Guarded Cell Doors"
IF Lo = 29 THEN Title$ = "Patient Cell #126"
IF Lo = 30 THEN Title$ = "Cell #126's Closet"

IF Lo = 31 THEN Title$ = "Cell #129's Closet"
IF Lo = 32 THEN Title$ = "Patient Cell #129"
IF Lo = 33 THEN Title$ = "Patient Cell #128"
IF Lo = 34 THEN Title$ = "Patient Cell #127"
IF Lo = 35 THEN Title$ = "Cell #127's Closet"

IF Lo = 36 THEN Title$ = "Nurse Todd's Hot Tub"

GetRoomTitle$ = Title$
END FUNCTION

FUNCTION GetSupport (Lo, b$)

IF Lo = 41 THEN Found = 1 ELSE Found = 0
exloop = 0
Resource = 1

IF Resource = 0 THEN
    OPEN "DATA\room" + LTRIM$(RTRIM$(STR$(Lo))) + ".dat" FOR INPUT SHARED AS #1
ELSE
    SEEK #1, 1
    LINE INPUT #1, bs1$ 'Get the index record
    SEEK #1, VAL(MID$(bs1$, (Lo * 8) + 1, 8))
END IF

IF Lo = 41 THEN OPEN "LUNATIX.SOL" FOR OUTPUT SHARED AS #2

WHILE exloop = 0 AND NOT EOF(1)
    LINE INPUT #1, bs1$
    IF Resource = 0 THEN
        bs1$ = RTRIM$(LTRIM$(bs1$))
    END IF
    IF LEN(bs1$) > 0 THEN
        IF Found = 0 THEN
            IF LEFT$(bs1$, 1) = ":" THEN
                IF Resource = 1 THEN Decode bs1$: bs1$ = RTRIM$(LTRIM$(bs1$))
                IF UCASE$(bs1$) = ":SUPPORT" THEN
                    Found = 1
                END IF
            END IF
        ELSE
            IF LEFT$(bs1$, 1) = ":" THEN
                exloop = 1
            ELSE
                IF Resource = 1 THEN Decode bs1$
                IF Lo <> 41 THEN
                    bs1$ = RTRIM$(LTRIM$(bs1$))
                    a1 = INSTR(bs1$, " ")
                    a2 = INSTR(a1 + 1, bs1$, " ")
                    a3 = INSTR(a2 + 1, bs1$, " ")
                    a4 = INSTR(a3 + 1, bs1$, " ")
                    a5 = INSTR(a4 + 1, bs1$, " ")
                    bs2$ = MID$(bs1$, a1 + 1, (a2 - a1) - 1) 'Optional PREP
                    bs3$ = MID$(bs1$, a2 + 1, (a3 - a2) - 1) 'NOUN 1
                    bs4$ = MID$(bs1$, a3 + 1, (a4 - a3) - 1) 'Optional NOUN2
                    bs5$ = MID$(bs1$, a4 + 1, (a5 - a4) - 1) 'Optional ITEM
                    bs6$ = RIGHT$(bs1$, LEN(bs1$) - a5) 'RESOURCE TAG
                    bs1$ = LEFT$(bs1$, a1 - 1) 'VERB
                    'Now Let's find out if this one fits!
                    '*************************************
                    IF (LEFT$(bs1$, 1) = "|" AND LEFT$(b$ + " ", LEN(bs1$)) = UCASE$(RIGHT$(bs1$, LEN(bs1$) - 1)) + " ") OR IsVerb(b$, bs1$) THEN
                        IF UCASE$(bs2$) = "X" OR IsPrep(b$, bs2$) THEN
                            IF UCASE$(bs3$) = "X" OR (LEFT$(bs3$, 1) = "|" AND INSTR(b$, " " + RIGHT$(bs3$, LEN(bs3$) - 1))) OR IsNoun(b$, bs3$) OR IsNoun2(b$, bs3$) THEN
                                IF UCASE$(bs3$) <> "X" THEN AddPronoun bs3$
                                IF (LEFT$(bs4$, 1) = "|" AND INSTR(b$, " " + UCASE$(RIGHT$(bs4$, LEN(bs4$) - 1)))) OR UCASE$(bs4$) = "X" OR IsNoun(b$, bs4$) OR IsNoun2(b$, bs4$) THEN
                                    IF UCASE$(bs4$) <> "X" THEN AddPronoun bs4$
                                    x1 = IsItem(" " + bs5$, 0)
                                    IF x1 > 0 THEN y1 = IsItem(b$, x1) ELSE y1 = 0
                                    IF UCASE$(bs5$) = "X" OR (x1 > 0 AND y1 > 0 AND GetObject(x1) = 0) THEN
                                        IF UCASE$(bs5$) <> "X" THEN AddPronoun bs5$
                                        IF Resource = 0 THEN CLOSE #1
                                        AddLine 2, GetResource$(Lo, bs6$), 1
                                        bs1$ = "": bs2$ = "": bs3$ = "": bs4$ = "": bs5$ = "": bs6$ = ""
                                        GetSupport = 1: EXIT FUNCTION
                                    END IF
                                END IF
                            END IF
                        END IF
                    END IF
                '*************************************
                ELSE
                    PRINT #2, RTRIM$(bs1$)
                    '*** Extract to file
                END IF
            END IF
        END IF
    END IF
WEND

IF Resource = 0 THEN CLOSE #1
IF Lo = 41 THEN CLOSE #2

bs1$ = "": bs2$ = "": bs3$ = "": bs4$ = "": bs5$ = "": bs6$ = ""
GetSupport = 0
END FUNCTION

SUB IntroText

IF TextMode = 0 THEN
    CreateArray "`%" + GetResource$(0, "DESCRIPTION"), Box2Size, 2, 0
ELSE
    CreateArray "`2" + GetResource$(0, "DESCRIPTION"), Box2Size, 2, 0
END IF

ShowArray 0, 2 'Show the intro text FIRST!

IF TextMode > 0 THEN
    Oprint "`%`9[ENTER]: "
    b$ = KbIn$(1, "", "$", 0)
    ClearLine
    CreateArray "", Box2Size, 2, 0
END IF

END SUB

SUB SetDirections (Lo)

'*** First, reset all directions...
FOR x = 1 TO 10: Direction(x) = 0: NEXT x

'*** Then, set all the defaults -- which rooms join these rooms!
IF Lo = 1 THEN Direction(6) = 6
IF Lo = 2 THEN Direction(2) = 7: Direction(8) = 8
IF Lo = 3 THEN Direction(2) = 8
IF Lo = 4 THEN Direction(9) = 8: Direction(3) = 5
IF Lo = 5 THEN Direction(4) = 4
IF Lo = 6 THEN Direction(5) = 1: Direction(6) = 12: Direction(8) = 12
IF Lo = 7 THEN Direction(1) = 2
IF Lo = 8 THEN Direction(1) = 3: Direction(2) = 13: Direction(7) = 4: Direction(10) = 2
IF Lo = 9 THEN Direction(2) = 14
IF Lo = 10 THEN Direction(9) = 14
IF Lo = 11 THEN Direction(3) = 12
IF Lo = 12 THEN Direction(10) = 6: Direction(4) = 11: Direction(3) = 13: Direction(5) = 6
IF Lo = 13 THEN Direction(1) = 8: Direction(4) = 12: Direction(2) = 18
IF Lo = 14 THEN Direction(1) = 9: Direction(7) = 10: Direction(3) = 15: Direction(2) = 19
IF Lo = 15 THEN Direction(4) = 14
IF Lo = 16 THEN Direction(2) = 21
IF Lo = 17 THEN Direction(3) = 18
IF Lo = 18 THEN Direction(1) = 13: Direction(2) = 23: Direction(3) = 19: Direction(4) = 17
IF Lo = 19 THEN Direction(1) = 14: Direction(2) = 24: Direction(3) = 20: Direction(4) = 18
IF Lo = 20 THEN Direction(4) = 19
IF Lo = 21 THEN Direction(3) = 22: Direction(1) = 16: Direction(2) = 26
IF Lo = 22 THEN Direction(2) = 27: Direction(3) = 23: Direction(4) = 21
IF Lo = 23 THEN Direction(1) = 18: Direction(2) = 28: Direction(4) = 22
IF Lo = 24 THEN Direction(1) = 19: Direction(3) = 25
IF Lo = 25 THEN Direction(4) = 24
IF Lo = 26 THEN Direction(1) = 21
IF Lo = 27 THEN Direction(1) = 22
IF Lo = 28 THEN Direction(1) = 23: Direction(3) = 29: Direction(8) = 34: Direction(2) = 33: Direction(9) = 32
IF Lo = 29 THEN Direction(3) = 30: Direction(4) = 28
IF Lo = 30 THEN Direction(4) = 29
IF Lo = 31 THEN Direction(3) = 32
IF Lo = 32 THEN Direction(4) = 31: Direction(7) = 28
IF Lo = 33 THEN Direction(1) = 28
IF Lo = 34 THEN Direction(10) = 28: Direction(3) = 35
IF Lo = 35 THEN Direction(4) = 34
IF Lo = 36 THEN Direction(3) = 20

'*** Now, take into account any special conditions/limitations
IF Lo = 8 AND GetSpecial(30) < 1 THEN Direction(10) = 0
IF Lo = 8 AND GetSpecial(31) < 1 THEN Direction(1) = 0
IF Lo = 8 AND GetSpecial(32) < 1 THEN Direction(7) = 0
IF Lo = 13 AND GetSpecial(23) < 2 THEN Direction(4) = 0
IF Lo = 13 AND GetSpecial(24) < 1 THEN Direction(1) = 0
IF Lo = 18 AND GetSpecial(8) < 1 THEN Direction(3) = 0: Direction(4) = 0: Direction(1) = 0
IF Lo = 18 AND GetSpecial(19) < 2 THEN Direction(4) = 0
IF Lo = 20 AND GetSpecial(21) = 2 THEN Direction(4) = 36 'West to the Hot Tub
IF Lo = 21 AND GetSpecial(17) = 0 THEN Direction(2) = 0
IF Lo = 21 AND GetSpecial(42) < 2 THEN Direction(1) = 0
IF Lo = 22 AND GetSpecial(4) < 2 THEN Direction(3) = 0
IF Lo = 24 AND GetSpecial(27) < 1 THEN Direction(3) = 0
IF Lo = 28 AND GetSpecial(5) < 2 THEN Direction(9) = 0
IF Lo = 28 AND GetSpecial(6) < 2 THEN Direction(2) = 0
IF Lo = 28 AND GetSpecial(7) < 2 THEN Direction(8) = 0
IF Lo = 28 AND GetSpecial(9) < 1 THEN Direction(3) = 0


END SUB

SUB SetRoomPic (Lo)

IF TextMode <> 0 THEN EXIT SUB

IF Lo = 1 THEN PicLoad "pipes", 1
IF Lo = 2 THEN PicLoad "room1-9", 1
IF Lo = 3 THEN PicLoad "room1-10", 1
IF Lo = 4 THEN PicLoad "room1-7", 1
IF Lo = 5 THEN PicLoad "kandi", 1
IF Lo = 6 THEN PicLoad "fans", 1
IF Lo = 7 THEN PicLoad "todd", 1
IF Lo = 8 THEN
IF GetSpecial(34) = 0 THEN PicLoad "oddward1", 1 ELSE PicLoad "OddWard2", 1
END IF
IF Lo = 9 THEN PicLoad "socrat-1", 1
IF Lo = 10 THEN PicLoad "napol-1", 1
IF Lo = 11 THEN PicLoad "constr", 1
IF Lo = 12 THEN PicLoad "meetroom", 1
IF Lo = 13 THEN
    IF GetSpecial(24) = 0 THEN PicLoad "hall5", 1 ELSE PicLoad "Hall7", 1
END IF
IF Lo = 14 THEN PicLoad "cafe", 1
IF Lo = 15 THEN PicLoad "caflady", 1
IF Lo = 16 THEN PicLoad "grounds", 1
IF Lo = 17 THEN PicLoad "lab2", 1
IF Lo = 18 THEN
    IF GetSpecial(8) = 0 THEN PicLoad "hall2", 1 ELSE PicLoad "hall3", 1
END IF
IF Lo = 19 THEN PicLoad "hallway4", 1
IF Lo = 20 THEN PicLoad "Elevator", 1
IF Lo = 21 THEN
    IF GetSpecial(42) = 2 THEN PicLoad "exitdor2", 1 ELSE PicLoad "exitdoor", 1
END IF
IF Lo = 22 THEN PicLoad "office1", 1
IF Lo = 23 THEN PicLoad "hall1", 1
IF Lo = 24 THEN
    IF GetSpecial(27) = 0 THEN PicLoad "esc_door", 1 ELSE PicLoad "Escdoor2", 1
END IF
IF Lo = 25 THEN PicLoad "chair1", 1

IF Lo = 26 THEN
    IF GetSpecial(37) = 0 THEN PicLoad "goats2", 1 ELSE PicLoad "hall6", 1
END IF
IF Lo = 27 THEN PicLoad "bathroom", 1
IF Lo = 28 THEN PicLoad "guard", 1
IF Lo = 29 THEN PicLoad "room1-8", 1
IF Lo = 30 THEN PicLoad "closet2", 1

IF Lo = 31 THEN
    IF GetObject(8) <> 0 OR GetSpecial(12) < 1 OR GetObject(9) <> 101 THEN
        PicLoad "closet3", 1
    ELSE
        PicLoad "closet", 1
    END IF
END IF
IF Lo = 32 THEN PicLoad "room1-5", 1
IF Lo = 33 THEN PicLoad "room1-4", 1
IF Lo = 34 THEN PicLoad "room1-6", 1
IF Lo = 35 THEN PicLoad "closet", 1
IF Lo = 36 THEN PicLoad "hottub", 1

END SUB

