/*
  Mem
  Simple memory operations--encapsulates the byte order and
  most of the pager accesses
  JBS 15 June 1994
*/

#ifndef _MEM_

#define _MEM_

#include "config.h"
#include "page.h"
#include "types.h"

#define BLOCK_SHIFT (9)
#define BLOCK_SIZE  (1<<BLOCK_SHIFT)

#define make_word(hi,lo) \
  ((((word) (hi) << 8) + (word) (lo)))

#define ptr_from_seg(page,off) (pg_fetch(page)+(off))

#define rd_byte_seg(p,o) (*ptr_from_seg(p,o))
byte rd_byte_addr(long_word);

word rd_word_ptr(byte *);
word rd_word_seg(word, word);
word rd_word_addr(long_word);

void wr_byte_addr(long_word, byte);

void wr_word_ptr(byte *, word);
void wr_word_addr(long_word, word);

#endif
