/*
  Stack
*/

#include "stack.h"

word stack_space[STACK_SIZE];
word *var_ptr;
word *stack_ptr;

void stk_throw(word off)
{
  var_ptr = stack_base + off;
}

void stk_link(void)
{
  stk_push((word)(var_ptr - stack_base));
  var_ptr = stack_ptr;
}

void stk_unlink(void)
{
  stack_ptr = var_ptr;
  var_ptr   = stack_base + (signed_word) stk_pop();
}

void stk_init(void)
{
  stack_ptr = var_ptr = stack_base - 1;
}


word stk_encode_stk(void)
{
  return -(int)(stack_ptr - stack_base);
}

word stk_encode_var(void)
{
  return -(int)(var_ptr - stack_base);
}

void stk_decode_stk(word off)
{
  stack_ptr = stack_base - off;
}

void stk_decode_var(word off)
{
  var_ptr = stack_base - off;
}



