package zpplet;

import java.awt.*;
import java.io.*;
import javax.swing.*;

import zpplet.machine.ZMachine;
import zpplet.system.*;

import javax.swing.JMenuItem;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;

public final class Zpplication
		extends JFrame
	{
	ZMachine zm;

	private javax.swing.JPanel jContentPane = null;
	private javax.swing.JMenuBar jJMenuBar = null;
	private javax.swing.JMenu gameMenu = null;
	private javax.swing.JMenu helpMenu = null;
	private javax.swing.JMenuItem exitMenuItem = null;
	private javax.swing.JMenuItem aboutMenuItem = null;
	private ZScreen zScreen = null;
	private JMenuItem loadFileMenuItem = null;

	private JMenu displayMenu = null;
	private JCheckBoxMenuItem fixedFontCheckBoxMenuItem = null;
	private JMenu fontMenu = null;
	private JRadioButtonMenuItem smallFontRadioButtonMenuItem = null;
	private JRadioButtonMenuItem regularFontRadioButtonMenuItem = null;
	private JRadioButtonMenuItem largeFontRadioButtonMenuItem = null;
	private JRadioButtonMenuItem xlargeFontRadioButtonMenuItem = null;
	private JMenuItem jMenuItem = null;

	private JCheckBoxMenuItem logMenuItem = null;
	private JCheckBoxMenuItem transMenuItem = null;

	private JMenuItem useLogMenuItem = null;
	public Zpplication()
		{
		super();
		initialize();
		}

	// TODO: font selector dialog, color selector dialog, scaling pct,
	// scrolling options
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize()
		{
		this.setLocation(0, 0);
		this.setPreferredSize(new java.awt.Dimension(640, 480));
		this.setContentPane(getJContentPane());
		this.setJMenuBar(getJJMenuBar());
		this.setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
		this.setSize(650, 480);
		this.setTitle("Zpplication");
		}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane()
		{
		if (jContentPane == null)
			{
			jContentPane = new javax.swing.JPanel();
			jContentPane.setLayout(new java.awt.BorderLayout());
			jContentPane.setPreferredSize(new java.awt.Dimension(640, 400));
			jContentPane.add(getZScreen(), java.awt.BorderLayout.CENTER);
			jContentPane.setVisible(true);
			}
		return jContentPane;
		}

	/**
	 * This method initializes jJMenuBar
	 * 
	 * @return javax.swing.JMenuBar
	 */
	private javax.swing.JMenuBar getJJMenuBar()
		{
		if (jJMenuBar == null)
			{
			jJMenuBar = new javax.swing.JMenuBar();
			jJMenuBar.add(getGameMenu());
			jJMenuBar.add(getDisplayMenu());
			jJMenuBar.add(getHelpMenu());
			}
		return jJMenuBar;
		}

	/**
	 * This method initializes jMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private javax.swing.JMenu getGameMenu()
		{
		if (gameMenu == null)
			{
			gameMenu = new javax.swing.JMenu();
			gameMenu.setText("Game");
			gameMenu.add(getLoadFileMenuItem());
			gameMenu.add(getLogMenuItem());
			gameMenu.add(getTransMenuItem());
			gameMenu.add(getUseLogMenuItem());
			gameMenu.addSeparator();
			gameMenu.add(getExitMenuItem());
			}
		return gameMenu;
		}

	/**
	 * This method initializes jMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private javax.swing.JMenu getHelpMenu()
		{
		if (helpMenu == null)
			{
			helpMenu = new javax.swing.JMenu();
			helpMenu.setText("Help");
			helpMenu.add(getJMenuItem());
			helpMenu.add(getAboutMenuItem());
			}
		return helpMenu;
		}

	/**
	 * This method initializes jMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private javax.swing.JMenuItem getExitMenuItem()
		{
		if (exitMenuItem == null)
			{
			exitMenuItem = new javax.swing.JMenuItem();
			exitMenuItem.setText("Exit");
			exitMenuItem.addActionListener(new java.awt.event.ActionListener()
				{
					public void actionPerformed(java.awt.event.ActionEvent e)
						{
						System.exit(0);
						}
				});
			}
		return exitMenuItem;
		}

	/**
	 * This method initializes jMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private javax.swing.JMenuItem getAboutMenuItem()
		{
		if (aboutMenuItem == null)
			{
			aboutMenuItem = new javax.swing.JMenuItem();
			aboutMenuItem.setText("About");
			aboutMenuItem.addActionListener(new java.awt.event.ActionListener()
				{
					public void actionPerformed(java.awt.event.ActionEvent e)
						{
						(new About(Zpplication.this)).setVisible(true);
						}
				});
			}
		return aboutMenuItem;
		}

	/**
	 * This method initializes zScreen
	 * 
	 * @return zpplet.screen.ZScreen
	 */
	private ZScreen getZScreen()
		{
		if (zScreen == null)
			{
			zScreen = new ZScreen();
			zScreen.setVisible(true);
			zScreen.setPreferredSize(new java.awt.Dimension(640, 480));
			}
		return zScreen;
		}

	byte[] getStream(InputStream s)
			throws IOException
		{
		byte[] buffer;
		byte[] oldbuffer;
		int currentbytes = 0;
		int bytesleft;
		int got;
		int buffersize = 2048;

		buffer = new byte[buffersize];
		bytesleft = buffersize;
		got = 0;
		while (got != -1)
			{
			bytesleft -= got;
			currentbytes += got;
			if (bytesleft == 0)
				{
				oldbuffer = buffer;
				buffer = new byte[buffersize + currentbytes];
				System.arraycopy(oldbuffer, 0, buffer, 0, currentbytes);
				oldbuffer = null;
				bytesleft = buffersize;
				}
			got = s.read(buffer, currentbytes, bytesleft);
			}
		if (buffer.length != currentbytes)
			{
			oldbuffer = buffer;
			buffer = new byte[currentbytes];
			System.arraycopy(oldbuffer, 0, buffer, 0, currentbytes);
			}
		return buffer;
		}

	void lookForBlorb(String codefile)
		{
		int dot = codefile.lastIndexOf(".");
		if (dot < 0) return;
		String blorbfile = codefile.substring(0, dot) + ".blb";

		File f = new File(blorbfile);
		if (f.exists())
			zm.loadMedia(blorbfile);
		}

	void startz(String codefile)
		{
		try
			{
			if (zm != null)
				{
				zm.kill();
				zm.join();
				}
			zm = ZMachine.NewZMachine(codefile, zScreen);
			if (zm == null)
				throw new Exception("Could not load file");
			if (zm.wantsMedia())
				lookForBlorb(codefile);
			setTitle("Zpplet - " + codefile);
			if (smallFontRadioButtonMenuItem.isSelected())
				ZUserConfig.fontsize = 12;
			else if (regularFontRadioButtonMenuItem.isSelected())
				ZUserConfig.fontsize = 16;
			else if (largeFontRadioButtonMenuItem.isSelected())
				ZUserConfig.fontsize = 20;
			else if (xlargeFontRadioButtonMenuItem.isSelected()) ZUserConfig.fontsize = 24;
			ZUserConfig.normalfont = fixedFontCheckBoxMenuItem.isSelected() ? ZUserConfig.fixedfont : ZUserConfig.variablefont;
			zm.start();
			}
		catch (Exception e)
			{
			if (e.getMessage() != null)
				{
				e.printStackTrace();
				JOptionPane.showMessageDialog(this, e.getMessage(), null, JOptionPane.ERROR_MESSAGE);
				}
			}
		}

	/**
	 * This method initializes jMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getLoadFileMenuItem()
		{
		if (loadFileMenuItem == null)
			{
			loadFileMenuItem = new JMenuItem();
			loadFileMenuItem.setText("Load game...");
			loadFileMenuItem.addActionListener(new java.awt.event.ActionListener()
				{
					public void actionPerformed(java.awt.event.ActionEvent e)
						{
						String codefile = promptForCodeFile();
						if (codefile != null) startz(codefile);
						}
				});
			}
		return loadFileMenuItem;
		}

	String promptForCodeFile()
		{
		FileDialog fd = new FileDialog(this, "Select game file", FileDialog.LOAD);
		fd.setVisible(true);
		if (fd.getFile() != null) return (new File(fd.getDirectory(), fd.getFile())).getAbsolutePath();
		return null;
		}

	/**
	 * This method initializes jMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getDisplayMenu()
		{
		if (displayMenu == null)
			{
			displayMenu = new JMenu();
			displayMenu.setText("Display");
			displayMenu.add(getFontMenu());
			}
		return displayMenu;
		}

	/**
	 * This method initializes jCheckBoxMenuItem
	 * 
	 * @return javax.swing.JCheckBoxMenuItem
	 */
	private JCheckBoxMenuItem getFixedFontCheckBoxMenuItem()
		{
		if (fixedFontCheckBoxMenuItem == null)
			{
			fixedFontCheckBoxMenuItem = new JCheckBoxMenuItem();
			fixedFontCheckBoxMenuItem.setText("Use fixed font only");
			fixedFontCheckBoxMenuItem.addItemListener(new java.awt.event.ItemListener() { 
				public void itemStateChanged(java.awt.event.ItemEvent e) {    
					ZUserConfig.normalfont = fixedFontCheckBoxMenuItem.isSelected() ? ZUserConfig.fixedfont : ZUserConfig.variablefont;
					if (zm != null)
						zm.notifyConfigChange();
				}
			});
			}
		return fixedFontCheckBoxMenuItem;
		}

	/**
	 * This method initializes jMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getFontMenu()
		{
		if (fontMenu == null)
			{
			fontMenu = new JMenu();
			fontMenu.setText("Font");
			fontMenu.add(getFixedFontCheckBoxMenuItem());
			fontMenu.addSeparator();
			fontMenu.add(getSmallFontRadioButtonMenuItem());
			fontMenu.add(getRegularFontRadioButtonMenuItem());
			fontMenu.add(getLargeFontRadioButtonMenuItem());
			fontMenu.add(getXlargeFontRadioButtonMenuItem());

			ButtonGroup bg = new ButtonGroup();
			bg.add(smallFontRadioButtonMenuItem);
			bg.add(regularFontRadioButtonMenuItem);
			bg.add(largeFontRadioButtonMenuItem);
			bg.add(xlargeFontRadioButtonMenuItem);
			}
		return fontMenu;
		}

	/**
	 * This method initializes jRadioButtonMenuItem
	 * 
	 * @return javax.swing.JRadioButtonMenuItem
	 */
	private JRadioButtonMenuItem getSmallFontRadioButtonMenuItem()
		{
		if (smallFontRadioButtonMenuItem == null)
			{
			smallFontRadioButtonMenuItem = new JRadioButtonMenuItem();
			smallFontRadioButtonMenuItem.setText("Small");
			smallFontRadioButtonMenuItem.addItemListener(new java.awt.event.ItemListener() { 
				public void itemStateChanged(java.awt.event.ItemEvent e) {    
					ZUserConfig.fontsize = 12;
					if (zm != null)
						zm.notifyConfigChange();
				}
			});
			}
		return smallFontRadioButtonMenuItem;
		}

	/**
	 * This method initializes jRadioButtonMenuItem1
	 * 
	 * @return javax.swing.JRadioButtonMenuItem
	 */
	private JRadioButtonMenuItem getRegularFontRadioButtonMenuItem()
		{
		if (regularFontRadioButtonMenuItem == null)
			{
			regularFontRadioButtonMenuItem = new JRadioButtonMenuItem();
			regularFontRadioButtonMenuItem.setText("Regular");
			regularFontRadioButtonMenuItem.setSelected(true);
			regularFontRadioButtonMenuItem.addItemListener(new java.awt.event.ItemListener() { 
				public void itemStateChanged(java.awt.event.ItemEvent e) {    
					ZUserConfig.fontsize = 16;
					if (zm != null)
						zm.notifyConfigChange();
				}
			});
			}
		return regularFontRadioButtonMenuItem;
		}

	/**
	 * This method initializes jRadioButtonMenuItem2
	 * 
	 * @return javax.swing.JRadioButtonMenuItem
	 */
	private JRadioButtonMenuItem getLargeFontRadioButtonMenuItem()
		{
		if (largeFontRadioButtonMenuItem == null)
			{
			largeFontRadioButtonMenuItem = new JRadioButtonMenuItem();
			largeFontRadioButtonMenuItem.setText("Large");
			largeFontRadioButtonMenuItem.addItemListener(new java.awt.event.ItemListener() { 
				public void itemStateChanged(java.awt.event.ItemEvent e) {    
					ZUserConfig.fontsize = 20;
					if (zm != null)
						zm.notifyConfigChange();
				}
			});
			}
		return largeFontRadioButtonMenuItem;
		}

	/**
	 * This method initializes jRadioButtonMenuItem3
	 * 
	 * @return javax.swing.JRadioButtonMenuItem
	 */
	private JRadioButtonMenuItem getXlargeFontRadioButtonMenuItem()
		{
		if (xlargeFontRadioButtonMenuItem == null)
			{
			xlargeFontRadioButtonMenuItem = new JRadioButtonMenuItem();
			xlargeFontRadioButtonMenuItem.setText("Extra large");
			xlargeFontRadioButtonMenuItem.addItemListener(new java.awt.event.ItemListener() { 
				public void itemStateChanged(java.awt.event.ItemEvent e) {    
					ZUserConfig.fontsize = 24;
					if (zm != null)
						zm.notifyConfigChange();
				}
			});
			}
		return xlargeFontRadioButtonMenuItem;
		}

	/**
	 * This method initializes jMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem()
		{
		if (jMenuItem == null)
			{
			jMenuItem = new JMenuItem();
			jMenuItem.setText("Fiddle with fonts");
			jMenuItem.addActionListener(new java.awt.event.ActionListener()
				{
					public void actionPerformed(java.awt.event.ActionEvent e)
						{
						JDialog jd = new FontSelect();
						jd.setVisible(true);
						}
				});
			}
		return jMenuItem;
		}

	/**
	 * This method initializes jCheckBoxMenuItem	
	 * 	
	 * @return javax.swing.JCheckBoxMenuItem	
	 */
	private JCheckBoxMenuItem getLogMenuItem()
		{
		if (logMenuItem == null)
			{
			logMenuItem = new JCheckBoxMenuItem();
			logMenuItem.setText("Log");
			logMenuItem.addItemListener(new java.awt.event.ItemListener()
				{
					public void itemStateChanged(java.awt.event.ItemEvent e)
						{
						if (zm != null)
							{
							zm.setOutputStream(ZMachine.OSTREAM_LOG, e.getStateChange() == java.awt.event.ItemEvent.SELECTED, 0, 0);
							((JCheckBoxMenuItem)e.getItem()).setSelected(zm.outputs[ZMachine.OSTREAM_LOG]);
							}
						}
				});
			}
		return logMenuItem;
		}

	/**
	 * This method initializes jCheckBoxMenuItem	
	 * 	
	 * @return javax.swing.JCheckBoxMenuItem	
	 */
	private JCheckBoxMenuItem getTransMenuItem()
		{
		if (transMenuItem == null)
			{
			transMenuItem = new JCheckBoxMenuItem();
			transMenuItem.setText("Transcript");
			transMenuItem.addItemListener(new java.awt.event.ItemListener()
				{
					public void itemStateChanged(java.awt.event.ItemEvent e)
						{
						if (zm != null)
							{
							zm.setOutputStream(ZMachine.OSTREAM_TRANSCRIPT,
									e.getStateChange() == java.awt.event.ItemEvent.SELECTED, 0, 0);
							((JCheckBoxMenuItem)e.getItem()).setSelected(zm.outputs[ZMachine.OSTREAM_TRANSCRIPT]);
							}
						}
				});
			}
		return transMenuItem;
		}

	/**
	 * This method initializes jMenuItem1	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */    
	private JMenuItem getUseLogMenuItem() {
		if (useLogMenuItem == null) {
			useLogMenuItem = new JMenuItem();
			useLogMenuItem.setText("Use log");
			useLogMenuItem.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					if (zm != null)
						zm.setInputStream(ZMachine.ISTREAM_LOG);
				}
			});
		}
		return useLogMenuItem;
	}
  	/**
	 * Launches this application
	 */
	public static void main(String[] args)
		{
		Zpplication app = new Zpplication();
		app.pack();
		app.setVisible(true);

		// get command-line arguments
		String codefile = null;
		for (int i = 0; i < args.length; i++)
			{
			if (args[i].charAt(0) == '-')
				{
				switch (args[i].charAt(1))
					{
					case 'f':
						ZColor.setDefaultForeground(args[++i]);
						break;
					case 'b':
						ZColor.setDefaultBackground(args[++i]);
						break;

					default:
						break;
					}
				}
			else
				codefile = args[i];
			}

		if (codefile != null) app.startz(codefile);
		}
	} //  @jve:decl-index=0:visual-constraint="6,4"
