package zpplet.machine;

import zpplet.ZUserConfig;
import zpplet.misc.*;
import zpplet.ops.ZInstruction6;
import zpplet.system.*;
import zpplet.data.ZDictionary4;
import zpplet.data.ZObjectTree4;
import zpplet.header.ZHeader;
import zpplet.header.ZHeader6;

public class ZMachine6
		extends ZMachine5
	{
	private int stringbase;
	private int routinebase;

	public ZMachine6(byte[] mem, ZScreen screen)
		{
		super(mem, screen);
		}

	public int unpackSAddr(int addr)
		{
		return stringbase + addr * 4;
		}

	public int unpackRAddr(int addr)
		{
		return routinebase + addr * 4;
		}
	
	protected void initStructures()
		{
		hd = new ZHeader6(m);
		objs = new ZObjectTree4(this);
		zd = new ZDictionary4(this);
		zi = new ZInstruction6(this);
		}
	
	protected void initWindows()
		{
		w = new ZWindow[8];

		w[0] = new ZWindow(this, 0);
		w[0].moveTo(1, 1);
		w[0].resize(s.getBoundsWidth(), s.getBoundsHeight());
		
		w[0].moveCursor(1, 1);
		w[0].setWrapMode(true);
		w[0].setScroll(true);
		w[0].setTranscripting(true);
		w[0].setBufferMode(true);
		
		for (int i = 1; i < 8; i++)
			{
			w[i] = new ZWindow(this, i);
			w[i].moveTo(1, 1);
			w[i].resize(0, 0);
			w[i].setWrapMode(false);
			w[i].setScroll(false);
			w[i].setTranscripting(false);
			w[i].setBufferMode(true);
			}
		w[1].resize(s.getBoundsWidth(), 0);
		
		curw = w[0];
		s.setMouseWindow(1);
		}

	public void setHeaderFlags()
		{
		ZHeader6 header = (ZHeader6)this.hd;

	    if ((header.story == ZHeader.ZORK_ZERO) && (header.getRelease() == 296))
	    	header.setGraphicsWanted(true);
	    
		header.setRevision(STANDARDS_VERSION_MAJOR, STANDARDS_VERSION_MINOR);
		if (header.isFixedForced())
			ZUserConfig.normalfont = ZUserConfig.fixedfont;
		
		// screen model flags
		header.setBoldAvailable(true);
		header.setItalicAvailable(true);
		header.setFixedFontAvailable(true);
		header.setTimedInputAvailable(true);

		header.setInterpreterInfo(ZUserConfig.interpreter, INTERPRETER_VERSION);
		header.setScreenDimensions(s.getLines(), s.getChars());

		// screen model flags
		header.setColorsAvailable(true);
		header.setPicturesAvailable(media != null);
		header.setUndoAvailable(true);
		header.setMouseAvailable(true);
		header.setSoundAvailable(true);

		// NOTE: for V6, using unit = 1 pixel
		header.setScreenHeightUnits(s.getBoundsHeight());
		header.setScreenWidthUnits(s.getBoundsWidth());
		header.setFontHeightUnits(s.getLineHeight());
		header.setFontWidthUnits(s.getCharWidth());


		//ZColor.def = new ZColor(header.getDefaultForegroundColor(), header.getDefaultBackgroundColor());
		header.setDefaultForegroundColor(ZColor.def.zfg);
		header.setDefaultBackgroundColor(ZColor.def.zbg);
		
		int alphabase = header.getAlphaCustomBase();
		int terminatorbase = header.getTerminatorsBase();
		int unicodebase = header.getUnicodeBase();
		zc.setCustomAddresses(alphabase, terminatorbase, unicodebase);

		routinebase = header.getRoutineBase();
		stringbase = header.getStringBase();
		
		header.setMenusAvailable(false); // TODO: menus
		}

	public void restart()
		{
		super.restart();

		w[0].moveTo(1, 1);
		w[0].resize(s.getBoundsWidth(), s.getBoundsHeight());
		w[0].moveCursor(1, w[0].getLines());

		for (int i = 1; i < 8; i++)
			{
			w[i].moveTo(1, 1);
			w[i].resize(0, 0);
			}
		
		curw = w[0];
		}
	
	public void resize()
		{
		ZHeader6 h = (ZHeader6)hd;
		h.setScreenDimensions(s.getLines(), s.getChars());
		h.setScreenHeightUnits(s.getBoundsHeight());
		h.setScreenWidthUnits(s.getBoundsWidth());
		}
	
	public void openStream3(int addr, int width)
		{
		if (width < 0)
			width = -width;
		else if (width > 0)
			width = w[width].getTextWidth();
		
		stream3.push(new Stream3Data(addr, width));
		outputs[OSTREAM_MEMORY] = true;
		}
	
	private StringBuilder getTableStringAt(int addr)
		{
		StringBuilder result = new StringBuilder();
		int nchars = getWord(addr);
		for (int i = 0; i < nchars; i++)
			result.append((char)getByte(addr + 2 + i));
		return result;
		}
	
	public void closeStream3()
		{
		Stream3Data data = (Stream3Data)stream3.pop(); 
		data.pixelwidth += curw.getStringWidth(getTableStringAt(data.addr).toString());
		if (data.width != 0)
			{ // write an empty line
			data.addr += getWord(data.addr) + 2;
			setWord(data.addr, 0);
			}
		((ZHeader6)hd).setPixelWidth(data.pixelwidth);
		outputs[OSTREAM_MEMORY] = !stream3.isEmpty();
		}
	
	public void printToStream3(int ch)
		{
		Stream3Data data = (Stream3Data)stream3.peek(); 
		int width = data.width;
		if (width == 0)
			{
			super.printToStream3(ch);
			return;
			}
		
		int nchars = getWord(data.addr);
		
		if (ch == ZChars.RETURN_CHAR) // go to new line
			{
			data.pixelwidth += curw.getStringWidth(getTableStringAt(data.addr).toString());
			data.addr += 2 + nchars;
			setWord(data.addr, 0);
			return;
			}

		// load current string
		StringBuilder sb = getTableStringAt(data.addr);
		sb.append((char)ch);
		
		// find split
		int split = curw.splitText(sb.toString(), data.width);
		if (split == 0)
			{ // no split, so append character
			setByte(data.addr + 2 + nchars, ch);
			setWord(data.addr, nchars + 1);
			return;
			}

		setWord(data.addr, split); // truncate current string at split
		data.pixelwidth += curw.getStringWidth(sb.substring(0, split));
		data.addr += 2 + nchars; // skip to next string

		// remove leading spaces (and the stuff in the previous string)
		while ((split < sb.length()) && sb.charAt(split) == ' ')
			split++;
		sb.delete(0, split);

		// write new string
		setWord(data.addr, sb.length());
		for (int i = 0; i < sb.length(); i++)
			setByte(data.addr + 2 + i, sb.charAt(i));
		}
	}
