#charset "us-ascii"
#include <advlite.h>

#ifdef __DEBUG

Test 'capsule' ['gonear large capsule', 'poweron', 'e', 'purloin jellybeans', 'give jellybeans to dinosaur',
    'w', 'get in capsule'];

#endif

// The MoveLeft and MoveRight actions are defined in a different file.

class CapsuleScenery: Distant
    // Question (1/19/18): Can you READ the shaveSigns? Not currently, no. You can't even examine them.
    // This is likely to be a bad thing.
    decorationActions = [Examine, Feel, Take]
    dobjFor(Feel) {
        check() {
            "{The subj dobj} {is} outside the window. You can't
            touch <<if (gDobj.plural)>>them<<else>>it<<end>>. ";
        }
    }
    cannotTakeMsg = '{The subj dobj} {is} outside the window.
        You can\'t touch <<if (gDobj.plural)>>them<<else>>it<<end>>. '
;

goldenPyramid: CapsuleScenery 'golden pyramid; rotating; beacon (of) light'
    "The pyramid vaguely resembles the decoration on the back of a dollar
    bill. It's not green, of course. "
;
duckPond: CapsuleScenery 'blue pond; broad flat glittering; ducks'
    "The pond is broad and flat and very blue. Ducks are swimming in it. "
;
giantShoe: CapsuleScenery 'giant shoe; swarming; children'
    "The shoe resembles something from a well-known fairy tale. "
;
knightInArmor: CapsuleScenery
    'knight (in) shining armor; improbably large motionless chrome-plated; horse'
    "The knight is nobility personified. "
;
choirSinging: CapsuleScenery
    'choir; hymn wearing; robes hymn-books book books'
    "The choir appears to be singing enthusiastically. "
;
ferrisWheel: CapsuleScenery
    'Ferris wheel; multicolored festive spinning'
    "The Ferris wheel is rotating slowly. "
;
shaveSigns: CapsuleScenery
    'sign; red; signs; it them'
    decorationActions = [Examine, Read]
    readDesc() { desc(); }
    desc () {
        // The solution is 3815
        switch (cTrack.onTrackAt) {
        case 25: "The signs you just passed were <q>Time to kick off</q>
            and <q>Who you'll be?</q> ";
            break;
        case 26: "The signs you just passed were <q>Get a fresh start,</q>
            <q>By choosing three,</q> and <q><i>Inkwell Shave.</i></q> ";
            break;
        case 21: "The signs you just passed were <q>A second do not</q>
            and <q>Hesitate.</q> ";
            break;
        case 19: "The signs you just passed were <q>Continuing</q>
            and <q>Will be such fun.</q> ";
            break;
        case 20: "The signs you just passed were <q>You're almost done,</q>
            <q>When you choose one,</q> and <q><i>Flogg Shave.</i></q> ";
            break;
        case 22: "The signs you just passed were <q>What you need next,</q>
            <q>Must be an eight,</q> and <q><i>Grabby Shave.</i></q> ";
            break;
        case 23: "The signs you just passed were <q>At last your new life</q>
            and <q>Will arrive.</q> ";
            break;
        case 24: "The signs you just passed were <q>If you have used,</q>
            <q>A final five,</q> and <q><i>Stuff Shave.</i></q>" ;
            break;
        default:
            "Looking out the window, at the moment you can see no signs at all. ";
        }
    }
;
stationPlatform: CapsuleScenery
    'station platform; flat level empty'
    "The platform is flat and level. Also empty --- nobody is standing on it. "
;
// goldenPyramid duckPond giantShoe knightInArmor choirSinging ferrisWheel shaveSigns stationPlatform

// Each track segment stores its next segment, which is set by the lever.
// These objects will not be visible within the capsule -- they're nowhere.
// Ditto the track "container" object -- it's nowhere.

class CapsuleSegment: Thing
    nextSegment = 1
    switchNextSegment (n) {
        nextSegment = n;
    }
;

//--------------------------------------------------------------------------
// The exterior room:
//--------------------------------------------------------------------------

capsuleRoom: Room 'Future Stuff Room'
    "In place of the elaborate electric train set that you remember from ten years
    ago, this room now features a bullet-shaped capsule that's large enough to climb
    into. Its exterior is a shocking combination of highly polished green, lavender,
    and chrome. Above the capsule is a banner that brashly proclaims, <q>See the
    Future Today: Take a Tour of Stuff World!!!</q> 
    
    <.p>The doorway back to the toy store is to the east. "
    
    canTravelerPass(traveler) {
        return (purpleDinosaur.friendly);
    }
    explainTravelBarrier (traveler) {
        if (traveler == me)
            "<q>Oh, goodness,</q> the large purple whatever-it-is exclaims. <q><<one of>>I really
            don\'t know if I should allow you to go in there. I haven\'t been told it\'s
            not allowed, but I haven\'t been told it <i>is</i> allowed either. I get so
            confused sometimes!<<or>>I\'m almost sure I mentioned to you that I thought perhaps
            I shouldn\'t allow you to go in there.<<stopping>></q> ";
    }
    
    east = toyShop
    in = capsuleExteriorDoor
;

+ Decoration 'banner'
    "The banner invites you, at least by implication, to take a tour. Quite possibly
    the tour is inside the capsule. "
;

+ capsuleExteriorDoor: Door '(capsule) door; ; hatch'
    "The door, or perhaps it's a hatch, as it's hinged at the top, stands invitingly open. "
    otherSide = capsuleInteriorDoor
    travelBarriers = [wagonBarrier]
    isOpen = true
    canTravelerPass(t) {
        return purpleDinosaur.friendly;
    }
    explainTravelBarrier (t) {
        "The friendly purple dinosaur manages somehow to insinuate his puffy self between you and
        the capsule. <q>I don't know if I ought to let you in there,</q> he says apologetically.
        <q>I mean, they didn't tell me <i>not</i> to let anybody try it out, but they didn't tell
        me it was all right either.</q> ";
    }
;
        
+ capsuleExterior: Enterable 'bullet-shaped capsule; large shiny highly polished green lavender chrome'
    "The capsule is shiny and futuristic-looking. Its door (perhaps one would call it a hatch) is
    invitingly open. "
    destination = capsuleExteriorDoor
;

//----------------------------------------------------------------------------
// The interior of the capsule:
//----------------------------------------------------------------------------

capsuleInterior: Room 'In the Capsule'
    "The interior of the capsule has wrap-around windows --- or rather, since no windows were visible
    from outside, these must be video projection screens. In them you see a panoramic view of
    a brightly colored and rather artificial-looking landscape. Situated on the panel in front of the
    bucket seat are a lever that can be moved left or right, and a button.
    
    <.p>It's not entirely clear in here which direction is which, but you can certainly get out
    by going out. "
    out = capsuleInteriorDoor
;

+ viewOfTrack: Decoration 'track'
    "The track is visible beyond the front of the capsule, and stretches away into the distance. "
;

+ capsuleInteriorDoor: Door '(capsule) door;; hatch'
    "The door fits snugly into the curving side wall of the capsule. At the moment
    it's <<if (isOpen)>>open<<else>>tightly shut<<end>>. "
    otherSide = capsuleExteriorDoor
    canTravelerPass(t) {
        return !cTrack.capsuleIsMoving;
    }
    explainTravelBarrier(t) {
        "The door seems to be stuck. As the scenery outside the windows is
        moving, it's a fair bet that you'll need to guide the capsule back
        to the station in order to release the door and get out. ";
    }
    dobjFor(Open) {
        check() {
            if (cTrack.capsuleIsMoving) "The door won\'t open, presumably because the virtual
                capsule is moving (even though it\'s not really moving). ";
        }
    }
;

+ capsuleWindows: Fixture 'wrap-around windows; ; window screen screens'
    "Visible through the windows is what appears to be a many-faceted amusement park. "
;

+ amusementPark: CapsuleScenery
    'amusement park; brightly colored unconvincing stuff; world simulation'
    "The amusement park is brightly colored but rather unconvincing. Possibly the fact
    that it's a simulation has something to do with that. "
;

+ cPanel: Fixture 'control panel'
    "The control panel is mounted within easy reach in front of the bucket seat.
    It has only two controls --- a lever, which is mounted in a horizontal
    slot so that it can be pushed to the left or right, and a button. Currently the lever
    is to the <<cLever.direction>>. "
;

++ cLever: Component 'lever'
    "The lever is mounted on the control panel. Currently it's angled to the
    <<direction>>. "
    // It starts out the game angled to the left:
    direction = 'left'
    dobjFor(MoveLeft) {
        verify() {}
        check() {
            if (direction == 'left') "The lever is already angled to the left. ";
        }
        action() {
            doInstead (Push, cLever);
        }
    }
    dobjFor(MoveRight) {
        verify() {}
        check() {
            if (direction == 'right') "The lever is already angled to the right. ";
        }
        action() {
            doInstead (Push, cLever);
        }
    }
    dobjFor(Move) asDobjFor(Push)
    dobjFor(Push) {
        verify() {}
        check() {}
        action() {
            if (direction == 'left') direction = 'right';
            else direction = 'left';
            cTrack.switchJunctions(direction);
            "You push the lever to the <<direction>>. ";
        }
    }
    dobjFor(Pull) {
        verify() {}
        check() {
            "The lever stubbornly resists being pulled. You could move it
            left or right, though. ";
        }
    }
;

++ cButton: Button 'button'
    "The button is mounted on the control panel. "
    dobjFor(Push) {
        action() {
            if (!junctionBox.isPowered) {
                "You push the button, but nothing happens. ";
                return;
            }
            if (cTrack.capsuleIsMoving) {
                "Pushing the button again seems to have no immediate effect. ";
                return;
            }
            // And now we'll start the car moving:
            if (cTrack.daemonID == nil) {
                local doorOpen = capsuleInteriorDoor.isOpen;
                capsuleInteriorDoor.makeOpen(nil);
                "As you push the button, <<if doorOpen>>the capsule door closes
                automatically and <<end>>the scenery visible through the windows
                begins to flow backward past the capsule. ";
                cTrack.daemonID = new Daemon (cTrack, &runningDaemon, 1);
                cTrack.capsuleIsMoving = true;
            }
        }
    }
;

//-----------------------------------------------------------------------------------
// The track and its segments. This object is not visible from within the capsule.
//-----------------------------------------------------------------------------------

cTrack: Thing
    // The only segments whose nextSegment can change are 8, 9, 12, and 13:
    switchJunctions (dir) {
        if (dir == 'left') {
            cSeg8.nextSegment = 25;
            cSeg9.nextSegment = 5;
            cSeg12.nextSegment = 17;
            cSeg13.nextSegment = 23;
        }
        else {
            cSeg8.nextSegment = 18;
            cSeg9.nextSegment = 21;
            cSeg12.nextSegment = 19;
            cSeg13.nextSegment = 6;
        }
    }
    // Because the capsule can't be seen from the outside, we don't need a car object,
    // so we'll put the activity descriptions daemon here:
    capsuleIsMoving = nil
    onTrackAt = 1
    nextSegment = 3
    stationOrientation = 'left'
    daemonID = nil

    // The point of removeScenery() is this: On reaching any track segment, we begin by
    // removing all of the scenery, most of which won't be there in any case. We then move
    // individual items into the capsuleInterior as needed, so that at least they can be
    // examined.
    removeScenery() {
        goldenPyramid.moveInto(nil);
        duckPond.moveInto(nil);
        giantShoe.moveInto(nil);
        knightInArmor.moveInto(nil);
        choirSinging.moveInto(nil);
        ferrisWheel.moveInto(nil);
    }
    runningDaemon {
        // the onTrackAt property points to where it was LAST turn. In the daemon
        // we will move it, change its onTrackAt, and describe where it is NOW.
        switch (onTrackAt) {
        case 1:
            onTrackAt = cSeg1.nextSegment;
            removeScenery();
            "The capsule speeds up. Ahead you can see a track curving in from the
            right to join the track you're on. Further off, the track you're on curves around
            to the right. ";
            break;
        case 2:
            onTrackAt = cSeg2.nextSegment;
            removeScenery();
            "The capsule speeds up. Ahead you can see a track curving in from the
            left to join the track you're on. Further off, the track you're on curves around
            to the left. ";
            break;
        case 3:
            onTrackAt = cSeg3.nextSegment;
            removeScenery();
            choirSinging.moveInto(capsuleInterior);
            "You pass the point where the track flows in from the right, and
            the capsule rocks slightly as it moves around a curve to the right.
            Off to the right is what appears to be
            a choir wearing robes and holding hymn-books. ";
            break;
        case 4:
            onTrackAt = cSeg4.nextSegment;
            removeScenery();
            duckPond.moveInto(capsuleInterior);
            // describe 7:
            "You pass the point where the track flows in from the left, and
            the capsule rocks slightly as it moves around a curve to the left. Off to
            the left is a glittering blue pond in which ducks are swimming. ";
            break;
        case 5:
            onTrackAt = cSeg5.nextSegment;
            removeScenery();
            stationPlatform.moveInto(capsuleInterior);
            "The capsule glides up to the station platform and stops. ";
            capsuleIsMoving = nil;
            if (daemonID != nil) {
                    daemonID.removeEvent();
                    daemonID = nil;
                }
            break;
        case 6:
            onTrackAt = cSeg6.nextSegment;
            removeScenery();
            stationPlatform.moveInto(capsuleInterior);
            "The capsule glides up to the station platform and stops. ";
            capsuleIsMoving = nil;
            if (daemonID != nil) {
                    daemonID.removeEvent();
                    daemonID = nil;
                }
            break;
        case 7:
            onTrackAt = cSeg7.nextSegment;
            removeScenery();
            ferrisWheel.moveInto(capsuleInterior);
            // describe 8:
            "You emerge from the leftward curve into a straight stretch
            of track. Ahead you can see a Y junction where the capsule
            can go either left or right. Off to the right, a festive multicolored
            Ferris wheel is spinning lazily. ";
            break;
        case 8:
            onTrackAt = cSeg8.nextSegment;
            removeScenery();
            if (onTrackAt == 18) {
                knightInArmor.moveInto(capsuleInterior);
                "After bearing right at the Y junction, you proceed down a long
                straight stretch of track. Standing off to the right is an improbably large (and
                motionless) knight in shining armor, mounted on an equally chrome-plated horse. ";
            }
            // else we've curved in onto 25 -- and here are some signs --
            // the start of the first series:
            else {
                giantShoe.moveInto(capsuleInterior);
                shaveSigns.moveInto(capsuleInterior);
                "After bearing to the left at the Y junction, you can see
                a crossing ahead. Off to the left is a giant shoe with children
                swarming over and around it. Nearer to hand, a couple of red signs are
                positioned alongside the track. The first sign reads, <q>Time
                to kick off</q>. The second sign reads, <q>Who you'll be?</q> ";
            }
            break;
        case 9:
            onTrackAt = cSeg9.nextSegment;
            removeScenery();
            if (onTrackAt == 21) {
                duckPond.moveInto(capsuleInterior);
                shaveSigns.moveInto(capsuleInterior);
                // the start of the second series:
                "After bearing to the right at the Y junction, you can see
                a crossing ahead. Off to
                the right is a glittering blue pond in which ducks are swimming.
                Up ahead, also on the right, is a giant shoe with children
                swarming over and around it. 
                Nearer to hand, a couple of red signs are
                positioned alongside the track. The first sign reads, <q>A
                second do not</q>. The second sign reads, <q>Hesitate.</q> ";
            }
            // else we've run straight ahead onto 5, and we're approaching
            // the station.
            else {
                stationPlatform.moveInto(capsuleInterior);
                "After bearing to the left at the Y junction, the capsule
                slows as it approaches the station platform. ";
            }
            break;
        case 10:
            onTrackAt = cSeg10.nextSegment;
            removeScenery();
            duckPond.moveInto(capsuleInterior);
            stationPlatform.moveInto(capsuleInterior);
            "You emerge from the rightward curve into a straight stretch
            of track. Ahead you can see a Y junction where the capsule
            can go either left or right. In the distance along the left-hand
            route, you can see the station platform. Off to
            the right is a glittering blue pond in which ducks are swimming. ";
            break;
        case 11:
            onTrackAt = cSeg11.nextSegment;
            removeScenery();
            goldenPyramid.moveInto(capsuleInterior);
            // describing segment 12:
            "You emerge from the rightward curve into a straight stretch
            of track. Ahead you can see a Y junction where the capsule
            can go either left or right. Off to the right stands a gigantic
            golden pyramid whose peak is a rotating beacon of light. ";
            break;
        case 12:
            onTrackAt = cSeg12.nextSegment;
            removeScenery();
            if (onTrackAt == 17)
                "After bearing left at the Y junction, you head down a long
                straight stretch of track. ";
            // else we've curved inward onto 19, and we're describing series 3:
            else {
                goldenPyramid.moveInto(capsuleInterior);
                shaveSigns.moveInto(capsuleInterior);
                "After bearing to the right at the Y junction, you can see
                an X crossing ahead. Off to the right stands a gigantic
                golden pyramid whose peak is a rotating beacon of light.
                Nearer to hand, a couple of red signs are
                positioned alongside the track. The first sign reads,
                <q>Continuing</q>. The second sign reads, <q>Will be such fun.</q> ";
            }
            break;
        case 13:
            onTrackAt = cSeg13.nextSegment;
            removeScenery();
            if (onTrackAt == 23) {
                choirSinging.moveInto(capsuleInterior);
                shaveSigns.moveInto(capsuleInterior);
                // The start of the fourth series:
                "After bearing to the left at the Y junction, you can see
                a crossing ahead. Off to the left is what appears to be
                a choir wearing robes and holding hymn-books.
                Nearer to hand, a couple of red signs are
                positioned alongside the track. The first sign reads,
                <q>At last your new life</q>. The second sign reads, <q>Will arrive</q>. ";
            }
            // else we're now on 6:
            else {
                stationPlatform.moveInto(capsuleInterior);
                "After bearing to the right at the Y junction, the capsule
                slows as it approaches the station platform. ";
            }
            break;
        case 14:
            onTrackAt = cSeg14.nextSegment;
            removeScenery();
            choirSinging.moveInto(capsuleInterior);
            // describe 13:
            "You emerge from the leftward curve into a straight stretch
            of track. Ahead you can see a Y junction where the capsule
            can go either left or right. Off to the left is what appears to be
            a choir wearing robes and holding hymn-books. ";
            break;
        case 15:
            onTrackAt = cSeg15.nextSegment;
            removeScenery();
            goldenPyramid.moveInto(capsuleInterior);
            // describe 14:
            "You pass the point where the track flows in from the left, and
            the capsule rocks slightly as it moves around a curve to the left. 
            Off to the left stands a gigantic
            golden pyramid whose peak is a rotating beacon of light. ";
            break;
        case 16:
            onTrackAt = cSeg16.nextSegment;
            removeScenery();
            ferrisWheel.moveInto(capsuleInterior);
            // describe 10:
            "You pass the point where the track flows in from the right, and
            the capsule rocks slightly as it moves around a curve to the right. 
            Off to the left, a festive multicolored
            Ferris wheel is spinning lazily. ";
            break;
        case 17:
            onTrackAt = cSeg17.nextSegment;
            removeScenery();
            knightInArmor.moveInto(capsuleInterior);
            // describe 16:
            "Ahead you can see a track curving in from the
            right to join the track you're on. Further off, the track you're on curves around
            to the right. Standing off to the left is an improbably large (and
            motionless) knight in shining armor, mounted on an equally chrome-plated horse. ";
            break;
        case 18:
            onTrackAt = cSeg18.nextSegment;
            removeScenery();
            // describe 15:
            "Ahead you can see a track curving in from the left
            to join the track you're on. Further off, the track you're on curves around
            to the left. ";
            break;
        case 19:
            onTrackAt = cSeg19.nextSegment;
            removeScenery();
            giantShoe.moveInto(capsuleInterior);
            duckPond.moveInto(capsuleInterior);
            shaveSigns.moveInto(capsuleInterior);
            // describe 20, which is the conclusion of series 3:
            "After crossing the X intersection, you can see
            ahead to where another track joins this track from the
            right. Off to the left is a giant shoe with children
            swarming over and around it. Further ahead, also on
            the left, is a glittering blue pond in which ducks are swimming.
            Nearer to hand, three red signs are
            positioned alongside the track. The first sign reads,
            <q>You're almost done</q>. The second sign reads, <q>When you
            choose one.</q> The third sign, in a different, more flowing
            script, reads, <q><i>Flogg Shave</i></q>. Or maybe it says,
            <q>Slave.</q> The script is hard to read. ";
            break;
        case 20:
            onTrackAt = cSeg20.nextSegment;
            removeScenery();
            duckPond.moveInto(capsuleInterior);
            // describe 7:
            "You pass the point where the track flows in from the right, and
            the capsule rocks slightly as it moves around a curve to the left.
            Off to
            the left is a glittering blue pond in which ducks are swimming. ";
            break;
        case 21:
            onTrackAt = cSeg21.nextSegment;
            removeScenery();
            goldenPyramid.moveInto(capsuleInterior);
            shaveSigns.moveInto(capsuleInterior);
            // describe 22, which is the second half of the second series:
            "After crossing the X intersection, you can see
            ahead to where another track joins this track from the
            right. Off to the left stands a gigantic
            golden pyramid whose peak is a rotating beacon of light.
            Nearer to hand, three red signs are
            positioned alongside the track. The first sign reads,
            <q>What you need next</q>. The second sign reads, <q>Must be
            an eight.</q> The third sign, in a different, more flowing
            script, reads, <q><i>Grabby Shave</i></q>. ";
            break;
        case 22:
            onTrackAt = cSeg22.nextSegment;
            removeScenery();
            goldenPyramid.moveInto(capsuleInterior);
            // describe 14:
            "After passing a place where another track merges from the right,
            the capsule rocks slightly as you proceed down a curve to the left.
            Off to the left stands a gigantic
            golden pyramid whose peak is a rotating beacon of light. ";
            break;
        case 23:
            onTrackAt = cSeg23.nextSegment;
            removeScenery();
            giantShoe.moveInto(capsuleInterior);
            shaveSigns.moveInto(capsuleInterior);
            // describe 24, which is the end of the fourth series:
            "After crossing the X intersection, you can see
            ahead to where another track joins this track from the
            left. Off to the right is a giant shoe with children
            swarming over and around it. Nearer to hand, three red signs are
            positioned alongside the track. The first sign reads,
            <q>If you have used</q>. The second sign reads, <q>A final five.</q>
            The third sign, in a different, more flowing
            script, reads, <q><i>Stuff Shave</i>.</q> ";
            break;
        case 24:
            onTrackAt = cSeg24.nextSegment;
            removeScenery();
            ferrisWheel.moveInto(capsuleInterior);
            // describe 10:
            "After passing a point where another track curves in to join yours
            from the left, you swing to the right along a broad curve.
            Off to the left, a festive multicolored
            Ferris wheel is spinning lazily. ";
            break;
        case 25:
            onTrackAt = cSeg25.nextSegment;
            removeScenery();
            choirSinging.moveInto(capsuleInterior);
            shaveSigns.moveInto(capsuleInterior);
            // describe 26 -- the end of the first segment:
            "After crossing the X intersection, you can see
            ahead to where another track joins this track from the
            left. Off to the right is what appears to be
            a choir wearing robes and holding hymn-books. Nearer to hand, three red signs are
            positioned alongside the track. The first sign reads,
            <q>Get a fresh start</q>. The second sign reads, <q>By choosing three.</q>
            The third sign, in a different, more flowing
            script, reads, <q><i>Inkwell Shave</i></q>. ";
            break;
        case 26:
            onTrackAt = cSeg26.nextSegment;
            removeScenery();
            choirSinging.moveInto(capsuleInterior);
            // describe 11:
            "After passing a point where another track curves in to join yours
            from the left, you swing to the right along a broad curve.
            Still visible to the right is
            a choir wearing robes and holding hymn-books. ";
            break;
        default:
            "Programming error --- this should never print. ";
        }
    }
;

// The defaults for the nextSegment of 8, 9, 12, and 13 assume the lever starts out at the left.
// The others are fixed.

+ cSeg1: CapsuleSegment
    nextSegment = 3
;
+ cSeg2: CapsuleSegment
    nextSegment = 4
;
+ cSeg3: CapsuleSegment
    nextSegment = 11
;
+ cSeg4: CapsuleSegment
    nextSegment = 7
;
+ cSeg5: CapsuleSegment
    nextSegment = 1
;
+ cSeg6: CapsuleSegment
    nextSegment = 2
;
+ cSeg7: CapsuleSegment
    nextSegment = 8
;
+ cSeg8: CapsuleSegment
    nextSegment = 25
;
+ cSeg9: CapsuleSegment
    nextSegment = 5
;
+ cSeg10: CapsuleSegment
    nextSegment = 9
;
+ cSeg11: CapsuleSegment
    nextSegment = 12
;
+ cSeg12: CapsuleSegment
    nextSegment = 17
;
+ cSeg13: CapsuleSegment
    nextSegment = 23
;
+ cSeg14: CapsuleSegment
    nextSegment = 13
;
+ cSeg15: CapsuleSegment
    nextSegment = 14
;
+ cSeg16: CapsuleSegment
    nextSegment = 10
;
+ cSeg17: CapsuleSegment
    nextSegment = 16
;
+ cSeg18: CapsuleSegment
    nextSegment = 15
;
+ cSeg19: CapsuleSegment
    nextSegment = 20
;
+ cSeg20: CapsuleSegment
    nextSegment = 7
;
+ cSeg21: CapsuleSegment
    nextSegment = 22
;
+ cSeg22: CapsuleSegment
    nextSegment = 14
;
+ cSeg23: CapsuleSegment
    nextSegment = 24
;
+ cSeg24: CapsuleSegment
    nextSegment = 10
;
+ cSeg25: CapsuleSegment
    nextSegment = 26
;
+ cSeg26: CapsuleSegment
    nextSegment = 11
;
