
  ;	       RESIDENT STRUCTURE by Antonio Musarra
  ;					   Pisa, Italy; tel. (+ 39) 50 575991.
  ;	 (only with necessary comments).


	jumps
JmpOldInt	macro	I
			 db	0EAh
	OldOffsetInt_&I  dw	0000h
	OldSegmentInt_&I dw	0000h
	endm
RetFar		macro	N
	ifb	<N>
		db	0CBh
	else
		db	0CAh
		dw	N
	endif
	endm
.sall

;***********--***********--***********--*********** {
KeywordLengthInWords = 5			; Not onto automodifying code.
;***********--***********--***********--***********  }

	if	KeywordLengthInWords lt 1
	  %out  Keyword must be at least one word long.
	  .err
	endif

Cseg    segment
        assume	cs:Cseg, ds:Cseg, ss:Cseg, es:Cseg
        org	0100h
Start:
	jmp	Initialization
Zero	=	Start - 0100h
	even
OldResident:
NewResident =	005Ch
Shift =	OldResident - Zero - NewResident

FirstInterrupt:
;************************************************** {
Int_15:
;**************************************************  }
	nop
	nop
;************************************************* {
OldInt_15:
	JmpOldInt 15
;*************************************************  }
AlmostBeginKeyword:
BeginKeyword =	offset AlmostBeginKeyword + 1

;***********--***********--***********--*********** {

  ; User code of first interrupt.

	jmp	OldInt_15

;***********--***********--***********--***********  }

MaxLenKeyword =	$ - BeginKeyword
	if	KeywordLengthInWords gt MaxLenKeyword / 2
	  %out  First interrupt cannot be shorter than keyword.
	  .err
	endif

;***********--***********--***********--*********** {
  ; Eventual code of any other interrupts, each of them beginning with:

; Int_xx:
;	nop
;	nop
; OldInt_xx:
;	JmpOldInt xx
;	...

  ; If necessary, you can jump to original routine using, for example,

;	jmp	OldInt_xx

  ;  or you can invoke, during user routine execution, original routine using

;	pushf
;	call	dword ptr [cs: OldInt_xx + 1 - Shift]

  ;  or you can finish interrupt using

;	iret

  ; If interrupt must transmit some flags to caller and the other flags
  ;  have no interest,  IRET will be substituted by

;	RetFar	2

  ;  whilest, if the other flags must be restored, interrupt finishes using

;	push	bp
;	  mov	bp, sp
;	  push	[ss: bp + 3*2]
;	  popf
;	  ...			;  Calculus of flags to transmit.
;	  pushf
;	  pop	[ss: bp + 3*2]
;	pop	bp
;	iret

  ;  or using

;	push	bp
;	  mov	bp, sp
;	  ...			; Direct modification of [SS: BP+3*2] bits.
;	pop	bp
;	iret

  ; Any addressing which points inside resident must contain " - Shift";
  ;  e.g.:

;	mov	[cs: Buffer - Shift + bx], al

  ;  with declaration

; Buffer db	LenBuffer dup (?)
;***********--***********--***********--***********  }

EndNewResident =	$ - Zero - Shift
WholeParagraphs =	EndNewResident / 10h
RemainingBytes =	EndNewResident - WholeParagraphs * 10h
	if	RemainingBytes eq 0
ParagraphsToBeResident =	WholeParagraphs
	else
ParagraphsToBeResident =	WholeParagraphs + 1
	endif
	even
ResidentLength =	$ - Zero - Shift - NewResident

Initialization:
	cld
	mov	si, offset FirstUninstallCommandLine
	mov	di, 0080h
	mov	cx, LenFirstUninstallCommandLine
	repe  cmpsb
	je	SetUninstallFlag
	mov	si, offset SecondUninstallCommandLine
	mov	di, 0080h
	mov	cx, LenSecondUninstallCommandLine
	repe  cmpsb
	jne	NoSetUninstallFlag
SetUninstallFlag:
	mov	[ds:UninstallFlag], 1
NoSetUninstallFlag:
	mov	si, offset OldResident
	mov	di, NewResident
	mov	cx, ResidentLength / 2
	rep  movsw
	mov	dx, BeginKeyword - Shift
	mov	ax, cs
NextCompare:
	  dec	ax
	  mov	ds, ax
	  mov	si, dx
	  mov	di, dx
	  mov	cx, KeywordLengthInWords
	  repe cmpsw
	  jne	ContinueSearch
	  cmp	word ptr [ds:FirstInterrupt - Shift], 9090h
	  je	ContinueSearch
	  jmp	InstalledFound
ContinueSearch:
	  cmp	ax, 0050h
	jne	NextCompare

; First installation:
	push	cs
	pop	ds
	cmp	[ds:UninstallFlag], 0
	jz	Install
	mov	dx, offset NotInstalledMessage
	mov	cx, LenNotInstalledMessage
	call	Print
	mov	ax, 4C01h
	int	21h
Install:

;************************************************** {
  ; DUPLICATE THIS SECTION for each interrupt TO BE ACTIVATED during first
  ;  installation, AMONG WHICH THE FIRST.
	mov	word ptr [ds:Int_15 - Shift], 05EBh
;**************************************************  }

;************************************************* {
  ; DUPLICATE THIS SECTION for each interrupt.
	mov	ax, 3515h
	int	21h
	mov	[ds:OldOffsetInt_15 - Shift], bx
	mov	[ds:OldSegmentInt_15 - Shift], es
	mov	dx, offset Int_15 - Shift
	mov	ax, 2515h
	int	21h
;*************************************************  }

	mov	ax, [ds:002Ch]
	or	ax,ax
	jz	AbsentEnvironment
	  mov	es, ax
	  mov	ah, 49h
	  int	21h
AbsentEnvironment:
	mov	dx, offset ActivationMessage
	mov	cx, LenActivationMessage
	call	Print
	mov	dx, ParagraphsToBeResident
	mov	ax, 3100h
	int	21h

InstalledFound:
	cmp	[es:UninstallFlag], 0
	jz	DeactivateOrReactivate
; Uninstall:

;************************************************** {
  ; DUPLICATE THIS SECTION for each interrupt.
	mov	ax, 3515h
	int	21h
	cmp	bx, offset Int_15 - Shift
	jne	NotUninstallable
	mov	ax, es
	mov	bx, ds
	cmp	ax, bx
	jne	NotUninstallable
;**************************************************  }

;************************************************* {
  ; DUPLICATE THIS SECTION for each interrupt.
	mov	dx, [ds:OldOffsetInt_15 - Shift]
	mov	ax, [ds:OldSegmentInt_15 - Shift]
	push	ds
	  mov	ds, ax
	  mov	ax, 2515h
	  int	21h
	pop	ds
;*************************************************  }

	not	word ptr [ds: BeginKeyword - Shift]
	mov	ax, ds
	mov	es, ax
	mov	ah, 49h
	int	21h
	push	cs
	pop	ds
	mov	dx, offset WellUninstalledMessage
	mov	cx, LenWellUninstalledMessage
	call	Print
	mov	ax, 4C00h
	int	21h
NotUninstallable:
	push	cs
	pop	ds
	mov	dx, offset NotUninstallableMessage
	mov	cx, LenNotUninstallableMessage
	call	Print
	mov	ax, 4C01h
	int	21h

DeactivateOrReactivate:
	mov	ax, 00EBh
	cmp	ax, word ptr [ds:FirstInterrupt - Shift]
	je	ToReactivate
; ToDeactivate:

;************************************************** {
  ; DUPLICATE THIS SECTION for each interrupt TO BE DEACTIVATED during each
  ;  program deactivation;
  ;  for eventual interrupts to be activated, substitute "ax" by "05EBh".
	mov	word ptr [ds:Int_15 - Shift], ax
;**************************************************  }

	mov	dx, offset DeactivationMessage
	mov	cx, LenDeactivationMessage
	jmp	ToggleEnd
ToReactivate:

;************************************************* {
  ; DUPLICATE THIS SECTION for each interrupt TO BE ACTIVATED during each
  ;  program reactivation;
  ;  for eventual interrupts to be deactivated, substitute "05EBh" by "00EBh".
	mov	word ptr [ds:Int_15 - Shift], 05EBh
;*************************************************  }
	mov	dx, offset ActivationMessage
	mov	cx, LenActivationMessage
ToggleEnd:
	push	cs
	pop	ds
	call	Print
	mov	ax, 4C00h
	int	21h

Print:
	mov	ah, 40h
	mov	bx, 0001
	int	21h
	ret

;***********--***********--***********--*********** {
ActivationMessage:
  db 'Resident activated.'
  db 0Dh, 0Ah
LenActivationMessage =	$ - ActivationMessage

DeactivationMessage:
  db 'Resident deactivated.'
  db 0Dh, 0Ah
LenDeactivationMessage =	$ - DeactivationMessage
;***********--***********--***********--***********  }

UninstallFlag	db	0
NotInstalledMessage:
  db 'Program not installed: invalid option.'
  db 0Dh, 0Ah
LenNotInstalledMessage =	$ - NotInstalledMessage
NotUninstallableMessage:
  db 'Program not uninstallable because of other resident programs.'
  db 0Dh, 0Ah
LenNotUninstallableMessage =	$ - NotUninstallableMessage
WellUninstalledMessage:
  db 'Program removed from memory.'
  db 0Dh, 0Ah
LenWellUninstalledMessage =	$ - WellUninstalledMessage
FirstUninstallCommandLine:
  db 03h, ' /u', 0Dh
LenFirstUninstallCommandLine =	 $ - FirstUninstallCommandLine
SecondUninstallCommandLine:
  db 03h, ' /U', 0Dh
LenSecondUninstallCommandLine = $ - SecondUninstallCommandLine

Cseg    ends
        end Start
