#include <Windows.h>
#include "Image2PDF.h"


UINT ShowError(char *which, UINT iErr)
{
	char message[200];
	
	wsprintf(message, "%s returned error %d", which, iErr);

	MessageBox(NULL, message, "Error Returned From Image2PDF DLL", MB_OK | MB_ICONERROR);

	return iErr;
}


int PASCAL WinMain(HINSTANCE hCurrentInstance, HINSTANCE hPreviousInstance,
                   LPSTR lpszCommandLine, int iCommandShow)
{
	UINT	iErr;
	char	appDir[MAX_PATH + 1];
	char	imageFilename[MAX_PATH + 1];
	char	pdfFilename[MAX_PATH + 1];
	char	*p;
	char	errorText[1024];

	// determine where app is running
	lstrcpy(appDir, GetCommandLine());
	if (*appDir == '"')
		lstrcpy(appDir, GetCommandLine() + 1);
	p = strrchr(appDir, '\\');
	if (p) p[1] = 0;

	wsprintf(imageFilename, "%stemp.jpg", appDir);
	wsprintf(pdfFilename, "%stest.pdf", appDir);

	iErr = I2PDF_AddImage(imageFilename);			if (iErr) return ShowError("I2PDF_AddImage", iErr);
	iErr = I2PDF_SetDPI(96);						if (iErr) return ShowError("I2PDF_SetDPI", iErr);
	iErr = I2PDF_MakePDF(pdfFilename, TRUE, FALSE, errorText, sizeof(errorText));
	if (iErr)
	{
		if (iErr == 1)
			ShowError(errorText, iErr);
		else
			ShowError("I2PDF_MakePDF", iErr);
	}
	return 0;
}
