/* 1512, Mon 20 Jan 92

   Works properly with large and small memory models,
   Doesn't need ntscr routines at all.

   LTEST: Test program for asynch. com. lines.

   Nevil Brownlee,  Computer Centre,  University of Auckland.
*/

#define EXTERN
#include <stdio.h>
#include "\nt\include\ntglob.h"
#include <ctype.h>

#include <dos.h>
#include <alloc.h>
char *getenv(char *);

struct asy_addr {  /* Async port addresses */
   int
      int_port_addr,  /* 8259 port address */
      int_mask_addr,  /* 8259 control address */
      int_int_level,  /* 8259 interrupt level of 8250 */
      com_int_addr,   /* 8250 interrupt address */
      com_port_addr,  /* 8250 data port address */
      com_ctrl_addr;  /* 8250 control port address */
   };

struct asy_port {
   char far *apbase;
   unsigned int rxbmsk,rxbmax,rxbemp, txbmsk,txbmax;
   unsigned int combase,comctrl,comiir,commdm,comline;
   unsigned int intctrl,intmask;
   unsigned int txhead,txtail,txcount;
   unsigned int rxhead,rxtail,rxspace,rxlost;
   unsigned int comadr,portseg;
   unsigned int txbuf;
   unsigned char intlev,eoici,mskci,enaci;
   unsigned char xonctl;
   unsigned char txXOFF,lecho;
   unsigned char rxXOFF,usrXOFF,rxbad;
#ifdef DBTRACE  /* Trace buffer for ntasy routines */
   unsigned int trctail;
   unsigned char trcbuf[8192];
#endif
   };

struct asy_port *comsetup(            /* Set up an async port */
   struct asy_addr *,int,int,int,int,int);
void cominit(struct asy_port *);      /* Initialise com handling */
void comfin(struct asy_port *);       /* Restore DOS com handling */
int comreg(struct asy_port *,int,int,int);  /* Read/write 8250 register */
int comrecv(struct asy_port *);       /* Receive a char,
                                            -1 if none in rx buffer */
int comsend(struct asy_port *,int);   /* Send a char,
                                            -1 if no room in tx buffer */
int comsbuf(struct asy_port *,int);   /* Nbr of chars in tx buffer */
int comrerr(struct asy_port *);       /* Nbr of chars lost.
                                            Resets lost-char count */
int comrbuf(struct asy_port *,int);   /* abs(result) = chars in send buffer.
                                             <0 if waiting for XON. */

void comend(void);
int comwrite(unsigned);
int comread(void);
void comreset(void);
void comclrXOFF(void);
int comcheck(void);
int comtxbusy(void);
void comsbc(int);
void shortbreak(void);
void linedrop(int);
int com_nmsg(char *,int);
int com_msg(char *);

char *strmov(to,from)      /* Copy chars 'from' to 'to', */
char *to,*from;            /*    return updated 'to' */
{
   while ((*to++ = *from++) != 0) ;
   return to;
   }

int min(a,b)
int a,b;
{  return (a < b) ? a : b;  }

union REGS call_regs, ret_regs;


long et_ms()  /* Adapted from Ecosoft C88's clock() */
{
   static long et_start = 0l;
   union REGS regs;
   long val;

   regs.x.ax = 0x2c00;
   intdos(&regs, &regs);  /* Get time */
   val = (long)regs.h.ch * 360000;
   val += (long)regs.h.cl * 6000;
   val += (long)regs.h.dh * 100;
   val += (long)regs.h.dl;
   val *= 10l;
   if (et_start) return val-et_start;
   et_start = val;  return 0l;
   }

void waitms(i)  /* Wait for i milliseconds */
int i;
{
   long ui, ti, et_ms();  /* Elapsed time in microseconds */
   ui = (long)i * 1000l;
   ti = et_ms();
   while (et_ms()-ti < ui) ;
   }

#if DEBUG
void port_state(p,full)
struct asy_port *p;
int full;
{
   printf("asy_port @ %d:\n", p);
   if (full) {
      printf("   rxbmsk = %04x, rxbmax = %d, rxbemp = %d\n",
         p->rxbmsk,p->rxbmax,p->rxbemp);
      printf("   txbmsk = %04x, txbmax = %d\n",
         p->txbmsk,p->txbmax);
      printf(
   "   combase,comctrl,comiir,commdm,comline = %03x,%03x,%03x,%03x,%03x\n",
         p->combase,p->comctrl,p->comiir,p->commdm,p->comline);
      printf("   intctrl,intmask = %03x,%03x\n",
         p->intctrl,p->intmask);
      printf("   comadr = %04x, portseg = %04x, txbuf = %02x\n",
         p->comadr,p->portseg,p->txbuf);
      printf("   intlev = %d, eoici = %02x, mskci = %02x, enaci = %02x\n",
         p->intlev,p->eoici,p->mskci,p->enaci);
      printf("   xonctl = %02x, lecho = %02x, rxbad = %02x\n",
         p->xonctl,p->lecho,p->rxbad);
      }
   printf("   txhead = %d, txtail = %d, txcount = %d\n",
      p->txhead,p->txtail,p->txcount);
   printf("   rxhead = %d, rxtail = %d, rxspace = %d, rxlost = %d\n",
      p->rxhead,p->rxtail,p->rxspace,p->rxlost);
   printf("   txXOFF = %02x, rxXOFF = %02x, usrXOFF = %02x\n",
      p->txXOFF,p->rxXOFF,p->usrXOFF);
   }
#endif

struct asy_addr com_addr[4] = {
/* 8259_port_addr,  int_level,   8250_port_addr,
     8259_mask_addr,   int_addr,     8250_ctrl_addr  */
   { 0x0020, 0x0021,  4, 0x0030,  0x03F8, 0x03F9 },    /* COM1 */
   { 0x0020, 0x0021,  3, 0x002C,  0x02F8, 0x02F9 },    /* COM2 */
   { 0x0020, 0x0021,  5, 0x0034,  0x03E8, 0x03E9 }  ,  /* COM3 */
   { 0x0020, 0x0021,  9, 0x0044,  0x02E8, 0x02E9 } };  /* COM4 */

struct asy_port *comsetup(apa, rxbsz,txbsz, com_bad, xon_ctl,l_echo)
struct asy_addr *apa;  /* Hardware addresses for port */
int rxbsz,   /* Size of receive buffer */
   txbsz,    /* Size of transmit buffer */
   com_bad,  /* Char to return on receive error */
   xon_ctl,  /* Non-zero for XON/XOFF flow control */
   l_echo;   /* Non-zero for half duplex */
{
   char *cp;
   register struct asy_port *p;
   unsigned char b;

   cp = calloc(
      (unsigned)(15 + sizeof(struct asy_port) + rxbsz + txbsz),
      (unsigned)1);
#if defined(__LARGE__) | defined(__HUGE__)  /* $$$$$$ */
   p = (struct asy_port *)(
      MK_FP(FP_SEG(cp), (FP_OFF(cp)+15) & 0xFFF0) );
#else
   p = (struct asy_port *)(
      MK_FP(_DS, ((unsigned int)(cp)+15) & 0xFFF0) );
#endif
   p->apbase = cp;  /* Address to free() later */
   p->rxbmsk = rxbsz-1;  p->rxbmax = rxbsz-2;  p->rxbemp = rxbsz-32;
   p->txbmsk = txbsz-1;  p->txbmax = txbsz-2;
   p->combase = apa->com_port_addr;
   p->comctrl = apa->com_ctrl_addr;  p->comiir = p->combase+2;
   p->commdm = p->combase+4;  p->comline = p->combase+5;
   p->comadr = apa->com_int_addr;  p->portseg = 0;
   p->intctrl = apa->int_port_addr;  p->intmask = apa->int_mask_addr;
   p->intlev = apa->int_int_level;  p->eoici = apa->int_int_level | 0x60;
   p->mskci = b = 1 << apa->int_int_level;  p->enaci = 0xFF ^ b;
   p->xonctl = xon_ctl ? 0xFF : 0;
   p->rxbad = com_bad;  p->lecho = l_echo;
   p->txbuf = sizeof(struct asy_port) + rxbsz;
   return p;
   }

int  /* Default hardware setup */
   com_port = 1, com_bps = 2400, com_d_bits = 7, com_s_bits = 1;
char kb_escchar = 29,  /* C-] */
   *com_parity = "E",*answer_back = "nt",*intro_msg = "\r",
   *tdf_id = "VT200", *display_adaptor = "";

#define rxbsz 8192
#define txbsz 8192
int xonctl = FALSE, lecho = FALSE;
struct asy_port *port;

int configure(ttyname,speed,parity,d_bits,s_bits, scrtype, service)
char *ttyname, *parity, *scrtype, *service;
unsigned int speed,d_bits,s_bits;
{
   static unsigned int
      bps[10]  = { 110, 150, 300, 600, 1200, 2400, 4800, 9600, 19200, 38400},
      bdiv[10] = {1047, 768, 384, 192,   96,   48,   24,   12,     6,     3};
   int j, control;

   if (*service == '\0') ;
   if (ttyname == NIL) j = com_port;
   else {
      j = 0;
      while (*ttyname && j == 0) {
         if (*ttyname == '1') j = 1;
         else if (*ttyname == '2') j = 2;
	 else if (*ttyname == '3') j = 3;
	 else if (*ttyname == '4') j = 4;
	 else ++ttyname;
         }
      }
   if (j == 0) {
      printf("IBM PC port: 1, 2, 3 or 4\n");
      exit();
      }
   port = comsetup(&com_addr[j-1], rxbsz,txbsz, '?', xonctl,lecho);
   cominit(port);  /* So we can use comreg() */

   if (speed == 0) speed = com_bps;
   for (j = 9; j >= 0; --j)
      if (speed == bps[j]) break;
   if (j < 0) {
      printf("PC speeds: 38400, 19200, 9600, 4800, 2400, 1200, 600\n");
      exit();
      }
   com_bps = speed;
   comreg(port, 1, TRUE, 0);  /* Disable interrupts */
   comreg(port, 4, TRUE, 0x10);  /* Set loopback */
   comreg(port, 3, TRUE, 0x80);  /* Set Divisor Latch Access Bit */
   comreg(port, 1, TRUE, bdiv[j]>>8);  /* Set Divisor Latch MSB */
   comreg(port, 0, TRUE, bdiv[j]);  /* Set Divisor Latch LSB */

   if (parity == NIL) parity = com_parity;
   switch (*com_parity = toupper(*parity)) {
  case 'E': control = 0x18;  /* even */
            break;
  case 'O': control = 0x08;  /* odd */
            break;
  case 'N': control = 0x00;  /* none */
            break;
  case 'S': control = 0x38;  /* space */
            break;
  case 'M': control = 0x28;  /* mark */
            break;
   default:
      printf("IBM PC parity: even, odd, none, space, mark\n");
      exit();
      }

   if (d_bits == 0) d_bits = com_d_bits;
   if (d_bits == 7) control ^= 0x02;
   else if (d_bits == 8) control ^= 0x03;
   else {
      printf("IBM PC data bits: 7, 8\n");
      exit();
      }
   com_d_bits = d_bits;

   if (s_bits == 0) s_bits = com_s_bits;
   if (s_bits == 1) control ^= 0x00;
   else if (s_bits == 2) control ^= 0x04;
   else {
      printf("IBM PC stop bits: 1, 2\n");
      exit();
      }
   com_s_bits = s_bits;

   comreg(port, 3, TRUE, control);  /* Set Line Control reg (clear DLAB) */
   comreg(port, 0, FALSE, control);  /* Clear receive buffer */
   j = 10000;  while (--j) ;  /* Wait a while */
   comreg(port, 0, FALSE, control);  /* Clear receive buffer again */

   cominit(port);  /* Reinitialise com interrupt handling */

   j = comreg(port, 2, FALSE,control);  /* Read Interupt ID register */
   printf("IIR = %04x\n", j);
   }

unsigned char *sb,*sbp, *rb,*rbp;

int waitchar()
{
   int s;
   long ui, ti, et_ms();  /* Elapsed time in milliseconds */
   ui = 2000l;  /* Time out after 2s */
   ti = et_ms();
   do {
      if ((s = comrecv(port)) >= 0) {  /* Data received */
         *rbp++ = s;  return TRUE;
         }
      } while (et_ms()-ti < ui) ;
   return FALSE;  /* Timed out */
   }

nl_to_null(s)
char *s;
{
   while (*s) {
      if (*s == '\n') *s = NULL;
      ++s;
      }
   }

main()
{
   unsigned int speed,d_bits, psize;  char parity[20];
   char sbuf[20];
   int tcs, c, j, n;
   unsigned char *p,*q, tty[5] = "COM1:";

   sb = calloc((unsigned)(8192),(unsigned)1);
   rb = calloc((unsigned)(8192),(unsigned)1);

   sbp = strmov(sb,"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
   p = sb;  q = sb+8191;
   while (sbp != q) *sbp++ = *p++;
   *q = '\0';  tcs = 7;
   speed = 2400;  d_bits = 7;  strmov(parity,"EVEN");  psize = 16;
   for (;;) {
      printf("\n%u bps, %d data bits, %s parity, %d %d-bit chars in packet, tty port %s",
	 speed,d_bits,parity, psize,tcs, tty);
      printf("\nEnter Q to quit, S to send, B,D,P,K,C,T to change parameters: ");
      printf("%c\n", c = toupper(getch()));
      switch (c) {
   case 'Q':
         exit(0);
   case 'S':
	 configure(tty,speed,parity,d_bits,1, NIL, "");
         for (j = 0; j != psize; ++j) comsend(port,sb[j]);
         while (comsbuf(port,0) != 0) ;  /* Wait for sb to empty */
         rbp = rb;
         while (waitchar()) ;  /* Now empty rb */
         comfin(port);  free(port->apbase);
         printf("%d chars sent, %d chars received  ", psize, j = (rbp-rb));
         printf("%s\n", (j == psize) ? "OK" : "<--ERROR");
         c = 0;  n = min(j,psize);
         for (j = 0; j != n; ++j) {
            if (rb[j] != sb[j]) ++c;
            }
         if (c == 0) printf("All received characters correct\n");
         else printf("%d (out of %d) characters corrupted\n", c,n);
         break;
   case 'K':
         j = psize;
         printf("Enter packet size (1 to 8000): ");
         fgets(sbuf,sizeof sbuf, stdin);
         sscanf(sbuf, "%d", &psize);
         if (psize < 1 || psize > 8000) {
            printf("Invalid packet size!\n");
            psize = j;
            }
         break;
   case 'B':
         printf("Enter line speed: ");
         fgets(sbuf,sizeof sbuf, stdin);
         sscanf(sbuf, "%u", &speed);
         break;
   case 'D':
         printf("Enter nbr of data bits: ");
         fgets(sbuf,sizeof sbuf, stdin);
         sscanf(sbuf, "%d", &d_bits);
         break;
   case 'P':
         printf("Enter parity: ");
         fgets(parity,sizeof parity, stdin);
         nl_to_null(parity);
         break;
   case 'C':
         printf("Enter test char size (7 or 8): ");
         fgets(sbuf,sizeof sbuf, stdin);
         sscanf(sbuf, "%d", &tcs);
         if (tcs == 8) {
            sbp = sb;
            for (j = 0; j <= 8191; ++j) *sbp++ = j & 0x00FF;
            d_bits = 8;  strmov(parity,"NONE");
            }
         else {
            sbp = strmov(sb,"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
            p = sb;  q = sb+8191;
            while (sbp != q) *sbp++ = *p++;
            *q = '\0';
            }
         break;
   case 'T':
	 printf("Enter port name: ");
	 fgets(tty,sizeof tty, stdin);
	 nl_to_null(tty);
         break;
   case 'E':  /* Get chars until \r, echo char count */
	 configure(tty,speed,parity,d_bits,1, NIL, "");
         do {
            n = 0;
            for (;;) {
               if ((c = comrecv(port)) >= 0) {  /* Data received */
                  if (c == 'Q') break;
                  else if (c == '\r') {
                     sprintf(sbuf,"%d\r\n",n);
                     for (j = 0; sbuf[j] != '\0'; ++j)
                        comsend(port,sbuf[j]);
                     break;
                     }
                  else ++n;
                  }
               }
            } while (c != 'Q');
         comfin(port);  free(port->apbase);
         break;
         }
      }
   }

