/* 1100, Thu 18 Mar 93

   PRTSERV: Telnet support code from apps\tcpport.c ..
      Takes input in message[] and does Telnet option handling.

   Copyright (C) 1993 by Nevil Brownlee
   Computer Centre,  University of Auckland */

#define HOST  /* Not CLIENT */

#include <stdio.h>
#include <time.h>

#include <tcp.h>

#include "prtserv.h"

#define IAC     255
#define DONT    254
#define DO      253
#define WONT    252
#define WILL    251
#define SB      250
#define BREAK   243
#define SE      240

#define TELOPT_ECHO     1
#define TELOPT_SGA      3
#define TELOPT_STATUS   5
#define TELOPT_TTYPE    24

char *telcmds[] = {
   "SE", "NOP", "DMARK", "BRK",  "IP",   "AO", "AYT",  "EC",    /*  0 */
   "EL", "GA",  "SB",    "WILL", "WONT", "DO", "DONT", "IAC",   /*  8 */
   };

char *telopts[] = {
   "BINARY", "ECHO", "RCP", "SUPPRESS GO AHEAD", "NAME",        /*  0 */
   "STATUS", "TIMING MARK", "RCTE", "NAOL", "NAOP",             /*  5 */
   "NAOCRD", "NAOHTS", "NAOHTD", "NAOFFD", "NAOVTS",            /* 10 */
   "NAOVTD", "NAOLFD", "EXTEND ASCII", "LOGOUT", "BYTE MACRO",  /* 15 */
   "DATA ENTRY TERMINAL", "SUPDUP", "SUPDUP OUTPUT",            /* 20 */
   "SEND LOCATION", "TERMINAL TYPE", "END OF RECORD",           /* 25 */
   "TACACS UID", "OUTPUT MARKING", "TTYLOC", "3270 REGIME",     /* 30 */
   "X.3 PAD", "NAWS", "TSPEED", "LFLOW", "LINEMODE"             /* 35 */
   };

int ntelopts = sizeof(telopts) / sizeof(char *);

void printTO(char *msg,int cmd,int opt)
{
   char numopt[10],*o;
   if (!TOdebug) return;
   if (opt < ntelopts) o = telopts[opt];
   else {
      sprintf(numopt,"%d",opt);  o = numopt;
      }
   printf("TO %s: IAC %s %s\n", msg,telcmds[cmd-SE],o);
   }

void send_iac(cmd,opt)  /* Send TO command, return 0 on success */
int cmd,opt;
{
   byte io_data[3];
   printTO("sent",cmd,opt);
   *rbp++ = IAC;  *rbp++ = cmd;  *rbp++ = opt;
   }

void please_echo(void)
/* Note on Telnet echo:  If we don't want the host to do local echoing,
   we should be able to say 'DONT ECHO, WILL ECHO', so the host will
   know we will be echoing.  Alas, many telnet implementations don't
   respond properly to this, ignoring the request and stubbornly
   continuing to echo.  For the print server the default is that
   echoing will be done locally by the host.    Nevil, Wed 17 Mar 93 */
{
   rbp = replybuf;
   send_iac(WONT,TELOPT_ECHO);  /* We won't, */
   send_iac(DO,TELOPT_ECHO);  /* you echo locally please */
   echo = 0;
   }

int tn_sttyp(void)  /* Send telnet terminal type */
{
   *rbp++ = 0;  /* 'is' ... */
   *rbp++ = IAC;
   *rbp++ = SE;
   send_iac(SB,TELOPT_TTYPE);  /* Send: Terminal Type */
   rbp = strmov(rbp,"UNKNOWN");
   return 0;
   }

#ifdef CLIENT
int tn_ini(void)  /* Initialise a telnet connection (from apps\tcpport.c) */
{
   rbp = replybuf;
   send_iac(WILL, TELOPT_TTYPE);
   send_iac(DO, TELOPT_SGA);

/*
 *  The ECHO negotiations are not necessary for talking to full-duplex
 *  systems, and they don't seem to do any good when sent to half-duplex
 *  ones -- they still refuse to echo, and what's worse, they get into
 *  prolonged negotiation loops.  Real telnet sends only the two above
 *  at the beginning of a connection.
 */

   send_iac(WONT,TELOPT_ECHO);  /* I won't echo */
   send_iac(DO,TELOPT_ECHO);  /* Please, you echo */
   return 0;
   }
#endif

int ttinc()  /* Get next input character, -1 if there isn't one */
{
   return (tobufx == tobuflim) ? -1 : messagebuf[tobufx++] & 0x00FF;
   }

int tn_doop(int c)  /* Do option negotiation.  Returns 0 if OK */
{
   int x, y, n, flag;

   if ((x = ttinc()) < 0) return -1;  /* Read command character */
   printTO("received",c,x);

   switch (x) {
   case TELOPT_ECHO:  /* ECHO negotiation */
      if (c == WILL) {  /* Host says it will echo */
	 if (echo) {
	    send_iac(DO,x);  /* Please do */
	    echo = 0;
	    }
	 return 0;
	 }
      if (c == WONT) {  /* Host says it won't echo */
	 if (!echo) {
	    send_iac(DONT,x);  /* I'll have to */
	    echo = 1;
	    }
	 return 0;
	 }
      if (c == DO) {  /* Host wants me to echo */
	 if (!echo) {
	    send_iac(WILL,x);  /* I will */
	    echo = 1;
	    }
	 return 0;
	 }
      if (c == DONT) {  /* Host wants me not to echo */
	 if (echo) {
	    send_iac(DO,x);  /* OK, he will echo */
	    echo = 0;
	    }
	 return 0;
	 }
      return 0;

   case TELOPT_SGA:  /* Suppress Go-Ahead */
      if (c == WONT) {  /* Host says it won't */
	 sgaflg = 1;  /* Remember */
	 if (!echo) {  /* If we're not echoing, */
	    send_iac(DONT,x);  /* acknowledge, */
	    echo = 1;  /* and switch to local echo */
	    }
	 }
      if (c == WILL) {  /* Host says it will */
	 sgaflg = 0;  /* Remember */
	 if (echo) {  /* If I'm echoing now, */
	    send_iac(DO,x);  /* This is a change, so ACK */
	    send_iac(DO,TELOPT_ECHO);  /* Request remote echo */
	    }
	 }
      return 0;

   case TELOPT_TTYPE:  /* Terminal Type */
      switch (c) {
      case DO:  /* DO terminal type */
	 send_iac(WILL,x);  /* Say I'll send it if asked */
	 return 0;
      case SB:  /* Enter subnegotiations */
	 n = flag = 0;  /* Flag for when done reading SB */
	 while (n < TSBUFSIZ) {  /* Loop looking for IAC SE */
	    if ((y = ttinc()) < 0) return -1;
	    sb[n++] = y;  /* Save what we got in buffer */
	    if (y == IAC) {  /* If this is an IAC, */
	       flag = 1;  /* set the flag */
	       }
	    else {  /* If not, */
	       if (flag && y == SE) /* if this is SE which immediately */
		  break;            /* follows IAC, we're done */
	       else flag = 0;      /* Otherwise turn off flag */
	       }
	    }
	 if (!flag)
	    return -1;  /* Make sure we got a valid SB */
	 if (*sb == 1) {
	    if (tn_sttyp()) return -1;
	    }

      default:  /* Others, ignore */
	 return 0;
	 }

   default:  /* All others: refuse */
      switch(c) {
      case WILL:  /* You will? */
	 send_iac(DONT,x);  /* Please don't */
	 break;
      case DO:  /* You want me to? */
	 send_iac(WONT,x);  /* I won't */
	 send_iac(DONT,x);  /* Don't you either */
	 break;
      case DONT:
	 send_iac(WONT,x);  /* I won't */
	 break;
      case WONT:  /* You won't? */
	 break;  /* Good */
	 }
      return 0;
      }
   }

int TO_parse(tcp_Socket *tn, int len)  /* Handle the Telnet options */
{
   int sx,tx, ow;
   unsigned char ch;
   ow = sx = tx = 0;
   rbp = replybuf;
   while (sx < len) {
      ch = messagebuf[sx++];
      if (ch == IAC) {
	 ch = messagebuf[sx++];
	 if (ch == IAC) messagebuf[tx++] = ch;
	 else {
	    tobufx = sx;  tobuflim = len;
	    if (tn_doop(ch) == 0)
	       sock_write(tn, replybuf, ow += rbp-replybuf);
	    sx = tobufx;
	    }
	 }
      else messagebuf[tx++] = ch;
      }
   if (ow != 0) sock_flush(tn);
   return tx;
   }

