/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Trim
extends Expression {
    private Expression expr;
    private int direction;
    private Expression trimChars;
    public static String LEADING = "LEADING";
    public static String TRAILING = "TRAILING";
    public static String BOTH = "BOTH";
    public static int LEADING_VAL = 1;
    public static int TRAILING_VAL = 2;
    public static int BOTH_VAL = 3;

    public F_Trim(Expression exp, String type, Expression chars) {
        this.expr = exp;
        this.direction = type.equals(LEADING) ? LEADING_VAL : (type.equals(TRAILING) ? TRAILING_VAL : BOTH_VAL);
        this.trimChars = chars;
    }

    public Object evaluate(Tuple t) {
        int i;
        String st = (String)this.expr.evaluate(t);
        if (st == null) {
            return null;
        }
        if (this.direction == BOTH_VAL && this.trimChars == null) {
            return st.trim();
        }
        String whiteSpaceString = this.trimChars == null ? " " : (String)this.trimChars.evaluate(t);
        int startLoc = 0;
        int endLoc = st.length();
        if (this.direction == BOTH_VAL || this.direction == LEADING_VAL) {
            i = 0;
            while (i < st.length()) {
                if (whiteSpaceString.indexOf(st.charAt(i)) == -1) break;
                ++i;
            }
            startLoc = i;
        }
        if (this.direction == BOTH_VAL || this.direction == TRAILING_VAL) {
            i = st.length() - 1;
            while (i > startLoc) {
                if (whiteSpaceString.indexOf(st.charAt(i)) == -1) break;
                --i;
            }
            endLoc = i;
        }
        return st.substring(startLoc, endLoc + 1);
    }

    public int getReturnType() {
        return 12;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_STRING, Attribute.TYPE_STRING, Attribute.TYPE_STRING};
    }

    public static String getFunctionName() {
        return "TRIM";
    }

    public String toString(Relation relation) {
        if (this.direction == BOTH_VAL && this.trimChars == null) {
            return "TRIM(" + this.expr.toString(relation) + ")";
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append("TRIM(");
        if (this.direction == TRAILING_VAL) {
            buf.append(String.valueOf(TRAILING) + " ");
        } else if (this.direction == LEADING_VAL) {
            buf.append(String.valueOf(LEADING) + " ");
        }
        if (this.trimChars != null) {
            buf.append(String.valueOf(this.trimChars.toString(relation)) + " ");
        }
        buf.append("FROM " + this.expr.toString(relation) + ")");
        return buf.toString();
    }
}

