/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import unity.io.FileManager;
import unity.operators.Operator;
import unity.predicates.SortComparator;
import unity.relational.Tuple;

public class MergeSort
extends Operator {
    private Tuple[] buffer;
    private int arraySize;
    private BufferedOutputStream outFile;
    private BufferedInputStream[] mergeFile;
    private ArrayList mergeFileName = new ArrayList(20);
    private int numFiles;
    private boolean onePass;
    private int curTuple;
    private SortComparator sorter;
    private Operator input;

    public MergeSort(Operator in, int bsize, int bfr, SortComparator sc) {
        super(new Operator[]{in}, bfr, bsize);
        this.input = in;
        this.sorter = sc;
        this.arraySize = bsize * bfr;
        this.setOutputRelation(in.getOutputRelation());
    }

    public void init() throws IOException, FileNotFoundException {
        this.input.init();
        this.buffer = new Tuple[this.arraySize];
        this.partition();
        if (!this.onePass) {
            this.mergeFile = new BufferedInputStream[this.numFiles];
            int i = 0;
            while (i < this.numFiles) {
                this.mergeFile[i] = FileManager.openInputFile((String)this.mergeFileName.get(i));
                this.buffer[i] = new Tuple(this.input.getOutputRelation());
                if (this.buffer[i].read(this.mergeFile[i])) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            this.curTuple = 0;
        }
    }

    public Tuple next() throws IOException, FileNotFoundException {
        if (this.onePass) {
            if (this.curTuple < this.arraySize) {
                return this.buffer[this.curTuple++];
            }
            return null;
        }
        if (this.numFiles > 0) {
            int minIdx = 0;
            int i = 1;
            while (i < this.numFiles) {
                if (this.sorter.sqlcompare(this.buffer[i], this.buffer[minIdx]) < 0) {
                    minIdx = i;
                }
                ++i;
            }
            Tuple t = new Tuple(this.buffer[minIdx]);
            if (!this.buffer[minIdx].read(this.mergeFile[minIdx])) {
                FileManager.closeFile(this.mergeFile[minIdx]);
                --this.numFiles;
                File tmpFile = new File((String)this.mergeFileName.get(minIdx));
                tmpFile.delete();
                this.buffer[minIdx] = this.buffer[this.numFiles];
                this.mergeFile[minIdx] = this.mergeFile[this.numFiles];
                this.mergeFileName.set(minIdx, this.mergeFileName.get(this.numFiles));
                this.mergeFileName.remove(this.numFiles);
            }
            return t;
        }
        return null;
    }

    public void close() throws IOException {
    }

    private void partition() throws IOException, FileNotFoundException {
        this.numFiles = 0;
        boolean endInput = false;
        do {
            int count = 0;
            while (count < this.arraySize) {
                this.buffer[count] = this.input.next();
                if (this.buffer[count] == null) {
                    endInput = true;
                    break;
                }
                ++count;
            }
            if (this.numFiles == 0 && count < this.arraySize) {
                this.incrementPagesRead((int)Math.ceil((double)count / (double)this.BLOCKING_FACTOR));
                this.incrementTuplesRead(count);
                this.incrementTuplesOutput(count);
                this.onePass = true;
                this.singlePass(count);
                return;
            }
            if (count <= 0) continue;
            Arrays.sort(this.buffer, 0, count, this.sorter);
            this.outFile = FileManager.openOutputFile(this.generateTmpFileName(this.numFiles));
            int i = 0;
            while (i < count) {
                this.buffer[i].write(this.outFile);
                ++i;
            }
            FileManager.closeFile(this.outFile);
            int pages = (int)Math.ceil((double)count / (double)this.BLOCKING_FACTOR);
            this.incrementPagesRead(pages);
            this.incrementTuplesRead(count);
            this.incrementTuplesOutput(count);
            this.incrementTupleIOs(count * 2);
            this.incrementPageIOs(pages * 2);
            ++this.numFiles;
        } while (!endInput);
        this.input.close();
    }

    private String generateTmpFileName(int i) {
        String st = FileManager.createTempFileName("merge_run" + i);
        this.mergeFileName.add(st);
        return st;
    }

    private void singlePass(int count) throws IOException, FileNotFoundException {
        Arrays.sort(this.buffer, 0, count, this.sorter);
        this.input.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("MERGE SORT: ");
        sb.append(this.sorter.toString(this.outputRelation));
        sb.append(" (BufferSize=" + this.arraySize + ")");
        return sb.toString();
    }
}

