/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import unity.annotation.AnnotatedSourceDatabase;
import unity.jdbc.UnityDriver;
import unity.operators.ResultSetScan;
import unity.query.GQDatabaseRef;

public class LocalQuery {
    private String SQLQueryString;
    private AnnotatedSourceDatabase database;
    private Connection con;
    private ResultSet rs = null;
    private Statement stmt = null;
    private ResultSetScan resultSetScanOp;
    private int _resultSetType;
    private int _resultSetConcurrency;
    private String errorMessage;

    public ResultSetScan getResultSetScan() {
        return this.resultSetScanOp;
    }

    public LocalQuery(AnnotatedSourceDatabase db) {
        this.database = db;
        this._resultSetType = 1003;
        this._resultSetConcurrency = 1007;
        this.errorMessage = null;
    }

    public LocalQuery(GQDatabaseRef db) {
        this.SQLQueryString = "";
        this.database = db.getDatabase();
        this._resultSetType = 1003;
        this._resultSetConcurrency = 1007;
        this.errorMessage = null;
    }

    public String getDatabaseName() {
        return this.database.getDatabaseName();
    }

    public void setResultSetType(int type) {
        this._resultSetType = type;
    }

    public void setResultSetConcurrency(int cc) {
        this._resultSetConcurrency = cc;
    }

    public void execute() throws SQLException {
        this.con = this.database.getConnection();
        this.stmt = this.con.createStatement(this._resultSetType, this._resultSetConcurrency);
        this.resultSetScanOp.setSQLString(this.SQLQueryString);
        if (!this.resultSetScanOp.getDelayedExecution()) {
            this.rs = this.stmt.executeQuery(this.SQLQueryString);
            this.resultSetScanOp.setResultSet(this.rs);
        } else if (UnityDriver.DEBUG) {
            System.out.println("Delaying execution due to distributed join.");
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public void setResultSet(ResultSet rs) {
        this.rs = rs;
    }

    public String getSQLQueryString() {
        return this.SQLQueryString;
    }

    public void setSQLQueryString(String queryString) {
        this.SQLQueryString = queryString;
    }

    public void setResultSetScanOp(ResultSetScan op) {
        this.resultSetScanOp = op;
    }

    public boolean hasErrorMessage() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String e) {
        this.errorMessage = e;
    }
}

