/*
 * Decompiled with CFR 0.152.
 */
package com.jxcell.server.xml;

import com.jxcell.server.ChartRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;

public class Z
extends Reader {
    public static final int[] BOM_BigEndian = new int[]{254, 255};
    public static final int[] BOM_LittleEndian = new int[]{255, 254};
    public static final int[] BOM_UTF8 = new int[]{239, 187, 191};
    private Reader EYFN;

    public static final Reader getReader(InputStream inputStream) {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        try {
            if (Z.BOM_UTF8(pushbackInputStream, -1)) {
                return new InputStreamReader(inputStream);
            }
            String string = "UTF-8";
            if (Z.BOM_LittleEndian(pushbackInputStream, BOM_BigEndian)) {
                string = "UTF-16BE";
            } else if (Z.BOM_LittleEndian(pushbackInputStream, BOM_LittleEndian)) {
                string = "UTF-16LE";
            } else if (!Z.BOM_LittleEndian(pushbackInputStream, BOM_UTF8)) {
                int n = pushbackInputStream.read();
                if (n == 0) {
                    string = "UTF-16";
                }
                pushbackInputStream.unread(n);
            }
            return new InputStreamReader((InputStream)pushbackInputStream, string);
        }
        catch (IOException iOException) {
            throw new ChartRuntimeException(iOException);
        }
    }

    public static final Writer getWriter(OutputStream outputStream, String string) {
        Z.writeBOM(outputStream, string);
        return new OutputStreamWriter(outputStream, string);
    }

    public Z(InputStream inputStream) {
        this.EYFN = Z.getReader(inputStream);
    }

    public Z(File file) {
        this(new FileInputStream(file));
    }

    public static final void writeBOM(OutputStream outputStream, String string) {
        int[] nArray = null;
        if (string.equalsIgnoreCase("UTF-16BE")) {
            nArray = BOM_BigEndian;
        } else if (string.equalsIgnoreCase("UTF-16LE")) {
            nArray = BOM_LittleEndian;
        } else if (string.equalsIgnoreCase("UTF-8")) {
            nArray = BOM_UTF8;
        }
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                outputStream.write(nArray[i]);
            }
        }
    }

    public Z(String string) {
        this(Z.BOM_BigEndian(string));
    }

    public Z(StringReader stringReader) {
        this.EYFN = stringReader;
    }

    private static InputStream BOM_BigEndian(String string) {
        InputStream inputStream;
        try {
            if (string.startsWith("file:") || string.startsWith("http:") || string.startsWith("ftp:")) {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
            } else {
                inputStream = new FileInputStream(string);
            }
        }
        catch (IOException iOException) {
            throw new ChartRuntimeException(iOException);
        }
        return inputStream;
    }

    private static boolean BOM_LittleEndian(PushbackInputStream pushbackInputStream, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = pushbackInputStream.read();
            if (n == nArray[i]) continue;
            if (n != -1) {
                pushbackInputStream.unread(n);
            }
            while (--i >= 0) {
                pushbackInputStream.unread(nArray[i]);
            }
            return false;
        }
        return true;
    }

    private static boolean BOM_UTF8(PushbackInputStream pushbackInputStream, int n) {
        int n2 = pushbackInputStream.read();
        if (n2 == n) {
            return true;
        }
        if (n2 != -1) {
            pushbackInputStream.unread(n2);
        }
        return false;
    }

    public final int read() {
        int n = this.EYFN.read();
        return n;
    }

    public final int read(char[] cArray, int n, int n2) {
        int n3 = this.EYFN.read(cArray, n, n2);
        return n3;
    }

    public final void close() {
        try {
            this.EYFN.close();
        }
        catch (IOException iOException) {
            throw new ChartRuntimeException(iOException);
        }
    }
}

