/*
**	GRASS -- Banjo player novice "Expert" system
**	lick0.c, lick1d.c, & lick2.c merged to make a module for accl.c
**	psl 7/87
*/
#include	<stdio.h>
#include	<midi.h>

#ifdef LINT
int	Stones[12];
#define SIXTEENTH 30
#endif
#define	PATLEN	8		/* # of sixteenths / pattern */
#define	PLMOD(N)	(((N)+PATLEN)%(PATLEN))

#define	MAXREACH	4	/* how big your hands are */

#define	CPS	30		/* MPU clocks per step (sixteenth notes) */

#define	STRINGS	5
#define	FIRST	0		/* index of first string */
#define	SECOND	1
#define	THIRD	2
#define	FOURTH	3
#define	FIFTH	4		/* index of fifth string */

#define	DIGITS	3
#define	THUMB	0
#define	INDEX	1
#define	MIDDLE	2

#define	OPEN	0		/* fret of open string */

#define	PITCHOF(S,F)	(Tuning[S]+(F))
#define	OVERLAP(ST1,ST0)	\
	((ST1[THUMB] >= 0 && ST0[INDEX] >= 0 && ST1[THUMB] <= ST0[INDEX]) \
	 || (ST1[THUMB] >= 0 && ST0[MIDDLE] >= 0 && ST1[THUMB] <= ST0[MIDDLE]) \
	 || (ST1[INDEX] >= 0 && ST0[THUMB] >= 0 && ST1[INDEX] >= ST0[THUMB]) \
	 || (ST1[INDEX] >= 0 && ST0[MIDDLE] >= 0 && ST1[INDEX] <= ST0[MIDDLE]) \
	 || (ST1[MIDDLE] >= 0 && ST0[THUMB] >= 0 && ST1[MIDDLE] >= ST0[THUMB]) \
	 || (ST1[MIDDLE] >= 0 && ST0[INDEX] >= 0 && ST1[MIDDLE] >= ST0[INDEX]))
#define	RANDR(L,H)	((L)+(rand()/3)%((H)-(L)+1))
#define	ABS(N)		((N)<0?-(N):(N))

#define	T	1		/* masks for Rhpat[] & Fi[] */
#define	I	2
#define	M	4
struct	fistr	{		/* finger info */
	int	mask;		/* Rhpat mask */
	int	lostr;		/* lowest (numbered) string it can reach */
	int	histr;		/* highest (numbered) string it can reach */
	int	bstr;		/* best (favorite) string */
} Fi[DIGITS] = {
/*	code	lowest	highest	favorite	*/
	{ T,	THIRD,	FIFTH,	FIFTH, },	/* thumb (numbers are -1) */
	{ I,	SECOND,	FOURTH,	THIRD, },	/* index */
	{ M,	FIRST,	THIRD,	FIRST, },	/* middle */
};
struct	miscstr	{		/* used by meval() */
	int	ap;		/* average pitch */
	int	ns;		/* num of simultaneous notes */
};
int	Rhpat[][PATLEN] = {
	T,   I,   M,   T,   I,   M,   T,   M,		/* forward */
	T,   M,   I,   T,   M,   I,   T,   M,		/* backward */
	T,   I,   M,   T,   M,   I,   T,   M,		/* backup */
	T,   I,   M,   T,   T,   I,   M,   T,		/* dbld thumb */
	T,   I,   M,   T,   M,   T,   M,   I,		/* ? */
	T,   M,   T,   M,   T,   M,   T,   M,		/* flat-pick */
	I,   M,   I,   M,   T,   I,   M,   T,		/* foggymtn */
	T,   I,   T,   M,   T,   I,   T,   M,		/* double thumb */
	T,   I,   T,   M,   T,   0,   T|M, 0,		/* John Hickman */
	I,   0,   T|M, 0,   I,   0,   T|M, 0,		/* bum-chang */
};
#define	NRHPAT	(sizeof Rhpat / sizeof Rhpat[0])

int	Beatval[]	= {	4, 1, 2, 1, 3, 1, 2, 1,	};
int	Lastpat = 0;		/* memory of previous pattern */
int	Lastlhloc;		/* memory of previous hand position */
int	Lstrings[STRINGS];	/* memory of previous fretting */
/* existing options */
int	Chan	= 0;		/* output MIDI channel */
int	Vol	= 80;		/* key velocity */
/* potential options */
int	Ilhloc	= 1;		/* initial left hand position */
int	Nrhpat	= NRHPAT;	/* number of patterns we can use */
int	Ntries	= 12;		/* number attempts to choose from */
int	Trace	= 0;
int	Tuning[STRINGS]	= {	/* How the banjo is tuned */
	62, 59, 55, 50, 67,	/* open G-Major */
};

extern	char	*key2name();

grass(start, stop, otones, ntones, lkp, dp)
long	start, stop;
int	otones[12], ntones[12], *lkp, *dp;
{
	register int i, f, s, d, pat;
	int t;		/* time in SIXTEENTHS */
	int *strt0, *strt1;
	int try1, try2, try3, n, p, ap1, ap2;
	int frets[PATLEN][STRINGS], val;
	int bfrets[PATLEN][STRINGS], bval;
	int bstrings[PATLEN][DIGITS];
	static int strings[PATLEN][DIGITS];
	int fr[32], fret[STRINGS];
	int bpat, fings, lhloc, blhloc;
	struct miscstr tmisc[PATLEN], bmisc[PATLEN];
	static struct miscstr hmisc[PATLEN];

/****/if(Trace) {
/****/fprintf(stderr, "otones:");
/****/for (i = 0; i < 12; fprintf(stderr, "%d", otones[i++]));
/****/fprintf(stderr, "  ntones:");
/****/for (i = 0; i < 12; fprintf(stderr, "%d", ntones[i++]));
/****/fprintf(stderr, "  Stones:");
/****/for (i = 0; i < 12; fprintf(stderr, "%d", Stones[i++]));
/****/fprintf(stderr, "\n");
/****/}
	if (start == 0)
	    Lastlhloc = Ilhloc;
	t = (int) (start / SIXTEENTH);
	for (; t < (int) (stop / SIXTEENTH); t += PATLEN) {
/****/if(Trace) fprintf(stderr, "t=%d\n");
	    bval = -9999;
	    for (try1 = 1; try1 <= Ntries; try1++) {
		/* pick new hand location */
		if (Lastlhloc > rand() % 19)
		    d = -3;
		else
		    d = (rand() % 7) - 3;
		lhloc = Lastlhloc + d;
		lhloc = lhloc < OPEN? OPEN : (lhloc > 19? 19 : lhloc);
		/* pick frets on each string */
		for (s = STRINGS; --s >= FIRST; ) {
		    n = 0;
		    for (f = lhloc; f < lhloc + MAXREACH; f++) {
			if (s == FIFTH && f <= 5)
			    continue;
			i = f - (s == FIFTH? 5 : 0);
			p = (PITCHOF(s, i) % 12);
			if (otones[p]) {
			    fr[n++] = f;
			    fr[n++] = f;
			    fr[n++] = f;
			}
			if (Stones[p])
			    fr[n++] = f;
			if (ntones[p])
			    fr[n++] = f;
		    }
		    if (n > 0)
			fret[s] = fr[rand() % n];
		    else
			fret[s] = OPEN;
		}
		/* pick some right-hand patterns */
		for (try2 = 3; --try2 >= 0; ) {
		    pat = try2==0? Lastpat : (rand() % Nrhpat);
		    /* pick strings */
		    for (;;) {
			for (i = 0; i < PATLEN; i++) {
			    fings = Rhpat[pat][i];
			    if (fings == 0) {
				for (d = DIGITS; --d >= THUMB; )
				    strings[i][d] = -1;
				continue;
			    }
			    for (try3 = 3; --try3 >= 0; ) {
				pickstring(fings, strings[i]);
				if (t + i == 0)
				    break;
				strt0 = i == 0? Lstrings : strings[i - 1];
				strt1 = strings[i];
				if (!OVERLAP(strt1, strt0))
				    break;		/* no overlap */
			    }
			    if (try3 < 0)	/* couldn't find one */
				break;
			}
			if (i >= PATLEN)	/* found strings */
			    break;
		    }
		    /* find the best fretted/unfretted arrangement */
		    for (i = 0; i < PATLEN; i++) {
			ap1 = ap2 = n = 0;
			for (d = DIGITS; --d >= THUMB; ) {
			    s = strings[i][d];
			    if (s != -1) {
				ap1 += PITCHOF(s, fret[s]);
				ap2 += PITCHOF(s, OPEN);
				n++;
			    }
			}
			if ((tmisc[i].ns = n) > 0) {
			    ap1 /= n;		/* average pitch if fretted */
			    ap2 /= n;		/* average pitch if open */
			    f = 0;
			    if (ap1 != ap2) {
				f = meval(i, ap1, n, tmisc, hmisc);
				f = (f >= meval(i, ap2, n, tmisc, hmisc));
			    }
			    for (d = DIGITS; --d >= THUMB; )
				if ((s = strings[i][d]) != -1)
				    frets[i][s] = f? fret[s] : OPEN;
			    tmisc[i].ap = f? ap1 : ap2;
			}
		    }
		    /* evaluate & save, if best */
		    val = eval(t, strings, frets, tmisc, hmisc, otones);
/****/if (Trace) fprintf(stderr, "    t:%d-%d, lhloc:%d, pat:%d, val:%d\n",
/****/ t, t + PATLEN - 1, lhloc, pat, val);
		    if (val > bval) {
			bval = val;
			for (i = PATLEN; --i >= 0; ) {
			    for (d = DIGITS; --d >= THUMB; )
				bstrings[i][d] = strings[i][d];
			    for (s = STRINGS; --s >= FIRST; )
				bfrets[i][s] = frets[i][s];
			    bmisc[i] = tmisc[i];
			}
			bpat = pat;
			blhloc = lhloc;
		    }
		}
	    }
/****/if (Trace) fprintf(stderr, "    bestpat=%d (val=%d)\n", bpat, bval);
	    n = 0;
	    for (i = 0; i < PATLEN; i++) {
		for (f = DIGITS; --f >= THUMB; )
		    if ((strings[i][f] = bstrings[i][f]) != -1)
			n++;
		output(strings[i], bfrets[i]);
		hmisc[i].ap = bmisc[i].ap;
		hmisc[i].ns = bmisc[i].ns;
	    }
	    for (s = STRINGS; --s >= FIRST; Lstrings[s] = strings[PATLEN-1][s]);
	    Lastpat = bpat;
	    Lastlhloc = blhloc;
/****/if (Trace) fprintf(stderr, "\n");
	}
}

/* return an evaluation of PATLEN events */
eval(t0, strings, frets, tmisc, hmisc, otones)
int	strings[][DIGITS], frets[][STRINGS];
struct miscstr tmisc[], hmisc[];
int	otones[12];
{
	register int val, t, d, s, p, i;
	int mv, nt, nic, noc, lastoc, harmv, movev, miscv;

	mv = nt = miscv = lastoc = nic = noc = 0;
	for (i = 0; i < PATLEN; i++) {
	    t = t0 + i;
/****/if(Trace) fprintf(stderr, " t=%d\n", t);
/****
	    b = Beatval[i];
/****/
	    for (d = DIGITS; --d >= THUMB; ) {
		if ((s = strings[t][d]) >= FIRST) {
		    if (Fi[d].bstr == s)	/* finger's favorite string */
			miscv += 2;
		    p = PITCHOF(s, frets[t][s]);
/****/if(Trace) fprintf(stderr, "\ts=%d, d=%d, f=%d, p=%d (%s)\n",
 s, d, frets[t][s], p, key2name(p));
		    if (otones[p % 12]) {
			nic++;
			lastoc = 0;
		    } else if (Stones[p % 12]) {
			noc += lastoc;
			lastoc = 1;
		    } else {
			noc += 1 + lastoc;
			lastoc = 2;
		    }
		}
	    }
	    if (tmisc[t].ns > 0) {
		mv += meval(t, tmisc[t].ap, tmisc[t].ns, tmisc, hmisc);
		nt++;
	    } else
		miscv -= 20;			/* the cost of silence */
	}
	harmv = 12 * nic - 16 * noc;
	if (noc > nic / 2)
	    harmv -= 20;
/****/if(Trace) fprintf(stderr, " nic=%d noc=%d harmv=%d ", nic, noc, harmv);
	movev = (32 * mv) / nt;
/****/if(Trace) fprintf(stderr, " mv=%d nt=%d movev=%d ", mv, nt, movev);
	val = harmv + movev + miscv;
/****/if(Trace) fprintf(stderr, " miscv=%d eval()=%d\n", miscv, val);
	return(val);
}

/* motion eval - how good is ap,ns at time t? */
meval(t, ap, ns, tmisc, hmisc)
struct miscstr tmisc[], hmisc[];
{
	register int pt, v, pns, pap, d;

	pt = PLMOD(t);			/* spot in pattern */
	v = 0;
	if (t < 1) {			/* first time in piece */
	    pns = 1;
	    pap = ap;
	} else if (pt < 1) {		/* first in a pattern */
	    pns = hmisc[PATLEN - 1].ns;	/* use history */
	    pap = hmisc[PATLEN - 1].ap;
	} else {			/* middle of pattern */
	    pns = tmisc[pt - 1].ns;
	    pap = tmisc[pt - 1].ap;
	}
	if (pns == 1 && ns == 1) {
	    d = ABS(ap - pap);
	    if (d == 0)
		v -= 5;
	    else if (d <= 2)
		v += 10;
	    else if (d <= 12)
		v += 12 - d;
	    else
		v += 24 - 2 * d;
	}
/****if (Trace) fprintf(stderr, "   ns=%d:%d ap=%d:%d v=%d",
/**** pns, ns, pap, ap, v); /****/
	if (t < 2) {			/* second time in piece */
	    pns = 1;
	    pap = ap;
	} else if (pt < 2) {		/* first or second in pattern */
	    pns = hmisc[PATLEN + pt - 2].ns;	/* use history */
	    pap = hmisc[PATLEN + pt - 2].ap;
	} else {			/* middle of pattern */
	    pns = tmisc[pt - 2].ns;
	    pap = tmisc[pt - 2].ap;
	}
	if (pns == 1 && ns == 1) {
	    d = ABS(ap - pap);
	    if (d == 0)
		v -= 4;
	    else if (d <= 4)
		v += 5;
	    else if (d <= 12)
		v += 9 - d;
	    else
		v += 22 - 2 * d;
	} else if (pns > 1 && ns > 1) {
	    d = ABS(ap - pap);
	    if (d == 0)
		v -= 4;
	    else if (d <= 5)
		v += 1;
	    else if (d <= 12)
		v += 6 - d;
	    else
		v += 18 - 2 * d;
	}
/****if (Trace) fprintf(stderr, "  ns=%d:%d ap=%d:%d v=%d\n",
/**** pns, ns, pap, ap, v);
/****/
	return(v);
}

pickstring(fpat, strngs)	/* select string(s) for finger(s) in fpat */
int	strngs[DIGITS];
{
	struct fistr *fip;

	strngs[THUMB] = strngs[INDEX] = strngs[MIDDLE] = -1;
	for (;;) {
	    fip = &Fi[THUMB];
	    if (fpat & fip->mask)
		strngs[THUMB] = RANDR(fip->lostr, fip->histr);
	    fip = &Fi[INDEX];
	    if (fpat & fip->mask)
		strngs[INDEX] = RANDR(fip->lostr, fip->histr);
	    fip = &Fi[MIDDLE];
	    if (fpat & fip->mask)
		strngs[MIDDLE] = RANDR(fip->lostr, fip->histr);
	    if (!OVERLAP(strngs, strngs))
		break;
	}
}

output(str, frt)
int	str[DIGITS], frt[STRINGS];
{
	register int d, s, dt, f;

	for (d = 0; d < DIGITS; d++) {
	    if ((s = str[d]) >= 0) {
		f = frt[s];
		if (Trace)
		    fprintf(stderr, "d=%d, s=%d, f=%d, p=%d (%s)\n",
		     d, s, f, PITCHOF(s, f), key2name(PITCHOF(s, f)));
		putc(0, stdout);			/* timing byte */
		putc(CH_KEY_ON | Chan, stdout);
		putc(PITCHOF(s, frt[s]), stdout);
		putc(Vol, stdout);
	    }
	}
	dt = CPS;
	for (d = DIGITS; --d >= 0; ) {
	    if ((s = str[d]) >= 0) {
		putc(dt, stdout);			/* timing byte */
		dt = 0;
		putc(CH_KEY_ON | Chan, stdout);
		putc(PITCHOF(s, frt[s]), stdout);
		putc(0, stdout);
	    }
	}
	if (dt) {
	    putc(dt, stdout);
	    putc(MPU_NO_OP, stdout);
	}
}
