/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_brx extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TK = "\u091f\u094b\u0915\u0947\u0932\u094c";
        final String metaValue_TO = "\u091f\u0949\u0902\u0917\u093e";
        final String metaValue_TR = "\u0924\u0941\u0930\u094d\u0915\u0940";
        final String metaValue_ae = "\u0905\u0935\u0938\u094d\u0924\u0928\u094d";
        final String metaValue_ar = "\u0905\u0930\u092c\u0940";
        final String metaValue_bo = "\u0924\u093f\u092c\u094d\u092c\u0924\u0940";
        final String metaValue_el = "\u0917\u094d\u0930\u0940\u0915";
        final String metaValue_gu = "\u0917\u0941\u091c\u0930\u093e\u0924\u0940";
        final String metaValue_ja = "\u091c\u093e\u092a\u093e\u0928\u0940";
        final String metaValue_jv = "\u091c\u093e\u0935\u093e\u0928\u0940\u0938";
        final String metaValue_km = "\u0916\u094d\u092e\u0947\u0930";
        final String metaValue_or = "\u0909\u0921\u093c\u093f\u092f\u093e";
        final String metaValue_te = "\u0924\u0947\u0932\u0941\u0917\u0941";
        final String metaValue_th = "\u0925\u093e\u0908";
        final String metaValue_bug = "\u092c\u0941\u0917\u0940\u0928\u0940";
        final String metaValue_nqo = "\u0928\u094d\u0917\u0915\u094b";
        final String metaValue_vai = "\u0935\u093e\u0908";
        final Object[][] data = new Object[][] {
            { "Ogam", "\u0913\u0917\u0939\u0948\u092e" },
            { "mwl", "\u092e\u0940\u0930\u093e\u0902\u0921\u0940" },
            { "cch", "\u0906\u0924\u094d\u0938\u092e" },
            { "mwr", "\u092e\u093e\u0930\u0935\u093e\u0921\u093c\u0940" },
            { "Tagb", "\u0924\u093e\u0917\u092c\u093e\u0928\u0935\u093e" },
            { "%%NJIVA", "\u0917\u094d\u0928\u0940\u0935\u093e \u092f\u093e \u0928\u094d\u091c\u0940\u0935\u093e \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "egy", "\u092a\u094d\u0930\u093e\u091a\u0940\u0928 \u092e\u093f\u0938\u094d\u0930\u0940" },
            { "raj", "\u0930\u093e\u091c\u0938\u094d\u0925\u093e\u0928\u0940" },
            { "Phag", "\u092b\u093e\u0917\u094d\u0938 \u092a\u093e" },
            { "tem", "\u0924\u0940\u092e\u0928\u0947" },
            { "rap", "\u0930\u093e\u092a\u093e\u0928\u0941\u0908" },
            { "ter", "\u0924\u0947\u0930\u0947\u0928\u094b" },
            { "rar", "\u0930\u093e\u0930\u094b\u091f\u094b\u0902\u0917\u093e" },
            { "tet", "\u0924\u0947\u0924\u0941\u092e" },
            { "AD", "\u090d\u0928\u094d\u0921\u094b\u0930\u093e" },
            { "AE", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0905\u0930\u092c \u0905\u092e\u0940\u0930\u093e\u0924" },
            { "nl_BE", "\u092b\u094d\u0932\u0947\u092e\u0940" },
            { "AF", "\u0905\u092b\u093c\u0917\u093c\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "AG", "\u090f\u0928\u094d\u091f\u093f\u0917\u0941\u0906 \u090f\u0935\u0902 \u092c\u093e\u0930\u092c\u0942\u0921\u093e" },
            { "AI", "\u090f\u0902\u0917\u0940\u0932\u093e" },
            { "AL", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e" },
            { "AM", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e" },
            { "Teng", "\u0924\u0947\u0902\u0917\u0935\u093e\u0930" },
            { "AO", "\u0905\u0902\u0917\u094b\u0932\u093e" },
            { "AQ", "\u0905\u0902\u091f\u093e\u0930\u094d\u0915\u091f\u093f\u0915\u093e" },
            { "AR", "\u0905\u0930\u094d\u091c\u0947\u0923\u094d\u091f\u093f\u0928\u093e" },
            { "AS", "\u0905\u092e\u0930\u093f\u0915\u0940 \u0938\u092e\u094b\u0906" },
            { "AT", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "AU", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e" },
            { "AW", "\u0905\u0930\u0942\u092c\u093e" },
            { "en_US", "\u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940 (\u0905\u092e\u0930\u093f\u0915\u0940)" },
            { "AX", "\u0906\u0932\u093e\u0901\u0921 \u0926\u094d\u0935\u0940\u092a" },
            { "AZ", "\u0905\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928" },
            { "%%AREVELA", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908" },
            { "BA", "\u092c\u094b\u0938\u0928\u093f\u092f\u093e \u0939\u0930\u094d\u091c\u093c\u0947\u0917\u094b\u0935\u093f\u0928\u093e" },
            { "BB", "\u092c\u093e\u0930\u092c\u093e\u0921\u094b\u0938" },
            { "ceb", "\u091a\u0947\u092c\u0941\u0906\u0928\u094b" },
            { "BD", "\u092c\u0902\u0917\u0932\u093e\u0926\u0947\u0936" },
            { "kum", "\u0915\u0941\u092e\u0940\u0915\u094d" },
            { "BE", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u092e" },
            { "gmh", "\u092e\u0927\u094d\u092f \u0909\u091a\u094d\u091a\u0938\u094d\u0924\u0930\u0940 \u091c\u0930\u094d\u092e\u0928" },
            { "BF", "\u092c\u0941\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u093e\u0938\u094b" },
            { "BG", "\u092c\u0932\u094d\u0917\u0948\u0930\u093f\u092f\u093e" },
            { "BH", "\u092c\u0939\u0930\u0948\u0928" },
            { "BI", "\u092c\u0941\u0930\u0941\u0902\u0921\u0940" },
            { "BJ", "\u092c\u0947\u0928\u0947\u0901" },
            { "BL", "\u0938\u0947\u0901 \u092c\u093e\u0930\u094d\u0925\u0947\u0932\u0947\u092e\u0940" },
            { "BM", "\u092c\u0930\u092e\u0942\u0921\u093e" },
            { "kut", "\u0915\u0941\u0924\u0947\u0928\u093e\u0908" },
            { "myv", "\u0910\u0930\u094d\u091c\u093c\u093f\u092f\u093e" },
            { "BN", "\u092c\u094d\u0930\u0942\u0928\u0907" },
            { "BO", "\u092c\u094b\u0932\u0940\u0935\u093f\u092f\u093e" },
            { "BR", "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932" },
            { "BS", "\u092c\u0939\u093e\u092e\u093e" },
            { "BT", "\u092d\u0942\u091f\u093e\u0928" },
            { "BV", "\u092c\u0941\u0935\u0947 \u0926\u094d\u0935\u0940\u092a" },
            { "BW", "\u092c\u094b\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "BY", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938" },
            { "BZ", "\u092c\u0947\u0932\u093f\u091c\u093c" },
            { "Visp", "\u0935\u0940\u091c\u093c\u0940\u092c\u0932 \u092c\u094b\u0932\u0940" },
            { "CA", "\u0915\u0948\u0928\u093e\u0921\u093e" },
            { "CC", "\u0915\u094b\u0915\u094b\u0938 \u0926\u094d\u0935\u0940\u092a" },
            { "CD", "\u0915\u0949\u0902\u0917\u094b \u0915\u093f\u0928\u0936\u093e\u0938\u093e" },
            { "CF", "\u0938\u0947\u0902\u091f\u094d\u0930\u0932 \u0905\u092b\u094d\u0930\u0940\u0915\u0928 \u0930\u093f\u092a\u092c\u094d\u0932\u093f\u0915" },
            { "CG", "\u0915\u0949\u0902\u0917\u094b \u092c\u094d\u0930\u093e\u091c\u093c\u094d\u091c\u093c\u093e\u0935\u0940\u0932" },
            { "CH", "\u0938\u094d\u0935\u093f\u0924\u094d\u091c\u093c\u0930\u0932\u0948\u0902\u0921" },
            { "CI", "\u0906\u0908\u0935\u0930\u0940 \u0915\u094b\u0938\u094d\u091f" },
            { "CK", "\u0915\u0941\u0915 \u0926\u094d\u0935\u0940\u092a" },
            { "CL", "\u091a\u093f\u0932\u0940" },
            { "CM", "\u0915\u094b\u092e\u0947\u0930\u093e\u0928" },
            { "CN", "\u091a\u0940\u0928" },
            { "CO", "\u0915\u094b\u0932\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "CR", "\u0915\u094b\u0938\u094d\u091f\u093e\u0930\u0940\u0915\u093e" },
            { "CU", "\u0915\u094d\u092f\u0942\u092c\u093e" },
            { "CV", "\u0915\u0948\u092a \u0935\u0947\u0930\u094d\u0926\u0947" },
            { "CX", "\u0915\u094d\u0930\u093f\u0938\u094d\u092e\u0938 \u0926\u094d\u0935\u0940\u092a" },
            { "CY", "\u0938\u093e\u0907\u092a\u094d\u0930\u0938" },
            { "CZ", "\u091a\u0947\u0915 \u0917\u0923\u0930\u093e\u091c\u094d\u092f" },
            { "eka", "\u090f\u0915\u093e\u091c\u0941\u0915" },
            { "DE", "\u091c\u0930\u094d\u092e\u0928\u0940" },
            { "goh", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0909\u091a\u094d\u091a\u0938\u094d\u0924\u0930\u0940 \u091c\u0930\u094d\u092e\u0928" },
            { "ace", "\u0905\u091a\u0947\u0939\u0928\u0940" },
            { "DJ", "\u0926\u094d\u091c\u093f\u092c\u0942\u0924\u0940" },
            { "DK", "\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915" },
            { "ach", "\u0905\u0915\u094b\u0932\u0940" },
            { "gon", "\u0917\u093e\u0901\u0921\u0940" },
            { "Brai", "\u092c\u094d\u0930\u0947\u0932" },
            { "Brah", "\u092c\u094d\u0930\u0939\u094d\u092e\u0940" },
            { "DM", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u093e" },
            { "DO", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u0917\u0923\u0930\u093e\u091c\u094d\u092f" },
            { "gor", "\u0917\u094b\u0930\u0902\u091f\u093e\u0932\u094b" },
            { "got", "\u0917\u0949\u0925\u093f\u0915" },
            { "Mtei", "\u092e\u0947\u0924\u0947\u0908 \u092e\u092f\u0947\u0915" },
            { "zun", "\u091c\u093c\u0941\u0928\u0940" },
            { "tig", "\u091f\u0940\u0917\u094d\u0930\u0947" },
            { "DZ", "\u0905\u0932\u094d\u091c\u0940\u0930\u093f\u092f\u093e" },
            { "pag", "\u092a\u093e\u0902\u0917\u093e\u0938\u0940\u0928\u0928" },
            { "pal", "\u092a\u0939\u0932\u0935\u0940" },
            { "chb", "\u091a\u0940\u092c\u091a\u093e" },
            { "pam", "\u092a\u0902\u092a\u0902\u0917\u093e" },
            { "EC", "\u090f\u0915\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "pap", "\u092a\u093e\u092a\u0940\u0906\u092e\u0947\u0928\u094d\u0924\u094b" },
            { "ada", "\u0905\u0921\u093e\u0902\u0917\u092e\u0947" },
            { "EE", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e" },
            { "tiv", "\u091f\u0940\u0935\u094d" },
            { "EG", "\u092e\u093f\u0938\u094d\u0930" },
            { "EH", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u0939\u093e\u0930\u093e" },
            { "chg", "\u091a\u0917\u0924\u093e\u0908" },
            { "pau", "\u092a\u093e\u0932\u093e\u090a" },
            { "chk", "\u091a\u0941\u0915\u0947\u0938\u0947" },
            { "chn", "\u091a\u0940\u0928\u0942\u0915\u094d \u091c\u093e\u0930\u094d\u0917\u0928\u094d" },
            { "chm", "\u092e\u093e\u0930\u0940" },
            { "chp", "\u091a\u093f\u092a\u0947\u0935\u093f\u092f\u093e\u0928\u094d" },
            { "cho", "\u091a\u094c\u0915\u094d\u091f\u094b" },
            { "chr", "\u091a\u0940\u0930\u094b\u0915\u0940" },
            { "ER", "\u090f\u0930\u093f\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "ES", "\u0938\u094d\u092a\u0947\u0928" },
            { "ET", "\u0907\u0925\u093f\u0913\u092a\u093f\u092f\u093e" },
            { "EU", "\u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0938\u0902\u0918" },
            { "elx", "\u090f\u0932\u093e\u092e\u0940" },
            { "type.ca.gregorian", "\u0917\u094d\u0930\u0947\u0917\u0930\u0940\u0905\u0928 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "chy", "\u0936\u093e\u092f\u093e\u0928\u094d" },
            { "Inds", "\u0938\u093f\u0928\u094d\u0927\u0941" },
            { "ady", "\u0905\u0921\u0940\u0917\u0947" },
            { "FI", "\u092b\u093f\u0928\u0932\u0948\u0902\u0921" },
            { "FJ", "\u092b\u093f\u091c\u0940" },
            { "FK", "\u092b\u093c\u0949\u0932\u094d\u0915\u0932\u0948\u0902\u0921 \u0926\u094d\u0935\u0940\u092a" },
            { "FM", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "FO", "\u092b\u0930\u094b \u0926\u094d\u0935\u0940\u092a" },
            { "Taml", "\u0924\u092e\u0940\u0933" },
            { "FR", "\u092b\u094d\u0930\u093e\u0901\u0938" },
            { "tkl", metaValue_TK },
            { "grb", "\u0917\u094d\u0930\u0947\u092c\u094b" },
            { "grc", "\u092a\u094d\u0930\u093e\u091a\u0940\u0928 \u092f\u0942\u0928\u093e\u0928\u0940" },
            { "GA", "\u0917\u0948\u092c\u0949\u0928" },
            { "vot", "\u0935\u094b\u091f\u0940\u0915" },
            { "GB", "\u092c\u094d\u0930\u093f\u0924\u0928" },
            { "GD", "\u0917\u094d\u0930\u0947\u0928\u0921\u093e" },
            { "GE", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e" },
            { "GF", "\u092b\u094d\u0930\u093e\u0901\u0938\u0940\u0938\u0940 \u0917\u093f\u0906\u0928\u093e" },
            { "GG", "\u0917\u0947\u0930\u094d\u0928\u0938\u0947" },
            { "GH", "\u0918\u093e\u0928\u093e" },
            { "Tale", "\u0924\u093e\u0908 \u0932\u0947" },
            { "GI", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u0930" },
            { "afh", "\u0905\u092b\u094d\u0930\u0940\u0939\u0940\u0932\u0940" },
            { "GL", "\u0917\u094d\u0930\u0940\u0928\u0932\u0948\u0923\u094d\u0921" },
            { "enm", "\u092e\u0927\u094d\u092f \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "GM", "\u0917\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "GN", "\u0917\u093f\u0928\u0940" },
            { "GP", "\u0917\u094d\u0935\u093e\u0926\u0932\u0941\u092a" },
            { "GQ", "\u0907\u0915\u094d\u0935\u0947\u091f\u094b\u0930\u093f\u092f\u0932 \u0917\u093f\u0928\u0940" },
            { "GR", "\u0917\u094d\u0930\u0940\u0938" },
            { "GS", "\u0926\u0915\u094d\u0937\u093f\u0923 \u091c\u094b\u0930\u094d\u091c\u093f\u092f\u093e \u090f\u0935\u0902 \u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0948\u0902\u0921\u0935\u0940\u091a \u0926\u094d\u0935\u0940\u092a" },
            { "GT", "\u0917\u094b\u0924\u0947\u0926\u093e\u0932\u093e" },
            { "GU", "\u0917\u0941\u0906\u092e" },
            { "GW", "\u0917\u0940\u0928\u0940-\u092c\u093f\u0938\u093e\u0909" },
            { "tli", "\u091f\u094d\u0932\u093f\u0902\u0917\u0940\u0924" },
            { "tlh", "\u0915\u094d\u0932\u0940\u0902\u0917\u0926\u0928" },
            { "Talu", "\u0928\u092f\u093e \u0924\u093e\u0908 \u0932\u0941\u090f" },
            { "GY", "\u0917\u0941\u092f\u093e\u0928\u093e" },
            { "zxx", "\u0930\u093f\u0915\u094d\u0924" },
            { "de_AT", "\u091c\u0930\u094d\u092e\u0928 (\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e)" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0939\u093e\u0901\u0917\u0915\u093e\u0901\u0917 \u0935\u093f\u0936\u0947\u0937 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0915\u094d\u0937\u0947\u0924\u094d\u0930 \u091a\u0940\u0928" },
            { "HM", "\u0939\u0930\u094d\u0921 \u0926\u094d\u0935\u0940\u092a \u090f\u0935\u0902 \u092e\u0948\u0915\u0921\u094b\u0928\u0949\u0932\u094d\u0921 \u0926\u094d\u0935\u0940\u092a" },
            { "HN", "\u0939\u094c\u0923\u094d\u0921\u0942\u0930\u093e\u0938" },
            { "HR", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e" },
            { "gsw", "\u0938\u094d\u0935\u0940\u0938 \u091c\u0930\u094d\u092e\u0928" },
            { "HT", "\u0939\u093e\u0907\u0924\u0940" },
            { "HU", "\u0939\u0902\u0917\u0930\u0940" },
            { "tmh", "\u0924\u092e\u093e\u0936\u0947\u0915" },
            { "ID", "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "peo", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092b\u093c\u093e\u0930\u0938\u0940" },
            { "IE", "\u0906\u092f\u0930\u0932\u0948\u0902\u0921" },
            { "nap", "\u0928\u0947\u0906\u092a\u094b\u0932\u093f\u091f\u0928" },
            { "zza", "\u091c\u093c\u093e\u091c\u093c\u093e" },
            { "IL", "\u0907\u0938\u094d\u0930\u093e\u0907\u0932" },
            { "IM", "\u0906\u0908\u0932 \u0911\u092b\u093c \u092e\u0948\u0928" },
            { "IN", "\u092d\u093e\u0930\u0924" },
            { "IO", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0939\u093f\u0902\u0926 \u092e\u0939\u093e\u0938\u093e\u0917\u0930\u093f\u092f \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "IQ", "\u0908\u0930\u093e\u0915\u093c" },
            { "IR", "\u0908\u0930\u093e\u0928" },
            { "IS", "\u0906\u0907\u0938\u0932\u0948\u0902\u0921" },
            { "IT", "\u0907\u091f\u0932\u0940" },
            { "%%POSIX", "\u0915\u092e\u094d\u092a\u094d\u092f\u0942\u091f\u0930" },
            { "JE", "\u091c\u0930\u094d\u0938\u0940" },
            { "type.ca.islamic", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "JM", "\u091c\u092e\u093e\u0907\u0915\u093e" },
            { "Beng", "\u092c\u0902\u0917\u093e\u0932\u0940" },
            { "JO", "\u091c\u0949\u0930\u094d\u0921\u0928" },
            { "JP", "\u091c\u093e\u092a\u093e\u0928" },
            { "%%1606NICT", "\u092e\u0927\u094d\u092f \u092b\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940 1606 \u0924\u0915" },
            { "ain", "\u0910\u0928\u0942" },
            { "tog", "\u0928\u094d\u092f\u093e\u0938\u093e \u091f\u0949\u0902\u0917\u093e" },
            { "Kali", "\u0915\u093e\u092f\u093e\u0939 \u0932\u0940" },
            { "de_CH", "\u0909\u091a\u094d\u091a \u0938\u094d\u0924\u0930\u093f\u092f \u0938\u094d\u0935\u0940\u0938 \u091c\u0930\u094d\u092e\u0928" },
            { "type.ca.buddhist", "\u092c\u094c\u0926\u094d\u0927 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "KE", "\u0915\u0947\u0928\u094d\u092f\u093e" },
            { "419", "\u0932\u0948\u091f\u093f\u0928 \u0905\u092e\u0930\u093f\u0915\u093e \u090f\u0935\u0902 \u0915\u0930\u0940\u092c\u0940" },
            { "KG", "\u0915\u093f\u0930\u094d\u0917\u093f\u091c\u093c" },
            { "KH", "\u0915\u092e\u094d\u092c\u094b\u0921\u093f\u092f\u093e" },
            { "KI", "\u0915\u093f\u0930\u093f\u092c\u093e\u0924\u0940" },
            { "KM", "\u0915\u094b\u092e\u094b\u0930\u094b\u091c\u093c" },
            { "KN", "\u0938\u0947\u0902\u091f \u0915\u093f\u091f\u094d\u0938 \u090f\u0935\u0902 \u0928\u0947\u0935\u093f\u0938" },
            { "Knda", "\u0915\u0928\u094d\u0928\u0921\u093c" },
            { "Zinh", "\u0935\u093f\u0930\u093e\u0938\u0924" },
            { "fr_CA", "\u092b\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940 (\u0915\u0928\u093e\u0921\u093e\u0908)" },
            { "KP", "\u0909\u0924\u094d\u0924\u0930 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KR", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "Plrd", "\u092a\u094c\u0932\u093e\u0930\u094d\u0921\u093c \u092b\u094b\u0928\u0947\u091f\u0940\u0915" },
            { "fr_CH", "\u092b\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940 (\u0938\u094d\u0935\u0940\u0938)" },
            { "KW", "\u0915\u0941\u0935\u0948\u0924" },
            { "tpi", "\u0924\u094b\u0915 \u092a\u093f\u0938\u0940\u0928" },
            { "KY", "\u0915\u0947\u092e\u0948\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "KZ", "\u0915\u091c\u093c\u093e\u0916\u0938\u094d\u0924\u093e\u0928" },
            { "Cyrl", "\u0938\u093f\u0930\u093f\u0932\u093f\u0915\u094d" },
            { "LA", "\u0932\u093e\u0913\u0938" },
            { "LB", "\u0932\u0947\u092c\u0928\u094b\u0928" },
            { "LC", "\u0938\u0947\u0902\u091f \u0932\u0942\u0938\u093f\u092f\u093e" },
            { "phn", "\u092b\u0940\u0928\u0940\u0938\u0940" },
            { "Cyrs", "\u092a\u0941\u0930\u093e\u0928\u0940 \u091a\u0930\u094d\u091a \u0938\u093f\u0930\u093f\u0932\u093f\u0915\u094d" },
            { "gwi", "\u0917\u094d\u0935\u0940\u091a\u0932\u0940\u0928" },
            { "nds", "\u0928\u0940\u091c\u0940 \u0938\u094d\u0924\u0930\u093f\u092f \u091c\u0930\u094d\u092e\u0928" },
            { "LI", "\u0932\u093f\u0915\u094d\u091f\u0948\u0928\u0938\u094d\u091f\u093e\u0908\u0928" },
            { "LK", "\u0936\u094d\u0930\u0940 \u0932\u0901\u0915\u093e" },
            { "akk", "\u0905\u0915\u093e\u0921\u093f\u0928\u0940" },
            { "cop", "\u0915\u0949\u092a\u094d\u091f\u0940\u0915\u094d" },
            { "LR", "\u0932\u093e\u0907\u092c\u0947\u0930\u093f\u092f\u093e" },
            { "LS", "\u0932\u0938\u094b\u0925\u094b" },
            { "Phlv", "\u092c\u0941\u0915 (\u0938\u093e\u0932\u091f\u0930) \u092a\u0939\u0932\u0935\u0940" },
            { "LT", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e" },
            { "LU", "\u0932\u0915\u094d\u0938\u092e\u092c\u0930\u094d\u0917" },
            { "LV", "\u0932\u093e\u091f\u094d\u0935\u0940\u092f\u093e" },
            { "Kana", "\u0915\u093e\u0924\u093e\u0915\u093e\u0928\u093e" },
            { "LY", "\u0932\u0940\u092c\u093f\u092f\u093e" },
            { "lad", "\u0932\u093e\u0921\u093c\u0940\u0928\u094b" },
            { "lah", "\u0932\u093e\u0939\u094d\u0921\u093e\u0902" },
            { "Thaa", "\u0925\u093e\u0928\u093e" },
            { "MA", "\u092e\u094b\u0930\u094b\u0915\u094d\u0915\u094b" },
            { "MC", "\u092e\u094b\u0928\u093e\u0915\u094b" },
            { "MD", "\u092e\u094b\u0932\u094d\u0921\u0947\u0935\u093f\u092f\u093e" },
            { "ME", "\u092e\u094b\u0902\u091f\u0947\u0928\u0947\u0917\u094d\u0930\u094b" },
            { "MF", "\u0938\u0947\u0901 \u092e\u093e\u0930\u094d\u091f\u0947\u0901" },
            { "lam", "\u0932\u093e\u0902\u092c\u093e" },
            { "MG", "\u092e\u0926\u093e\u0917\u093e\u0938\u094d\u0915\u0930" },
            { "Thai", metaValue_th },
            { "MH", "\u092e\u093e\u0930\u094d\u0936\u0932 \u0926\u094d\u0935\u0940\u092a" },
            { "ale", "\u0905\u0932\u0941\u091f" },
            { "ML", "\u092e\u093e\u0932\u0940" },
            { "MM", "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930" },
            { "MN", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e" },
            { "new", "\u0928\u0947\u0935\u093e\u0930\u0940" },
            { "MO", "\u092e\u0915\u093e\u0913 \u0935\u093f\u0936\u0947\u0937 \u092a\u094d\u0930\u0936\u093e\u0938\u0928\u093f\u0915 \u0915\u094d\u0937\u0947\u0924\u094d\u0930 (\u091a\u0940\u0928)" },
            { "MP", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092e\u093e\u0930\u093f\u092f\u093e\u0928\u093e \u0926\u094d\u0935\u0940\u092a" },
            { "MQ", "\u092e\u093e\u0930\u094d\u091f\u0940\u0928\u093f\u0915" },
            { "MR", "\u092e\u0949\u0930\u093f\u091f\u0947\u0928\u093f\u092f\u093e" },
            { "MS", "\u092e\u0949\u0902\u0938\u0947\u0930\u093e" },
            { "MT", "\u092e\u093e\u0932\u094d\u091f\u093e" },
            { "MU", "\u092e\u0949\u0930\u093f\u0938" },
            { "MV", "\u092e\u093e\u0932\u0926\u0940\u0935" },
            { "MW", "\u092e\u0932\u093e\u0935\u0940" },
            { "MX", "\u092e\u0948\u0915\u094d\u0938\u093f\u0915\u094b" },
            { "type.ca.japanese", "\u091c\u093e\u092a\u093e\u0928\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "MY", "\u092e\u0932\u0947\u0936\u093f\u092f\u093e" },
            { "MZ", "\u092e\u094b\u091c\u093c\u093e\u092e\u094d\u092c\u093f\u0915" },
            { "NA", "\u0928\u093e\u092e\u0940\u092c\u093f\u092f\u093e" },
            { "type.ca.hebrew", "\u092f\u0939\u0941\u0926\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "NC", "\u0928\u094d\u092f\u0942 \u0915\u0948\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "NE", "\u0928\u093e\u0907\u091c\u0947\u0930" },
            { "NF", "\u0928\u0949\u0930\u092b\u093c\u0949\u0915 \u0926\u094d\u0935\u0940\u092a" },
            { "NG", "\u0928\u093e\u0907\u091c\u0940\u0930\u093f\u092f\u093e" },
            { "NI", "\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0906" },
            { "Hmng", "\u092a\u093e\u0939\u0935\u093e\u0939 \u0939\u094d\u092e\u094c\u0902\u0917" },
            { "NL", "\u0928\u0947\u0926\u0930\u0932\u0948\u0923\u094d\u0921" },
            { "NO", "\u0928\u0949\u0930\u094d\u0935\u0947" },
            { "NP", "\u0928\u0947\u092a\u093e\u0932" },
            { "NR", "\u0928\u093e\u0909\u0930\u0942" },
            { "NU", "\u0928\u0940\u092f\u0942\u090f" },
            { "Phnx", "\u092b\u094b\u0928\u0940\u0936\u0940\u092f\u0928" },
            { "tsi", "\u0924\u094d\u0938\u0940\u092e\u0936\u0940\u0906\u0928\u094d" },
            { "NZ", "\u0928\u094d\u092f\u0942\u091c\u093c\u0940\u0932\u0948\u0902\u0921" },
            { "rom", "\u0930\u0941\u092e\u093e\u0928\u0940" },
            { "Mero", "\u092e\u0947\u0930\u094b\u0908\u091f\u0940\u0915\u094d" },
            { "crh", "\u0924\u0941\u0930\u094d\u0915\u0940 \u0915\u094d\u0930\u093f\u092e\u093f\u092f\u093e" },
            { "ang", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "OM", "\u0913\u092e\u093e\u0928" },
            { "anp", "\u0905\u0902\u0917\u0940\u0915\u093e" },
            { "Xpeo", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092b\u093e\u0930\u0938\u0940" },
            { "PA", "\u092a\u0928\u093e\u092e\u093e" },
            { "type.ca.islamic-civil", "\u0907\u0938\u094d\u0932\u093e\u092e\u0940 \u0928\u093e\u0917\u0930\u093f\u0915 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "csb", "\u0915\u093e\u0936\u0941\u092c\u093f\u092f\u093e\u0928\u094d" },
            { "en_GB", "\u0905\u0902\u0917\u094d\u0930\u0947\u091c\u0940 (\u092c\u094d\u0930\u093f\u091f\u093f\u0936)" },
            { "PE", "\u092a\u0947\u0930\u0942" },
            { "PF", "\u092b\u094d\u0930\u093e\u0901\u0938\u0940\u0938\u0940 \u092a\u0949\u0932\u093f\u0928\u0940\u0936\u093f\u092f\u093e" },
            { "PG", "\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093f\u0928\u0940" },
            { "PH", "\u092b\u093f\u0932\u0940\u092a\u093f\u0928\u094d\u0938" },
            { "PK", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "PL", "\u092a\u094b\u0932\u0948\u0923\u094d\u0921" },
            { "ewo", "\u090f\u0935\u094c\u0902\u0921\u094b" },
            { "PM", "\u0938\u0947\u0901 \u092a\u0940\u090f\u0930 \u090f\u0935\u0902 \u092e\u093f\u200d\u0915\u0947\u0932\u0949\u0902" },
            { "PN", "\u092a\u093f\u091f\u0915\u0947\u0930\u094d\u0928" },
            { "PR", "\u092a\u0941\u090f\u0930\u094d\u091f\u094b \u0930\u0940\u0915\u094b" },
            { "PS", "\u092b\u093c\u093f\u0932\u093f\u0938\u094d\u0924\u0940\u0928" },
            { "Bali", "\u092c\u093e\u0932\u0940" },
            { "PT", "\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932" },
            { "PW", "\u092a\u0932\u093e\u090a" },
            { "nia", "\u0928\u093f\u092f\u093e\u0938" },
            { "PY", "\u092a\u093e\u0930\u093e\u0917\u0941\u090f" },
            { "tum", "\u091f\u0941\u0901\u092c\u0941\u0915\u093e" },
            { "Hebr", "\u0939\u093f\u092c\u094d\u0930\u0942" },
            { "QA", "\u0915\u093c\u0924\u093e\u0930" },
            { "%%SCOTLAND", "\u092e\u093e\u0928\u0915 \u0938\u094d\u0915\u0949\u091f \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "niu", "\u0928\u093f\u092f\u0941\u0907\u0906\u0928" },
            { "QO", "\u092c\u093e\u0939\u0930\u093f\u092f \u0913\u0936\u0947\u0906\u0928\u093f\u092f\u093e" },
            { "lez", "\u0932\u0947\u091c\u093c\u0917\u0940\u092f\u093e\u0928" },
            { "%%FONUPA", "\u092f\u0941\u092a\u0940\u090f \u092b\u093c\u094b\u0928\u0947\u091f\u0940\u0915\u094d\u0938" },
            { "tvl", "\u091f\u0941\u0935\u093e\u0932\u0941" },
            { "001", "\u0926\u0941\u0928\u093f\u092f\u093e" },
            { "002", "\u0905\u092b\u094d\u0930\u0940\u0915\u093e" },
            { "003", "\u0909\u0924\u094d\u0924\u0930 \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "RE", "\u0930\u0947\u092f\u0942\u0928\u093f\u092f\u0949\u0902" },
            { "005", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "jbo", "\u0932\u094b\u091c\u092c\u093e\u0928" },
            { "Rjng", "\u0930\u0947\u091c\u0947\u0902\u0917" },
            { "009", "\u0913\u0936\u0947\u0906\u0928\u093f\u092f\u093e" },
            { "RO", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e" },
            { "RS", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e" },
            { "RU", "\u0930\u0942\u0938" },
            { "RW", "\u0930\u0942\u0906\u0923\u094d\u0921\u093e" },
            { "Mani", "\u092e\u093e\u0928\u0940\u0915\u0940" },
            { "Ugar", "\u090a\u0917\u093e\u0930\u0940\u091f\u0940\u0915" },
            { "Khar", "\u0916\u0930\u094b\u0937\u094d\u091f\u0940" },
            { "SA", "\u0938\u090a\u0926\u0940 \u0905\u0930\u092c" },
            { "pon", "\u092a\u094b\u0939\u0928\u092a\u0940" },
            { "Mand", "\u092e\u093e\u0902\u0921\u0947" },
            { "SB", "\u0938\u0949\u0932\u094b\u092e\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "011", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u092b\u094d\u0930\u0940\u0915\u093e" },
            { "SC", "\u0938\u0947\u0936\u0947\u0932\u094d\u0938" },
            { "SD", "\u0938\u0942\u0926\u093e\u0928" },
            { "013", "\u092e\u0927\u094d\u092f \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "SE", "\u0938\u094d\u0935\u0940\u0921\u0928" },
            { "014", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u092b\u094d\u0930\u0940\u0915\u093e" },
            { "arc", "\u0905\u0930\u093e\u092e\u093e\u0908\u0915" },
            { "015", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092b\u094d\u0930\u0940\u0915\u093e" },
            { "SG", "\u0938\u093f\u0902\u0917\u093e\u092a\u0941\u0930" },
            { "SH", "\u0938\u0947\u0923\u094d\u200d\u091f \u0939\u0947\u0932\u0947\u0928\u093e" },
            { "017", "\u092e\u0927\u094d\u092f \u0905\u092b\u094d\u0930\u0940\u0915\u093e" },
            { "SI", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e" },
            { "018", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0905\u092b\u094d\u0930\u0940\u0915\u093e" },
            { "SJ", "\u0938\u094d\u0935\u093e\u0932\u094d\u092c\u093e\u0930\u094d\u0921 \u090f\u0935\u0902 \u092f\u093e\u0928 \u092e\u093e\u092f\u0947\u0928" },
            { "019", "\u0905\u092e\u0930\u093f\u0915\u093e\u091c\u093c\u094d" },
            { "SK", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915\u093f\u092f\u093e" },
            { "SL", "\u0938\u093f\u092f\u0947\u0930\u093e \u0932\u0947\u0913\u0928" },
            { "SM", "\u0938\u0948\u0928 \u092e\u0930\u0940\u0928\u094b" },
            { "SN", "\u0938\u0947\u0928\u0947\u0917\u093e\u0932" },
            { "SO", "\u0938\u094b\u092e\u093e\u0932\u093f\u092f\u093e" },
            { "arp", "\u0905\u0930\u093e\u092a\u093e\u0939\u094b" },
            { "SR", "\u0938\u0941\u0930\u093f\u0928\u093e\u092e" },
            { "ST", "\u0938\u093e\u0909\u0901-\u0924\u094b\u092e\u0947 \u090f\u0935\u0902 \u092a\u094d\u0930\u093f\u0902\u0938\u093f\u092a" },
            { "SV", "\u090d\u0932 \u0938\u093e\u0932\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "SY", "\u0938\u0940\u0930\u093f\u092f\u093e" },
            { "yao", "\u092f\u093e\u0913" },
            { "SZ", "\u0938\u094d\u0935\u093e\u091c\u093c\u0940\u0932\u0948\u0902\u0921" },
            { "arw", "\u0905\u0930\u093e\u0935\u093e\u0915" },
            { "yap", "\u092f\u093e\u092a\u0940\u091c\u093c" },
            { "021", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "TC", "\u0924\u0941\u0930\u094d\u0915\u0940 \u090f\u0935\u0902 \u0915\u0948\u0915\u094b\u091c\u093c \u0926\u094d\u0935\u0940\u092a" },
            { "TD", "\u091a\u093e\u0921" },
            { "TF", "\u092b\u094d\u0930\u093e\u0901\u0938\u0940\u0938\u0940 \u0909\u0924\u094d\u0924\u0930\u0940 \u0915\u094d\u0937\u0947\u0924\u094d\u0930\u094b\u0902" },
            { "TG", "\u091f\u094b\u0917\u094b" },
            { "TH", "\u0925\u093e\u0907\u0932\u0948\u0923\u094d\u0921" },
            { "TJ", "\u0924\u093e\u091c\u093f\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TK", metaValue_TK },
            { "029", "\u0915\u0948\u0930\u093f\u092c\u093f\u092f\u0928" },
            { "TL", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0924\u093f\u092e\u094b\u0930" },
            { "TM", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u0940\u0938\u094d\u0924\u093e\u0928" },
            { "%%BOONT", "\u092c\u0941\u0928\u094d\u0924\u0932\u0940\u0902\u0917" },
            { "TN", "\u0924\u094d\u092f\u0941\u0928\u093f\u0936\u093f\u092f\u093e" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "\u091f\u094d\u0930\u093f\u0928\u093f\u0921\u093e\u0921 \u090f\u0935\u0902 \u091f\u094b\u092c\u0948\u0917\u094b" },
            { "TV", "\u0924\u0941\u0935\u093e\u0932\u0941" },
            { "TW", "\u0924\u093e\u0907\u0935\u093e\u0928" },
            { "Orkh", "\u0913\u0930\u0916\u094b\u0928" },
            { "TZ", "\u0924\u0902\u091c\u093c\u093e\u0928\u093f\u092f\u093e" },
            { "Zzzz", "\u0905\u091c\u094d\u091e\u093e\u0924 \u092f\u093e \u0905\u0935\u0948\u0927 \u0932\u093f\u092a\u093f" },
            { "UA", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928" },
            { "rup", "\u0906\u0930\u094b\u092e\u093e\u0928\u0940" },
            { "030", "\u092a\u0942\u0930\u094d\u0935\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "tyv", "\u091f\u0941\u0935\u0940" },
            { "034", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "hai", "\u0939\u0908\u0921\u093e" },
            { "035", "\u0926\u0915\u094d\u0937\u093f\u0923-\u092a\u0942\u0930\u094d\u0935\u0940 \u090f\u0936\u093f\u092f\u093e" },
            { "UG", "\u092f\u0941\u0917\u093e\u0901\u0921\u093e" },
            { "type.co.pinyin", "\u092a\u093f\u0928\u092f\u0940\u0928 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "039", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "Sinh", "\u0938\u093f\u0902\u0939\u093e\u0932\u0940" },
            { "UM", "\u092f\u0941\u0928\u093e\u0907\u091f\u0947\u0921 \u0938\u094d\u091f\u0947\u091f\u094d\u0938 \u0915\u0947 \u091b\u094b\u091f\u0947 \u092c\u093e\u0939\u0930\u093f\u092f \u0926\u094d\u0935\u0940\u092a" },
            { "US", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0930\u093e\u091c\u094d\u092f \u0905\u092e\u0930\u093f\u0915\u093e" },
            { "haw", "\u0939\u0935\u093e\u0908\u0905\u0928" },
            { "type.co.gb2312han", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u091a\u0940\u0928\u0940 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923 \u091c\u0940\u092c\u09402312" },
            { "UY", "\u092f\u0941\u0930\u0942\u0917\u0941\u090f" },
            { "UZ", "\u0909\u091c\u093c\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "type.co.stroke", "\u0938\u094d\u091f\u094d\u0930\u094b\u0915 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "VA", "\u0935\u0948\u091f\u093f\u0915\u0928" },
            { "pro", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092a\u094d\u0930\u094b\u0935\u093e\u0901\u0938\u093e\u0932" },
            { "VC", "\u0938\u0947\u0902\u091f \u0935\u093f\u0902\u0938\u0902\u091f \u090f\u0935\u0902 \u0926\u0940 \u0917\u094d\u0930\u0928\u093e\u0921\u0940\u0928\u094d\u0938\u094d" },
            { "VE", "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e" },
            { "VG", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0935\u0930\u094d\u091c\u0940\u0928 \u0906\u0908\u0932\u0902\u0921\u094d\u0938" },
            { "VI", "\u092f\u0941.\u090f\u0938. \u0935\u0930\u094d\u091c\u0940\u0928 \u0906\u0908\u0932\u0902\u0921\u094d\u0938" },
            { "VN", "\u0935\u093f\u092f\u0924\u0928\u093e\u092e" },
            { "VU", "\u0935\u093e\u0928\u093e\u090a\u091f\u0941" },
            { "nog", "\u0928\u094b\u0917\u093e\u0908" },
            { "non", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0928\u0949\u0930\u094d\u0938\u094d" },
            { "053", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u090f\u0935\u0902 \u0928\u094d\u092f\u0942\u091c\u0940\u0932\u0948\u0902\u0921" },
            { "054", "\u092e\u0947\u0932\u0940\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "WF", "\u0935\u0949\u0932\u0947\u0938 \u090f\u0935\u0902 \u092b\u093c\u094d\u092f\u0942\u091a\u0942\u0928\u093e" },
            { "type.co.traditional", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "057", "\u092e\u093e\u0908\u0915\u094d\u0930\u094b\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "WS", "\u0938\u092e\u094b\u0906" },
            { "wal", "\u0935\u093e\u0932\u093e\u092e\u094b" },
            { "was", "\u0935\u093e\u0936\u094b" },
            { "war", "\u0935\u093e\u0930\u092f" },
            { "awa", "\u0905\u0935\u0927\u0940" },
            { "061", "\u092a\u094b\u0932\u0940\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0905\u0932\u093f\u0916\u093f\u0924" },
            { "Olck", "\u0913\u0932 \u091a\u0940\u0915\u0940" },
            { "Batk", "\u092c\u091f\u0915\u0940" },
            { "Blis", "\u092c\u094d\u0932\u0940\u0938 \u091a\u0940\u0928\u094d\u0939" },
            { "YE", "\u092f\u092e\u0928" },
            { "nqo", metaValue_nqo },
            { "fan", "\u092b\u093e\u0901\u0917\u094d" },
            { "%%ROZAJ", "\u0930\u0947\u091c\u093c\u0940\u092f\u0928" },
            { "fat", "\u092b\u093e\u0901\u091f\u0940" },
            { "Sgnw", "\u0938\u093e\u0902\u0915\u0947\u0924\u093f\u0915 \u0932\u0947\u0916" },
            { "YT", "\u092e\u0948\u092f\u094c\u091f" },
            { "ZA", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092b\u094d\u0930\u0940\u0915\u093e" },
            { "Deva", "\u0926\u0947\u0935\u0928\u093e\u0917\u0930\u0940" },
            { "Hira", "\u0939\u0940\u0930\u093e\u0917\u093e\u0928\u093e" },
            { "ZM", "\u091c\u093c\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "ZW", "\u091c\u093c\u0940\u092e\u094d\u092c\u093e\u092c\u094d\u0935\u0947" },
            { "ZZ", "\u0905\u091c\u094d\u091e\u093e\u0924 \u092f\u093e \u0905\u0935\u0948\u0927 \u092a\u094d\u0930\u0926\u0947\u0936" },
            { "Runr", "\u0930\u0942\u0928\u093f\u0915" },
            { "lol", "\u092e\u094b\u0902\u0917\u094b" },
            { "loz", "\u0932\u094b\u091c\u093c\u0940" },
            { "hil", "\u0939\u0940\u0932\u0940\u0917\u0948\u0928\u094b\u0928" },
            { "dak", "\u0921\u0915\u094c\u091f\u093e" },
            { "hit", "\u0939\u0940\u0924\u094d\u0924\u0940" },
            { "dar", "\u0926\u0930\u094d\u0917\u0935\u093e" },
            { "Maya", "\u092e\u093e\u092f\u093e \u0939\u0940\u0930\u094b\u0917\u094d\u0932\u0940\u092b\u094d" },
            { "Copt", "\u0915\u0949\u092a\u094d\u091f" },
            { "nwc", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0928\u0947\u0935\u093e\u0930\u0940" },
            { "udm", "\u0909\u0921\u093c\u092e\u0941\u0930\u094d\u0924" },
            { "Khmr", metaValue_km },
            { "Limb", "\u0932\u093f\u092e\u094d\u092c\u0941" },
            { "sad", "\u0938\u0902\u0921\u093e\u0935\u0947" },
            { "sah", "\u092f\u0915\u0941\u091f\u094d" },
            { "sam", "\u0938\u092e\u093e\u0930\u0940\u0924\u0940 \u0906\u0930\u093e\u092e\u093e\u0908\u0915\u093c" },
            { "%%SCOUSE", "\u0938\u094d\u0915\u093e\u0909\u091c\u093c" },
            { "sas", "\u0938\u093e\u0938\u0915" },
            { "sat", "\u0938\u0902\u0924\u093e\u0932\u0940" },
            { "Tfng", "\u0924\u0940\u092b\u0940\u0928\u093e\u0917\u093c" },
            { "jpr", "\u092f\u0939\u0941\u0926\u0940 \u092b\u093c\u093e\u0930\u0938\u0940" },
            { "Guru", "\u0917\u0941\u0930\u092e\u0941\u0916\u0940" },
            { "lua", "\u0932\u0941\u092c\u093e \u0932\u0941\u0932\u0941\u0906" },
            { "lui", "\u0932\u0941\u0908\u0938\u0947\u0928\u094b" },
            { "nyn", "\u0928\u094d\u092f\u093e\u0928\u0915\u094b\u0932\u0947" },
            { "nym", "\u0928\u094d\u092f\u093e\u092e\u0935\u0947\u091c\u093c\u0940" },
            { "lun", "\u0932\u0941\u0902\u0921\u093e" },
            { "nyo", "\u0928\u094d\u092f\u094c\u0930\u094b" },
            { "luo", "\u0932\u0941\u0913" },
            { "fil", "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u094b" },
            { "hmn", "\u0939\u094d\u092e\u094c\u0902\u0917" },
            { "del", "\u0926\u0932\u093e\u0935\u093e\u0930\u094d" },
            { "lus", "\u0932\u0941\u0936\u093e\u0908" },
            { "bal", "\u092c\u0932\u0942\u091a\u0940" },
            { "den", "\u0938\u094d\u0932\u0947\u0935\u094d" },
            { "ban", "\u092c\u093e\u0932\u093f\u0928\u0940" },
            { "uga", "\u0909\u0917\u093e\u0930\u093f\u0924\u0940" },
            { "bas", "\u092c\u093e\u0938\u094d\u0915\u093c\u094d" },
            { "jrb", "\u092f\u0939\u0941\u0926\u0940 \u0905\u0930\u092c\u0940" },
            { "es_ES", "\u0908\u0935\u0947\u0930\u093f\u092f\u093e\u0908 \u0938\u094d\u092a\u0948\u0928\u093f\u0936" },
            { "nzi", "\u0928\u094d\u091c\u093c\u0940\u092e\u093e" },
            { "sco", "\u0938\u094d\u0915\u0949\u091f" },
            { "scn", "\u0938\u0940\u0938\u0940\u0932\u0940\u0905\u0928" },
            { "ab", "\u0905\u092c\u094d\u0916\u093e\u091c\u093c\u093f\u092f\u0928\u094d" },
            { "ae", metaValue_ae },
            { "af", "\u0905\u092b\u094d\u0930\u0940\u0915\u0940" },
            { "ak", "\u0905\u0915\u0928" },
            { "am", "\u0905\u092e\u094d\u0939\u093e\u0930\u093f\u0915\u094d" },
            { "Arab", metaValue_ar },
            { "an", "\u0906\u0930\u094d\u0917\u094b\u0928\u0940" },
            { "%%SOLBA", "\u0936\u094d\u091f\u094b\u0932\u0935\u093f\u091c\u093c\u094d\u091c\u093c\u093e \u092f\u093e \u0938\u094b\u0932\u092c\u0940\u0915\u093e \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0915\u093e\u0924\u093e\u0915\u093e\u0928\u093e \u092f\u093e \u0939\u0940\u0930\u093e\u0917\u093e\u0928\u093e" },
            { "as", "\u0905\u0938\u093e\u092e\u0940" },
            { "Lina", "\u0932\u0940\u0928\u0940\u092f\u0930 \u090f" },
            { "av", "\u0905\u0935\u093e\u0930\u093f\u0915\u094d" },
            { "Linb", "\u0932\u0940\u0928\u0940\u092f\u0930 \u092c\u0940" },
            { "ay", "\u0906\u092f\u092e\u093e\u0930\u093e" },
            { "az", "\u0905\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928\u0940" },
            { "%%OSOJS", "\u0913\u0938\u0947\u0906\u0915\u094b \u0913\u0938\u094b\u091c\u093e\u0928\u0947 \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "ba", "\u092c\u0936\u0916\u093c\u093f\u0930\u094d" },
            { "be", "\u092c\u0948\u0932\u094b\u0930\u0942\u0938\u093f\u092f\u0928\u094d" },
            { "bg", "\u092c\u0932\u094d\u0917\u0948\u0930\u093f\u092f\u0928\u094d" },
            { "bi", "\u092c\u093f\u0938\u094d\u0932\u093e\u092e\u093e" },
            { "bm", "\u092c\u093e\u0902\u092c\u093e\u0930\u093e" },
            { "bn", "\u092c\u0902\u0917\u0932\u093e" },
            { "bo", metaValue_bo },
            { "dgr", "\u0921\u094b\u0917\u0930\u0940\u092c\u094d" },
            { "br", "\u092c\u094d\u0930\u091f\u094b\u0902" },
            { "bs", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e\u0908" },
            { "Mymr", "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930\u094d" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0938\u0947\u0932\u0915\u0941\u092a" },
            { "ca", "\u0915\u093e\u0924\u093e\u0932\u093e\u0928\u094d" },
            { "ce", "\u091a\u0947\u091a\u0947\u0928\u094d" },
            { "ch", "\u091a\u093e\u092e\u094b\u0930\u094b" },
            { "%%REVISED", "\u0938\u0902\u0936\u094b\u0927\u093f\u0924 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "co", "\u0915\u094b\u0930\u094d\u0938\u0940\u0915\u0928\u094d" },
            { "Orya", metaValue_or },
            { "cr", "\u0915\u094d\u0930\u0940" },
            { "cs", "\u091a\u0947\u0915\u094d" },
            { "cu", "\u091a\u0930\u094d\u091a \u0938\u094d\u0932\u093e\u0935\u093f\u0915\u094d" },
            { "cv", "\u091a\u0941\u0935\u093e\u0936\u094d" },
            { "cy", "\u0935\u0948\u0932\u094d\u0936\u094d" },
            { "Yiii", "\u092f\u0940" },
            { "da", "\u0921\u0948\u0928\u0940\u0936\u094d" },
            { "de", "\u091c\u093c\u0930\u094d\u092e\u0928" },
            { "bej", "\u092c\u0947\u091c\u093e" },
            { "din", "\u0921\u0940\u0902\u0917\u0915\u093e" },
            { "Bugi", metaValue_bug },
            { "bem", "\u092c\u0947\u0902\u092c\u093e" },
            { "sga", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0906\u0908\u0930\u0940\u0936" },
            { "dv", "\u0926\u0940\u0935\u0947\u0939\u0940" },
            { "es_419", "\u0932\u0948\u091f\u093f\u0928 \u0905\u092e\u0930\u093f\u0915\u0940 \u0938\u094d\u092a\u0948\u0928\u093f\u0936" },
            { "dz", "\u092d\u0941\u091f\u093e\u0928\u0940" },
            { "type.ca.chinese", "\u091a\u0940\u0928\u0940 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "ee", "\u090f\u0935\u0947" },
            { "ro_MD", "\u092e\u094b\u0932\u094d\u0921\u0947\u0935\u093f\u092f\u0928\u094d" },
            { "el", metaValue_el },
            { "en", "\u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "eo", "\u090f\u0938\u094d\u092a\u0947\u0930\u093e\u0928\u094d\u0924\u094b" },
            { "type.co.big5han", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u091a\u0940\u0928\u0940 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923 \u092c\u0940\u0917 \u092b\u093c\u093e\u0908\u0935" },
            { "es", "\u0938\u094d\u092a\u0948\u0928\u093f\u0936" },
            { "et", "\u0910\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u0928\u094d" },
            { "eu", "\u092c\u093e\u0938\u094d\u0915\u094d" },
            { "Buhd", "\u092c\u0941\u0939\u0940\u0926" },
            { "Hang", "\u0939\u0902\u0917\u0941\u0932" },
            { "Samr", "\u0938\u092e\u093e\u0930\u0924\u0940" },
            { "hsb", "\u090a\u092a\u0930\u0940 \u0938\u094c\u0930\u094d\u092c\u093f\u092f\u0928" },
            { "Hani", "\u0939\u093e\u0928" },
            { "shn", "\u0936\u093e\u0928" },
            { "Hano", "\u0939\u093e\u0928\u0941\u0928\u0941" },
            { "fa", "\u092b\u093e\u0930\u094d\u0938\u0940" },
            { "Hans", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u0939\u093e\u0928" },
            { "Hant", "\u092a\u093e\u0930\u092e\u094d\u092a\u0930\u093f\u0915 \u0939\u093e\u0928" },
            { "ff", "\u092b\u0941\u0932\u093e\u0939\u094d" },
            { "fi", "\u092b\u093f\u0928\u093f\u0936\u094d" },
            { "fj", "\u092b\u093c\u0940\u091c\u0940" },
            { "fon", "\u092b\u094b\u0928" },
            { "fo", "\u092b\u093f\u0930\u094b\u091c\u093c\u0940" },
            { "umb", "\u0909\u0902\u092c\u0941\u0902\u0921\u0941" },
            { "fr", "\u092b\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "sid", "\u0938\u0940\u0926\u093e\u092e\u094b" },
            { "fy", "\u092a\u0936\u094d\u091a\u0940\u092e\u0940 \u092b\u094d\u0930\u0940\u091c\u093c\u093f\u092f\u0928\u094d" },
            { "ga", "\u0906\u0908\u0930\u093f\u0936" },
            { "gd", "\u0938\u094d\u0915\u0949\u091f\u094d\u0938\u094d \u0917\u0948\u0932\u093f\u0915\u094d" },
            { "gl", "\u0917\u0948\u0932\u093f\u0936\u093f\u092f\u0928\u094d" },
            { "gn", "\u0917\u0941\u0906\u0930\u093e\u0928\u0940" },
            { "bho", "\u092d\u094b\u091c\u092a\u0941\u0930\u0940" },
            { "und", "\u0905\u091c\u094d\u091e\u093e\u0924 \u092f\u093e \u0905\u0935\u0948\u0927 \u092d\u093e\u0937\u093e" },
            { "gu", metaValue_gu },
            { "gv", "\u092e\u0948\u0902\u0915\u094d\u0938" },
            { "ha", "\u0939\u0909\u0938\u093e" },
            { "he", "\u0939\u093f\u092c\u094d\u0930\u0941" },
            { "hi", "\u0939\u093f\u0902\u0926\u0940" },
            { "hup", "\u0939\u0942\u092a\u093e" },
            { "bik", "\u092c\u093f\u0915\u094b\u0932\u094d" },
            { "bin", "\u092c\u093f\u0928\u0940" },
            { "ho", "\u0939\u0940\u0930\u0940 \u092e\u094b\u091f\u0941" },
            { "hr", "\u0915\u094d\u0930\u094b\u090f\u0936\u0928\u094d" },
            { "ht", "\u0939\u093e\u0908\u0936\u0940\u092f\u0928\u094d" },
            { "hu", "\u0939\u0902\u0917\u0948\u0930\u0940\u092f\u0928\u094d" },
            { "hy", "\u0905\u0930\u092e\u0947\u0928\u093f\u092f\u0928\u094d" },
            { "hz", "\u0939\u0947\u0930\u0947\u0930\u094b" },
            { "%%FONIPA", "\u0906\u0908\u092a\u0940\u090f \u092b\u093c\u094b\u0928\u0947\u091f\u0940\u0915\u094d\u0938" },
            { "ia", "\u0908\u0928\u094d\u091f\u0930\u0932\u093f\u0902\u0917\u094d\u0935\u093e" },
            { "id", "\u0907\u0928\u094d\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u0928\u094d" },
            { "ie", "\u0908\u0928\u094d\u091f\u0930\u0932\u093f\u0902\u0917\u094d\u0935\u0947" },
            { "ig", "\u0908\u0917\u094d\u092c\u094b" },
            { "ii", "\u0938\u0940\u091a\u0941\u0906\u0928\u094d \u092f\u0940" },
            { "frm", "\u092e\u0927\u094d\u092f \u092b\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "ik", "\u0907\u0928\u0941\u092a\u093f\u092f\u093e\u0915\u093c\u094d" },
            { "fro", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092b\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "io", "\u0908\u0921\u094b" },
            { "frs", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092b\u094d\u0930\u0940\u091c\u093c\u093f\u092f\u0928\u094d" },
            { "frr", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092b\u094d\u0930\u0940\u091c\u093c\u093f\u092f\u0928\u094d" },
            { "is", "\u0906\u0908\u0938\u094d\u0932\u0948\u0902\u0921\u093f\u0915\u094d" },
            { "it", "\u0908\u091f\u093e\u0932\u093f\u092f\u0928\u094d" },
            { "iu", "\u0907\u0928\u0942\u0915\u094d\u091f\u0940\u091f\u0942\u0924\u094d" },
            { "ja", metaValue_ja },
            { "Mlym", "\u092e\u0932\u092f\u093e\u0932\u092e\u094d" },
            { "Sara", "\u0938\u0930\u093e\u0924\u0940" },
            { "doi", "\u0921\u094b\u0917\u0930\u0940" },
            { "sma", "\u092a\u0936\u094d\u091a\u0940\u092e\u0940 \u0938\u093e\u092e\u0940" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0936\u0947\u0935\u093f\u092f\u0928" },
            { "mad", "\u092e\u093e\u0926\u0941\u0930\u0940" },
            { "smj", "\u0932\u0941\u0932\u0947 \u0938\u093e\u092e\u0940" },
            { "mag", "\u092e\u0918\u0940" },
            { "mai", "\u092e\u0948\u0925\u0940\u0932\u0940" },
            { "smn", "\u0908\u0928\u093e\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "ka", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u0928\u094d" },
            { "bla", "\u0938\u0940\u0915\u0938\u0940\u0915\u093e" },
            { "mak", "\u092e\u0915\u094d\u0938\u0930" },
            { "sms", "\u0938\u094d\u0915\u094b\u0932\u094d\u091f\u094d \u0938\u093e\u092e\u0940" },
            { "man", "\u092e\u093e\u0902\u0921\u0940\u0902\u0917\u094b" },
            { "kg", "\u0915\u0949\u0902\u0917\u094b" },
            { "Goth", "\u0917\u094c\u0925\u0940\u0915" },
            { "ki", "\u0915\u093f\u0915\u0941\u092f\u0941" },
            { "mas", "\u092e\u0938\u093e\u0908" },
            { "kj", "\u0915\u0941\u0906\u0928\u092f\u093e\u092e\u093e" },
            { "kk", "\u0915\u093c\u091c\u093c\u093e\u0916\u093c\u094d" },
            { "kl", "\u0915\u0932\u093e\u0932\u0940\u0938\u0941\u0924" },
            { "km", metaValue_km },
            { "kn", "\u0915\u0928\u094d\u0928\u0921\u094d" },
            { "ko", "\u0915\u094b\u0930\u0940\u092f\u0928\u094d" },
            { "kr", "\u0915\u0928\u0941\u0930\u0940" },
            { "ks", "\u0915\u0936\u094d\u092e\u093f\u0930\u0940" },
            { "Cirt", "\u0938\u093f\u0930\u094d\u0925" },
            { "Lepc", "\u0932\u0947\u092a\u091a\u093e" },
            { "Avst", metaValue_ae },
            { "ku", "\u0915\u0941\u0930\u094d\u0926\u0940" },
            { "kv", "\u0915\u094b\u092e\u0940" },
            { "kw", "\u0915\u094c\u0930\u094d\u0928\u0935\u0949\u0932\u0940" },
            { "ky", "\u0915\u093f\u0930\u0917\u093c\u0940\u091c\u093c\u094d" },
            { "snk", "\u0938\u094b\u0928\u093f\u0902\u0917\u0915\u0947" },
            { "la", "\u0932\u0948\u091f\u0940\u0928\u094d" },
            { "lb", "\u0932\u0941\u0915\u094d\u0938\u092e\u092c\u0941\u0930\u094d\u0917\u0940" },
            { "lg", "\u0917\u093e\u0902\u0921\u093e" },
            { "Roro", "\u0930\u094b\u0902\u0917\u094b\u0930\u094b\u0902\u0917\u094b" },
            { "li", "\u0932\u0940\u0902\u092c\u0941\u0930\u094d\u0917\u0940" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0932\u093f\u0902\u0917\u093e\u0932\u093e" },
            { "fur", "\u092b\u094d\u0930\u0940\u0909\u0932\u0940\u0905\u0928\u094d" },
            { "lo", "\u0932\u093e\u0913\u0938\u0940\u092f\u0928\u094d" },
            { "lt", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u0928\u094d" },
            { "lu", "\u0932\u0941\u092c\u093e \u0915\u091f\u093e\u0902\u0917\u093e" },
            { "lv", "\u0932\u093e\u091f\u0935\u093f\u092f\u0928\u094d (\u0932\u0948\u091f\u094d\u091f\u0940\u0936)" },
            { "sog", "\u0938\u094b\u0917\u0921\u0940\u092f\u0928" },
            { "ListCompositionPattern", "{0},{1}" },
            { "mg", "\u092e\u093e\u0932\u093e\u0917\u093e\u0938\u0940" },
            { "mh", "\u092e\u093e\u0930\u094d\u0936\u0932\u0940" },
            { "mi", "\u092e\u093e\u0913\u0930\u0940" },
            { "mk", "\u092e\u0948\u0938\u0947\u0921\u094b\u0928\u093f\u092f\u0928\u094d" },
            { "ml", "\u092e\u0932\u092f\u093e\u0932\u092e" },
            { "mn", "\u092e\u094b\u0902\u0917\u094b\u0932\u093f\u092f\u0928" },
            { "mr", "\u092e\u0930\u093e\u0920\u0940" },
            { "ms", "\u092e\u0932\u093e\u092f" },
            { "mt", "\u092e\u093e\u0932\u091f\u0940\u091c\u093c\u094d" },
            { "my", "\u092c\u0930\u094d\u092e\u0940" },
            { "Saur", "\u0938\u094c\u0930\u093e\u0937\u094d\u091f\u094d\u0930" },
            { "Armn", "\u0905\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908" },
            { "mdf", "\u092e\u094b\u0915\u094d\u0937\u093e" },
            { "dsb", "\u0938\u094b\u0930\u094d\u092c\u093f\u092f\u0928\u094d" },
            { "Armi", "\u0936\u0939\u0928\u0936\u093e\u0939\u0940 \u0906\u0930\u093e\u092e\u093e\u0908\u0915" },
            { "na", "\u0928\u093e\u090a\u0930\u0942" },
            { "nb", "\u0928\u094b\u0930\u094d\u0935\u0947\u0917\u0940 \u092c\u094b\u0915\u092e\u093e\u0932" },
            { "nd", "\u0909\u0924\u094d\u0924\u0930 \u0928\u094d\u0926\u092c\u0947\u0932\u0947" },
            { "ne", "\u0928\u0947\u092a\u093e\u0932\u0940" },
            { "ng", "\u0928\u094d\u0921\u094b\u0902\u0917\u093e" },
            { "mdr", "\u092e\u0902\u0926\u093e\u0930" },
            { "nl", "\u0921\u091a\u094d" },
            { "nn", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u0928\u094d \u0928\u0940\u0928\u0949\u0930\u094d\u0938\u094d\u0915\u094d" },
            { "no", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u0940\u092f\u0928\u094d" },
            { "nr", "\u0926\u0915\u094d\u0937\u093f\u0923\u0940 \u0928\u094d\u0926\u092c\u0947\u0932\u0947" },
            { "nv", "\u0928\u093e\u0935\u093e\u0939\u094b" },
            { "kaa", "\u0915\u093e\u0930\u093e \u0915\u0932\u092a\u0915" },
            { "ny", "\u0928\u094d\u092f\u093e\u0928\u091c\u093e" },
            { "kac", "\u0915\u091a\u0940\u0928\u094d" },
            { "kab", "\u0915\u093e\u092c\u0940\u0932\u094d" },
            { "%%POLYTON", "\u092c\u0939\u0941\u0938\u094d\u0935\u0930\u0940\u092f" },
            { "oc", "\u0913\u0915\u094d\u0938\u0940\u0924\u093e\u0928" },
            { "kaj", "\u091c\u0941" },
            { "kam", "\u0915\u0902\u092c\u093e" },
            { "men", "\u092e\u0947\u0902\u0926\u0947" },
            { "oj", "\u0913\u0939\u0940\u092c\u0935\u093e" },
            { "om", "\u0913\u0930\u094b\u092e\u094b (\u0905\u092b\u093c\u093e\u0928)" },
            { "kaw", "\u0915\u093e\u0935\u0940" },
            { "or", metaValue_or },
            { "os", "\u0913\u0938\u094d\u0938\u0947\u091f\u0940" },
            { "kbd", "\u0915\u092c\u093e\u0930\u094d\u0921\u0940 \u092d\u093e\u0937\u093e" },
            { "srn", "\u0938\u094d\u0930\u0928\u093e\u0928\u094d \u091f\u0949\u0902\u0917\u094b" },
            { "pa", "\u092a\u0902\u091c\u093e\u092c\u0940" },
            { "dua", "\u0921\u0941\u0906\u0932\u093e" },
            { "srr", "\u0938\u0947\u0930\u0947\u0930" },
            { "%%LIPAW", "\u0930\u0947\u091c\u093c\u0940\u092f\u0928 \u0915\u0940 \u0932\u0940\u092a\u094b\u0935\u093e\u091c\u093c \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "pi", "\u092a\u093e\u0932\u0940" },
            { "pl", "\u092a\u094b\u0932\u093f\u0936" },
            { "dum", "\u092e\u0927\u094d\u092f \u0921\u091a" },
            { "ps", "\u092a\u0916\u093c\u094d\u0924\u0941" },
            { "pt", "\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "mga", "\u092e\u0927\u094d\u092f \u0906\u0908\u0930\u0940\u0936 \u092d\u093e\u0937\u093e" },
            { "key.co", "\u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "kcg", "\u0924\u094d\u092f\u093e\u092a\u094d" },
            { "bra", "\u092c\u094d\u0930\u091c" },
            { "key.ca", "\u092a\u0902\u091a\u093e\u0917" },
            { "Laoo", "\u0932\u093e\u0913" },
            { "qu", "\u0915\u094d\u0935\u0947\u091a\u0941\u0906" },
            { "zap", "\u091c\u093c\u093e\u092a\u094b\u0924\u0947\u0915" },
            { "brx", "\u092c\u0921\u093c\u094b" },
            { "Lana", "\u0932\u093e\u0928\u093e" },
            { "Ethi", "\u0908\u0925\u094b\u092a\u093f\u092f\u093e\u0908" },
            { "rm", "\u0930\u0947\u0939\u094d\u091f\u094b-\u0930\u094b\u092e\u093e\u0928\u094d\u0938" },
            { "rn", "\u0915\u093f\u0930\u0942\u0928\u094d\u0926\u0940" },
            { "key.cu", "\u092e\u0941\u0926\u094d\u0930\u093e" },
            { "ro", "\u0930\u0942\u092e\u093e\u0928\u0940\u092f\u0928\u094d" },
            { "%%SAAHO", "\u0938\u093e\u0939\u094b" },
            { "ru", "\u0930\u0941\u0938\u0940" },
            { "rw", "\u0915\u093f\u0928\u094d\u092f\u093e\u0930\u0941\u0906\u0923\u094d\u0921\u093e" },
            { "zbl", "\u092c\u094d\u0932\u0940\u0938 \u091a\u093f\u0928\u094d\u0939" },
            { "mic", "\u092e\u0940\u0915\u092e\u093e\u0915" },
            { "suk", "\u0938\u0941\u0915\u0941\u092e\u093e" },
            { "en_AU", "\u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940 (\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e \u0915\u093e)" },
            { "sa", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924\u094d" },
            { "sc", "\u0938\u093e\u0930\u094d\u0926\u0940\u0928\u0940" },
            { "sus", "\u0938\u0941\u0938\u0941" },
            { "sd", "\u0938\u093f\u0902\u0927\u0940" },
            { "se", "\u0909\u0924\u094d\u0924\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "min", "\u092e\u093f\u0928\u0902\u0917\u0915\u093e\u092c\u093e\u0909" },
            { "sg", "\u0938\u093e\u0902\u0917\u094d\u0930\u094b" },
            { "sh", "\u0938\u0930\u094d\u092c\u094b-\u0915\u094d\u0930\u094b\u090f\u0936\u0928\u094d" },
            { "si", "\u0938\u0940\u0902\u0939\u093e\u0932\u093e" },
            { "sux", "\u0938\u0941\u092e\u0947\u0930\u093f\u0905\u0928" },
            { "sk", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915\u094d" },
            { "sl", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u0928\u094d" },
            { "sm", "\u0938\u093e\u092e\u094b\u0905\u0928" },
            { "sn", "\u0936\u094b\u0928\u093e" },
            { "so", "\u0938\u094b\u092e\u093e\u0932\u0940" },
            { "sq", "\u0906\u0932\u094d\u092c\u0947\u0928\u093f\u092f\u0928\u094d" },
            { "sr", "\u0938\u0930\u094d\u092c\u093f\u092f\u0928\u094d" },
            { "ss", "\u0938\u094d\u0935\u093e\u091f\u093f" },
            { "Java", metaValue_jv },
            { "su", "\u0938\u0941\u0928\u094d\u0926\u093e\u0928\u0940" },
            { "%%NEDIS", "\u0928\u093e\u091f\u0940\u0938\u094b\u0928 \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "sv", "\u0938\u094d\u0935\u0940\u0921\u093f\u0936" },
            { "sw", "\u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "iba", "\u0908\u092c\u093e\u0928\u094d" },
            { "ta", "\u0924\u092e\u093f\u0933" },
            { "142", "\u090f\u0936\u093f\u092f\u093e" },
            { "bua", "\u092c\u0941\u0930\u093f\u092f\u093e\u0924" },
            { "143", "\u092e\u0927\u094d\u092f \u090f\u0936\u093f\u092f\u093e" },
            { "te", metaValue_te },
            { "145", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0910\u0936\u093f\u092f\u093e" },
            { "tg", "\u0924\u093e\u091c\u093f\u0915\u094d" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "\u0924\u093f\u0917\u094d\u0930\u0940\u0928\u094d\u092f\u093e" },
            { "kfo", "\u0915\u094b\u0930\u094b" },
            { "en_CA", "\u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940 (\u0915\u0928\u093e\u0921\u093e\u0908)" },
            { "tk", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928" },
            { "tl", "\u0924\u093e\u0917\u093e\u0932\u094b\u0917" },
            { "tn", "\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "to", metaValue_TO },
            { "tr", metaValue_TR },
            { "ts", "\u0938\u094b\u0902\u0917\u093e" },
            { "tt", "\u091f\u093e\u091f\u0930\u094d" },
            { "dyu", "\u0926\u094d\u092f\u0941\u0906\u0932\u093e" },
            { "tw", "\u091f\u094d\u0935\u0940" },
            { "ty", "\u091f\u093e\u0939\u093f\u091f\u093f" },
            { "%%BISKE", "\u0938\u093e\u0928 \u091c\u0940\u0913\u0930\u094d\u091c\u0940\u0913 / \u092c\u0940\u0932\u093e \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "150", "\u092f\u0942\u0930\u094b\u092a" },
            { "151", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "154", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092f\u0942\u0930\u094b\u092a" },
            { "155", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092f\u0942\u0930\u094b\u092a\u094d" },
            { "ug", "\u0909\u0908\u0917\u093c\u0941\u0930" },
            { "Ital", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0907\u091f\u0948\u0932\u093f\u092f\u0928" },
            { "Kore", "\u0915\u094b\u0930\u093f\u092f\u093e\u0908" },
            { "Zyyy", "\u0906\u092e" },
            { "uk", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928\u093f\u092f\u0928\u094d" },
            { "ur", "\u090a\u0930\u094d\u0926\u0941" },
            { "%%1994", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u0930\u0947\u0938\u0940\u092f\u0928 \u0935\u0930\u094d\u0924\u0928\u0940 1994" },
            { "xal", "\u0915\u093e\u0932\u092e\u0940\u0915" },
            { "zen", "\u091c\u093c\u0947\u0928\u093e\u0917\u093e" },
            { "uz", "\u0909\u091c\u093c\u092c\u0947\u0915\u094d" },
            { "kha", "\u0916\u093c\u093e\u0938\u0940" },
            { "%%1996", "\u091c\u0930\u094d\u092e\u0928 \u0935\u0930\u094d\u0924\u0928\u0940 1996" },
            { "Sylo", "\u0938\u0940\u0932\u094d\u0939\u094b\u091f\u0940 \u0928\u093e\u0917\u0930\u0940" },
            { "ve", "\u0935\u0947\u0902\u0921\u093e" },
            { "type.ca.roc", "\u091a\u0940\u0928\u0940 \u0917\u0923\u0924\u0902\u0924\u094d\u0930 \u092a\u0902\u091a\u093e\u0902\u0917" },
            { "vi", "\u0935\u093f\u092f\u0947\u0924\u0928\u093e\u092e\u0940" },
            { "kho", "\u0916\u093c\u094b\u0924\u093e\u0928\u0940" },
            { "%%TARASK", "\u0924\u093e\u0930\u093e\u0938\u094d\u0915\u0940\u090f\u0935\u0940\u091a\u093e \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "vo", "\u0935\u094b\u0932\u093e\u092a\u094b\u0915" },
            { "syc", "\u092a\u093e\u0930\u0902\u092a\u0930\u0940\u0915 \u0938\u093f\u0930\u093f\u0906\u0915" },
            { "Osma", "\u0913\u0938\u094d\u092e\u093e\u0928\u093f\u092f\u093e" },
            { "gaa", "\u0917\u093e" },
            { "wa", "\u0935\u093e\u0932\u0941\u0928" },
            { "syr", "\u0938\u093f\u0930\u093f\u0906\u0915" },
            { "Grek", metaValue_el },
            { "Lydi", "\u0932\u0940\u0921\u0940\u092f\u0928" },
            { "Xsux", "\u0938\u0941\u092e\u0947\u0930\u094b \u0905\u0915\u094d\u0915\u093e\u0921\u093c\u0940 \u0915\u0941\u0928\u0947\u0908\u092b\u0949\u0930\u094d\u092e" },
            { "wo", "\u0935\u094b\u0932\u094b\u092b" },
            { "Cans", "\u092f\u0941\u0928\u0940\u092b\u093e\u0908\u0921 \u0915\u0948\u0928\u0947\u0921\u093f\u092f\u0928 \u0905\u092c\u0949\u0930\u0940\u091c\u0940\u0928\u0932 \u0938\u0940\u0932\u0948\u092c\u0940\u0915\u094d\u0938" },
            { "gay", "\u0917\u093e\u092f\u094b" },
            { "Mong", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e\u0908" },
            { "mnc", "\u092e\u093e\u0902\u091a\u0941" },
            { "Latf", "\u092b\u094d\u0930\u0948\u0915\u094d\u0924\u0941\u0930 \u0932\u0948\u091f\u093f\u0928" },
            { "gba", "\u0917\u094d\u092c\u093e\u092f\u093e" },
            { "mni", "\u092e\u0923\u0940\u092a\u0941\u0930\u0940" },
            { "Latn", "\u0932\u0948\u091f\u093f\u0928" },
            { "Latg", "\u0917\u0948\u0932\u0940\u0915 \u0932\u0948\u091f\u093f\u0928" },
            { "xh", "\u0916\u093c\u094b\u0938\u093e" },
            { "byn", "\u092c\u094d\u0932\u0940\u0928" },
            { "Lyci", "\u0932\u0940\u0938\u0940\u092f\u0928" },
            { "osa", "\u0913\u0938\u0947\u091c" },
            { "Moon", "\u092e\u0941\u0928\u094d" },
            { "moh", "\u092e\u094b\u0939\u094b\u0915" },
            { "yi", "\u092f\u0940\u0926\u094d\u0926\u0940\u0936" },
            { "mos", "\u092e\u094b\u0938\u094d\u0938\u0940" },
            { "Syrc", "\u0938\u0940\u0930\u0940\u0906\u0915" },
            { "Dsrt", "\u0926\u0947\u0938\u0947\u0930\u091f\u094d" },
            { "yo", "\u092f\u094b\u0930\u0942\u092c\u093e" },
            { "Syrj", "\u092a\u0936\u094d\u091a\u0940\u092e\u0940 \u0938\u0940\u0930\u0940\u0906\u0915" },
            { "ota", "\u0924\u0941\u0930\u094d\u0915\u0940 \u0913\u091f\u094b\u092e\u093e\u0928" },
            { "Syre", "\u090f\u0938\u094d\u091f\u094d\u0930\u093e\u0902\u0917\u0932\u094b \u0938\u0940\u0930\u0940\u0906\u0915" },
            { "vai", metaValue_vai },
            { "za", "\u091c\u093c\u0941\u0906\u0902\u0917" },
            { "Cari", "\u0915\u093e\u0930\u093f\u092f\u0928" },
            { "zh", "\u091a\u0940\u0928\u0940" },
            { "Bopo", "\u092c\u094b\u092a\u094b\u092e\u094b\u092b\u094b" },
            { "Perm", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092a\u0930\u094d\u092e\u0940\u0915\u094d" },
            { "zu", "\u091c\u093c\u0941\u0932\u0942" },
            { "type.co.phonebook", "\u0926\u0942\u0930\u092d\u093e\u0937 \u0928\u093f\u0930\u094d\u0926\u0947\u0936\u093f\u0915\u093e \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "%%MONOTON", "\u090f\u0915\u0938\u094d\u0935\u0930\u0940\u092f" },
            { "Geor", "\u091c\u094b\u0930\u094d\u091c\u0940\u092f\u0928" },
            { "kmb", "\u0915\u0940\u0902\u092c\u0941\u0902\u0921\u0941" },
            { "Cham", "\u0915\u0945\u092e" },
            { "gez", "\u0917\u0940\u091c\u093c\u094d" },
            { "Syrn", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0938\u0940\u0930\u0940\u0906\u0915" },
            { "Tglg", "\u091f\u093e\u0917\u093e\u0932\u0949\u0917" },
            { "Egyd", "\u092e\u0940\u0938\u094d\u0930\u0940 \u0921\u0948\u092e\u094b\u091f\u0940\u0915\u094d" },
            { "Egyh", "\u092e\u0940\u0938\u094d\u0930\u0940 \u0939\u0948\u0930\u0948\u091f\u0940\u0915\u094d" },
            { "Egyp", "\u092e\u0940\u0938\u094d\u0930\u0940 \u0939\u0948\u0930\u094b\u0917\u094d\u0932\u0940\u092b\u093c\u094d" },
            { "Geok", "\u091c\u094b\u0930\u094d\u091c\u0940\u092f\u0928 \u0916\u0941\u0924\u0938\u0941\u0930\u0940" },
            { "zh_Hans", "\u091a\u0940\u0928\u0940 (\u0938\u0930\u0932\u0940\u0915\u0943\u0924)" },
            { "Hung", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0939\u0902\u0917\u0948\u0930\u0940\u092f\u0928" },
            { "kok", "\u0915\u094b\u0902\u0915\u0923\u0940" },
            { "%%1901", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u091c\u0930\u094d\u092e\u0928 \u0935\u0930\u094d\u0924\u0928\u0940 1901" },
            { "kos", "\u0915\u094b\u0938\u094d\u0930\u093e\u0908\u092f\u0928\u094d" },
            { "zh_Hant", "\u091a\u0940\u0928\u0940 (\u092a\u093e\u0930\u092e\u094d\u092a\u0930\u093f\u0915)" },
            { "Sund", "\u0938\u0942\u0921\u093e\u0928\u0940" },
            { "kpe", "\u0915\u094d\u092a\u0947\u0932\u0947" },
            { "ilo", "\u0908\u0932\u094b\u0915\u094b" },
            { "Cprt", "\u0938\u0940\u092a\u094d\u0930\u0940\u0913\u091f\u094d" },
            { "%%BAKU1926", "\u092f\u0941\u0928\u0940\u092b\u093e\u0908\u0921 \u0924\u0941\u0930\u094d\u0915\u0940 \u0932\u0948\u091f\u0940\u0928\u0940 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "cad", "\u0915\u093e\u0926\u094d\u0926\u094c" },
            { "mus", "\u0915\u094d\u0930\u0940\u0915" },
            { "Glag", "\u0917\u094d\u0932\u0948\u0917\u094b\u0932\u093f\u091f\u0940\u0915" },
            { "gil", "\u0917\u0940\u0932\u092c\u0930\u094d\u091f\u0940" },
            { "Cher", "\u091a\u093f\u0930\u0942\u0915\u0940" },
            { "car", "\u0915\u093e\u0930\u0940\u092c\u094d" },
            { "krc", "\u0915\u0930\u093e\u091a\u092f\u094d \u092c\u0932\u0915\u093e\u0930\u094d" },
            { "inh", "\u0908\u0902\u0917\u0941\u0937" },
            { "krl", "\u0915\u0930\u0947\u0932\u093f\u092f\u0928\u094d" },
            { "efi", "\u090f\u092b\u0940\u0915\u094d" },
            { "kru", "\u0915\u0941\u0930\u0941\u0916\u093c\u094d" },
            { "Telu", metaValue_te },
        };
        return data;
    }
}
