#!/usr/bin/env python

# Return the cvs repository - see CVS/Repository.
def GetCVSRepository():
    try:
	fp = open('CVS/Root', 'r')
    except:
        try:
            # should search but we cheat.
            fp = open('pcl/CVS/Root', 'r')
        except:
	    print "Error: Cannot find CVS Root"
            return None
    # get the Root name and strip off the newline
    repos = fp.readline()[:-1]
    fp.close()
    return repos

# extract root repository directory name this is just the CVS root
# directory without server and account information
def GetCVSRootDirName():
    import string
    root = GetCVSRepository()
    # search first / to end of string
    return root[string.find(root, "/") - 1:]

# figure out what day it is given year month and day
def weekday(year, month, day):
    import time
    seconds = time.mktime((year, month, day, 0, 0, 0, 0, 0, 0))
    tm = time.localtime(seconds)
    return tm[6]


# convert an rcs time to a tuple that C/python time functions can work
# with.  No error checking here.  Precision to hours only.
def RcsDate2CtimeTuple(date_data):
    import string
    tmp_date = string.splitfields(date_data, ' ')
    date = tmp_date[0]
    time = tmp_date[1]
    try:
        (year, month, day) = string.splitfields(date, '/')
    except:
        (year, month, day) = string.splitfields(date, '-')
    (hours, mins, secs) = string.splitfields(time, ':')
    year = string.atoi(year)
    month = string.atoi(month)
    day = string.atoi(day)
    hours = string.atoi(hours)
    return (year, month, day, hours, 0, 0, weekday(year, month, day), 0, 0)

# get the last date from a log file return the time tuple of the last
# log entry or return or return Jan 1, 1970.  This date is the start
# point for logging
def LastLogDate2CtimeTuple(filename):
    import string
    day_abbr = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
    month_abbr = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
    date_tuple = (1970, 1, 1, 0, 0, 0, 0, 0, 0)
    try:
	fp = open(filename, 'r')
    except:
	print "couldn't open log file: " + filename
	return date_tuple
    while 1:
	line = fp.readline()
	if not line:
	    break
	# we could test more but ...
	if line[0:3] in day_abbr and line[4:7] in month_abbr and (0 <= string.atoi(string.strip(line[8:10])) <= 31):
	    (dd, mm, dn, t, yy) = string.split(line[:24])
	    (th, tm, ts) =  string.splitfields(t, ':')
	    dd=day_abbr.index(dd)
	    yy=string.atoi(yy)
            mm=month_abbr.index(mm) + 1
	    dn=string.atoi(dn)
	    th=string.atoi(th)
	    tm=string.atoi(tm)
	    date_tuple = (yy, mm, dn, th, tm, 0, dd, 0, 0)
	    break
    return date_tuple

# build a date, time, author, email address header.
def ChangeLogDateNameHeader(date, author, hostname, tabsize):
    import time, pwd
    seperator1 = ' ' * tabsize
    seperator2 = ' ' * (tabsize / 2)
    try:
	author_name = pwd.getpwnam(author)[4]
    except:
	author_name = ''
    return time.asctime(date) + ' GMT' + seperator1 + author_name +\
	   seperator2 + author + '@' + hostname + '\n'

def BuildPatch(revision, rcs_file):
    import os, string
    # NB this needs work we only handle the special cases here.
    rev_int_str = revision[:string.find(revision, '.')]
    rev_frac_str = revision[string.find(revision, '.')+1:]
    try:
        prev_frac_int = string.atoi(rev_frac_str) - 1;
    except:
        return "the patch must be created manually"
    prev_revision = rev_int_str + '.' + `prev_frac_int`
    patch_command = 'cvs diff -C2 -r' + revision + ' -r' + prev_revision + ' ' + rcs_file
    return os.popen(patch_command, 'r').readlines()
        

# build change log entries with file name, revisions, etc. lumping
# like descriptions together.  We assume the dictionary contains data.
def ChangeLogFileRevDesc(entry_dict, indent, line_length, patch):
    leading_space = ' ' * indent

    change_log_entry = ''
    pos = 0
    for description in entry_dict.keys():
	change_log_entry = change_log_entry + leading_space + '* '
	pos = len(leading_space + '* ')
	# get the revisions and rcs files associated with the
	# description.
	for revision, rcs_file, lines_changed in entry_dict[description]:
	    # NB do a better wrapping job.
	    if pos > line_length:
		change_log_entry = change_log_entry + '\n' + leading_space
		pos = len(leading_space)
	    change_log_entry = change_log_entry + rcs_file + ' [' + revision + ']' + ' (' + lines_changed[:-1] + ')' + ', '
            pos = pos + len(rcs_file + ' [' + revision + ']' + ' (' + lines_changed[:-1] + ')' + ', ')
	# replace last ', ' with a semicolon - strings are immutable so
	# an inplace assignment won't do.
	change_log_entry = change_log_entry[:-2] + ':\n'
	# add on the current description
	change_log_entry = change_log_entry + description + '\n'
        # add on the patches if necessary
        if ( patch == 1 ):
            for revision, rcs_file, lines_changed in entry_dict[description]:
                for patch_line in BuildPatch(revision, rcs_file):
                    change_log_entry = change_log_entry + patch_line
    return change_log_entry

def Revision(line):
    return line[len("revision "):]

def WorkingFile(line):
    return line[len("Working file: "):]

def DateAuthorStateLinesChanged(line, revision, rcs_file):
    import string
    # sample log line - date: 2000/03/15 06:45:34; author: \
    # henrys; state: Exp; lines: +7 -1
    (dd, aa, ss, ll) = string.splitfields(line, ';')
    (foo, date) = string.splitfields(dd, ': ')
    (foo, author) = string.splitfields(aa, ': ')
    (foo, state) = string.splitfields(ss, ': ')
    try:
        (foo, lines_changed) = string.splitfields(ll, ': ')
    except:
        # lines changed does not exist in the initial revision
        lines_changed = "+0 -0" + "\n"
        expensive_lines_changed = 0
        if ( expensive_lines_changed == 1 ):
            import os
            lines_changed = ""
            initial_rev_line_count_command = 'cvs -d ' + GetCVSRepository() + ' update  -r ' + revision[:-1] + ' -p ' + rcs_file[:-1] + ' 2>/dev/null | wc -l';
            lines_changed = os.popen(initial_rev_line_count_command, 'r').readline()[:-1]
            lines_changed = "+" + lines_changed.lstrip() + " -0" + "\n"
    return (date, author, state, lines_changed)

# Build the cvs log.
def BuildLog(log_date_command):
    import os, string, sys
    reading_description = 0
    description = []
    log = []
    # start reading cvs log output putting what we need in the log
    # list
    logpipe = os.popen(log_date_command, 'r')
    while (1):
        line = logpipe.readline()
        if not line:
            break
	if line[:5] == '=====' or line[:5] == '-----':
	    if description != []:
		# append these items in the sort order we'll want later on.
                # we skip branches entirely.
                if ( revision.count(".") == 1 ):
                    log.append((RcsDate2CtimeTuple(date), author, description,
                                rcs_file[:-1], revision[:-1], state, lines_changed))
	    reading_description = 0
	    description = []
	elif not reading_description and line[:len("Working file: ")] == "Working file: ":
	    rcs_file = WorkingFile(line)
	elif not reading_description and line[:len("revision ")] == "revision ":
	    revision = Revision(line)
	elif not reading_description and line[:len("date: ")] == "date: ":
            date, author, state, lines_changed = DateAuthorStateLinesChanged(line, revision, rcs_file)
	    reading_description = 1
	elif reading_description:
	    description.append(line)
	else:
	    continue
    return log

def PrintLog(log, hostname, tabwidth, indent, length, patches):
    # Pass through the logs creating new entries based on changing
    # authors, dates and descriptions.
    last_date = None
    last_author = None
    entry_dict = {}
    for date, author, description, rcs_file, revision, state, lines_changed in log:
	if author != last_author or date != last_date:
	    # clear out any old revisions, descriptions, and filenames
	    # that belong with the last log.
	    if entry_dict:
		print ChangeLogFileRevDesc(entry_dict, indent, length, patches)
	    # clear the entry log for the next group of changes
	    # if we have a new author or date we print a date, time,
	    # author, and email address.
	    entry_dict = {}
	    print ChangeLogDateNameHeader(date, author, hostname, tabwidth)
	# build string from description list so we can use it as a key
	# for the entry dictionary
	description_data = indent * ' '
	for line in description:
	    description_data = description_data + line + indent * ' '
	# put the revisions and rcs files in decription-keyed
	# dictionary.
	if entry_dict.has_key(description_data):
	    entry_dict[description_data].append((revision, rcs_file, lines_changed))
	else:
	    entry_dict[description_data] = [(revision, rcs_file, lines_changed)]

	last_author = author
	last_date = date
	last_description = description

    # print the last entry if there is one (i.e. the last two entries
    # have the same author and date)
    if entry_dict:
	print ChangeLogFileRevDesc(entry_dict, indent, length, patches)
    
def main():
    import sys, getopt, time, string, socket
    try:
	opts, args = getopt.getopt(sys.argv[1:], "d:i:h:l:u:r:Rt:pL:",
				   ["date",
                                    "indent",
				    "hostname",
				    "length",
				    "user",
				    "rlog_options", #### not yet supported
				    "Recursive",    #### not yet supported
				    "tabwidth",
				    "patches",        #### not yet supported
				    "Logfile"])

    except getopt.error, msg:
	sys.stdout = sys.stderr
	print msg
	print "Usage: Options:"
	print "[-h hostname] [-i indent] [-l length] [-R]"
	print "[-r rlog_option] [-d rcs date]\n[-t tabwidth] [-u 'login<TAB>fullname<TAB>mailaddr']..."
	sys.exit(2)

    # Set up defaults for all of the command line options.
    cvsrepository=GetCVSRepository()
    if not cvsrepository:
	print "cvs2log.py must be executed in a working CVS directory"
	sys.exit(2)
    indent=8
    hostname=socket.gethostname()
    length=63
    user=0
    recursive=0
    tabwidth=8
    rlog_options=0
    logfile=None
    date_option = ""
    diffs=1
    patches=0
    # override defaults if specified on the command line
    for o, a in opts:
	if o == '-h' : hostname = a
	elif o == '-i' : indent = a
	elif o == '-l' : length = a
	elif o == '-t' : tabwidth = a
	elif o == '-u' : user = a
	elif o == '-r' : rlog_options = a
	elif o == '-R' : recursive = 1
        elif o == '-d' : date_option = "-d " + "'" + a + "'"
	elif o == '-L' : logfile = a
        elif o == '-p' : patches = 1
	else: print "getopt should have failed already"

    # getopts should have left any filenames behind - convert those to
    # one string.
    filenames = ""
    for file in args:
        filenames = filenames + " " + file
    # set up the cvs log command arguments.  If a logfile is specified
    # we get all dates later than the logfile.
    if logfile:
	date_option = "'" + "-d>" + time.asctime(LastLogDate2CtimeTuple(logfile)) + "'"
    log_date_command= 'cvs -d ' + GetCVSRepository() + ' -Q log -N ' + date_option + filenames
    # build the logs.
    log = BuildLog(log_date_command)
    # chronologically reversed.  We reverse everything in the list as
    # well.
    log.sort()
    log.reverse()
    PrintLog(log, hostname, tabwidth, indent, length, patches)

if __name__ == '__main__':
    main()
