| Source:  bnumexpr.dtx
| Version: v1.7b, 2025/09/27
| Author:  Jean-François Burnol
| Info:    Expressions with big integers
| License: LPPL 1.3c

Usage and aim
=============

The package provides `\bnumeval`.

To use with LaTeX, add `\usepackage{bnumexpr}` to the preamble.
To use with Plain TeX, execute `\input miniltx.tex` then
`\input bnumexpr.sty`.

`\bnumeval` is an expandable expression parser extending
LaTeX's `\inteval` (a wrapper of eTeX's `\numexpr`).

Compared to `\inteval`, the added functionalities are:

- support for arbitrarily big integers,
- `//` for floored division,
- `/:` for the associated remainder,
- `^` and `**` for powers,
- `!` for factorials,
- comma separated calculations,
- space character or underscore may serve to separate digits,
- `0b`, `0o` and `0x` are recognized as prefixes for binary, octal,
  and hexadecimal inputs (in addition to the TeX prefixes `'` and `"`),
- letters used for hexadecimal input may be in lowercase,
- optional argument `[b]`, `[o]` or `[h]` for converting the output
  to binary, octal, or hexadecimal (`[ha]` for lowercase hexadecimal),
- quasi complete customizability and extensibility of the syntax.

The last item means that not only is it possible to map any given
operation to a macro of one's own choosing, it is also possible to add
new infix or postfix operators to the syntax.

Installation
============

The package is provided by the major LaTeX distributions.

For a manual installation  obtain `bnumexpr.dtx`, from CTAN:

> <http://www.ctan.org/pkg/bnumexpr>

Run `"etex bnumexpr.dtx"` to extract in particular the style file
`bnumexpr.sty` (and other files inclusive of this `README.md`).  Put it
where (La)TeX can find it and you are done.

To build the documentation check the instructions in extracted
file `bnumexpr.tex`.

License
=======

Copyright © 2014-2022, 2025 Jean-François Burnol

| This Work may be distributed and/or modified under the
| conditions of the LaTeX Project Public License 1.3c.
| This version of this license is in

>   <http://www.latex-project.org/lppl/lppl-1-3c.txt>

| and version 1.3 or later is part of all distributions of
| LaTeX version 2005/12/01 or later.

This Work has the LPPL maintenance status "author-maintained".

The Author and Maintainer of this Work is Jean-François Burnol.

This Work consists of the main source file and its derived files

    bnumexpr.dtx, bnumexpr.sty, bnumexpr.pdf, bnumexpr.tex,
    bnumexprchanges.tex, README.md

