/*
** OPTIONS.C - This is the ODBC sample driver code for
** executing Set/GetConnect/StmtOption.
**
**	This code is furnished on an as-is basis as part of the ODBC SDK and is
**	intended for example purposes only.
**
*/

//	-	-	-	-	-	-	-	-	-

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gorta.h"
#include "states.h"

RETCODE SQL_API SQLSetConnectOption(
	HDBC	hdbc,
	UWORD	fOption,
	UDWORD	vParam)
{
	RETCODE retcode = SQL_SUCCESS;
	LPEI lpeiTmp;
	LPDBC lpdbc;
	
	lpdbc = (LPDBC)hdbc;
	
	switch (fOption)
	{
	case SQL_LOGIN_TIMEOUT:
		break;
	case SQL_AUTOCOMMIT:
		break;
	default:
		// Unsupported function
		retcode = SQL_ERROR;
		lpeiTmp = malloc(sizeof(EI));
		if (!lpeiTmp)
		{
			retcode = SQL_ERROR;
			goto Exit;
		}
		lpeiTmp->pNext = lpdbc->lpei;
		lpeiTmp->lErrorCode=-1;
		strncpy(lpeiTmp->szSqlState, MSQL_NOT_SUPPORTED, 5);
		sprintf(lpeiTmp->szErrorMessage, 
			"[MSQLODBC]SQLSetConnectOption option [%d] not supported ", fOption);
		lpdbc->lpei=lpeiTmp;
		goto Exit;
	}
	
Exit:
	return(retcode);
}

//	-	-	-	-	-	-	-	-	-

RETCODE SQL_API SQLSetStmtOption(
	HSTMT	hstmt,
	UWORD	fOption,
	UDWORD	vParam)
{
	RETCODE retcode = SQL_SUCCESS;
	LPEI lpeiTmp;
	LPSTMT lpstmt;

	lpstmt = hstmt;
	switch (fOption)
	{
	case SQL_AUTOCOMMIT_OFF:
	case SQL_AUTOCOMMIT_ON:
		break; 
	default:	
		// Unsupported function
		retcode = SQL_ERROR;
		lpeiTmp = malloc(sizeof(EI));
		if (!lpeiTmp)
		{
			retcode = SQL_ERROR;
			goto Exit;
		}
		lpeiTmp->pNext = lpstmt->lpei;
		lpeiTmp->lErrorCode=-1;
		strncpy(lpeiTmp->szSqlState, MSQL_NOT_SUPPORTED, 5);
		sprintf(lpeiTmp->szErrorMessage, 
			"[MSQLODBC]SQLSetStmtOption option [%d] not supported ", fOption);
		lpstmt->lpei=lpeiTmp;
		goto Exit;
	}
	
Exit:
	return(retcode);
}

//	-	-	-	-	-	-	-	-	-

RETCODE SQL_API SQLGetConnectOption(
	HDBC	hdbc,
	UWORD	fOption,
	PTR     pvParam)
{
	RETCODE retcode = SQL_SUCCESS;
	LPEI lpeiTmp;
	LPDBC lpdbc;
	
	lpdbc = (LPDBC)hdbc;
	
	// Unsupported function
	retcode = SQL_ERROR;
	lpeiTmp = malloc(sizeof(EI));
	if (!lpeiTmp)
	{
		retcode = SQL_ERROR;
		goto Exit;
	}
	lpeiTmp->pNext = lpdbc->lpei;
	lpeiTmp->lErrorCode=-1;
	strncpy(lpeiTmp->szSqlState, MSQL_NOT_SUPPORTED, 5);
	sprintf(lpeiTmp->szErrorMessage, 
		"[MSQLODBC]SQLGetConnectOption option [%d] not supported ", fOption);
	lpdbc->lpei=lpeiTmp;
	goto Exit;
	
Exit:
	return(retcode);
}

//	-	-	-	-	-	-	-	-	-

RETCODE SQL_API SQLGetStmtOption(
	HSTMT	hstmt,
	UWORD	fOption,
	PTR     pvParam)
{
	RETCODE retcode = SQL_SUCCESS;
	LPEI lpeiTmp;
	LPSTMT lpstmt;

	lpstmt = hstmt;
	
	// Unsupported function
	retcode = SQL_ERROR;
	lpeiTmp = malloc(sizeof(EI));
	if (!lpeiTmp)
	{
		retcode = SQL_ERROR;
		goto Exit;
	}
	lpeiTmp->pNext = lpstmt->lpei;
	lpeiTmp->lErrorCode=-1;
	strncpy(lpeiTmp->szSqlState, MSQL_NOT_SUPPORTED, 5);
	sprintf(lpeiTmp->szErrorMessage, 
		"[MSQLODBC]SQLGetStmtOption option [%d] not supported ", fOption);
	lpstmt->lpei=lpeiTmp;
	goto Exit;
	
Exit:
	return(retcode);
}

//	-	-	-	-	-	-	-	-	-
