
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>

#include "fdefs.h"

int gx_sm256(palette,fmat)
unsigned char palette[PALBUFSIZE][3];
float fmat[][3];
{
	int i,i1,iptr;
	float fpal[PALBUFSIZE][3];
	float ka,kd,ks;
	float mt[20];
	float r,g,b;
	float ns;

	ka = fmat[KCO][0];
	kd = fmat[KCO][1];
	ks = fmat[KCO][2];

	ns = fmat[NSV][0];

	for(i=0; i<PALBUFSIZE; i++){
		r = (float)palette[i][0];
		g = (float)palette[i][1];
		b = (float)palette[i][2];
		fpal[i][0] = r / 255.0;
		fpal[i][1] = g / 255.0;
		fpal[i][2] = b / 255.0;
	}

	for(i=0; i<PALBUFSIZE; i++){
		i1 = i + 1;
		iptr = 0;
		mt[iptr++] = (float)SPECULAR;

		mt[iptr++] = ks * fmat[LCO][0];
		mt[iptr++] = ks * fmat[LCO][1];
		mt[iptr++] = ks * fmat[LCO][2];
/*
		mt[iptr++] = ks * fpal[i][0];
		mt[iptr++] = ks * fpal[i][1];
		mt[iptr++] = ks * fpal[i][2];
*/
		mt[iptr++] = (float)DIFFUSE;
		mt[iptr++] = kd * fpal[i][0];
		mt[iptr++] = kd * fpal[i][1];
		mt[iptr++] = kd * fpal[i][2];
		mt[iptr++] = (float)SHININESS;
		mt[iptr++] = ns;
		mt[iptr++] = (float)AMBIENT;
		mt[iptr++] = ka * fpal[i][0];
		mt[iptr++] = ka * fpal[i][1];
		mt[iptr++] = ka * fpal[i][2];
		mt[iptr++] = LMNULL;
		lmdef(DEFMATERIAL, i1, iptr, mt);
	}

	return(0);
}
