
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include "df.h"

#define NOPTS 1
#define MINARGS 3

#define PALBUFSIZE 256

main(argc,argv)
int argc;
char *argv[];
{
	char *pname,*pstr;
	float pver;
	unsigned short dev_month,dev_year;
	int err_ret,nopts,nargs;
	char pstat;
	char *opt_array[NOPTS],*opt_desc[NOPTS];
	int opt_loc[NOPTS];

	char *imgfile_in,*imgfile_out,*imgcmd;
	unsigned char *ibuf,*obuf,palette[PALBUFSIZE][3],gpal[PALBUFSIZE][3];
	int x,y,z;
	int xsize,ysize,zsize,ibits,ispal,pil;
	int num_bytes;
	register int i;

	pname = "rtobw";
	pver = 1.00;
	dev_month = 5;
	dev_year = 1990;
	pstat = 'P';
	pstr = "public domain software";

	opt_desc[0] = "rtobw <rimg_in> <r8bwimg_out>";
	opt_array[0] = opt_desc[0];
	nopts = NOPTS;

	err_ret = prog_title(pname,pver,dev_month,dev_year,pstat,pstr);

	if (argc < MINARGS){
		err_ret = prog_opts(nopts,opt_array,opt_desc);
		exit(1);
	}

	if (argc > MINARGS)
		err_ret = opt_index(argv,opt_array,argc,nopts,opt_loc);

	imgfile_in  = argv[argc-2];
	imgfile_out = argv[argc-1];

	for(i=0; i < PALBUFSIZE; i++){
		gpal[i][0] = (unsigned char)i;
		gpal[i][1] = (unsigned char)i;
		gpal[i][2] = (unsigned char)i;
	}

Hdf8:
	zsize = 1;
	err_ret = DFR8getdims(imgfile_in,&xsize,&ysize,&ispal);
	if(err_ret) goto Hdf24;
	else{
		num_bytes = xsize * ysize * zsize;
		ibuf = (unsigned char *)malloc(num_bytes);
		if (!ibuf){
			printf("%s: Not enough memory\n",imgfile_in);
			exit(1);
		}
		err_ret = DFR8getimage(imgfile_in,ibuf,xsize,ysize,palette);
		if(err_ret){
			printf("%s: Error with DFR8getimage\n",imgfile_in);
			exit(1);
		}
		num_bytes = xsize * ysize;
		obuf = (unsigned char *)malloc(num_bytes);
		if(!obuf){
			printf("%s: Not enough memory\n",imgfile_out);
			exit(1);
		}
		err_ret = img8_tobw(ibuf,obuf,xsize,ysize,palette);

		DFR8setpalette(gpal);
		err_ret = DFR8putimage(imgfile_out,obuf,xsize,ysize,DFTAG_RLE);
		if (err_ret){
			printf("%s: Error with DFR8putimage\n",imgfile_out);
			exit(1);
		}
	
		free(obuf);
		free(ibuf);

		goto Hdfdone;
	}

Hdf24:
	zsize = 3;
	err_ret = DF24getdims(imgfile_in,&xsize,&ysize,&pil);
	if (err_ret){
		printf("%s: Error with DF24getdims\n",imgfile_in);
		exit(1);
	}
	else{	
		num_bytes = xsize * ysize * zsize;
		ibuf = (unsigned char *)malloc(num_bytes);
		if (!ibuf){
			printf("%s: Not enough memory\n",imgfile_in);
			exit(1);
		}
		err_ret = DF24getimage(imgfile_in,ibuf,xsize,ysize);
		if (err_ret){
			printf("%s: Error with DF24getimage\n",imgfile_in);
			exit(1);
		}
		num_bytes = xsize * ysize;
		obuf = (unsigned char *)malloc(num_bytes);
		if (!obuf){
			printf("%s: Not enough memory\n",imgfile_out);
			exit(1);
		}
		err_ret = img24_tobw(ibuf,obuf,xsize,ysize);

		DFR8setpalette(gpal);
		err_ret = DFR8putimage(imgfile_out,obuf,xsize,ysize,DFTAG_RLE);
		if (err_ret){
			printf("%s: Error with DFR8putimage\n",imgfile_out);
			exit(1);
		}
	
		free(obuf);
		free(ibuf);
	}

Hdfdone:;
}

